package com.vpapps.adService;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.util.Log;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

import com.applovin.mediation.MaxAd;
import com.applovin.mediation.MaxAdListener;
import com.applovin.mediation.MaxError;
import com.applovin.mediation.ads.MaxAppOpenAd;
import com.google.android.gms.ads.AdError;
import com.google.android.gms.ads.AdRequest;
import com.google.android.gms.ads.FullScreenContentCallback;
import com.google.android.gms.ads.LoadAdError;
import com.google.android.gms.ads.appopen.AppOpenAd;
import com.startapp.sdk.adsbase.Ad;
import com.startapp.sdk.adsbase.StartAppAd;
import com.startapp.sdk.adsbase.adlisteners.AdDisplayListener;
import com.startapp.sdk.adsbase.adlisteners.AdEventListener;
import com.vpapps.interfaces.OnShowAdCompleteListener;
import com.vpapps.onlinemp3.MainActivity;
import com.vpapps.onlinemp3.SplashActivity;
import com.vpapps.utils.Constant;
import com.vpapps.utils.GDPRChecker;

import java.util.Date;

public class AppOpenAdManager {
    private AppOpenAd appOpenAd = null;
    private com.wortise.ads.appopen.AppOpenAd mAppOpenAdWortise = null;
    private MaxAppOpenAd maxAppOpenAd;
    StartAppAd startAppAd;
    private boolean isLoadingAd = false;
    public boolean isShowingAd = false;
    private long loadTime = 0;
    Context context;

    public AppOpenAdManager(Context context) {
        this.context = context;
    }

    public void loadAd(Context context) {
        // Do not load ad if there is an unused ad or one is already loading.
        if (Constant.isAppOpenAdShown) {
            return;
        }
        if (isLoadingAd || isAdAvailable()) {
            return;
        }

        isLoadingAd = true;
        switch (Constant.openAdType) {
            case Constant.AD_TYPE_ADMOB, Constant.AD_TYPE_FACEBOOK -> {
                AdRequest request = new AdRequest.Builder().build();
                AppOpenAd.load(
                        context,
                        Constant.openAdId,
                        request,
                        new AppOpenAd.AppOpenAdLoadCallback() {
                            @Override
                            public void onAdLoaded(@NonNull AppOpenAd ad) {
                                appOpenAd = ad;
                                isLoadingAd = false;
                                loadTime = (new Date()).getTime();
                            }

                            @Override
                            public void onAdFailedToLoad(@NonNull LoadAdError loadAdError) {
                                isLoadingAd = false;
                            }
                        });
            }
            case Constant.AD_TYPE_WORTISE -> {
                mAppOpenAdWortise = new com.wortise.ads.appopen.AppOpenAd(context, Constant.openAdId);
                mAppOpenAdWortise.setListener(new com.wortise.ads.appopen.AppOpenAd.Listener() {
                    @Override
                    public void onAppOpenClicked(@NonNull com.wortise.ads.appopen.AppOpenAd appOpenAd) {

                    }

                    @Override
                    public void onAppOpenDismissed(@NonNull com.wortise.ads.appopen.AppOpenAd appOpenAd) {

                    }

                    @Override
                    public void onAppOpenFailedToLoad(@NonNull com.wortise.ads.appopen.AppOpenAd appOpenAd, @NonNull com.wortise.ads.AdError adError) {
                        isLoadingAd = false;
                    }

                    @Override
                    public void onAppOpenFailedToShow(@NonNull com.wortise.ads.appopen.AppOpenAd appOpenAd, @NonNull com.wortise.ads.AdError adError) {

                    }

                    @Override
                    public void onAppOpenImpression(@NonNull com.wortise.ads.appopen.AppOpenAd appOpenAd) {

                    }

                    @Override
                    public void onAppOpenLoaded(@NonNull com.wortise.ads.appopen.AppOpenAd appOpenAd) {
                        mAppOpenAdWortise = appOpenAd;
                        isLoadingAd = false;
                        loadTime = (new Date()).getTime();
                    }

                    @Override
                    public void onAppOpenShown(@NonNull com.wortise.ads.appopen.AppOpenAd appOpenAd) {

                    }
                });
                mAppOpenAdWortise.loadAd();
            }
            case Constant.AD_TYPE_APPLOVIN -> {
                maxAppOpenAd = new MaxAppOpenAd(Constant.openAdId, context);
                maxAppOpenAd.setListener(new MaxAdListener() {
                    @Override
                    public void onAdLoaded(MaxAd maxAd) {
//                    maxAppOpenAd = maxAd;
                        isLoadingAd = false;
                        loadTime = (new Date()).getTime();
                    }

                    @Override
                    public void onAdDisplayed(MaxAd maxAd) {

                    }

                    @Override
                    public void onAdHidden(MaxAd maxAd) {

                    }

                    @Override
                    public void onAdClicked(MaxAd maxAd) {

                    }

                    @Override
                    public void onAdLoadFailed(String s, MaxError maxError) {
                        isLoadingAd = false;
                    }

                    @Override
                    public void onAdDisplayFailed(MaxAd maxAd, MaxError maxError) {

                    }
                });
                maxAppOpenAd.loadAd();
            }
            case Constant.AD_TYPE_STARTAPP -> {
                startAppAd = new StartAppAd(context);
                startAppAd.loadAd(new AdEventListener() {
                    @Override
                    public void onReceiveAd(@NonNull Ad ad) {
                        isLoadingAd = false;
                        loadTime = (new Date()).getTime();
                    }

                    @Override
                    public void onFailedToReceiveAd(@Nullable Ad ad) {
                        isLoadingAd = false;
                    }
                });
            }
        }
    }

    private boolean wasLoadTimeLessThanNHoursAgo() {
        long dateDifference = (new Date()).getTime() - loadTime;
        long numMilliSecondsPerHour = 3600000;
        return (dateDifference < (numMilliSecondsPerHour * (long) 4));
    }

    public boolean isAdAvailable() {
        return switch (Constant.openAdType) {
            case Constant.AD_TYPE_ADMOB -> appOpenAd != null && wasLoadTimeLessThanNHoursAgo();
            case Constant.AD_TYPE_WORTISE ->
                    mAppOpenAdWortise != null && mAppOpenAdWortise.isAvailable() && wasLoadTimeLessThanNHoursAgo();
            case Constant.AD_TYPE_APPLOVIN -> maxAppOpenAd != null && maxAppOpenAd.isReady();
            case Constant.AD_TYPE_STARTAPP -> startAppAd != null && startAppAd.isReady();
            default -> false;
        };
    }

    public void showAdIfAvailable(@NonNull final Activity activity) {
            showAdIfAvailable(
                    activity,
                    () -> {
                        // Empty because the user will go back to the activity that shows the ad.
                    });
    }

    public void showAdIfAvailable(
            @NonNull final Activity activity,
            @NonNull OnShowAdCompleteListener onShowAdCompleteListener) {
        if (isShowingAd) {
            return;
        }

        if (!isAdAvailable()) {
            onShowAdCompleteListener.onShowAdComplete();
            if (new GDPRChecker(context).canLoadAdOpenAds()) {
                loadAd(activity);
            }
            return;
        }

        switch (Constant.openAdType) {
            case Constant.AD_TYPE_ADMOB -> {
                appOpenAd.setFullScreenContentCallback(
                        new FullScreenContentCallback() {
                            @Override
                            public void onAdDismissedFullScreenContent() {
                                // Set the reference to null so isAdAvailable() returns false.
                                appOpenAd = null;
                                isShowingAd = false;

                                if (activity instanceof SplashActivity) {
                                    Intent intent = new Intent(activity, MainActivity.class);
                                    intent.setFlags(Intent.FLAG_ACTIVITY_CLEAR_TOP);
                                    activity.startActivity(intent);
                                    activity.finish();
                                }

                                onShowAdCompleteListener.onShowAdComplete();
                                if (new GDPRChecker(context).canLoadAdOpenAds()) {
                                    loadAd(activity);
                                }
                            }

                            @Override
                            public void onAdFailedToShowFullScreenContent(@NonNull AdError adError) {
                                appOpenAd = null;
                                isShowingAd = false;

                                onShowAdCompleteListener.onShowAdComplete();
                                if (new GDPRChecker(context).canLoadAdOpenAds()) {
                                    loadAd(activity);
                                }
                            }

                            @Override
                            public void onAdShowedFullScreenContent() {
                                Constant.isAppOpenAdShown = true;
                                isShowingAd = true;
                            }
                        });
                isShowingAd = true;
                appOpenAd.show(activity);
            }
            case Constant.AD_TYPE_WORTISE -> {
                mAppOpenAdWortise.setListener(new com.wortise.ads.appopen.AppOpenAd.Listener() {
                    @Override
                    public void onAppOpenClicked(@NonNull com.wortise.ads.appopen.AppOpenAd appOpenAd) {

                    }

                    @Override
                    public void onAppOpenDismissed(@NonNull com.wortise.ads.appopen.AppOpenAd appOpenAd) {
                        mAppOpenAdWortise = null;
                        isShowingAd = false;

                        if (activity instanceof SplashActivity) {
                            Intent intent = new Intent(activity, MainActivity.class);
                            intent.setFlags(Intent.FLAG_ACTIVITY_CLEAR_TOP);
                            activity.startActivity(intent);
                            activity.finish();
                        }

                        onShowAdCompleteListener.onShowAdComplete();
                        if (new GDPRChecker(context).canLoadAdOpenAds()) {
                            loadAd(activity);
                        }
                    }

                    @Override
                    public void onAppOpenFailedToLoad(@NonNull com.wortise.ads.appopen.AppOpenAd appOpenAd, @NonNull com.wortise.ads.AdError adError) {

                    }

                    @Override
                    public void onAppOpenFailedToShow(@NonNull com.wortise.ads.appopen.AppOpenAd appOpenAd, @NonNull com.wortise.ads.AdError adError) {
                        mAppOpenAdWortise = null;
                        isShowingAd = false;

                        onShowAdCompleteListener.onShowAdComplete();
                        if (new GDPRChecker(context).canLoadAdOpenAds()) {
                            loadAd(activity);
                        }
                    }

                    @Override
                    public void onAppOpenImpression(@NonNull com.wortise.ads.appopen.AppOpenAd appOpenAd) {

                    }

                    @Override
                    public void onAppOpenLoaded(@NonNull com.wortise.ads.appopen.AppOpenAd appOpenAd) {

                    }

                    @Override
                    public void onAppOpenShown(@NonNull com.wortise.ads.appopen.AppOpenAd appOpenAd) {
                        Constant.isAppOpenAdShown = true;
                        isShowingAd = true;
                    }
                });
                isShowingAd = true;
                mAppOpenAdWortise.showAd(activity);
            }
            case Constant.AD_TYPE_APPLOVIN -> {
                maxAppOpenAd.setListener(new MaxAdListener() {
                    @Override
                    public void onAdHidden(MaxAd maxAd) {
                        maxAppOpenAd = null;
                        isShowingAd = false;

                        if (activity instanceof SplashActivity) {
                            Intent intent = new Intent(activity, MainActivity.class);
                            intent.setFlags(Intent.FLAG_ACTIVITY_CLEAR_TOP);
                            activity.startActivity(intent);
                            activity.finish();
                        }

                        onShowAdCompleteListener.onShowAdComplete();
                        if (new GDPRChecker(context).canLoadAdOpenAds()) {
                            loadAd(activity);
                        }
                    }

                    @Override
                    public void onAdClicked(MaxAd maxAd) {

                    }

                    @Override
                    public void onAdLoadFailed(String s, MaxError maxError) {

                    }

                    @Override
                    public void onAdDisplayFailed(MaxAd maxAd, MaxError maxError) {
                        maxAppOpenAd = null;
                        isShowingAd = false;

                        onShowAdCompleteListener.onShowAdComplete();
                        if (new GDPRChecker(context).canLoadAdOpenAds()) {
                            loadAd(activity);
                        }
                    }

                    @Override
                    public void onAdLoaded(MaxAd maxAd) {

                    }

                    @Override
                    public void onAdDisplayed(MaxAd maxAd) {
                        Constant.isAppOpenAdShown = true;
                        isShowingAd = true;
                    }
                });
                isShowingAd = true;
                maxAppOpenAd.showAd();
            }
            case Constant.AD_TYPE_STARTAPP -> {
                startAppAd.showAd(new AdDisplayListener() {
                    @Override
                    public void adHidden(Ad ad) {
                        startAppAd = null;
                        isShowingAd = false;

                        if (activity instanceof SplashActivity) {
                            Intent intent = new Intent(activity, MainActivity.class);
                            intent.setFlags(Intent.FLAG_ACTIVITY_CLEAR_TOP);
                            activity.startActivity(intent);
                            activity.finish();
                        }

                        onShowAdCompleteListener.onShowAdComplete();
                        if (new GDPRChecker(context).canLoadAdOpenAds()) {
                            loadAd(activity);
                        }
                    }

                    @Override
                    public void adDisplayed(Ad ad) {
                        Constant.isAppOpenAdShown = true;
                        isShowingAd = true;
                    }

                    @Override
                    public void adClicked(Ad ad) {

                    }

                    @Override
                    public void adNotDisplayed(Ad ad) {
                        startAppAd = null;
                        isShowingAd = false;

                        onShowAdCompleteListener.onShowAdComplete();
                        if (new GDPRChecker(context).canLoadAdOpenAds()) {
                            loadAd(activity);
                        }
                    }
                });
                isShowingAd = true;
            }
        }
    }
}