package com.vpapps.adapter;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.graphics.Typeface;
import android.net.Uri;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.Filter;
import android.widget.ImageView;
import android.widget.ProgressBar;
import android.widget.RatingBar;
import android.widget.RelativeLayout;
import android.widget.TextView;
import android.widget.Toast;

import androidx.annotation.NonNull;
import androidx.appcompat.widget.AppCompatRatingBar;
import androidx.recyclerview.widget.RecyclerView;

import com.applovin.mediation.MaxAd;
import com.applovin.mediation.MaxError;
import com.applovin.mediation.nativeAds.MaxNativeAdListener;
import com.applovin.mediation.nativeAds.MaxNativeAdLoader;
import com.applovin.mediation.nativeAds.MaxNativeAdView;
import com.google.android.gms.ads.nativead.MediaView;
import com.google.android.gms.ads.nativead.NativeAd;
import com.google.android.gms.ads.nativead.NativeAdView;
import com.google.android.material.bottomsheet.BottomSheetDialog;
import com.squareup.picasso.Picasso;
import com.startapp.sdk.ads.nativead.NativeAdDetails;
import com.vpapps.interfaces.ClickListenerCallback;
import com.vpapps.interfaces.RewardAdListener;
import com.vpapps.item.ItemMyPlayList;
import com.vpapps.item.ItemSong;
import com.vpapps.onlinemp3.PlayerService;
import com.vpapps.onlinemp3.R;
import com.vpapps.utils.Constant;
import com.vpapps.utils.DBHelper;
import com.vpapps.utils.GlobalBus;
import com.vpapps.utils.Methods;
import com.vpapps.utils.SharedPref;
import com.wortise.ads.AdError;
import com.wortise.ads.natives.GoogleNativeAd;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;

import es.claucookie.miniequalizerlibrary.EqualizerView;


public class AdapterAllSongList extends RecyclerView.Adapter {

    Context context;
    ArrayList<ItemSong> arrayList;
    ArrayList<ItemSong> filteredArrayList;
    ClickListenerCallback recyclerClickListener;
    NameFilter filter;
    String type;
    Methods methods;
    DBHelper dbHelper;

    private final int VIEW_PROG = -1;

    Boolean isAdLoaded = false;
    List<NativeAd> mNativeAdsAdmob = new ArrayList<>();
    List<NativeAdDetails> nativeAdsStartApp = new ArrayList<>();

    public AdapterAllSongList(Context context, ArrayList<ItemSong> arrayList, ClickListenerCallback recyclerClickListener, String type) {
        this.arrayList = arrayList;
        this.filteredArrayList = arrayList;
        this.context = context;
        this.type = type;
        this.recyclerClickListener = recyclerClickListener;
        methods = new Methods(context);
        dbHelper = new DBHelper(context);
    }

    class MyViewHolder extends RecyclerView.ViewHolder {
        TextView textView_song, textView_catname, tv_avg_rate, tv_views, tv_download;
        EqualizerView equalizer;
        ImageView imageView, imageView_option, iv_downlaod_icon;
        RelativeLayout rl, rl_native_ad;
        AppCompatRatingBar ratingBar;
        View view_ad;

        MyViewHolder(View view) {
            super(view);
            rl = view.findViewById(R.id.ll_songlist);
            rl_native_ad = view.findViewById(R.id.rl_native_ad);
            tv_views = view.findViewById(R.id.tv_songlist_views);
            tv_download = view.findViewById(R.id.tv_songlist_downloads);
            textView_song = view.findViewById(R.id.tv_songlist_name);
            tv_avg_rate = view.findViewById(R.id.tv_songlist_avg_rate);
            equalizer = view.findViewById(R.id.equalizer_view);
            textView_catname = view.findViewById(R.id.tv_songlist_cat);
            imageView = view.findViewById(R.id.iv_songlist);
            imageView_option = view.findViewById(R.id.iv_songlist_option);
            ratingBar = view.findViewById(R.id.rb_songlist);
            iv_downlaod_icon = view.findViewById(R.id.iv_downlaod_icon);
            view_ad = view.findViewById(R.id.view3);

            if (!Constant.isSongDownload) {
                tv_download.setVisibility(View.GONE);
                iv_downlaod_icon.setVisibility(View.GONE);
            }
        }
    }

    private static class ProgressViewHolder extends RecyclerView.ViewHolder {
        private static ProgressBar progressBar;

        private ProgressViewHolder(View v) {
            super(v);
            progressBar = v.findViewById(R.id.progressBar);
        }
    }

    @NonNull
    @Override
    public RecyclerView.ViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        if (viewType == VIEW_PROG) {
            View v = LayoutInflater.from(parent.getContext()).inflate(R.layout.layout_progressbar, parent, false);
            return new ProgressViewHolder(v);
        } else {
            View itemView = LayoutInflater.from(parent.getContext()).inflate(R.layout.layout_all_songs, parent, false);
            return new MyViewHolder(itemView);
        }
    }

    @Override
    public void onBindViewHolder(@NonNull final RecyclerView.ViewHolder holder, int position) {
        if (holder instanceof MyViewHolder) {

            ((MyViewHolder) holder).tv_views.setText(methods.format(Double.parseDouble(arrayList.get(holder.getAbsoluteAdapterPosition()).getViews())));
            ((MyViewHolder) holder).tv_download.setText(methods.format(Double.parseDouble(arrayList.get(holder.getAbsoluteAdapterPosition()).getDownloads())));

            ((MyViewHolder) holder).textView_song.setText(arrayList.get(holder.getAbsoluteAdapterPosition()).getTitle());
            Picasso.get()
                    .load(arrayList.get(holder.getAbsoluteAdapterPosition()).getImageBig())
                    .resize(300,300)
                    .placeholder(R.drawable.placeholder_song)
                    .into(((MyViewHolder) holder).imageView);

            ((MyViewHolder) holder).tv_avg_rate.setTypeface(((MyViewHolder) holder).tv_avg_rate.getTypeface(), Typeface.BOLD);
            ((MyViewHolder) holder).tv_avg_rate.setText(arrayList.get(holder.getAbsoluteAdapterPosition()).getAverageRating());
            ((MyViewHolder) holder).ratingBar.setRating(Float.parseFloat(arrayList.get(holder.getAbsoluteAdapterPosition()).getAverageRating()));

            if (PlayerService.getIsPlayling() && Constant.playPos <= holder.getAbsoluteAdapterPosition() && Constant.arrayList_play.get(Constant.playPos).getId().equals(arrayList.get(holder.getAbsoluteAdapterPosition()).getId())) {
                ((MyViewHolder) holder).imageView.setVisibility(View.INVISIBLE);
                ((MyViewHolder) holder).equalizer.setVisibility(View.VISIBLE);
                ((MyViewHolder) holder).equalizer.animateBars();
            } else {
                ((MyViewHolder) holder).imageView.setVisibility(View.VISIBLE);
                ((MyViewHolder) holder).equalizer.setVisibility(View.GONE);
                ((MyViewHolder) holder).equalizer.stopBars();
            }

            ((MyViewHolder) holder).textView_catname.setText(arrayList.get(holder.getAbsoluteAdapterPosition()).getArtist());

            ((MyViewHolder) holder).rl.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View view) {
                    try {
                        recyclerClickListener.onClick(getPosition(arrayList.get(holder.getAbsoluteAdapterPosition()).getId()));
                    } catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            });

            ((MyViewHolder) holder).imageView_option.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View view) {
                    try {
                        openOptionPopUp(holder.getAbsoluteAdapterPosition());
                    } catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            });

            if (Constant.isNativeAd && isAdLoaded && (holder.getAbsoluteAdapterPosition() != arrayList.size() - 1) && (holder.getAbsoluteAdapterPosition() + 1) % Constant.nativeAdShow == 0) {
                try {
                    if (((MyViewHolder) holder).rl_native_ad.getChildCount() == 0) {
                        switch (Constant.nativeAdType) {
                            case Constant.AD_TYPE_ADMOB:
                                if (mNativeAdsAdmob.size() >= 1) {

                                    int i = new Random().nextInt(mNativeAdsAdmob.size() - 1);

                                    NativeAdView adView = (NativeAdView) ((Activity) context).getLayoutInflater().inflate(R.layout.layout_native_ad_admob, null);
                                    populateUnifiedNativeAdView(mNativeAdsAdmob.get(i), adView);
                                    ((MyViewHolder) holder).rl_native_ad.removeAllViews();
                                    ((MyViewHolder) holder).rl_native_ad.addView(adView);

                                    ((MyViewHolder) holder).rl_native_ad.setVisibility(View.VISIBLE);
                                    ((MyViewHolder) holder).view_ad.setVisibility(View.VISIBLE);
                                }
                                break;
                            case Constant.AD_TYPE_STARTAPP:
                                int i = new Random().nextInt(nativeAdsStartApp.size() - 1);

                                RelativeLayout nativeAdView = (RelativeLayout) ((Activity) context).getLayoutInflater().inflate(R.layout.layout_native_ad_startapp, null);
                                populateStartAppNativeAdView(nativeAdsStartApp.get(i), nativeAdView);

                                ((MyViewHolder) holder).rl_native_ad.removeAllViews();
                                ((MyViewHolder) holder).rl_native_ad.addView(nativeAdView);
                                ((MyViewHolder) holder).rl_native_ad.setVisibility(View.VISIBLE);
                                ((MyViewHolder) holder).view_ad.setVisibility(View.VISIBLE);
                                break;
                            case Constant.AD_TYPE_APPLOVIN:
                                MaxNativeAdLoader nativeAdLoader = new MaxNativeAdLoader(Constant.nativeAdID, context);
                                nativeAdLoader.setNativeAdListener(new MaxNativeAdListener() {
                                    @Override
                                    public void onNativeAdLoaded(final MaxNativeAdView nativeAdView, final MaxAd ad) {
                                        ((MyViewHolder) holder).rl_native_ad.removeAllViews();
                                        ((MyViewHolder) holder).rl_native_ad.addView(nativeAdView);
                                        ((MyViewHolder) holder).rl_native_ad.setVisibility(View.VISIBLE);
                                        ((MyViewHolder) holder).view_ad.setVisibility(View.VISIBLE);
                                    }

                                    @Override
                                    public void onNativeAdLoadFailed(final String adUnitId, final MaxError error) {
                                    }

                                    @Override
                                    public void onNativeAdClicked(final MaxAd ad) {
                                    }
                                });

                                nativeAdLoader.loadAd();
                                break;
                            case Constant.AD_TYPE_WORTISE:
//                                if (!((MyViewHolder) holder).isAdRequested) {
                                    GoogleNativeAd googleNativeAd = new GoogleNativeAd(
                                            context, Constant.nativeAdID, new GoogleNativeAd.Listener() {
                                        @Override
                                        public void onNativeClicked(@NonNull GoogleNativeAd googleNativeAd) {

                                        }

                                        @Override
                                        public void onNativeFailedToLoad(@NonNull GoogleNativeAd googleNativeAd, @NonNull AdError adError) {

                                        }

                                        @Override
                                        public void onNativeImpression(@NonNull GoogleNativeAd googleNativeAd) {

                                        }

                                        @Override
                                        public void onNativeLoaded(@NonNull GoogleNativeAd googleNativeAd, @NonNull NativeAd nativeAd) {
                                            NativeAdView adView = (NativeAdView) ((Activity) context).getLayoutInflater().inflate(R.layout.layout_native_ad_admob, null);
                                            populateUnifiedNativeAdView(nativeAd, adView);
                                            ((MyViewHolder) holder).rl_native_ad.removeAllViews();
                                            ((MyViewHolder) holder).rl_native_ad.addView(adView);

                                            ((MyViewHolder) holder).rl_native_ad.setVisibility(View.VISIBLE);
                                        }
                                    });
                                    googleNativeAd.load();
//                                    ((MyViewHolder) holder).isAdRequested = true;
//                                }
                                break;
                        }
                    }
                } catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    @Override
    public long getItemId(int id) {
        return id;
    }

    @Override
    public int getItemCount() {
        return arrayList.size();
    }

    @Override
    public int getItemViewType(int position) {
        if (arrayList.get(position) != null) {
            return position;
        } else {
            return VIEW_PROG;
        }
    }

    private int getPosition(String id) {
        int count = 0;
        for (int i = 0; i < filteredArrayList.size(); i++) {
            if (id.equals(filteredArrayList.get(i).getId())) {
                count = i;
                break;
            }
        }
        return count;
    }

    private void openOptionPopUp(final int pos) {
        View view = ((Activity)context).getLayoutInflater().inflate(R.layout.layout_bottomsheet_songs, null);

        BottomSheetDialog dialog = new BottomSheetDialog(context);
        dialog.setContentView(view);
        dialog.getWindow().findViewById(R.id.design_bottom_sheet).setBackgroundResource(android.R.color.transparent);
        dialog.show();

        TextView tv_add_playlist = dialog.findViewById(R.id.tv_option_add_playlist);
        TextView tv_add_queue = dialog.findViewById(R.id.tv_option_add_queue);
        TextView tv_download = dialog.findViewById(R.id.tv_option_download);
        TextView tv_youtube = dialog.findViewById(R.id.tv_option_youtube);
        TextView tv_share = dialog.findViewById(R.id.tv_option_share);

        if (type.equals("playlist")) {
            tv_add_playlist.setText(context.getString(R.string.remove));
        }
        if (!Constant.isOnline) {
            tv_add_queue.setVisibility(View.GONE);
            dialog.findViewById(R.id.iv_options_queue).setVisibility(View.GONE);
        }
        if (!methods.isYoutubeAppInstalled()) {
            tv_youtube.setVisibility(View.GONE);
            dialog.findViewById(R.id.iv_option_youtube).setVisibility(View.GONE);
        }

        if (!Constant.isSongDownload) {
            tv_download.setVisibility(View.GONE);
            dialog.findViewById(R.id.iv_options_download).setVisibility(View.GONE);
        }

        tv_add_playlist.setOnClickListener(view1 -> {
            dialog.dismiss();
            if (type.equals("playlist")) {
                dbHelper.removeFromPlayList(arrayList.get(pos).getId(), true);
                arrayList.remove(pos);
                notifyItemRemoved(pos);
                Toast.makeText(context, context.getString(R.string.remove_from_playlist), Toast.LENGTH_SHORT).show();
                if (arrayList.size() == 0) {
                    recyclerClickListener.onItemZero();
                }
            } else {
                // methods.openPlaylists(arrayList.get(pos), true);
                methods.showBottomSheetAddToPlaylist(arrayList.get(pos), true);
            }
        });

        tv_add_queue.setOnClickListener(view1 -> {
            dialog.dismiss();
            Constant.arrayList_play.add(arrayList.get(pos));
            PlayerService.getInstance().addMediaSource(Uri.parse(arrayList.get(pos).getUrl()));
            GlobalBus.getBus().postSticky(new ItemMyPlayList("", "", null));
            Toast.makeText(context, context.getString(R.string.add_to_queue), Toast.LENGTH_SHORT).show();
        });

        tv_download.setOnClickListener(view1 -> {
            dialog.dismiss();
            methods.showRewardAds(() -> methods.download(arrayList.get(pos)));
        });

        tv_youtube.setOnClickListener(view1 -> {
            dialog.dismiss();
            Intent intent = new Intent(Intent.ACTION_SEARCH);
            intent.setPackage("com.google.android.youtube");
            intent.putExtra("query", arrayList.get(pos).getTitle());
            intent.setFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
            context.startActivity(intent);
        });

        tv_share.setOnClickListener(view1 -> {
            dialog.dismiss();
            methods.shareSong(arrayList.get(pos), true);
        });
    }

    private void populateStartAppNativeAdView(NativeAdDetails nativeAdDetails, RelativeLayout nativeAdView) {
        ImageView icon = nativeAdView.findViewById(R.id.icon);
        TextView title = nativeAdView.findViewById(R.id.title);
        TextView description = nativeAdView.findViewById(R.id.description);
        Button button = nativeAdView.findViewById(R.id.button);

        icon.setImageBitmap(nativeAdDetails.getImageBitmap());
        title.setText(nativeAdDetails.getTitle());
        description.setText(nativeAdDetails.getDescription());
        button.setText(nativeAdDetails.isApp() ? "Install" : "Open");

//        nativeAdDetails.registerViewForInteraction(itemView);
    }

    private void populateUnifiedNativeAdView(NativeAd nativeAd, NativeAdView adView) {
        // Set the media view. Media content will be automatically populated in the media view once
        // adView.setNativeAd() is called.
        MediaView mediaView = adView.findViewById(R.id.ad_media);
        adView.setMediaView(mediaView);

        // Set other ad assets.
        adView.setHeadlineView(adView.findViewById(R.id.ad_headline));
        adView.setBodyView(adView.findViewById(R.id.ad_body));
        adView.setCallToActionView(adView.findViewById(R.id.ad_call_to_action));
        adView.setIconView(adView.findViewById(R.id.ad_icon));
        adView.setPriceView(adView.findViewById(R.id.ad_price));
        adView.setStarRatingView(adView.findViewById(R.id.ad_stars));
        adView.setStoreView(adView.findViewById(R.id.ad_store));
        adView.setAdvertiserView(adView.findViewById(R.id.ad_advertiser));

        // The headline is guaranteed to be in every UnifiedNativeAd.
        ((TextView) adView.getHeadlineView()).setText(nativeAd.getHeadline());

        // These assets aren't guaranteed to be in every UnifiedNativeAd, so it's important to
        // check before trying to display them.
        if (nativeAd.getBody() == null) {
            adView.getBodyView().setVisibility(View.INVISIBLE);
        } else {
            adView.getBodyView().setVisibility(View.VISIBLE);
            ((TextView) adView.getBodyView()).setText(nativeAd.getBody());
        }

        if (nativeAd.getCallToAction() == null) {
            adView.getCallToActionView().setVisibility(View.INVISIBLE);
        } else {
            adView.getCallToActionView().setVisibility(View.VISIBLE);
            ((Button) adView.getCallToActionView()).setText(nativeAd.getCallToAction());
        }

        if (nativeAd.getIcon() == null) {
            adView.getIconView().setVisibility(View.GONE);
        } else {
            ((ImageView) adView.getIconView()).setImageDrawable(
                    nativeAd.getIcon().getDrawable());
            adView.getIconView().setVisibility(View.VISIBLE);
        }

        if (nativeAd.getPrice() == null) {
            adView.getPriceView().setVisibility(View.INVISIBLE);
        } else {
            adView.getPriceView().setVisibility(View.VISIBLE);
            ((TextView) adView.getPriceView()).setText(nativeAd.getPrice());
        }

        if (nativeAd.getStore() == null) {
            adView.getStoreView().setVisibility(View.INVISIBLE);
        } else {
            adView.getStoreView().setVisibility(View.VISIBLE);
            ((TextView) adView.getStoreView()).setText(nativeAd.getStore());
        }

        if (nativeAd.getStarRating() == null) {
            adView.getStarRatingView().setVisibility(View.INVISIBLE);
        } else {
            ((RatingBar) adView.getStarRatingView())
                    .setRating(nativeAd.getStarRating().floatValue());
            adView.getStarRatingView().setVisibility(View.VISIBLE);
        }

        if (nativeAd.getAdvertiser() == null) {
            adView.getAdvertiserView().setVisibility(View.INVISIBLE);
        } else {
            ((TextView) adView.getAdvertiserView()).setText(nativeAd.getAdvertiser());
            adView.getAdvertiserView().setVisibility(View.VISIBLE);
        }

        // This method tells the Google Mobile Ads SDK that you have finished populating your
        // native ad view with this native ad. The SDK will populate the adView's MediaView
        // with the media content from this native ad.
        adView.setNativeAd(nativeAd);
    }

    public void destroyNativeAds() {
        try {
            for (int i = 0; i < mNativeAdsAdmob.size(); i++) {
                mNativeAdsAdmob.get(i).destroy();
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void addAds(NativeAd unifiedNativeAd) {
        mNativeAdsAdmob.add(unifiedNativeAd);
        isAdLoaded = true;
    }

    public void addNativeAds(ArrayList<NativeAdDetails> nativeAdDetails) {
        nativeAdsStartApp.addAll(nativeAdDetails);
        isAdLoaded = true;
    }

    public void setNativeAds(boolean isLoaded) {
        isAdLoaded = isLoaded;
    }

    public Filter getFilter() {
        if (filter == null) {
            filter = new NameFilter();
        }
        return filter;
    }

    private class NameFilter extends Filter {

        @Override
        protected FilterResults performFiltering(CharSequence constraint) {

            constraint = constraint.toString().toLowerCase();
            FilterResults result = new FilterResults();
            if (!constraint.toString().isEmpty()) {
                ArrayList<ItemSong> filteredItems = new ArrayList<>();

                for (int i = 0, l = filteredArrayList.size(); i < l; i++) {
                    String nameList = filteredArrayList.get(i).getTitle();
                    if (nameList.toLowerCase().contains(constraint))
                        filteredItems.add(filteredArrayList.get(i));
                }
                result.count = filteredItems.size();
                result.values = filteredItems;
            } else {
                synchronized (this) {
                    result.values = filteredArrayList;
                    result.count = filteredArrayList.size();
                }
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected void publishResults(CharSequence constraint,
                                      FilterResults results) {

            arrayList = (ArrayList<ItemSong>) results.values;
            notifyDataSetChanged();
        }
    }

    public void closeDatabase() {
        try {
            dbHelper.close();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
}