package com.vpapps.adapter;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ProgressBar;
import android.widget.TextView;
import android.widget.Toast;

import androidx.annotation.NonNull;
import androidx.appcompat.app.AppCompatActivity;
import androidx.fragment.app.FragmentTransaction;
import androidx.recyclerview.widget.DefaultItemAnimator;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;

import com.tiagosantos.enchantedviewpager.EnchantedViewPager;
import com.vpapps.fragment.FragmentAlbums;
import com.vpapps.fragment.FragmentArtist;
import com.vpapps.fragment.FragmentCategories;
import com.vpapps.fragment.FragmentHomeSectionSongs;
import com.vpapps.fragment.FragmentRecentSongs;
import com.vpapps.fragment.FragmentServerPlaylist;
import com.vpapps.fragment.FragmentTrendingSongs;
import com.vpapps.interfaces.ClickListenerCallback;
import com.vpapps.interfaces.InterAdListener;
import com.vpapps.item.ItemMyPlayList;
import com.vpapps.item.ItemPost;
import com.vpapps.onlinemp3.MainActivity;
import com.vpapps.onlinemp3.PlayerService;
import com.vpapps.onlinemp3.R;
import com.vpapps.onlinemp3.SongByCatActivity;
import com.vpapps.onlinemp3.SongByServerPlaylistActivity;
import com.vpapps.utils.Constant;
import com.vpapps.utils.GlobalBus;
import com.vpapps.utils.Methods;
import com.vpapps.utils.RecyclerItemClickListener;

import java.util.ArrayList;
import java.util.Objects;

public class AdapterHome extends RecyclerView.Adapter {

    Context context;
    Methods methods;
    ArrayList<ItemPost> arrayList;
    int clickPos = 0;

    final int VIEW_PROG = 0;
    final int VIEW_BANNER = 1;
    final int VIEW_SONGS = 2;
    final int VIEW_ARTIST = 3;
    final int VIEW_ALBUMS = 4;
    final int VIEW_CATEGORIES = 5;
    final int VIEW_PLAYLIST = 6;
    final int VIEW_RECENT = 7;

    public AdapterHome(Context context, ArrayList<ItemPost> arrayList) {
        this.context = context;
        this.arrayList = arrayList;
        methods = new Methods(context, interAdListener);
    }

    class BannerHolder extends RecyclerView.ViewHolder {
        EnchantedViewPager enchantedViewPager;
        HomePagerAdapter homePagerAdapter;

        BannerHolder(View view) {
            super(view);
            enchantedViewPager = view.findViewById(R.id.viewPager_home);
            enchantedViewPager.useAlpha();
            enchantedViewPager.useScale();

            enchantedViewPager.setPageMargin(-5);
//            enchantedViewPager.setPadding(left,0,right,0);
        }
    }

    class CategoriesHolder extends RecyclerView.ViewHolder {
        RecyclerView rv_cat;
        AdapterHomeCat adapterHomeCat;
        TextView tv_title, tv_view_all;

        CategoriesHolder(View view) {
            super(view);
            rv_cat = view.findViewById(R.id.rv_home_cat);
            tv_title = view.findViewById(R.id.tv_home_title);
            tv_view_all = view.findViewById(R.id.tv_home_view_all);

            LinearLayoutManager llm_artist = new LinearLayoutManager(context, LinearLayoutManager.HORIZONTAL, false);
            rv_cat.setLayoutManager(llm_artist);
            rv_cat.setItemAnimator(new DefaultItemAnimator());
        }
    }

    class ArtistHolder extends RecyclerView.ViewHolder {
        RecyclerView rv_artist;
        AdapterHomeArtist adapterHomeArtist;
        TextView tv_title, tv_view_all;

        ArtistHolder(View view) {
            super(view);
            rv_artist = view.findViewById(R.id.rv_home_cat);
            tv_title = view.findViewById(R.id.tv_home_title);
            tv_view_all = view.findViewById(R.id.tv_home_view_all);
            LinearLayoutManager llm_artist = new LinearLayoutManager(context, LinearLayoutManager.HORIZONTAL, false);
            rv_artist.setLayoutManager(llm_artist);
            rv_artist.setItemAnimator(new DefaultItemAnimator());
        }
    }

    class AlbumsHolder extends RecyclerView.ViewHolder {
        RecyclerView rv_albums;
        AdapterHomeAlbums adapterHomeAlbums;
        TextView tv_title, tv_view_all;

        AlbumsHolder(View view) {
            super(view);
            rv_albums = view.findViewById(R.id.rv_home_cat);
            tv_title = view.findViewById(R.id.tv_home_title);
            tv_view_all = view.findViewById(R.id.tv_home_view_all);
            LinearLayoutManager llm_artist = new LinearLayoutManager(context, LinearLayoutManager.HORIZONTAL, false);
            rv_albums.setLayoutManager(llm_artist);
            rv_albums.setItemAnimator(new DefaultItemAnimator());
        }
    }

    class PlaylistHolder extends RecyclerView.ViewHolder {
        RecyclerView rv_playlist;
        AdapterPlaylistHome adapterPlaylistHome;
        TextView tv_title, tv_view_all;

        PlaylistHolder(View view) {
            super(view);
            rv_playlist = view.findViewById(R.id.rv_home_cat);
            tv_title = view.findViewById(R.id.tv_home_title);
            tv_view_all = view.findViewById(R.id.tv_home_view_all);
            LinearLayoutManager llm_artist = new LinearLayoutManager(context, LinearLayoutManager.HORIZONTAL, false);
            rv_playlist.setLayoutManager(llm_artist);
            rv_playlist.setItemAnimator(new DefaultItemAnimator());
        }
    }

    class SongsHolder extends RecyclerView.ViewHolder {
        RecyclerView rv_songs;
        AdapterHomeSongs adapterHomeSongs;
        TextView tv_title, tv_view_all;

        SongsHolder(View view) {
            super(view);
            rv_songs = view.findViewById(R.id.rv_home_cat);
            tv_title = view.findViewById(R.id.tv_home_title);
            tv_view_all = view.findViewById(R.id.tv_home_view_all);
            LinearLayoutManager llm_artist = new LinearLayoutManager(context, LinearLayoutManager.HORIZONTAL, false);
            rv_songs.setLayoutManager(llm_artist);
            rv_songs.setItemAnimator(new DefaultItemAnimator());
        }
    }

    class RecentSongsHolder extends RecyclerView.ViewHolder {
        RecyclerView rv_songs;
        AdapterHomeRecent adapterHomeSongs;
        TextView tv_title, tv_view_all;

        RecentSongsHolder(View view) {
            super(view);
            rv_songs = view.findViewById(R.id.rv_home_cat);
            tv_title = view.findViewById(R.id.tv_home_title);
            tv_view_all = view.findViewById(R.id.tv_home_view_all);
            LinearLayoutManager llm_artist = new LinearLayoutManager(context, LinearLayoutManager.HORIZONTAL, false);
            rv_songs.setLayoutManager(llm_artist);
            rv_songs.setItemAnimator(new DefaultItemAnimator());
        }
    }

    private static class ProgressViewHolder extends RecyclerView.ViewHolder {
        private static ProgressBar progressBar;

        private ProgressViewHolder(View v) {
            super(v);
            progressBar = v.findViewById(R.id.progressBar);
        }
    }

    @NonNull
    @Override
    public RecyclerView.ViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        if (viewType == VIEW_BANNER) {
            View itemView = LayoutInflater.from(parent.getContext()).inflate(R.layout.layout_home_ui_banner, parent, false);
            return new BannerHolder(itemView);
        } else if (viewType == VIEW_CATEGORIES) {
            View itemView = LayoutInflater.from(parent.getContext()).inflate(R.layout.layout_home_ui_categories, parent, false);
            return new CategoriesHolder(itemView);
        } else if (viewType == VIEW_ARTIST) {
            View itemView = LayoutInflater.from(parent.getContext()).inflate(R.layout.layout_home_ui_categories, parent, false);
            return new ArtistHolder(itemView);
        } else if (viewType == VIEW_ALBUMS) {
            View itemView = LayoutInflater.from(parent.getContext()).inflate(R.layout.layout_home_ui_categories, parent, false);
            return new AlbumsHolder(itemView);
        } else if (viewType == VIEW_PLAYLIST) {
            View itemView = LayoutInflater.from(parent.getContext()).inflate(R.layout.layout_home_ui_categories, parent, false);
            return new PlaylistHolder(itemView);
        } else if (viewType == VIEW_RECENT) {
            View itemView = LayoutInflater.from(parent.getContext()).inflate(R.layout.layout_home_ui_categories, parent, false);
            return new RecentSongsHolder(itemView);
        } else if (viewType == VIEW_SONGS) {
            View itemView = LayoutInflater.from(parent.getContext()).inflate(R.layout.layout_home_ui_categories, parent, false);
            return new SongsHolder(itemView);
        } else {
            View v = LayoutInflater.from(parent.getContext()).inflate(R.layout.layout_progressbar, parent, false);
            return new ProgressViewHolder(v);
        }
    }

    @Override
    public void onBindViewHolder(@NonNull RecyclerView.ViewHolder holder, int position) {

        if (holder instanceof BannerHolder) {
            if (((BannerHolder) holder).homePagerAdapter == null) {
                ((BannerHolder) holder).enchantedViewPager.setFocusable(false);
                ((BannerHolder) holder).homePagerAdapter = new HomePagerAdapter(context, arrayList.get(holder.getAbsoluteAdapterPosition()).getArrayListBanner());
                ((BannerHolder) holder).enchantedViewPager.setAdapter(((BannerHolder) holder).homePagerAdapter);
                if (((BannerHolder) holder).homePagerAdapter.getCount() > 2) {
                    ((BannerHolder) holder).enchantedViewPager.setCurrentItem(1);
                }
            }
        } else if (holder instanceof CategoriesHolder) {

            ((CategoriesHolder) holder).tv_title.setText(arrayList.get(holder.getAbsoluteAdapterPosition()).getTitle());

            ((CategoriesHolder) holder).adapterHomeCat = new AdapterHomeCat(arrayList.get(holder.getAbsoluteAdapterPosition()).getArrayListCategories());
            ((CategoriesHolder) holder).rv_cat.setAdapter(((CategoriesHolder) holder).adapterHomeCat);

            ((CategoriesHolder) holder).rv_cat.addOnItemTouchListener(new RecyclerItemClickListener(context, new RecyclerItemClickListener.OnItemClickListener() {
                @Override
                public void onItemClick(View view, int position) {
                    clickPos = holder.getAbsoluteAdapterPosition();
                    methods.showInterAd(position, context.getString(R.string.categories));
                }
            }));

            ((CategoriesHolder) holder).tv_view_all.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View v) {
                    FragmentCategories f_albums = new FragmentCategories();
                    Bundle bundle = new Bundle();
                    bundle.putBoolean("ishome", true);
                    bundle.putString("id", arrayList.get(holder.getAbsoluteAdapterPosition()).getId());
                    f_albums.setArguments(bundle);
                    FragmentTransaction ft = ((AppCompatActivity) context).getSupportFragmentManager().beginTransaction();
                    ft.setTransition(FragmentTransaction.TRANSIT_FRAGMENT_OPEN);
                    ft.hide(((AppCompatActivity) context).getSupportFragmentManager()
                            .getFragments()
                            .get(((AppCompatActivity) context).getSupportFragmentManager().getBackStackEntryCount()));
                    ft.add(R.id.fragment, f_albums, context.getString(R.string.categories));
                    ft.addToBackStack(context.getString(R.string.categories));
                    ft.commit();
                    ((MainActivity) context).getSupportActionBar().setTitle(context.getString(R.string.categories));
                    Objects.requireNonNull(((MainActivity) context).getSupportActionBar()).setDisplayHomeAsUpEnabled(true);
                }
            });

        } else if (holder instanceof ArtistHolder) {

            if (((ArtistHolder) holder).adapterHomeArtist == null) {
                ((ArtistHolder) holder).tv_title.setText(arrayList.get(holder.getAbsoluteAdapterPosition()).getTitle());

                ((ArtistHolder) holder).adapterHomeArtist = new AdapterHomeArtist(arrayList.get(holder.getAbsoluteAdapterPosition()).getArrayListArtist());
                ((ArtistHolder) holder).rv_artist.setAdapter(((ArtistHolder) holder).adapterHomeArtist);

                ((ArtistHolder) holder).rv_artist.addOnItemTouchListener(new RecyclerItemClickListener(context, new RecyclerItemClickListener.OnItemClickListener() {
                    @Override
                    public void onItemClick(View view, int position) {
                        clickPos = holder.getAbsoluteAdapterPosition();
                        methods.showInterAd(position, context.getString(R.string.artist));
                    }
                }));

                ((ArtistHolder) holder).tv_view_all.setOnClickListener(v -> {
                    FragmentArtist f_art = new FragmentArtist();
                    Bundle bundle = new Bundle();
                    bundle.putBoolean("ishome", true);
                    bundle.putString("id", arrayList.get(holder.getAbsoluteAdapterPosition()).getId());
                    f_art.setArguments(bundle);
                    FragmentTransaction ft = ((AppCompatActivity) context).getSupportFragmentManager().beginTransaction();
                    ft.setTransition(FragmentTransaction.TRANSIT_FRAGMENT_OPEN);
                    ft.hide(((AppCompatActivity) context).getSupportFragmentManager()
                            .getFragments()
                            .get(((AppCompatActivity) context).getSupportFragmentManager().getBackStackEntryCount()));
                    ft.add(R.id.fragment, f_art, context.getString(R.string.artist));
                    ft.addToBackStack(context.getString(R.string.artist));
                    ft.commit();
                    ((MainActivity) context).getSupportActionBar().setTitle(context.getString(R.string.artist));
                    Objects.requireNonNull(((MainActivity) context).getSupportActionBar()).setDisplayHomeAsUpEnabled(true);
                });
            }
        } else if (holder instanceof AlbumsHolder) {

            if (((AlbumsHolder) holder).adapterHomeAlbums == null) {
                ((AlbumsHolder) holder).tv_title.setText(arrayList.get(holder.getAbsoluteAdapterPosition()).getTitle());

                ((AlbumsHolder) holder).adapterHomeAlbums = new AdapterHomeAlbums(context, arrayList.get(holder.getAbsoluteAdapterPosition()).getArrayListAlbums());
                ((AlbumsHolder) holder).rv_albums.setAdapter(((AlbumsHolder) holder).adapterHomeAlbums);

                ((AlbumsHolder) holder).rv_albums.addOnItemTouchListener(new RecyclerItemClickListener(context, new RecyclerItemClickListener.OnItemClickListener() {
                    @Override
                    public void onItemClick(View view, int position) {
                        clickPos = holder.getAbsoluteAdapterPosition();
                        methods.showInterAd(position, context.getString(R.string.albums));
                    }
                }));

                ((AlbumsHolder) holder).tv_view_all.setOnClickListener(v -> {
                    FragmentAlbums f_albums = new FragmentAlbums();
                    Bundle bundle = new Bundle();
                    bundle.putBoolean("ishome", true);
                    bundle.putString("id", arrayList.get(holder.getAbsoluteAdapterPosition()).getId());
                    f_albums.setArguments(bundle);
                    FragmentTransaction ft = ((AppCompatActivity) context).getSupportFragmentManager().beginTransaction();
                    ft.setTransition(FragmentTransaction.TRANSIT_FRAGMENT_OPEN);
                    ft.hide(((AppCompatActivity) context).getSupportFragmentManager()
                            .getFragments()
                            .get(((AppCompatActivity) context).getSupportFragmentManager().getBackStackEntryCount()));
                    ft.add(R.id.fragment, f_albums, context.getString(R.string.albums));
                    ft.addToBackStack(context.getString(R.string.albums));
                    ft.commit();
                    ((MainActivity) context).getSupportActionBar().setTitle(context.getString(R.string.albums));
                    Objects.requireNonNull(((MainActivity) context).getSupportActionBar()).setDisplayHomeAsUpEnabled(true);
                });
            }
        } else if (holder instanceof PlaylistHolder) {

            if (((PlaylistHolder) holder).adapterPlaylistHome == null) {
                ((PlaylistHolder) holder).tv_title.setText(arrayList.get(holder.getAbsoluteAdapterPosition()).getTitle());

                ((PlaylistHolder) holder).adapterPlaylistHome = new AdapterPlaylistHome(arrayList.get(holder.getAbsoluteAdapterPosition()).getArrayListPlaylist());
                ((PlaylistHolder) holder).rv_playlist.setAdapter(((PlaylistHolder) holder).adapterPlaylistHome);

                ((PlaylistHolder) holder).rv_playlist.addOnItemTouchListener(new RecyclerItemClickListener(context, new RecyclerItemClickListener.OnItemClickListener() {
                    @Override
                    public void onItemClick(View view, int position) {
                        clickPos = holder.getAbsoluteAdapterPosition();
                        methods.showInterAd(position, context.getString(R.string.playlist));
                    }
                }));

                ((PlaylistHolder) holder).tv_view_all.setOnClickListener(v -> {
                    FragmentServerPlaylist f_art = new FragmentServerPlaylist();
                    Bundle bundle = new Bundle();
                    bundle.putBoolean("ishome", true);
                    bundle.putString("id", arrayList.get(holder.getAbsoluteAdapterPosition()).getId());
                    f_art.setArguments(bundle);
                    FragmentTransaction ft = ((AppCompatActivity) context).getSupportFragmentManager().beginTransaction();
                    ft.setTransition(FragmentTransaction.TRANSIT_FRAGMENT_OPEN);
                    ft.hide(((AppCompatActivity) context).getSupportFragmentManager()
                            .getFragments()
                            .get(((AppCompatActivity) context).getSupportFragmentManager().getBackStackEntryCount()));
                    ft.add(R.id.fragment, f_art, context.getString(R.string.playlist));
                    ft.addToBackStack(context.getString(R.string.playlist));
                    ft.commit();
                    ((MainActivity) context).getSupportActionBar().setTitle(context.getString(R.string.playlist));
                    Objects.requireNonNull(((MainActivity) context).getSupportActionBar()).setDisplayHomeAsUpEnabled(true);
                });
            }
        } else if (holder instanceof RecentSongsHolder) {

            if (((RecentSongsHolder) holder).adapterHomeSongs == null) {

                ((RecentSongsHolder) holder).tv_title.setText(arrayList.get(holder.getAbsoluteAdapterPosition()).getTitle());
                ((RecentSongsHolder) holder).adapterHomeSongs = new AdapterHomeRecent(context, arrayList.get(holder.getAbsoluteAdapterPosition()).getArrayListSongs(), new ClickListenerCallback() {
                    @Override
                    public void onClick(int position) {
                        if (methods.isNetworkAvailable()) {
                            Constant.isOnline = true;
                            String addedFrom = "home".concat(arrayList.get(holder.getAbsoluteAdapterPosition()).getTitle());
                            if (!Constant.addedFrom.equals(addedFrom)) {
                                Constant.arrayList_play.clear();
                                Constant.arrayList_play.addAll(arrayList.get(holder.getAbsoluteAdapterPosition()).getArrayListSongs());
                                Constant.addedFrom = addedFrom;
                                Constant.isNewAdded = true;
                                try {
                                    GlobalBus.getBus().postSticky(new ItemMyPlayList("", "", null));
                                } catch (Exception e) {
                                    e.printStackTrace();
                                }
                            }
                            Constant.playPos = position;

                            methods.showInterAd(position, context.getString(R.string.songs));
                        } else {
                            Toast.makeText(context, context.getString(R.string.err_internet_not_conn), Toast.LENGTH_SHORT).show();
                        }
                    }

                    @Override
                    public void onItemZero() {

                    }
                });
                ((RecentSongsHolder) holder).rv_songs.setAdapter(((RecentSongsHolder) holder).adapterHomeSongs);

                ((RecentSongsHolder) holder).tv_view_all.setOnClickListener(new View.OnClickListener() {
                    @Override
                    public void onClick(View v) {
                        FragmentRecentSongs f_recent = new FragmentRecentSongs();
                        FragmentTransaction ft = ((AppCompatActivity) context).getSupportFragmentManager().beginTransaction();
                        ft.setTransition(FragmentTransaction.TRANSIT_FRAGMENT_OPEN);
                        ft.hide(((AppCompatActivity) context).getSupportFragmentManager()
                                .getFragments()
                                .get(((AppCompatActivity) context).getSupportFragmentManager().getBackStackEntryCount()));
                        ft.add(R.id.fragment, f_recent, context.getString(R.string.recently_played));
                        ft.addToBackStack(context.getString(R.string.recently_played));
                        ft.commit();
                        ((MainActivity) context).getSupportActionBar().setTitle(((RecentSongsHolder) holder).tv_title.getText().toString());
                        Objects.requireNonNull(((MainActivity) context).getSupportActionBar()).setDisplayHomeAsUpEnabled(true);
                    }
                });
            }
        } else if (holder instanceof SongsHolder) {

            if (((SongsHolder) holder).adapterHomeSongs == null) {

                if (!arrayList.get(holder.getAbsoluteAdapterPosition()).getTitle().equals("Trending Songs")) {
                    ((SongsHolder) holder).tv_title.setText(arrayList.get(holder.getAbsoluteAdapterPosition()).getTitle());
                } else {
                    ((SongsHolder) holder).tv_title.setText(context.getString(R.string.trending_songs));
                }
                ((SongsHolder) holder).adapterHomeSongs = new AdapterHomeSongs(context, arrayList.get(holder.getAbsoluteAdapterPosition()).getArrayListSongs(), new ClickListenerCallback() {
                    @Override
                    public void onClick(int position) {
                        if (methods.isNetworkAvailable()) {
                            Constant.isOnline = true;
                            String addedFrom = "home".concat(arrayList.get(holder.getAbsoluteAdapterPosition()).getTitle());
                            if (!Constant.addedFrom.equals(addedFrom)) {
                                Constant.arrayList_play.clear();
                                Constant.arrayList_play.addAll(arrayList.get(holder.getAbsoluteAdapterPosition()).getArrayListSongs());
                                Constant.addedFrom = addedFrom;
                                Constant.isNewAdded = true;
                                try {
                                    GlobalBus.getBus().postSticky(new ItemMyPlayList("", "", null));
                                } catch (Exception e) {
                                    e.printStackTrace();
                                }
                            }
                            Constant.playPos = position;

                            methods.showInterAd(position, context.getString(R.string.songs));
                        } else {
                            Toast.makeText(context, context.getString(R.string.err_internet_not_conn), Toast.LENGTH_SHORT).show();
                        }
                    }

                    @Override
                    public void onItemZero() {

                    }
                });
                ((SongsHolder) holder).rv_songs.setAdapter(((SongsHolder) holder).adapterHomeSongs);

                ((SongsHolder) holder).tv_view_all.setOnClickListener(new View.OnClickListener() {
                    @Override
                    public void onClick(View v) {
                        if (!arrayList.get(holder.getAbsoluteAdapterPosition()).getTitle().equals("Trending Songs")) {
                            FragmentHomeSectionSongs f_trending = new FragmentHomeSectionSongs();
                            Bundle bundle = new Bundle();
                            bundle.putString("id", arrayList.get(holder.getAbsoluteAdapterPosition()).getId());
                            f_trending.setArguments(bundle);
                            FragmentTransaction ft = ((AppCompatActivity) context).getSupportFragmentManager().beginTransaction();
                            ft.setTransition(FragmentTransaction.TRANSIT_FRAGMENT_OPEN);
                            ft.hide(((AppCompatActivity) context).getSupportFragmentManager()
                                    .getFragments()
                                    .get(((AppCompatActivity) context).getSupportFragmentManager().getBackStackEntryCount()));
                            ft.add(R.id.fragment, f_trending, context.getString(R.string.songs));
                            ft.addToBackStack(context.getString(R.string.songs));
                            ft.commit();
                        } else {
                            FragmentTrendingSongs f_trending = new FragmentTrendingSongs();
                            FragmentTransaction ft = ((AppCompatActivity) context).getSupportFragmentManager().beginTransaction();
                            ft.setTransition(FragmentTransaction.TRANSIT_FRAGMENT_OPEN);
                            ft.hide(((AppCompatActivity) context).getSupportFragmentManager()
                                    .getFragments()
                                    .get(((AppCompatActivity) context).getSupportFragmentManager().getBackStackEntryCount()));
                            ft.add(R.id.fragment, f_trending, context.getString(R.string.trending_songs));
                            ft.addToBackStack(context.getString(R.string.trending_songs));
                            ft.commit();
                        }
                        ((MainActivity) context).getSupportActionBar().setTitle(((SongsHolder) holder).tv_title.getText().toString());
                        Objects.requireNonNull(((MainActivity) context).getSupportActionBar()).setDisplayHomeAsUpEnabled(true);
                    }
                });
            }
        }
    }

    @Override
    public long getItemId(int id) {
        return id;
    }

    @Override
    public int getItemCount() {
        return arrayList.size();
    }

    public void hideHeader() {
        ProgressViewHolder.progressBar.setVisibility(View.GONE);
    }

    public boolean isHeader(int position) {
        return arrayList.get(position) == null;
    }

    @Override
    public int getItemViewType(int position) {
        switch (arrayList.get(position).getType()) {
            case "song":
                return VIEW_SONGS;
            case "recent":
                return VIEW_RECENT;
            case "artist":
                return VIEW_ARTIST;
            case "album":
                return VIEW_ALBUMS;
            case "playlist":
                return VIEW_PLAYLIST;
            case "category":
                return VIEW_CATEGORIES;
            case "slider":
                return VIEW_BANNER;
            default:
                return VIEW_PROG;
        }
    }

    InterAdListener interAdListener = new InterAdListener() {
        @Override
        public void onClick(int position, String type) {
            if (type.equals(context.getString(R.string.songs))) {
                Intent intent = new Intent(context, PlayerService.class);
                intent.setAction(PlayerService.ACTION_PLAY);
                context.startService(intent);
            } else if (type.equals(context.getString(R.string.artist))) {
                Intent intent = new Intent(context, SongByCatActivity.class);
                intent.putExtra("type", context.getString(R.string.artist));
                intent.putExtra("id", arrayList.get(clickPos).getArrayListArtist().get(position).getId());
                intent.putExtra("name", arrayList.get(clickPos).getArrayListArtist().get(position).getName());
                context.startActivity(intent);
            } else if (type.equals(context.getString(R.string.albums))) {
                Intent intent = new Intent(context, SongByCatActivity.class);
                intent.putExtra("type", context.getString(R.string.albums));
                intent.putExtra("id", arrayList.get(clickPos).getArrayListAlbums().get(position).getId());
                intent.putExtra("name", arrayList.get(clickPos).getArrayListAlbums().get(position).getName());
                context.startActivity(intent);
            } else if (type.equals(context.getString(R.string.categories))) {
                Intent intent = new Intent(context, SongByCatActivity.class);
                intent.putExtra("type", context.getString(R.string.categories));
                intent.putExtra("id", arrayList.get(clickPos).getArrayListCategories().get(position).getId());
                intent.putExtra("name", arrayList.get(clickPos).getArrayListCategories().get(position).getName());
                context.startActivity(intent);
            } else if (type.equals(context.getString(R.string.playlist))) {
                Intent intent = new Intent(context, SongByServerPlaylistActivity.class);
                intent.putExtra("item", arrayList.get(clickPos).getArrayListPlaylist().get(position));
                context.startActivity(intent);
            }
        }
    };
}