package com.vpapps.adapter;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;

import com.makeramen.roundedimageview.RoundedImageView;
import com.squareup.picasso.Picasso;
import com.vpapps.interfaces.ClickListenerCallback;
import com.vpapps.item.ItemSong;
import com.vpapps.onlinemp3.R;
import com.vpapps.utils.Methods;

import java.util.ArrayList;

import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;

public class AdapterHomeSongs extends RecyclerView.Adapter<AdapterHomeSongs.MyViewHolder> {

    Methods methods;
    Context context;
    ArrayList<ItemSong> arrayList;
    ClickListenerCallback clickListenerCallback;

    static class MyViewHolder extends RecyclerView.ViewHolder {
        RoundedImageView iv_song;
        TextView tv_title;

        MyViewHolder(View view) {
            super(view);
            iv_song = view.findViewById(R.id.iv_recent);
            tv_title = view.findViewById(R.id.tv_home_song);
        }
    }

    public AdapterHomeSongs(Context context, ArrayList<ItemSong> arrayList, ClickListenerCallback clickListenerCallback) {
        this.context = context;
        this.arrayList = arrayList;
        this.clickListenerCallback = clickListenerCallback;
        methods = new Methods(context);
    }

    @NonNull
    @Override
    public MyViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        View itemView = LayoutInflater.from(parent.getContext())
                .inflate(R.layout.layout_songs_home, parent, false);

        return new MyViewHolder(itemView);
    }

    @Override
    public void onBindViewHolder(@NonNull final MyViewHolder holder, int position) {

        holder.tv_title.setText(arrayList.get(position).getTitle());
        Picasso.get()
                .load(arrayList.get(position).getImageBig())
                .resize(300,300)
                .placeholder(R.drawable.placeholder_song)
                .into(holder.iv_song);

        holder.iv_song.setOnClickListener(v -> {
            clickListenerCallback.onClick(holder.getAbsoluteAdapterPosition());
        });
    }

    @Override
    public long getItemId(int id) {
        return id;
    }

    @Override
    public int getItemCount() {
        return arrayList.size();
    }
}