package com.vpapps.adapter;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;

import com.google.android.material.button.MaterialButton;
import com.vpapps.interfaces.ClickListenerCallback;
import com.vpapps.item.ItemLoggedDevice;
import com.vpapps.onlinemp3.R;
import com.vpapps.utils.Methods;

import java.util.ArrayList;


public class AdapterLoggedDevice extends RecyclerView.Adapter<AdapterLoggedDevice.MyViewHolder> {

    Context context;
    ArrayList<ItemLoggedDevice> arrayList;
    Methods methods;
    ClickListenerCallback clickListenerCallback;

    public AdapterLoggedDevice(Context context, ArrayList<ItemLoggedDevice> arrayList, ClickListenerCallback clickListenerCallback) {
        this.context = context;
        this.arrayList = arrayList;
        this.clickListenerCallback = clickListenerCallback;
        methods = new Methods(context);
    }

    static class MyViewHolder extends RecyclerView.ViewHolder {
        MaterialButton btn_logout;
        TextView tv_name, tv_date;

        MyViewHolder(View view) {
            super(view);
            btn_logout = view.findViewById(R.id.btn_device_logout);
            tv_name = view.findViewById(R.id.tv_device_name);
            tv_date = view.findViewById(R.id.tv_device_date);
        }
    }

    @NonNull
    @Override
    public MyViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        View itemView = LayoutInflater.from(parent.getContext()).inflate(R.layout.layout_logged_device, parent, false);

        return new MyViewHolder(itemView);
    }

    @Override
    public void onBindViewHolder(@NonNull final MyViewHolder holder, int position) {
        holder.tv_name.setText(arrayList.get(holder.getAbsoluteAdapterPosition()).getDeviceName());
        holder.tv_date.setText(context.getString(R.string.logged_on).concat(arrayList.get(holder.getAbsoluteAdapterPosition()).getDateTime()));

        holder.btn_logout.setOnClickListener(view -> {
            clickListenerCallback.onClick(holder.getAbsoluteAdapterPosition());
        });
    }

    @Override
    public long getItemId(int id) {
        return id;
    }

    @Override
    public int getItemCount() {
        return arrayList.size();
    }
}