package com.vpapps.adapter;

import static android.app.Activity.RESULT_OK;

import android.app.Activity;
import android.content.ContentValues;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.media.MediaMetadataRetriever;
import android.media.RingtoneManager;
import android.net.Uri;
import android.provider.MediaStore;
import android.provider.Settings;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Filter;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;
import android.widget.Toast;

import androidx.annotation.NonNull;
import androidx.constraintlayout.widget.ConstraintLayout;
import androidx.recyclerview.widget.RecyclerView;

import com.google.android.material.bottomsheet.BottomSheetDialog;
import com.google.android.material.button.MaterialButton;
import com.squareup.picasso.Picasso;
import com.vpapps.interfaces.ClickDeleteListenerPlayList;
import com.vpapps.item.ItemMyPlayList;
import com.vpapps.item.ItemSong;
import com.vpapps.onlinemp3.PlayerService;
import com.vpapps.onlinemp3.R;
import com.vpapps.onlinemp3.SongByOFFPlaylistActivity;
import com.vpapps.utils.Constant;
import com.vpapps.utils.DBHelper;
import com.vpapps.utils.GlobalBus;
import com.vpapps.utils.Methods;

import java.io.File;
import java.util.ArrayList;

import es.claucookie.miniequalizerlibrary.EqualizerView;


public class AdapterOFSongList extends RecyclerView.Adapter<AdapterOFSongList.MyViewHolder> {

    Context context;
    ArrayList<ItemSong> arrayList;
    ArrayList<ItemSong> filteredArrayList;
    ClickDeleteListenerPlayList clickDeleteListenerPlayList;
    NameFilter filter;
    String type;
    Methods methods;
    DBHelper dbHelper;
    int posi = 0, DELETE_REQUEST_URI_R = 11, DELETE_REQUEST_URI_Q = 12;

    class MyViewHolder extends RecyclerView.ViewHolder {
        TextView textView_song, textView_artist;
        EqualizerView equalizer;
        ImageView imageView, imageView_option;
        RelativeLayout rl;

        MyViewHolder(View view) {
            super(view);
            rl = view.findViewById(R.id.ll_off_songlist);
            textView_song = view.findViewById(R.id.tv_off_songlist_name);
            equalizer = view.findViewById(R.id.equalizer_view_off);
            textView_artist = view.findViewById(R.id.tv_off_songlist_art);
            imageView = view.findViewById(R.id.iv_off_songlist);
            imageView_option = view.findViewById(R.id.iv_off_songlist_option);
        }
    }

    public AdapterOFSongList(Context context, ArrayList<ItemSong> arrayList, ClickDeleteListenerPlayList clickDeleteListenerPlayList, String type) {
        this.arrayList = arrayList;
        this.filteredArrayList = arrayList;
        this.context = context;
        this.type = type;
        this.clickDeleteListenerPlayList = clickDeleteListenerPlayList;
        methods = new Methods(context);
        dbHelper = new DBHelper(context);
    }

    @NonNull
    @Override
    public MyViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        View itemView = LayoutInflater.from(parent.getContext())
                .inflate(R.layout.layout_offline_songs, parent, false);

        return new MyViewHolder(itemView);
    }

    @Override
    public void onBindViewHolder(@NonNull final MyViewHolder holder, int position) {

        holder.textView_song.setText(arrayList.get(position).getTitle());

        Picasso.get()
                .load(Uri.parse(arrayList.get(holder.getAdapterPosition()).getImageBig()))
                .resize(300, 300)
                .placeholder(R.drawable.placeholder_song)
                .into(holder.imageView);

        if (PlayerService.getIsPlayling() && Constant.arrayList_play.get(Constant.playPos).getId().equals(arrayList.get(position).getId())) {
            holder.imageView.setVisibility(View.INVISIBLE);
            holder.equalizer.setVisibility(View.VISIBLE);
            holder.equalizer.animateBars();
        } else {
            holder.imageView.setVisibility(View.VISIBLE);
            holder.equalizer.setVisibility(View.GONE);
            holder.equalizer.stopBars();
        }

        holder.textView_artist.setText(arrayList.get(position).getArtist());

        holder.rl.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                Constant.isDownloaded = type.equals("downloads");
                clickDeleteListenerPlayList.onClick(getPosition(arrayList.get(holder.getAdapterPosition()).getId()));
            }
        });

        holder.imageView_option.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                openOptionPopUp(holder.getAdapterPosition());
            }
        });
    }

    @Override
    public long getItemId(int id) {
        return id;
    }

    @Override
    public int getItemCount() {
        return arrayList.size();
    }

    public ItemSong getItem(int pos) {
        return arrayList.get(pos);
    }

    private int getPosition(String id) {
        int count = 0;
        for (int i = 0; i < filteredArrayList.size(); i++) {
            if (id.equals(filteredArrayList.get(i).getId())) {
                count = i;
                break;
            }
        }
        return count;
    }

    private void openOptionPopUp(final int pos) {
        View view = ((Activity) context).getLayoutInflater().inflate(R.layout.layout_bottomsheet_songs_offline, null);

        BottomSheetDialog dialog = new BottomSheetDialog(context);
        dialog.setContentView(view);
        dialog.getWindow().findViewById(R.id.design_bottom_sheet).setBackgroundResource(android.R.color.transparent);
        dialog.show();

        TextView tv_add_playlist = dialog.findViewById(R.id.tv_option_add_playlist);
        TextView tv_add_queue = dialog.findViewById(R.id.tv_option_add_queue);
        TextView tv_youtube = dialog.findViewById(R.id.tv_option_youtube);
        TextView tv_set_as = dialog.findViewById(R.id.tv_option_setas);
        TextView tv_delete = dialog.findViewById(R.id.tv_option_delete);
        TextView tv_share = dialog.findViewById(R.id.tv_option_share);

        if (type.equals("downloads")) {
            tv_set_as.setVisibility(View.GONE);
            tv_add_queue.setVisibility(View.GONE);
            tv_add_playlist.setVisibility(View.GONE);
            dialog.findViewById(R.id.iv_options_queue).setVisibility(View.GONE);
            dialog.findViewById(R.id.iv_options_playlist).setVisibility(View.GONE);
            dialog.findViewById(R.id.iv_options_setas).setVisibility(View.GONE);

            ConstraintLayout.LayoutParams params = (ConstraintLayout.LayoutParams) tv_youtube.getLayoutParams();
            params.topMargin = 40;
        }
        if (type.equals(context.getString(R.string.playlist))) {
            tv_add_playlist.setText(context.getString(R.string.remove));
            tv_delete.setVisibility(View.GONE);
            dialog.findViewById(R.id.iv_options_playlist).setVisibility(View.GONE);
            dialog.findViewById(R.id.iv_options_delete).setVisibility(View.GONE);
        }
        if (Constant.isOnline || Constant.isDownloaded) {
            tv_add_queue.setVisibility(View.GONE);
            dialog.findViewById(R.id.iv_options_queue).setVisibility(View.GONE);
        }
        if (!methods.isYoutubeAppInstalled()) {
            tv_youtube.setVisibility(View.GONE);
            dialog.findViewById(R.id.iv_option_youtube).setVisibility(View.GONE);
        }

        tv_add_playlist.setOnClickListener(view1 -> {
            dialog.dismiss();
            if (type.equals(context.getString(R.string.playlist))) {
                dbHelper.removeFromPlayList(arrayList.get(pos).getId(), false);
                arrayList.remove(pos);
                notifyItemRemoved(pos);
                Toast.makeText(context, context.getString(R.string.remove_from_playlist), Toast.LENGTH_SHORT).show();
                if (arrayList.size() == 0) {
                    clickDeleteListenerPlayList.onItemZero();
                }
            } else {
                methods.showBottomSheetAddToPlaylist(arrayList.get(pos), false);
            }
        });

        tv_add_queue.setOnClickListener(view1 -> {
            dialog.dismiss();
            Constant.arrayList_play.add(arrayList.get(pos));
            PlayerService.getInstance().addMediaSource(Uri.parse(arrayList.get(pos).getUrl()));
            GlobalBus.getBus().postSticky(new ItemMyPlayList("", "", null));
        });

        tv_delete.setOnClickListener(view1 -> {
            dialog.dismiss();
            openDeleteDialog(pos);
        });

        tv_set_as.setOnClickListener(view1 -> {
            dialog.dismiss();
            showBottomSheetDialog(pos);
        });

        tv_youtube.setOnClickListener(view1 -> {
            dialog.dismiss();
            Intent intent = new Intent(Intent.ACTION_SEARCH);
            intent.setPackage("com.google.android.youtube");
            intent.putExtra("query", arrayList.get(pos).getTitle());
            intent.setFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
            context.startActivity(intent);
        });

        tv_share.setOnClickListener(view1 -> {
            dialog.dismiss();
            methods.shareSong(arrayList.get(pos), true);
        });
    }

    private void openDeleteDialog(final int pos) {
        View view = ((Activity)context).getLayoutInflater().inflate(R.layout.layout_bottom_logout, null);

        BottomSheetDialog dialog = new BottomSheetDialog(context);
        dialog.setContentView(view);
        dialog.getWindow().findViewById(R.id.design_bottom_sheet).setBackgroundResource(android.R.color.transparent);
        dialog.show();

        MaterialButton btn_stop = dialog.findViewById(R.id.btn_bottom_logout);
        MaterialButton btn_cancel = dialog.findViewById(R.id.btn_bottom_cancel);
        TextView tv1 = dialog.findViewById(R.id.tv1);
        TextView tv2 = dialog.findViewById(R.id.tv2);

        btn_stop.setText(context.getString(R.string.delete));
        tv1.setText(context.getString(R.string.delete));
        tv2.setText(context.getString(R.string.sure_delete_playlist));

        btn_stop.setOnClickListener(view1 -> {
            dialog.dismiss();

            posi = pos;
            if (type.equals("downloads")) {
                final File file = new File(arrayList.get(pos).getUrl());
                final File file_image = new File(arrayList.get(pos).getImageBig());
                if (file.exists()) {
                    if (type.equals("downloads")) {
                        dbHelper.removeFromDownload(arrayList.get(pos).getId());

                    }
                    file.delete();
                    file_image.delete();
                    arrayList.remove(pos);
                    notifyItemRemoved(pos);
                }
                Toast.makeText(context, context.getString(R.string.file_deleted), Toast.LENGTH_SHORT).show();
            } else {
                try {
                    int delete = context.getContentResolver().delete(Uri.parse(arrayList.get(pos).getUrl()), null, null);
                    if (delete == 1) {
                        arrayList.remove(pos);
                        notifyItemRemoved(pos);
                        Toast.makeText(context, context.getString(R.string.file_deleted), Toast.LENGTH_SHORT).show();
                    } else {
                        Toast.makeText(context, context.getString(R.string.error_file_delete), Toast.LENGTH_SHORT).show();
                    }
                } catch (Exception exception) {
                    clickDeleteListenerPlayList.onDelete(posi, exception, DELETE_REQUEST_URI_R, DELETE_REQUEST_URI_Q);
                }
            }
        });

        btn_cancel.setOnClickListener(view1 -> dialog.dismiss());
    }


    private void showBottomSheetDialog(final int pos) {
        LayoutInflater inflater = (LayoutInflater) context.getSystemService(Context.LAYOUT_INFLATER_SERVICE);
        assert inflater != null;
        View view = inflater.inflate(R.layout.layout_audio_setas, null);

        BottomSheetDialog dialog_setas = new BottomSheetDialog(context);
        dialog_setas.setContentView(view);
        dialog_setas.getWindow().findViewById(R.id.design_bottom_sheet).setBackgroundResource(android.R.color.transparent);
        dialog_setas.show();

        LinearLayout ll_set_ring = dialog_setas.findViewById(R.id.ll_set_ring);
        LinearLayout ll_set_noti = dialog_setas.findViewById(R.id.ll_set_noti);
        LinearLayout ll_set_alarm = dialog_setas.findViewById(R.id.ll_set_alarm);

        ll_set_ring.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                setRingtone(pos, "ring");
            }
        });

        ll_set_noti.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                setRingtone(pos, "noti");
            }
        });

        ll_set_alarm.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                setRingtone(pos, "alarm");
            }
        });
    }

    private void setRingtone(final int pos, final String type) {
        boolean settingsCanWrite = false;
        if (android.os.Build.VERSION.SDK_INT >= android.os.Build.VERSION_CODES.M) {
            settingsCanWrite = Settings.System.canWrite(context);

            if (!settingsCanWrite) {
                // If do not have write settings permission then open the Can modify system settings panel.
                Intent intent = new Intent(Settings.ACTION_MANAGE_WRITE_SETTINGS);
                context.startActivity(intent);
            } else {
                loadRingTone(pos, type);
            }
        } else {
            loadRingTone(pos, type);
        }
    }

    private void loadRingTone(final int pos, final String type) {
        switch (type) {
            case "ring":
                setAsRingtone(arrayList.get(pos));
                break;
            case "noti":
                setNoti(arrayList.get(pos));
                break;
            case "alarm":
                setAlarm(arrayList.get(pos));
                break;
        }
    }

    private void setAsRingtone(ItemSong itemSong) {
        String filePath = itemSong.getUrl();

        File ringtoneFile = new File(filePath);

        MediaMetadataRetriever md = new MediaMetadataRetriever();
        md.setDataSource(ringtoneFile.getAbsolutePath());
        String title = ringtoneFile.getName();
        String duration = md.extractMetadata(MediaMetadataRetriever.METADATA_KEY_DURATION);
        String artist = md.extractMetadata(MediaMetadataRetriever.METADATA_KEY_ARTIST);

        ContentValues content = new ContentValues();
        content.put(MediaStore.MediaColumns.DATA, filePath);
        content.put(MediaStore.MediaColumns.TITLE, title);
        content.put(MediaStore.MediaColumns.SIZE, ringtoneFile.length());
        content.put(MediaStore.MediaColumns.MIME_TYPE, "audio/*");
        content.put(MediaStore.Audio.Media.ARTIST, artist);
        content.put(MediaStore.Audio.Media.DURATION, duration);
        content.put(MediaStore.Audio.Media.IS_RINGTONE, true);
        content.put(MediaStore.Audio.Media.IS_NOTIFICATION, true);
        content.put(MediaStore.Audio.Media.IS_ALARM, true);
        content.put(MediaStore.Audio.Media.IS_MUSIC, true);

        Uri uri = MediaStore.Audio.Media.getContentUriForPath(ringtoneFile.getAbsolutePath());

        context.getContentResolver().delete(uri, MediaStore.MediaColumns.DATA + "=\"" + ringtoneFile.getAbsolutePath() + "\"", null);
        Uri newUri = context.getContentResolver().insert(uri, content);

        RingtoneManager.setActualDefaultRingtoneUri(context, RingtoneManager.TYPE_RINGTONE, newUri);

        Toast.makeText(context, context.getString(R.string.ringtone_set), Toast.LENGTH_SHORT).show();
    }

    private void setAlarm(ItemSong itemSong) {
        String filePath = itemSong.getUrl();

        File ringtoneFile = new File(filePath);

        MediaMetadataRetriever md = new MediaMetadataRetriever();
        md.setDataSource(ringtoneFile.getAbsolutePath());
        String title = ringtoneFile.getName();
        String duration = md.extractMetadata(MediaMetadataRetriever.METADATA_KEY_DURATION);
        String artist = md.extractMetadata(MediaMetadataRetriever.METADATA_KEY_ARTIST);

        ContentValues content = new ContentValues();
        content.put(MediaStore.MediaColumns.DATA, filePath);
        content.put(MediaStore.MediaColumns.TITLE, title);
        content.put(MediaStore.MediaColumns.SIZE, ringtoneFile.length());
        content.put(MediaStore.MediaColumns.MIME_TYPE, "audio/*");
        content.put(MediaStore.Audio.Media.ARTIST, artist);
        content.put(MediaStore.Audio.Media.DURATION, Integer.parseInt(duration));
        content.put(MediaStore.Audio.Media.IS_RINGTONE, true);
        content.put(MediaStore.Audio.Media.IS_NOTIFICATION, true);
        content.put(MediaStore.Audio.Media.IS_ALARM, true);
        content.put(MediaStore.Audio.Media.IS_MUSIC, true);

        Uri uri = MediaStore.Audio.Media.getContentUriForPath(ringtoneFile.getAbsolutePath());

        context.getContentResolver().delete(uri, MediaStore.MediaColumns.DATA + "=\"" + ringtoneFile.getAbsolutePath() + "\"", null);
        Uri newUri = context.getContentResolver().insert(uri, content);

        RingtoneManager.setActualDefaultRingtoneUri(context, RingtoneManager.TYPE_ALARM, newUri);

        Toast.makeText(context, context.getString(R.string.alarm_set), Toast.LENGTH_SHORT).show();
    }

    private void setNoti(ItemSong itemSong) {

        String filePath = itemSong.getUrl();

        File ringtoneFile = new File(filePath);

        MediaMetadataRetriever md = new MediaMetadataRetriever();
        md.setDataSource(ringtoneFile.getAbsolutePath());
        String title = ringtoneFile.getName();
        String duration = md.extractMetadata(MediaMetadataRetriever.METADATA_KEY_DURATION);
        String artist = md.extractMetadata(MediaMetadataRetriever.METADATA_KEY_ARTIST);

        ContentValues content = new ContentValues();
        content.put(MediaStore.MediaColumns.DATA, filePath);
        content.put(MediaStore.MediaColumns.TITLE, title);
        content.put(MediaStore.MediaColumns.SIZE, ringtoneFile.length());
        content.put(MediaStore.MediaColumns.MIME_TYPE, "audio/*");
        content.put(MediaStore.Audio.Media.ARTIST, artist);
        content.put(MediaStore.Audio.Media.DURATION, duration);
        content.put(MediaStore.Audio.Media.IS_RINGTONE, true);
        content.put(MediaStore.Audio.Media.IS_NOTIFICATION, true);
        content.put(MediaStore.Audio.Media.IS_ALARM, true);
        content.put(MediaStore.Audio.Media.IS_MUSIC, true);

        Uri uri = MediaStore.Audio.Media.getContentUriForPath(ringtoneFile.getAbsolutePath());

        context.getContentResolver().delete(uri, MediaStore.MediaColumns.DATA + "=\"" + ringtoneFile.getAbsolutePath() + "\"", null);
        Uri newUri = context.getContentResolver().insert(uri, content);

        RingtoneManager.setActualDefaultRingtoneUri(context, RingtoneManager.TYPE_NOTIFICATION, newUri);

        Toast.makeText(context, context.getString(R.string.noti_set), Toast.LENGTH_SHORT).show();
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        if (requestCode == DELETE_REQUEST_URI_R) {
            if (resultCode == RESULT_OK) {
                arrayList.remove(posi);
                notifyItemRemoved(posi);
                Toast.makeText(context, context.getResources().getString(R.string.file_deleted), Toast.LENGTH_SHORT).show();
            }
        } else if (requestCode == DELETE_REQUEST_URI_Q) {
            if (resultCode == RESULT_OK) {
                int delete = context.getContentResolver().delete(Uri.parse(arrayList.get(posi).getUrl()), null, null);
                if (delete == 1) {
                    arrayList.remove(posi);
                    notifyItemRemoved(posi);
                    Toast.makeText(context, context.getResources().getString(R.string.file_deleted), Toast.LENGTH_SHORT).show();
                } else {
                    Toast.makeText(context, context.getResources().getString(R.string.error_file_delete), Toast.LENGTH_SHORT).show();
                }
            }
        }
    }

    public Filter getFilter() {
        if (filter == null) {
            filter = new NameFilter();
        }
        return filter;
    }

    private class NameFilter extends Filter {

        @Override
        protected FilterResults performFiltering(CharSequence constraint) {

            constraint = constraint.toString().toLowerCase();
            FilterResults result = new FilterResults();
            if (!constraint.toString().isEmpty()) {
                ArrayList<ItemSong> filteredItems = new ArrayList<>();

                for (int i = 0, l = filteredArrayList.size(); i < l; i++) {
                    String nameList = filteredArrayList.get(i).getTitle();
                    if (nameList.toLowerCase().contains(constraint))
                        filteredItems.add(filteredArrayList.get(i));
                }
                result.count = filteredItems.size();
                result.values = filteredItems;
            } else {
                synchronized (this) {
                    result.values = filteredArrayList;
                    result.count = filteredArrayList.size();
                }
            }
            return result;
        }

        @SuppressWarnings("unchecked")
        @Override
        protected void publishResults(CharSequence constraint,
                                      FilterResults results) {

            arrayList = (ArrayList<ItemSong>) results.values;
            notifyDataSetChanged();
        }
    }

    public void closeDatabase() {
        try {
            dbHelper.close();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
}