package com.vpapps.adapter;

import android.content.Context;
import android.graphics.PorterDuff;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.RadioButton;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.constraintlayout.widget.ConstraintLayout;
import androidx.core.content.ContextCompat;
import androidx.recyclerview.widget.RecyclerView;

import com.squareup.picasso.Picasso;
import com.vpapps.item.ItemPaymentMethod;
import com.vpapps.onlinemp3.R;
import com.vpapps.utils.Methods;

import java.util.ArrayList;


public class AdapterPaymentMethods extends RecyclerView.Adapter<AdapterPaymentMethods.MyViewHolder> {

    Context context;
    ArrayList<ItemPaymentMethod> arrayList;
    int selectedPos = -1, oldSelectedPos = -1;

    public AdapterPaymentMethods(Context context, ArrayList<ItemPaymentMethod> arrayList) {
        this.context = context;
        this.arrayList = arrayList;
    }

    static class MyViewHolder extends RecyclerView.ViewHolder {
        ConstraintLayout cl_payment;
        RadioButton radioButton;
        ImageView iv_payment;
        TextView tv_title;

        MyViewHolder(View view) {
            super(view);
            cl_payment = view.findViewById(R.id.cl_payment_method);
            radioButton = view.findViewById(R.id.rb_payment);
            iv_payment = view.findViewById(R.id.iv_payment);
            tv_title = view.findViewById(R.id.tv_payment_title);
        }
    }

    @NonNull
    @Override
    public MyViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        View itemView = LayoutInflater.from(parent.getContext()).inflate(R.layout.layout_payment_methods, parent, false);

        return new MyViewHolder(itemView);
    }

    @Override
    public void onBindViewHolder(@NonNull final MyViewHolder holder, int position) {
        holder.tv_title.setText(arrayList.get(holder.getAbsoluteAdapterPosition()).getName());
        Picasso.get()
                .load(arrayList.get(holder.getAbsoluteAdapterPosition()).getLogo())
                .into(holder.iv_payment);

        if (selectedPos != -1 && selectedPos == holder.getAbsoluteAdapterPosition()) {
            holder.cl_payment.setBackgroundResource(R.drawable.bg_gradient_button_corner);
            holder.radioButton.setChecked(true);

            holder.tv_title.setTextColor(ContextCompat.getColor(context, R.color.text_final_title));
            holder.iv_payment.setColorFilter(ContextCompat.getColor(context, R.color.white), PorterDuff.Mode.SRC_IN);
        } else {
            holder.cl_payment.setBackgroundColor(ContextCompat.getColor(context, R.color.bg_items));
            holder.radioButton.setChecked(false);

            holder.tv_title.setTextColor(ContextCompat.getColor(context, R.color.text_black));
            if(new Methods(context).isDarkMode()) {
                holder.iv_payment.setColorFilter(ContextCompat.getColor(context, R.color.white), PorterDuff.Mode.SRC_IN);
            } else {
                holder.iv_payment.setColorFilter(null);
            }
        }

        holder.cl_payment.setOnClickListener(view -> {
            if (oldSelectedPos != -1) {
                oldSelectedPos = selectedPos;
                notifyItemChanged(selectedPos);
            } else {
                oldSelectedPos = holder.getAbsoluteAdapterPosition();
            }
            selectedPos = holder.getAbsoluteAdapterPosition();


            notifyItemChanged(holder.getAbsoluteAdapterPosition());
        });

        holder.radioButton.setOnClickListener(view -> {
            holder.cl_payment.performClick();
        });
    }

    @Override
    public long getItemId(int id) {
        return id;
    }

    @Override
    public int getItemCount() {
        return arrayList.size();
    }

    public int getSelectedPos() {
        return selectedPos;
    }
}