package com.vpapps.adapter;

import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.cardview.widget.CardView;
import androidx.recyclerview.widget.RecyclerView;

import com.vpapps.interfaces.ClickListenerCallback;
import com.vpapps.item.ItemMyPlayList;
import com.vpapps.onlinemp3.R;

import java.util.ArrayList;


public class AdapterPlaylistDialog extends RecyclerView.Adapter<AdapterPlaylistDialog.MyViewHolder> {

    ArrayList<ItemMyPlayList> arrayList;
    ClickListenerCallback clickListenerCallback;

    static class MyViewHolder extends RecyclerView.ViewHolder {
        CardView cv_playlist;
        TextView textView;

        MyViewHolder(View view) {
            super(view);
            cv_playlist = view.findViewById(R.id.cv_playlist_dialog);
            textView = view.findViewById(R.id.textView_playlist_dialog);
        }
    }

    public AdapterPlaylistDialog(ArrayList<ItemMyPlayList> arrayList, ClickListenerCallback clickListenerCallback) {
        this.arrayList = arrayList;
        this.clickListenerCallback = clickListenerCallback;
    }

    @NonNull
    @Override
    public MyViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        View itemView = LayoutInflater.from(parent.getContext()).inflate(R.layout.layout_playlist_dialog, parent, false);
        return new MyViewHolder(itemView);
    }

    @Override
    public void onBindViewHolder(@NonNull final MyViewHolder holder, int position) {
        holder.textView.setText(arrayList.get(position).getName());
        holder.cv_playlist.setOnClickListener(view -> clickListenerCallback.onClick(holder.getAbsoluteAdapterPosition()));
    }

    @Override
    public long getItemId(int id) {
        return id;
    }

    @Override
    public int getItemCount() {
        return arrayList.size();
    }
}