package com.vpapps.adapter;

import android.graphics.Typeface;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;

import com.makeramen.roundedimageview.RoundedImageView;
import com.squareup.picasso.Picasso;
import com.vpapps.item.ItemServerPlayList;
import com.vpapps.onlinemp3.R;

import java.util.ArrayList;

import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;

public class AdapterPlaylistHome extends RecyclerView.Adapter<AdapterPlaylistHome.MyViewHolder> {

    private ArrayList<ItemServerPlayList> arrayList;

    class MyViewHolder extends RecyclerView.ViewHolder {
        RoundedImageView iv_playlist;
        TextView tv_playlist;

        MyViewHolder(View view) {
            super(view);
            iv_playlist = view.findViewById(R.id.iv_home_playlist);
            tv_playlist = view.findViewById(R.id.tv_home_playlist);
        }
    }

    public AdapterPlaylistHome(ArrayList<ItemServerPlayList> arrayList) {
        this.arrayList = arrayList;
    }

    @NonNull
    @Override
    public MyViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        View itemView = LayoutInflater.from(parent.getContext())
                .inflate(R.layout.layout_playlist_home, parent, false);

        return new MyViewHolder(itemView);
    }

    @Override
    public void onBindViewHolder(@NonNull MyViewHolder holder, int position) {

        holder.tv_playlist.setText(arrayList.get(position).getName());
        Picasso.get()
                .load(arrayList.get(position).getImage())
                .resize(300,300)
                .placeholder(R.drawable.placeholder_song)
                .into(holder.iv_playlist);
    }

    @Override
    public long getItemId(int id) {
        return id;
    }

    @Override
    public int getItemCount() {
        return arrayList.size();
    }
}