package com.vpapps.adapter;

import android.content.Context;
import android.content.Intent;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ProgressBar;
import android.widget.TextView;
import android.widget.Toast;

import com.vpapps.fragment.FragmentSearchAlbums;
import com.vpapps.fragment.FragmentSearchArtist;
import com.vpapps.fragment.FragmentSearchCategories;
import com.vpapps.fragment.FragmentSearchPlaylist;
import com.vpapps.fragment.FragmentSearchSong;
import com.vpapps.interfaces.ClickListenerCallback;
import com.vpapps.interfaces.InterAdListener;
import com.vpapps.item.ItemMyPlayList;
import com.vpapps.item.ItemPost;
import com.vpapps.onlinemp3.PlayerService;
import com.vpapps.onlinemp3.R;
import com.vpapps.onlinemp3.SongByCatActivity;
import com.vpapps.onlinemp3.SongByServerPlaylistActivity;
import com.vpapps.utils.Constant;
import com.vpapps.utils.GlobalBus;
import com.vpapps.utils.Methods;
import com.vpapps.utils.RecyclerItemClickListener;

import java.util.ArrayList;

import androidx.annotation.NonNull;
import androidx.appcompat.app.AppCompatActivity;
import androidx.fragment.app.FragmentTransaction;
import androidx.recyclerview.widget.DefaultItemAnimator;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;

public class AdapterSearch extends RecyclerView.Adapter {

    Context context;
    Methods methods;
    ArrayList<ItemPost> arrayList;
    int clickPos = 0;

    final int VIEW_PROG = 0;
    final int VIEW_SONGS = 2;
    final int VIEW_ARTIST = 3;
    final int VIEW_ALBUMS = 4;
    final int VIEW_CATEGORIES = 5;
    final int VIEW_PLAYLIST = 6;

    public AdapterSearch(Context context, ArrayList<ItemPost> arrayList) {
        this.context = context;
        this.arrayList = arrayList;
        methods = new Methods(context, interAdListener);
    }

    class CategoriesHolder extends RecyclerView.ViewHolder {
        RecyclerView rv_cat;
        AdapterHomeCat adapterHomeCat;
        TextView tv_title, tv_view_all;

        CategoriesHolder(View view) {
            super(view);
            rv_cat = view.findViewById(R.id.rv_home_cat);
            tv_title = view.findViewById(R.id.tv_home_title);
            tv_view_all = view.findViewById(R.id.tv_home_view_all);

            LinearLayoutManager llm_artist = new LinearLayoutManager(context, LinearLayoutManager.HORIZONTAL, false);
            rv_cat.setLayoutManager(llm_artist);
            rv_cat.setItemAnimator(new DefaultItemAnimator());
        }
    }

    class ArtistHolder extends RecyclerView.ViewHolder {
        RecyclerView rv_artist;
        AdapterHomeArtist adapterHomeArtist;
        TextView tv_title, tv_view_all;

        ArtistHolder(View view) {
            super(view);
            rv_artist = view.findViewById(R.id.rv_home_cat);
            tv_title = view.findViewById(R.id.tv_home_title);
            tv_view_all = view.findViewById(R.id.tv_home_view_all);
            LinearLayoutManager llm_artist = new LinearLayoutManager(context, LinearLayoutManager.HORIZONTAL, false);
            rv_artist.setLayoutManager(llm_artist);
            rv_artist.setItemAnimator(new DefaultItemAnimator());
        }
    }

    class AlbumsHolder extends RecyclerView.ViewHolder {
        RecyclerView rv_albums;
        AdapterHomeAlbums adapterHomeAlbums;
        TextView tv_title, tv_view_all;

        AlbumsHolder(View view) {
            super(view);
            rv_albums = view.findViewById(R.id.rv_home_cat);
            tv_title = view.findViewById(R.id.tv_home_title);
            tv_view_all = view.findViewById(R.id.tv_home_view_all);
            LinearLayoutManager llm_artist = new LinearLayoutManager(context, LinearLayoutManager.HORIZONTAL, false);
            rv_albums.setLayoutManager(llm_artist);
            rv_albums.setItemAnimator(new DefaultItemAnimator());
        }
    }

    class PlaylistHolder extends RecyclerView.ViewHolder {
        RecyclerView rv_playlist;
        AdapterPlaylistHome adapterPlaylistHome;
        TextView tv_title, tv_view_all;

        PlaylistHolder(View view) {
            super(view);
            rv_playlist = view.findViewById(R.id.rv_home_cat);
            tv_title = view.findViewById(R.id.tv_home_title);
            tv_view_all = view.findViewById(R.id.tv_home_view_all);
            LinearLayoutManager llm_artist = new LinearLayoutManager(context, LinearLayoutManager.HORIZONTAL, false);
            rv_playlist.setLayoutManager(llm_artist);
            rv_playlist.setItemAnimator(new DefaultItemAnimator());
        }
    }

    class SongsHolder extends RecyclerView.ViewHolder {
        RecyclerView rv_songs;
        AdapterHomeSongs adapterHomeSongs;
        TextView tv_title, tv_view_all;

        SongsHolder(View view) {
            super(view);
            rv_songs = view.findViewById(R.id.rv_home_cat);
            tv_title = view.findViewById(R.id.tv_home_title);
            tv_view_all = view.findViewById(R.id.tv_home_view_all);
            LinearLayoutManager llm_artist = new LinearLayoutManager(context, LinearLayoutManager.HORIZONTAL, false);
            rv_songs.setLayoutManager(llm_artist);
            rv_songs.setItemAnimator(new DefaultItemAnimator());
        }
    }

    private static class ProgressViewHolder extends RecyclerView.ViewHolder {
        private static ProgressBar progressBar;

        private ProgressViewHolder(View v) {
            super(v);
            progressBar = v.findViewById(R.id.progressBar);
        }
    }

    @NonNull
    @Override
    public RecyclerView.ViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        if (viewType == VIEW_CATEGORIES) {
            View itemView = LayoutInflater.from(parent.getContext()).inflate(R.layout.layout_home_ui_categories, parent, false);
            return new CategoriesHolder(itemView);
        } else if (viewType == VIEW_ARTIST) {
            View itemView = LayoutInflater.from(parent.getContext()).inflate(R.layout.layout_home_ui_categories, parent, false);
            return new ArtistHolder(itemView);
        } else if (viewType == VIEW_ALBUMS) {
            View itemView = LayoutInflater.from(parent.getContext()).inflate(R.layout.layout_home_ui_categories, parent, false);
            return new AlbumsHolder(itemView);
        } else if (viewType == VIEW_PLAYLIST) {
            View itemView = LayoutInflater.from(parent.getContext()).inflate(R.layout.layout_home_ui_categories, parent, false);
            return new PlaylistHolder(itemView);
        } else if (viewType == VIEW_SONGS) {
            View itemView = LayoutInflater.from(parent.getContext()).inflate(R.layout.layout_home_ui_categories, parent, false);
            return new SongsHolder(itemView);
        } else {
            View v = LayoutInflater.from(parent.getContext()).inflate(R.layout.layout_progressbar, parent, false);
            return new ProgressViewHolder(v);
        }
    }

    @Override
    public void onBindViewHolder(@NonNull RecyclerView.ViewHolder holder, int position) {

        if (holder instanceof CategoriesHolder) {

            ((CategoriesHolder) holder).tv_title.setText(arrayList.get(holder.getAbsoluteAdapterPosition()).getTitle());

            ((CategoriesHolder) holder).adapterHomeCat = new AdapterHomeCat(arrayList.get(holder.getAbsoluteAdapterPosition()).getArrayListCategories());
            ((CategoriesHolder) holder).rv_cat.setAdapter(((CategoriesHolder) holder).adapterHomeCat);

            ((CategoriesHolder) holder).rv_cat.addOnItemTouchListener(new RecyclerItemClickListener(context, new RecyclerItemClickListener.OnItemClickListener() {
                @Override
                public void onItemClick(View view, int position) {
                    clickPos = holder.getAbsoluteAdapterPosition();
                    methods.showInterAd(position, context.getString(R.string.categories));
                }
            }));

            ((CategoriesHolder) holder).tv_view_all.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View v) {
                    FragmentSearchCategories f_albums = new FragmentSearchCategories();
                    FragmentTransaction ft = ((AppCompatActivity) context).getSupportFragmentManager().beginTransaction();
                    ft.setTransition(FragmentTransaction.TRANSIT_FRAGMENT_OPEN);
                    ft.hide(((AppCompatActivity) context).getSupportFragmentManager()
                            .getFragments()
                            .get(((AppCompatActivity) context).getSupportFragmentManager().getBackStackEntryCount()));
                    ft.add(R.id.fragment, f_albums, context.getString(R.string.categories));
                    ft.addToBackStack(context.getString(R.string.categories));
                    ft.commit();
                }
            });

        } else if (holder instanceof ArtistHolder) {

            if (((ArtistHolder) holder).adapterHomeArtist == null) {
                ((ArtistHolder) holder).tv_title.setText(context.getString(R.string.artist));

                ((ArtistHolder) holder).adapterHomeArtist = new AdapterHomeArtist(arrayList.get(holder.getAbsoluteAdapterPosition()).getArrayListArtist());
                ((ArtistHolder) holder).rv_artist.setAdapter(((ArtistHolder) holder).adapterHomeArtist);

                ((ArtistHolder) holder).rv_artist.addOnItemTouchListener(new RecyclerItemClickListener(context, new RecyclerItemClickListener.OnItemClickListener() {
                    @Override
                    public void onItemClick(View view, int position) {
                        clickPos = holder.getAbsoluteAdapterPosition();
                        methods.showInterAd(position, context.getString(R.string.artist));
                    }
                }));

                ((ArtistHolder) holder).tv_view_all.setOnClickListener(v -> {
                    FragmentSearchArtist f_art = new FragmentSearchArtist();
                    FragmentTransaction ft = ((AppCompatActivity) context).getSupportFragmentManager().beginTransaction();
                    ft.setTransition(FragmentTransaction.TRANSIT_FRAGMENT_OPEN);
                    ft.hide(((AppCompatActivity) context).getSupportFragmentManager()
                            .getFragments()
                            .get(((AppCompatActivity) context).getSupportFragmentManager().getBackStackEntryCount()));
                    ft.add(R.id.fragment, f_art, context.getString(R.string.search_artist));
                    ft.addToBackStack(context.getString(R.string.search_artist));
                    ft.commit();
                });
            }

        } else if (holder instanceof AlbumsHolder) {

            if (((AlbumsHolder) holder).adapterHomeAlbums == null) {
                ((AlbumsHolder) holder).tv_title.setText(context.getString(R.string.albums));

                ((AlbumsHolder) holder).adapterHomeAlbums = new AdapterHomeAlbums(context, arrayList.get(holder.getAbsoluteAdapterPosition()).getArrayListAlbums());
                ((AlbumsHolder) holder).rv_albums.setAdapter(((AlbumsHolder) holder).adapterHomeAlbums);

                ((AlbumsHolder) holder).rv_albums.addOnItemTouchListener(new RecyclerItemClickListener(context, new RecyclerItemClickListener.OnItemClickListener() {
                    @Override
                    public void onItemClick(View view, int position) {
                        clickPos = holder.getAbsoluteAdapterPosition();
                        methods.showInterAd(position, context.getString(R.string.albums));
                    }
                }));

                ((AlbumsHolder) holder).tv_view_all.setOnClickListener(v -> {
                    FragmentSearchAlbums f_albums = new FragmentSearchAlbums();
                    FragmentTransaction ft = ((AppCompatActivity) context).getSupportFragmentManager().beginTransaction();
                    ft.setTransition(FragmentTransaction.TRANSIT_FRAGMENT_OPEN);
                    ft.hide(((AppCompatActivity) context).getSupportFragmentManager()
                            .getFragments()
                            .get(((AppCompatActivity) context).getSupportFragmentManager().getBackStackEntryCount()));
                    ft.add(R.id.fragment, f_albums, context.getString(R.string.search_albums));
                    ft.addToBackStack(context.getString(R.string.search_albums));
                    ft.commit();
                });
            }
        } else if (holder instanceof PlaylistHolder) {

            if (((PlaylistHolder) holder).adapterPlaylistHome == null) {
                ((PlaylistHolder) holder).tv_title.setText(context.getString(R.string.playlist));

                ((PlaylistHolder) holder).adapterPlaylistHome = new AdapterPlaylistHome(arrayList.get(holder.getAbsoluteAdapterPosition()).getArrayListPlaylist());
                ((PlaylistHolder) holder).rv_playlist.setAdapter(((PlaylistHolder) holder).adapterPlaylistHome);

                ((PlaylistHolder) holder).rv_playlist.addOnItemTouchListener(new RecyclerItemClickListener(context, new RecyclerItemClickListener.OnItemClickListener() {
                    @Override
                    public void onItemClick(View view, int position) {
                        clickPos = holder.getAbsoluteAdapterPosition();
                        methods.showInterAd(position, context.getString(R.string.playlist));
                    }
                }));

                ((PlaylistHolder) holder).tv_view_all.setOnClickListener(v -> {
                    FragmentSearchPlaylist f_art = new FragmentSearchPlaylist();
                    FragmentTransaction ft = ((AppCompatActivity) context).getSupportFragmentManager().beginTransaction();
                    ft.setTransition(FragmentTransaction.TRANSIT_FRAGMENT_OPEN);
                    ft.hide(((AppCompatActivity) context).getSupportFragmentManager()
                            .getFragments()
                            .get(((AppCompatActivity) context).getSupportFragmentManager().getBackStackEntryCount()));
                    ft.add(R.id.fragment, f_art, context.getString(R.string.playlist));
                    ft.addToBackStack(context.getString(R.string.playlist));
                    ft.commit();
                });
            }
        } else if (holder instanceof SongsHolder) {

            if (((SongsHolder) holder).adapterHomeSongs == null) {

                ((SongsHolder) holder).tv_title.setText(context.getString(R.string.songs));

                ((SongsHolder) holder).adapterHomeSongs = new AdapterHomeSongs(context, arrayList.get(holder.getAbsoluteAdapterPosition()).getArrayListSongs(), new ClickListenerCallback() {
                    @Override
                    public void onClick(int position) {
                        if (methods.isNetworkAvailable()) {
                            Constant.isOnline = true;
                            String addedFrom = "home".concat(arrayList.get(holder.getAbsoluteAdapterPosition()).getTitle());
                            if (!Constant.addedFrom.equals(addedFrom)) {
                                Constant.arrayList_play.clear();
                                Constant.arrayList_play.addAll(arrayList.get(holder.getAbsoluteAdapterPosition()).getArrayListSongs());
                                Constant.addedFrom = addedFrom;
                                Constant.isNewAdded = true;
                                try {
                                    GlobalBus.getBus().postSticky(new ItemMyPlayList("", "", null));
                                } catch (Exception e) {
                                    e.printStackTrace();
                                }
                            }
                            Constant.playPos = position;

                            methods.showInterAd(position, context.getString(R.string.songs));
                        } else {
                            Toast.makeText(context, context.getString(R.string.err_internet_not_conn), Toast.LENGTH_SHORT).show();
                        }
                    }

                    @Override
                    public void onItemZero() {

                    }
                });
                ((SongsHolder) holder).rv_songs.setAdapter(((SongsHolder) holder).adapterHomeSongs);

                ((SongsHolder) holder).tv_view_all.setOnClickListener(new View.OnClickListener() {
                    @Override
                    public void onClick(View v) {
                        FragmentSearchSong f_trending = new FragmentSearchSong();
                        FragmentTransaction ft = ((AppCompatActivity) context).getSupportFragmentManager().beginTransaction();
                        ft.setTransition(FragmentTransaction.TRANSIT_FRAGMENT_OPEN);
                        ft.hide(((AppCompatActivity) context).getSupportFragmentManager()
                                .getFragments()
                                .get(((AppCompatActivity) context).getSupportFragmentManager().getBackStackEntryCount()));
                        ft.add(R.id.fragment, f_trending, context.getString(R.string.search_songs));
                        ft.addToBackStack(context.getString(R.string.search_songs));
                        ft.commit();
                    }
                });
            }
        }
    }

    @Override
    public long getItemId(int id) {
        return id;
    }

    @Override
    public int getItemCount() {
        return arrayList.size();
    }

    public void hideHeader() {
        ProgressViewHolder.progressBar.setVisibility(View.GONE);
    }

    public boolean isHeader(int position) {
        return arrayList.get(position) == null;
    }

    @Override
    public int getItemViewType(int position) {
        switch (arrayList.get(position).getType()) {
            case "songs":
                return VIEW_SONGS;
            case "artists":
                return VIEW_ARTIST;
            case "albums":
                return VIEW_ALBUMS;
            case "playlists":
                return VIEW_PLAYLIST;
            case "categories":
                return VIEW_CATEGORIES;
            default:
                return VIEW_PROG;
        }
    }

    InterAdListener interAdListener = new InterAdListener() {
        @Override
        public void onClick(int position, String type) {
            if (type.equals(context.getString(R.string.songs))) {
                Intent intent = new Intent(context, PlayerService.class);
                intent.setAction(PlayerService.ACTION_PLAY);
                context.startService(intent);
            } else if (type.equals(context.getString(R.string.artist))) {
                Intent intent = new Intent(context, SongByCatActivity.class);
                intent.putExtra("type", context.getString(R.string.artist));
                intent.putExtra("id", arrayList.get(clickPos).getArrayListArtist().get(position).getId());
                intent.putExtra("name", arrayList.get(clickPos).getArrayListArtist().get(position).getName());
                context.startActivity(intent);
            } else if (type.equals(context.getString(R.string.albums))) {
                Intent intent = new Intent(context, SongByCatActivity.class);
                intent.putExtra("type", context.getString(R.string.albums));
                intent.putExtra("id", arrayList.get(clickPos).getArrayListAlbums().get(position).getId());
                intent.putExtra("name", arrayList.get(clickPos).getArrayListAlbums().get(position).getName());
                context.startActivity(intent);
            } else if (type.equals(context.getString(R.string.categories))) {
                Intent intent = new Intent(context, SongByCatActivity.class);
                intent.putExtra("type", context.getString(R.string.categories));
                intent.putExtra("id", arrayList.get(clickPos).getArrayListCategories().get(position).getId());
                intent.putExtra("name", arrayList.get(clickPos).getArrayListCategories().get(position).getName());
                context.startActivity(intent);
            } else if (type.equals(context.getString(R.string.playlist))) {
                Intent intent = new Intent(context, SongByServerPlaylistActivity.class);
                intent.putExtra("item", arrayList.get(clickPos).getArrayListPlaylist().get(position));
                context.startActivity(intent);
            }
        }
    };
}