package com.vpapps.adapter;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RadioButton;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.cardview.widget.CardView;
import androidx.constraintlayout.widget.ConstraintLayout;
import androidx.core.content.ContextCompat;
import androidx.recyclerview.widget.RecyclerView;

import com.vpapps.onlinemp3.R;
import com.vpapps.interfaces.ClickListenerCallback;
import com.vpapps.item.ItemSubscriptionPlan;
import com.vpapps.utils.SharedPref;

import java.util.ArrayList;


public class AdapterSubscriptionPlans extends RecyclerView.Adapter<AdapterSubscriptionPlans.MyViewHolder> {

    Context context;
    ArrayList<ItemSubscriptionPlan> arrayList;
    int selectedPos = -1, oldSelectedPos = -1;
    ClickListenerCallback clickListenerCallback;

    public AdapterSubscriptionPlans(Context context, ArrayList<ItemSubscriptionPlan> arrayList, ClickListenerCallback clickListenerCallback) {
        this.context = context;
        this.arrayList = arrayList;
        this.clickListenerCallback = clickListenerCallback;
    }

    static class MyViewHolder extends RecyclerView.ViewHolder {
        CardView cv_plan;
        ConstraintLayout cl_plan;
        RadioButton radioButton;
        TextView tv_title, tv_duration, tv_amount, tv_active;

        MyViewHolder(View view) {
            super(view);
            cv_plan = view.findViewById(R.id.cv_subs_plan);
            cl_plan = view.findViewById(R.id.cl_subs_plan);
            radioButton = view.findViewById(R.id.rb_subs_plan);
            tv_title = view.findViewById(R.id.tv_subs_plan_title);
            tv_duration = view.findViewById(R.id.tv_subs_plan_duration);
            tv_amount = view.findViewById(R.id.tv_subs_plan_amount);
            tv_active = view.findViewById(R.id.tv_subs_plan_active);
        }
    }

    @NonNull
    @Override
    public MyViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        View itemView = LayoutInflater.from(parent.getContext()).inflate(R.layout.layout_subscription_plan, parent, false);

        return new MyViewHolder(itemView);
    }

    @Override
    public void onBindViewHolder(@NonNull final MyViewHolder holder, int position) {

        holder.tv_title.setText(arrayList.get(holder.getAbsoluteAdapterPosition()).getTitle());
        holder.tv_amount.setText(arrayList.get(holder.getAbsoluteAdapterPosition()).getAmount().concat(" ").concat(arrayList.get(holder.getAbsoluteAdapterPosition()).getCurrencyCode()));
        holder.tv_duration.setText(arrayList.get(holder.getAbsoluteAdapterPosition()).getDuration());

        if (selectedPos != -1 && selectedPos == holder.getAbsoluteAdapterPosition()) {
            holder.cl_plan.setBackgroundResource(R.drawable.bg_gradient);
        } else {
            holder.cl_plan.setBackgroundColor(ContextCompat.getColor(context, R.color.bg_subs_plan));
        }

        if(new SharedPref(context).getSubscriptionPlanID().equals(arrayList.get(holder.getAbsoluteAdapterPosition()).getId())) {
            holder.tv_active.setVisibility(View.VISIBLE);
        } else {
            holder.tv_active.setVisibility(View.GONE);
        }

        holder.cv_plan.setOnClickListener(view -> {
            if (oldSelectedPos != -1) {
                oldSelectedPos = selectedPos;
                notifyItemChanged(selectedPos);
            } else {
                oldSelectedPos = holder.getAbsoluteAdapterPosition();
            }
            selectedPos = holder.getAbsoluteAdapterPosition();


            notifyItemChanged(holder.getAbsoluteAdapterPosition());

            clickListenerCallback.onClick(selectedPos);
        });
    }

    @Override
    public long getItemId(int id) {
        return id;
    }

    @Override
    public int getItemCount() {
        return arrayList.size();
    }

    public int getSelectedPos() {
        return selectedPos;
    }

    public void setSelectedPos(int pos) {
        if (oldSelectedPos != -1) {
            oldSelectedPos = selectedPos;
            notifyItemChanged(selectedPos);
        } else {
            oldSelectedPos = pos;
        }
        selectedPos = pos;


        notifyItemChanged(pos);

        clickListenerCallback.onClick(selectedPos);
    }
}