package com.vpapps.adapter;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;

import com.vpapps.item.ItemTransaction;
import com.vpapps.onlinemp3.R;

import java.util.ArrayList;


public class AdapterTransaction extends RecyclerView.Adapter<AdapterTransaction.MyViewHolder> {

    Context context;
    ArrayList<ItemTransaction> arrayList;

    public AdapterTransaction(Context context, ArrayList<ItemTransaction> arrayList) {
        this.context = context;
        this.arrayList = arrayList;
    }

    static class MyViewHolder extends RecyclerView.ViewHolder {
        TextView tv_subs_name, tv_payment_id, tv_payment_gateway, tv_amount, tv_date;

        MyViewHolder(View view) {
            super(view);
            tv_subs_name = view.findViewById(R.id.tv_trans_subs_name);
            tv_payment_gateway = view.findViewById(R.id.tv_trans_payment_gateway);
            tv_amount = view.findViewById(R.id.tv_trans_amount);
            tv_payment_id = view.findViewById(R.id.tv_trans_payment_id);
            tv_date = view.findViewById(R.id.tv_trans_payment_date);
        }
    }

    @NonNull
    @Override
    public MyViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        View itemView = LayoutInflater.from(parent.getContext()).inflate(R.layout.layout_transaction, parent, false);

        return new MyViewHolder(itemView);
    }


    @Override
    public void onBindViewHolder(@NonNull final MyViewHolder holder, int position) {
        holder.tv_subs_name.setText(arrayList.get(holder.getAbsoluteAdapterPosition()).getPlanName());
        holder.tv_payment_id.setText(context.getString(R.string.payment_id).concat(arrayList.get(holder.getAbsoluteAdapterPosition()).getPaymentID()));
        holder.tv_payment_gateway.setText(arrayList.get(holder.getAbsoluteAdapterPosition()).getPaymentGateway());
        holder.tv_amount.setText(arrayList.get(holder.getAbsoluteAdapterPosition()).getAmount().concat(" ").concat(arrayList.get(holder.getAbsoluteAdapterPosition()).getCurrencyCode()));
        holder.tv_date.setText(arrayList.get(holder.getAbsoluteAdapterPosition()).getDate());
    }

    @Override
    public long getItemId(int id) {
        return id;
    }

    @Override
    public int getItemCount() {
        return arrayList.size();
    }
}