package com.vpapps.asyncTask;

import android.content.Context;

import com.vpapps.interfaces.AboutListener;
import com.vpapps.item.ItemAbout;
import com.vpapps.item.ItemPage;
import com.vpapps.utils.BackgroundTask;
import com.vpapps.utils.Constant;
import com.vpapps.utils.JsonUtils;
import com.vpapps.utils.Methods;

import org.json.JSONArray;
import org.json.JSONObject;

public class LoadAbout {

    Methods methods;
    AboutListener aboutListener;
    String message = "", verifyStatus = "0";

    public LoadAbout(Context context, AboutListener aboutListener) {
        this.aboutListener = aboutListener;
        methods = new Methods(context);
    }

    public void doWork() {
        new BackgroundTask() {
            @Override
            public void onPreExecute() {
                aboutListener.onStart();
            }
            @Override
            public boolean doInBackground() {
                try {
                    String json = JsonUtils.okhttpPost(Constant.METHOD_APP_DETAILS, methods.getAPIRequest(Constant.METHOD_APP_DETAILS, 0, "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", null));
                    JSONObject jsonObject = new JSONObject(json);
                    if (jsonObject.has(Constant.TAG_ROOT)) {
                        JSONArray jsonArray = jsonObject.getJSONArray(Constant.TAG_ROOT);

                        for (int i = 0; i < jsonArray.length(); i++) {
                            JSONObject c = jsonArray.getJSONObject(i);

//                    if (!c.has(Constant.TAG_SUCCESS)) {
                            String appname = c.getString("app_name");
                            String applogo = c.getString("app_logo");

                            String appversion = c.getString("app_version");
                            String appauthor = c.getString("app_company");
                            String appcontact = c.getString("app_contact");
                            String email = c.getString("app_email");
                            String website = c.getString("app_website");

                            Constant.isSongDownload = Boolean.parseBoolean(c.getString("song_download"));
                            Constant.isSubscriptionEnabled = Boolean.parseBoolean(c.getString("subscription_on_off"));
                            Constant.packageName = c.getString("app_package_name");

                            Constant.showUpdateDialog = c.getBoolean("app_update_hide_show");
                            Constant.appVersion = c.getString("app_update_version_code");
                            Constant.appUpdateMsg = c.getString("app_update_desc");
                            Constant.appUpdateURL = c.getString("app_update_link");
                            Constant.appUpdateCancel = c.getBoolean("app_update_cancel_option");

                            Constant.urlYoutube = c.getString("youtube_link");
                            Constant.urlInstagram = c.getString("instagram_link");
                            Constant.urlTwitter = c.getString("twitter_link");
                            Constant.urlFacebook = c.getString("facebook_link");

                            JSONArray jArrayAds = c.getJSONArray("ads_list");
                            if(jArrayAds.length() > 0) {
                                JSONObject jObjAds = jArrayAds.getJSONObject(0);
                                JSONObject jObjAdsDetails = jObjAds.getJSONObject("ads_info");
                                switch (jObjAds.getString("ads_name")) {
                                    case Constant.AD_TYPE_ADMOB, Constant.AD_TYPE_FACEBOOK ->
                                            Constant.publisherAdID = jObjAdsDetails.getString("publisher_id");
                                    case Constant.AD_TYPE_STARTAPP ->
                                            Constant.startappAppId = jObjAdsDetails.getString("publisher_id");
                                    case Constant.AD_TYPE_WORTISE ->
                                            Constant.wortiseAppId = jObjAdsDetails.getString("publisher_id");
                                    case Constant.AD_TYPE_UNITY ->
                                            Constant.unityGameId = jObjAdsDetails.getString("publisher_id");
                                }
                                Constant.bannerAdID = jObjAdsDetails.getString("banner_id");
                                Constant.interstitialAdID = jObjAdsDetails.getString("interstitial_id");

                                Constant.isBannerAd = jObjAdsDetails.getString("banner_on_off").equals("1");
                                Constant.isInterAd = jObjAdsDetails.getString("interstitial_on_off").equals("1");

                                Constant.bannerAdType = jObjAds.getString("ads_name");
                                Constant.interstitialAdType = jObjAds.getString("ads_name");
                                Constant.openAdType = jObjAds.getString("ads_name");
                                Constant.rewardAdType = jObjAds.getString("ads_name");

                                if(jObjAdsDetails.has("native_id")) {
                                    Constant.nativeAdID = jObjAdsDetails.getString("native_id");
                                    Constant.isNativeAd = jObjAdsDetails.getString("native_on_off").equals("1");
                                    Constant.nativeAdShow = Integer.parseInt(jObjAdsDetails.getString("native_position"));
                                    Constant.nativeAdType = jObjAds.getString("ads_name");
                                }
                                if(jObjAdsDetails.has("open_ads_id")) {
                                    Constant.openAdId = jObjAdsDetails.getString("open_ads_id");
                                    Constant.isOpenAd = jObjAdsDetails.getString("open_ads_on_off").equals("1");
                                }
                                if(jObjAdsDetails.has("reward_video_ads_on_off")) {
                                    Constant.rewardAdsID = jObjAdsDetails.getString("reward_video_ads_id");
                                    Constant.isRewardAd = jObjAdsDetails.getString("reward_video_ads_on_off").equals("1");
                                }

                                Constant.interstitialAdShow = Integer.parseInt(jObjAdsDetails.getString("interstitial_clicks"));
                            } else {
                                Constant.isBannerAd = false;
                                Constant.isInterAd = false;
                                Constant.isNativeAd = false;
                            }

                            Constant.itemAbout = new ItemAbout(appname, applogo, "desc", appversion, appauthor, appcontact, email, website);

                            JSONArray jAPage = c.getJSONArray("page_list");
                            Constant.arrayListPages.clear();
                            for (int j = 0; j < jAPage.length(); j++) {
                                JSONObject jObj = jAPage.getJSONObject(j);
                                String id = jObj.getString("page_id");
                                String content = jObj.getString("page_content");
                                if(!id.equals("1")) {
                                    String title = jObj.getString("page_title");
                                    Constant.arrayListPages.add(new ItemPage(id, title, content));
                                } else {
                                    Constant.itemAbout.setAppDesc(content);
                                }
                            }
//                    } else {
//                        verifyStatus = c.getString(Constant.TAG_SUCCESS);
//                        message = c.getString(Constant.TAG_MSG);
//                    }
                        }
                    }
                    return true;
                } catch (Exception ee) {
                    ee.printStackTrace();
                    return false;
                }
            }
            @Override
            public void onPostExecute(Boolean isExecutionSuccess) {
                aboutListener.onEnd(isExecutionSuccess ? "1" : "0", verifyStatus, message);
            }
        }.execute();
    }
}