package com.vpapps.asyncTask;

import com.vpapps.interfaces.AddTransactionListener;
import com.vpapps.utils.BackgroundTask;
import com.vpapps.utils.Constant;
import com.vpapps.utils.JsonUtils;

import org.json.JSONArray;
import org.json.JSONObject;

import okhttp3.RequestBody;

public class LoadAddTransaction {

    RequestBody requestBody;
    AddTransactionListener addTransactionListener;
    String verifyStatus = "0", message = "", expired_on="";

    public LoadAddTransaction(AddTransactionListener addTransactionListener, RequestBody requestBody) {
        this.addTransactionListener = addTransactionListener;
        this.requestBody = requestBody;
    }

    public void doWork(String apiUrl) {
        new BackgroundTask() {
            @Override
            public void onPreExecute() {
                addTransactionListener.onStart();
            }

            @Override
            public boolean doInBackground() {
                try {
                    String json = JsonUtils.okhttpPost(apiUrl, requestBody);
                    JSONObject mainJson = new JSONObject(json);

                    JSONArray jsonArray = mainJson.getJSONArray(Constant.TAG_ROOT);
                    JSONObject jObj = jsonArray.getJSONObject(0);
                    verifyStatus = jObj.getString("success");
                    message = jObj.getString("msg");
                    expired_on = jObj.getString("expired_on");
                    return true;
                } catch (Exception ee) {
                    ee.printStackTrace();
                    return false;
                }
            }

            @Override
            public void onPostExecute(Boolean isExecutionSuccess) {
                addTransactionListener.onEnd(isExecutionSuccess ? "1" : "0", verifyStatus, message, expired_on);
            }
        }.execute();
    }
}