package com.vpapps.asyncTask;

import android.util.Log;

import com.vpapps.interfaces.BraintreeCheckoutListener;
import com.vpapps.interfaces.GenerateKeysListener;
import com.vpapps.utils.BackgroundTask;
import com.vpapps.utils.Constant;
import com.vpapps.utils.JsonUtils;

import org.json.JSONArray;
import org.json.JSONObject;

import okhttp3.RequestBody;

public class LoadBraintreeCheckout {

    RequestBody requestBody;
    BraintreeCheckoutListener braintreeCheckoutListener;
    String apiSuccess = "0", message = "";
    String paymentID="";

    public LoadBraintreeCheckout(BraintreeCheckoutListener braintreeCheckoutListener, RequestBody requestBody) {
        this.braintreeCheckoutListener = braintreeCheckoutListener;
        this.requestBody = requestBody;
    }

    public void doWork(String apiUrl) {
        new BackgroundTask() {
            @Override
            public void onPreExecute() {
                braintreeCheckoutListener.onStart();
            }

            @Override
            public boolean doInBackground() {
                try {
                    String json = JsonUtils.okhttpPost(apiUrl, requestBody);
                    JSONObject mainJson = new JSONObject(json);
                    JSONArray jsonArray = mainJson.getJSONArray(Constant.TAG_ROOT);

                    for (int i = 0; i < jsonArray.length(); i++) {
                        JSONObject objJson = jsonArray.getJSONObject(i);

                        message = objJson.getString("msg");
                        apiSuccess = objJson.getString("success");
                        if(objJson.has("paypal_payment_id")) {
                            paymentID = objJson.getString("paypal_payment_id");
                        } else if(objJson.has("transaction_id")){
                            paymentID = objJson.getString("transaction_id");
                        }
                    }
                    return true;
                } catch (Exception ee) {
                    ee.printStackTrace();
                    return false;
                }
            }

            @Override
            public void onPostExecute(Boolean isExecutionSuccess) {
                braintreeCheckoutListener.onEnd(isExecutionSuccess ? "1" : "0", apiSuccess, message, paymentID);
            }
        }.execute();
    }
}