package com.vpapps.asyncTask;

import android.util.Log;

import com.vpapps.interfaces.GenerateKeysListener;
import com.vpapps.utils.BackgroundTask;
import com.vpapps.utils.Constant;
import com.vpapps.utils.JsonUtils;

import org.json.JSONArray;
import org.json.JSONObject;

import okhttp3.RequestBody;

public class LoadGenerateKeys {

    RequestBody requestBody;
    GenerateKeysListener generateKeysListener;
    String apiSuccess = "0", message = "";
    String razorPayOrderID, stripePaymentID, stripeToken, stripeEphemeralKey, stripeCustomer, braintreeToken, payumoneyHash, instamojoOrderID;

    public LoadGenerateKeys(GenerateKeysListener generateKeysListener, RequestBody requestBody) {
        this.generateKeysListener = generateKeysListener;
        this.requestBody = requestBody;
    }

    public void doWork(String apiUrl, String paymentGateway) {
        new BackgroundTask() {
            @Override
            public void onPreExecute() {
                generateKeysListener.onStart();
            }

            @Override
            public boolean doInBackground() {
                try {
                    String json = JsonUtils.okhttpPost(apiUrl, requestBody);
                    JSONObject mainJson = new JSONObject(json);
                    JSONArray jsonArray = mainJson.getJSONArray(Constant.TAG_ROOT);

                    for (int i = 0; i < jsonArray.length(); i++) {
                        JSONObject objJson = jsonArray.getJSONObject(i);

                        message = objJson.getString("msg");
                        apiSuccess = objJson.getString("success");

                        switch (paymentGateway) {
                            case "Paypal" -> {
                                braintreeToken = objJson.getString("client_token");
                            }
                            case "Stripe" -> {
                                stripePaymentID = objJson.getString("id");
                                stripeToken = objJson.getString("stripe_payment_token");
                                stripeEphemeralKey = objJson.getString("ephemeralKey");
                                stripeCustomer = objJson.getString("customer");
                            }
                            case "Razorpay" -> {
                                razorPayOrderID = objJson.getString("order_id");
                            }
                            case "Instamojo" -> {
                                instamojoOrderID = objJson.getString("instamojo_order_id");
                            }
                            case "PayUMoney" -> {
                                payumoneyHash = objJson.getString("payu_hash");
                            }
                        }
                    }
                    return true;
                } catch (Exception ee) {
                    ee.printStackTrace();
                    return false;
                }
            }

            @Override
            public void onPostExecute(Boolean isExecutionSuccess) {
                generateKeysListener.onEnd(isExecutionSuccess ? "1" : "0", apiSuccess, message, razorPayOrderID, stripePaymentID, stripeToken, stripeEphemeralKey, stripeCustomer, braintreeToken, payumoneyHash, instamojoOrderID);
            }
        }.execute();
    }
}