package com.vpapps.asyncTask;

import android.os.AsyncTask;

import com.vpapps.interfaces.HomeListener;
import com.vpapps.item.ItemAlbums;
import com.vpapps.item.ItemArtist;
import com.vpapps.item.ItemCat;
import com.vpapps.item.ItemHomeSlider;
import com.vpapps.item.ItemPost;
import com.vpapps.item.ItemServerPlayList;
import com.vpapps.item.ItemSong;
import com.vpapps.utils.Constant;
import com.vpapps.utils.JsonUtils;

import org.json.JSONArray;
import org.json.JSONObject;

import java.util.ArrayList;

import okhttp3.RequestBody;

public class LoadHome extends AsyncTask<String, String, String> {

    RequestBody requestBody;
    HomeListener homeListener;
    ArrayList<ItemPost> arrayListPost = new ArrayList<>();
    String message = "", successAPI = "1";

    public LoadHome(HomeListener homeListener, RequestBody requestBody) {
        this.homeListener = homeListener;
        this.requestBody = requestBody;
    }

    @Override
    protected void onPreExecute() {
        homeListener.onStart();
        super.onPreExecute();
    }

    @Override
    protected String doInBackground(String... strings) {
        try {

            String json = JsonUtils.okhttpPost(strings[0], requestBody);

            JSONObject mainJson = new JSONObject(json);

            try {
                JSONObject jsonObject = mainJson.getJSONObject(Constant.TAG_ROOT);

                ItemPost itemPost;
                String postTitle, postType, postId;

                if (jsonObject.has("slider")) {

                    JSONArray jsonArrayBanner = jsonObject.getJSONArray("slider");

                    postTitle = "Home Banners";
                    postType = "slider";
                    itemPost = new ItemPost("", postTitle, postType);

                    ArrayList<ItemHomeSlider> arrayListBanner = new ArrayList<>();
                    for (int i = 0; i < jsonArrayBanner.length(); i++) {
                        JSONObject objJsonBanner = jsonArrayBanner.getJSONObject(i);

                        String banner_id = objJsonBanner.getString(Constant.TAG_SLIDER_ID);
                        String banner_title = objJsonBanner.getString(Constant.TAG_SLIDER_TITLE);
                        String banner_desc = objJsonBanner.getString(Constant.TAG_SLIDER_DESC);
                        String banner_image = objJsonBanner.getString(Constant.TAG_SLIDER_IMAGE);

                        arrayListBanner.add(new ItemHomeSlider(banner_id, banner_title, banner_image, banner_desc));
                    }
                    itemPost.setArrayListBanner(arrayListBanner);
                    arrayListPost.add(itemPost);
                }

                if (jsonObject.has("recently_songs")) {

                    JSONArray jsonArrayRecent = jsonObject.getJSONArray("recently_songs");

                    if (jsonArrayRecent.length() > 0) {

                        postTitle = "Recently Songs";
                        postType = "recent";
                        itemPost = new ItemPost("", postTitle, postType);

                        ArrayList<ItemSong> arrayListRecent = new ArrayList<>();
                        for (int i = 0; i < jsonArrayRecent.length(); i++) {
                            JSONObject objJson = jsonArrayRecent.getJSONObject(i);

                            String id = objJson.getString(Constant.TAG_SONG_ID);
                            String name = objJson.getString(Constant.TAG_SONG_NAME);
                            String url = objJson.getString(Constant.TAG_MP3_URL);
                            String desc = objJson.getString(Constant.TAG_DESC);
                            String lyrics = objJson.getString(Constant.TAG_SONG_LYRICS);
                            String thumb = objJson.getString(Constant.TAG_THUMB_B).replace(" ", "%20");
                            if (thumb.equals("")) {
                                thumb = "null";
                            }

                            String avg_rate = objJson.getString(Constant.TAG_AVERAGE_RATE);
                            String views = objJson.getString(Constant.TAG_VIEWS);
                            String downloads = objJson.getString(Constant.TAG_DOWNLOADS);
                            Boolean isFav = objJson.getBoolean(Constant.TAG_IS_FAV);

                            String artist = "";
                            if (objJson.has("artist_list")) {
                                JSONArray jAArtist = objJson.getJSONArray("artist_list");
                                if (jAArtist.length() > 0) {
                                    artist = jAArtist.getJSONObject(0).getString("artist_name");

                                    for (int j = 1; j < jAArtist.length(); j++) {
                                        artist = artist.concat(", ").concat(jAArtist.getJSONObject(j).getString("artist_name"));
                                    }
                                }
                            }

                            ItemSong objItem = new ItemSong(id, artist, url, thumb, name, desc, lyrics, avg_rate, views, downloads, isFav);
                            arrayListRecent.add(objItem);
                        }
                        itemPost.setArrayListSongs(arrayListRecent);
                        arrayListPost.add(itemPost);
                    }
                }

                if (jsonObject.has("trending_songs")) {

                    JSONArray jsonArrayTrending = jsonObject.getJSONArray("trending_songs");

                    if (jsonArrayTrending.length() > 0) {

                        postTitle = "Trending Songs";
                        postType = "song";
                        itemPost = new ItemPost("", postTitle, postType);

                        ArrayList<ItemSong> arrayListTrending = new ArrayList<>();
                        for (int i = 0; i < jsonArrayTrending.length(); i++) {
                            JSONObject objJson = jsonArrayTrending.getJSONObject(i);

                            String id = objJson.getString(Constant.TAG_SONG_ID);
                            String name = objJson.getString(Constant.TAG_SONG_NAME);
                            String url = objJson.getString(Constant.TAG_MP3_URL);
                            String desc = objJson.getString(Constant.TAG_DESC);
                            String lyrics = objJson.getString(Constant.TAG_SONG_LYRICS);
                            String thumb = objJson.getString(Constant.TAG_THUMB_B).replace(" ", "%20");
                            if (thumb.equals("")) {
                                thumb = "null";
                            }

                            String avg_rate = objJson.getString(Constant.TAG_AVERAGE_RATE);
                            String views = objJson.getString(Constant.TAG_VIEWS);
                            String downloads = objJson.getString(Constant.TAG_DOWNLOADS);
                            Boolean isFav = objJson.getBoolean(Constant.TAG_IS_FAV);

                            String artist = "";
                            if (objJson.has("artist_list")) {
                                JSONArray jAArtist = objJson.getJSONArray("artist_list");
                                if (jAArtist.length() > 0) {
                                    artist = jAArtist.getJSONObject(0).getString("artist_name");

                                    for (int j = 1; j < jAArtist.length(); j++) {
                                        artist = artist.concat(", ").concat(jAArtist.getJSONObject(j).getString("artist_name"));
                                    }
                                }
                            }

                            ItemSong objItem = new ItemSong(id, artist, url, thumb, name, desc, lyrics, avg_rate, views, downloads, isFav);
                            arrayListTrending.add(objItem);
                        }
                        itemPost.setArrayListSongs(arrayListTrending);
                        arrayListPost.add(itemPost);
                    }
                }

                if (jsonObject.has("home_sections")) {

                    JSONArray jsonArraySection = jsonObject.getJSONArray("home_sections");

                    for (int j = 0; j < jsonArraySection.length(); j++) {

                        JSONObject jObjHome = jsonArraySection.getJSONObject(j);

                        postId = jObjHome.getString("home_id");
                        postTitle = jObjHome.getString("home_title");
                        postType = jObjHome.getString("home_type");
                        itemPost = new ItemPost(postId, postTitle, postType);

                        JSONArray jsonArrayHomeContent = jObjHome.getJSONArray("home_content");

                        switch (postType) {
                            case "category":
                                ArrayList<ItemCat> arrayListCat = new ArrayList<>();
                                for (int i = 0; i < jsonArrayHomeContent.length(); i++) {
                                    JSONObject objJson = jsonArrayHomeContent.getJSONObject(i);

                                    String id = objJson.getString("post_id");
                                    String name = objJson.getString("post_title");
                                    String image = objJson.getString("post_image");

                                    ItemCat itemCat = new ItemCat(id, name, image);

                                    arrayListCat.add(itemCat);
                                }
                                itemPost.setArrayListCategories(arrayListCat);

                                break;

                            case "song":
                                ArrayList<ItemSong> arrayListSongs = new ArrayList<>();
                                for (int i = 0; i < jsonArrayHomeContent.length(); i++) {
                                    JSONObject objJson = jsonArrayHomeContent.getJSONObject(i);

                                    String id = objJson.getString(Constant.TAG_SONG_ID);
                                    String name = objJson.getString(Constant.TAG_SONG_NAME);
                                    String url = objJson.getString(Constant.TAG_MP3_URL);
                                    String desc = objJson.getString(Constant.TAG_DESC);
                                    String lyrics = objJson.getString(Constant.TAG_SONG_LYRICS);
                                    String thumb = objJson.getString(Constant.TAG_THUMB_B).replace(" ", "%20");
                                    if (thumb.equals("")) {
                                        thumb = "null";
                                    }

                                    String avg_rate = objJson.getString(Constant.TAG_AVERAGE_RATE);
                                    String views = objJson.getString(Constant.TAG_VIEWS);
                                    String downloads = objJson.getString(Constant.TAG_DOWNLOADS);
                                    Boolean isFav = objJson.getBoolean(Constant.TAG_IS_FAV);

                                    String artist = "";
                                    if(objJson.has("artist_list")) {
                                        JSONArray jAArtist = objJson.getJSONArray("artist_list");
                                        if(jAArtist.length() >0) {
                                            artist = jAArtist.getJSONObject(0).getString("artist_name");

                                            for (int k = 1; k < jAArtist.length(); k++) {
                                                artist = artist.concat(", ").concat(jAArtist.getJSONObject(k).getString("artist_name"));
                                            }
                                        }
                                    }

                                    ItemSong objItem = new ItemSong(id, artist, url, thumb, name, desc, lyrics, avg_rate, views, downloads, isFav);
                                    arrayListSongs.add(objItem);
                                }
                                itemPost.setArrayListSongs(arrayListSongs);
                                break;

                            case "playlist":
                                ArrayList<ItemServerPlayList> arrayListPlaylist = new ArrayList<>();
                                for (int i = 0; i < jsonArrayHomeContent.length(); i++) {
                                    JSONObject objJson = jsonArrayHomeContent.getJSONObject(i);

                                    String id = objJson.getString(Constant.TAG_POST_ID);
                                    String name = objJson.getString(Constant.TAG_POST_TITLE);
                                    String image = objJson.getString(Constant.TAG_POST_IMAGE);
                                    String totalSongs = objJson.getString(Constant.TAG_TOTAL_SONGS);

                                    ItemServerPlayList itemServerPlayList = new ItemServerPlayList(id, name, image, totalSongs);

                                    arrayListPlaylist.add(itemServerPlayList);
                                }
                                itemPost.setArrayListPlaylist(arrayListPlaylist);
                                break;

                            case "artist":
                                ArrayList<ItemArtist> arrayListArtist = new ArrayList<>();
                                for (int i = 0; i < jsonArrayHomeContent.length(); i++) {
                                    JSONObject objJson = jsonArrayHomeContent.getJSONObject(i);

                                    String id = objJson.getString(Constant.TAG_POST_ID);
                                    String name = objJson.getString(Constant.TAG_POST_TITLE);
                                    String image = objJson.getString(Constant.TAG_POST_IMAGE);

                                    ItemArtist objItem = new ItemArtist(id, name, image, "thumb");
                                    arrayListArtist.add(objItem);
                                }
                                itemPost.setArrayListArtist(arrayListArtist);
                                break;

                            case "album":
                                ArrayList<ItemAlbums> arrayListAlbums = new ArrayList<>();
                                for (int i = 0; i < jsonArrayHomeContent.length(); i++) {
                                    JSONObject objJson = jsonArrayHomeContent.getJSONObject(i);

                                    String id = objJson.getString(Constant.TAG_POST_ID);
                                    String name = objJson.getString(Constant.TAG_POST_TITLE);
                                    String image = objJson.getString(Constant.TAG_POST_IMAGE);
                                    String totalSongs = objJson.getString(Constant.TAG_TOTAL_SONGS);

                                    ItemAlbums objItem = new ItemAlbums(id, name, image, totalSongs);
                                    arrayListAlbums.add(objItem);
                                }
                                itemPost.setArrayListAlbums(arrayListAlbums);
                                break;
                        }

                        arrayListPost.add(itemPost);
                    }
                }
            } catch (Exception e) {
                JSONArray jsonArray = mainJson.getJSONArray(Constant.TAG_ROOT);
                JSONObject jsonObject = jsonArray.getJSONObject(0);
                successAPI = jsonObject.getString(Constant.TAG_SUCCESS);
                message = jsonObject.getString(Constant.TAG_MSG);

                e.printStackTrace();
            }
            return successAPI;
        } catch (Exception e) {
            e.printStackTrace();
            return "0";
        }
    }

    @Override
    protected void onPostExecute(String s) {
        homeListener.onEnd(s, message, arrayListPost);
        super.onPostExecute(s);
    }
}