package com.vpapps.asyncTask;

import android.util.Log;

import com.vpapps.interfaces.LoggedDeviceListener;
import com.vpapps.item.ItemLoggedDevice;
import com.vpapps.utils.BackgroundTask;
import com.vpapps.utils.Constant;
import com.vpapps.utils.JsonUtils;

import org.json.JSONArray;
import org.json.JSONObject;

import java.util.ArrayList;

import okhttp3.RequestBody;

public class LoadLoggedDevice {

    RequestBody requestBody;
    ArrayList<ItemLoggedDevice> arrayList = new ArrayList<>();
    LoggedDeviceListener loggedDeviceListener;
    String verifyStatus = "0", message = "";

    public LoadLoggedDevice(LoggedDeviceListener loggedDeviceListener, RequestBody requestBody) {
        this.loggedDeviceListener = loggedDeviceListener;
        this.requestBody = requestBody;
    }

    public void doWork(String apiUrl, String userSession) {
        new BackgroundTask() {
            @Override
            public void onPreExecute() {
                loggedDeviceListener.onStart();
            }

            @Override
            public boolean doInBackground() {
                try {
                    String json = JsonUtils.okhttpPost(apiUrl, requestBody);
                    JSONObject mainJson = new JSONObject(json);

                    JSONArray jsonArray = mainJson.getJSONArray(Constant.TAG_ROOT);

                    for (int i = 0; i < jsonArray.length(); i++) {
                        JSONObject objJson = jsonArray.getJSONObject(i);
                        String session_id = objJson.getString("user_session_name");

                        if(!session_id.equals(userSession)) {
                            String user_id = objJson.getString("user_id");
                            String device_name = objJson.getString("device_name");
                            String date_time = objJson.getString("user_device_date_time");

                            arrayList.add(new ItemLoggedDevice(user_id, device_name, session_id, date_time));
                        }
                    }
                    return true;
                } catch (Exception ee) {
                    ee.printStackTrace();
                    return false;
                }
            }

            @Override
            public void onPostExecute(Boolean isExecutionSuccess) {
                loggedDeviceListener.onEnd(isExecutionSuccess ? "1" : "0", verifyStatus, message, arrayList);
            }
        }.execute();
    }
}