package com.vpapps.asyncTask;

import android.os.AsyncTask;
import android.util.Log;

import com.vpapps.interfaces.LoginListener;
import com.vpapps.utils.Constant;
import com.vpapps.utils.JsonUtils;

import org.json.JSONArray;
import org.json.JSONObject;

import okhttp3.RequestBody;

public class LoadLogin extends AsyncTask<String, String, String> {

    RequestBody requestBody;
    LoginListener loginListener;
    boolean device_limit_reached;
    String user_id="", user_name="", email="", phone="", image="", user_session_name="", success="0", message = "";

    public LoadLogin(LoginListener loginListener, RequestBody requestBody) {
        this.loginListener = loginListener;
        this.requestBody = requestBody;
    }

    @Override
    protected void onPreExecute() {
        loginListener.onStart();
        super.onPreExecute();
    }

    @Override
    protected String doInBackground(String... strings) {
        try {
            String json = JsonUtils.okhttpPost(strings[0], requestBody);
            JSONObject mainJson = new JSONObject(json);
            JSONArray jsonArray = mainJson.getJSONArray(Constant.TAG_ROOT);

            for (int i = 0; i < jsonArray.length(); i++) {
                JSONObject c = jsonArray.getJSONObject(i);

                success = c.getString(Constant.TAG_SUCCESS);
                if(success.equals("1")) {
                    user_id = c.getString("user_id");
                    user_name = c.getString("name");
                    email = c.getString("email");
                    phone = c.getString("phone");
                    image = c.getString("user_image");
                    user_session_name = c.getString("user_session_name");
                    device_limit_reached = c.getBoolean("device_limit_reached");
                }
                message = c.getString(Constant.TAG_MSG);
            }
            return "1";
        } catch (Exception e) {
            e.printStackTrace();
            return "0";
        }
    }

    @Override
    protected void onPostExecute(String s) {
        loginListener.onEnd(s, success, message, user_id, user_name, email, phone, image, user_session_name, device_limit_reached);
        super.onPostExecute(s);
    }
}