package com.vpapps.asyncTask;

import android.os.AsyncTask;
import android.util.Log;

import com.vpapps.interfaces.LoggedDeviceListener;
import com.vpapps.interfaces.SuccessListener;
import com.vpapps.item.ItemLoggedDevice;
import com.vpapps.utils.BackgroundTask;
import com.vpapps.utils.Constant;
import com.vpapps.utils.JsonUtils;

import org.json.JSONArray;
import org.json.JSONObject;

import okhttp3.RequestBody;

public class LoadLogout {

    RequestBody requestBody;
    LoggedDeviceListener loggedDeviceListener;
    String success = "0", message = "", isDeviceLimitReached = "false";

    public LoadLogout(LoggedDeviceListener loggedDeviceListener, RequestBody requestBody) {
        this.loggedDeviceListener = loggedDeviceListener;
        this.requestBody = requestBody;
    }

    public void doWork(String apiUrl) {
        new BackgroundTask() {
            @Override
            public void onPreExecute() {
                loggedDeviceListener.onStart();
            }

            @Override
            public boolean doInBackground() {
                try {
                    String json = JsonUtils.okhttpPost(apiUrl, requestBody);
                    JSONObject mainJson = new JSONObject(json);
                    isDeviceLimitReached = mainJson.getString("success");
//                    JSONArray jsonArray = mainJson.getJSONArray(Constant.TAG_ROOT);
//
//                    for (int i = 0; i < jsonArray.length(); i++) {
//                        JSONObject objJson = jsonArray.getJSONObject(i);
//                        String user_id = objJson.getString("user_id");
//                        String device_name = objJson.getString("device_name");
//                        String session_id = objJson.getString("user_session_name");
//
//                        arrayList.add(new ItemLoggedDevice(user_id, device_name, session_id));
//                    }
                    return true;
                } catch (Exception ee) {
                    ee.printStackTrace();
                    return false;
                }
            }

            @Override
            public void onPostExecute(Boolean isExecutionSuccess) {
                loggedDeviceListener.onEnd(isExecutionSuccess ? "1" : "0", isDeviceLimitReached, message, null);
            }
        }.execute();
    }
}