package com.vpapps.asyncTask;

import com.vpapps.interfaces.PaymentMethodListener;
import com.vpapps.item.ItemPaymentMethod;
import com.vpapps.utils.BackgroundTask;
import com.vpapps.utils.Constant;
import com.vpapps.utils.JsonUtils;

import org.json.JSONArray;
import org.json.JSONObject;

import java.util.ArrayList;

import okhttp3.RequestBody;

public class LoadPaymentDetails {

    RequestBody requestBody;
    ArrayList<ItemPaymentMethod> arrayList = new ArrayList<>();
    PaymentMethodListener paymentMethodListener;
    String verifyStatus = "0", message = "";

    public LoadPaymentDetails(PaymentMethodListener paymentMethodListener, RequestBody requestBody) {
        this.paymentMethodListener = paymentMethodListener;
        this.requestBody = requestBody;
    }

    public void doWork(String apiUrl) {
        new BackgroundTask() {
            @Override
            public void onPreExecute() {
                paymentMethodListener.onStart();
            }

            @Override
            public boolean doInBackground() {
                try {
                    String json = JsonUtils.okhttpPost(apiUrl, requestBody);
                    JSONObject mainJson = new JSONObject(json);
                    JSONArray jsonArray = mainJson.getJSONArray(Constant.TAG_ROOT);

                    for (int i = 0; i < jsonArray.length(); i++) {
                        JSONObject objJson = jsonArray.getJSONObject(i);

//                if (!objJson.has(Constant.TAG_SUCCESS)) {
                        String id = objJson.getString("gateway_id");
                        String name = objJson.getString("gateway_name");
                        String image = objJson.getString("gateway_logo");
                        boolean status = objJson.getString("status").equals("true");

                        if (objJson.has("gateway_info") && objJson.get("gateway_info") instanceof JSONObject) {
                            JSONObject jObjInfo = objJson.getJSONObject("gateway_info");
                            switch (name) {
                                case "Paypal" -> {
                                    boolean isSandBox = jObjInfo.getString("mode").equals("sandbox");
                                    arrayList.add(new ItemPaymentMethod(id, name, image, status, "", "", "", "", "", "", "", "", "", "", "", isSandBox, false, false));
                                }
                                case "Stripe" -> {
                                    String stripePubKey = jObjInfo.getString("stripe_publishable_key");
                                    arrayList.add(new ItemPaymentMethod(id, name, image, status, stripePubKey, "", "", "", "", "", "", "", "", "", "", false, false, false));
                                }
                                case "Razorpay" -> {
                                    String razorPayKey = jObjInfo.getString("razorpay_key");
                                    arrayList.add(new ItemPaymentMethod(id, name, image, status, "", razorPayKey, "", "", "", "", "", "", "", "", "", false, false, false));
                                }
                                case "Paystack" -> {
                                    String payStackPublicKey = jObjInfo.getString("paystack_public_key");
                                    arrayList.add(new ItemPaymentMethod(id, name, image, status, "", "", payStackPublicKey, "", "", "", "", "", "", "", "", false, false, false));
                                }
                                case "PayUMoney" -> {
                                    boolean isPayUMoneySandBox = jObjInfo.getString("mode").equals("sandbox");
                                    String payuMerchantId = jObjInfo.getString("payu_merchant_id");
                                    String payuKey = jObjInfo.getString("payu_key");
                                    arrayList.add(new ItemPaymentMethod(id, name, image, status, "", "", "", payuMerchantId, payuKey, "", "", "", "", "", "", false, isPayUMoneySandBox, false));
                                }
                                case "Flutterwave" -> {
                                    String flutterWavePublicKey = jObjInfo.getString("flutterwave_public_key");
                                    String flutterWaveSecretKey = jObjInfo.getString("flutterwave_secret_key");
                                    String flutterWaveEncryptionKey = jObjInfo.getString("flutterwave_encryption_key");
                                    arrayList.add(new ItemPaymentMethod(id, name, image, status, "", "", "", "", "", flutterWavePublicKey, flutterWaveSecretKey, flutterWaveEncryptionKey, "", "", "", false, false, false));
                                }
                                case "CinetPay" -> {
                                    String cinetpayApiKey = jObjInfo.getString("cinetpay_api_key");
                                    String cinetpaySiteId = jObjInfo.getString("cinetpay_site_id");
                                    arrayList.add(new ItemPaymentMethod(id, name, image, status, "", "", "", "", "", "", "", "", cinetpayApiKey, cinetpaySiteId, "", false, false, false));
                                }
                                case "Bank Transfer" -> {
                                    String bankTransferInfo = jObjInfo.getString("banktransfer_info");
                                    arrayList.add(new ItemPaymentMethod(id, name, image, status, "", "", "", "", "", "", "", "", "", "", bankTransferInfo, false, false, false));
                                }
                                case "Instamojo" -> {
                                    boolean isSandBox = jObjInfo.getString("mode").equals("sandbox");
                                    arrayList.add(new ItemPaymentMethod(id, name, image, status, "", "", "", "", "", "", "", "", "", "", "", false, false, isSandBox));
                                }
                            }
                        }
                    }
                    return true;
                } catch (Exception e) {
                    e.printStackTrace();
                    return false;
                }
            }

            @Override
            public void onPostExecute(Boolean isExecutionSuccess) {
                paymentMethodListener.onEnd(isExecutionSuccess ? "1" : "0", verifyStatus, message, arrayList);
            }
        }.execute();
    }
}