package com.vpapps.asyncTask;

import android.os.AsyncTask;

import com.vpapps.interfaces.ProfileListener;
import com.vpapps.interfaces.SuccessListener;
import com.vpapps.utils.Constant;
import com.vpapps.utils.JsonUtils;

import org.json.JSONArray;
import org.json.JSONObject;

import okhttp3.RequestBody;

public class LoadProfile extends AsyncTask<String, String, String> {

    RequestBody requestBody;
    ProfileListener profileListener;
    String success = "0", message = "", user_id = "", user_name = "", email = "", phone = "", image = "";

    public LoadProfile(ProfileListener profileListener, RequestBody requestBody) {
        this.profileListener = profileListener;
        this.requestBody = requestBody;
    }

    @Override
    protected void onPreExecute() {
        profileListener.onStart();
        super.onPreExecute();
    }

    @Override
    protected String doInBackground(String... strings) {
        try {
            String json = JsonUtils.okhttpPost(strings[0], requestBody);
            JSONObject mainJson = new JSONObject(json);
            JSONArray jsonArray = mainJson.getJSONArray(Constant.TAG_ROOT);

            for (int i = 0; i < jsonArray.length(); i++) {
                JSONObject c = jsonArray.getJSONObject(i);

                success = c.getString(Constant.TAG_SUCCESS);

                if (success.equals("1")) {
                    user_id = c.getString("user_id");
                    user_name = c.getString("name");
                    email = c.getString("email");
                    phone = c.getString("phone");
                    image = c.getString("user_image");
                } else {
                    message = c.getString(Constant.TAG_MSG);
                }
            }
            return "1";
        } catch (Exception e) {
            e.printStackTrace();
            return "0";
        }
    }

    @Override
    protected void onPostExecute(String s) {
        profileListener.onEnd(s, success, message, user_id, user_name, email, phone, image);
        super.onPostExecute(s);
    }
}