package com.vpapps.asyncTask;

import android.os.AsyncTask;

import com.vpapps.interfaces.SearchListener;
import com.vpapps.item.ItemAlbums;
import com.vpapps.item.ItemArtist;
import com.vpapps.item.ItemCat;
import com.vpapps.item.ItemPost;
import com.vpapps.item.ItemServerPlayList;
import com.vpapps.item.ItemSong;
import com.vpapps.utils.Constant;
import com.vpapps.utils.JsonUtils;

import org.json.JSONArray;
import org.json.JSONObject;

import java.util.ArrayList;

import okhttp3.RequestBody;

public class LoadSearch extends AsyncTask<String, String, String> {

    SearchListener searchListener;
    RequestBody requestBody;
    ArrayList<ItemPost> arrayListPost = new ArrayList<>();

    public LoadSearch(SearchListener searchListener, RequestBody requestBody) {
        this.searchListener = searchListener;
        this.requestBody = requestBody;
    }

    @Override
    protected void onPreExecute() {
        searchListener.onStart();
        super.onPreExecute();
    }

    @Override
    protected String doInBackground(String... strings) {
        try {
            String json = JsonUtils.okhttpPost(strings[0], requestBody);

            JSONObject mainJson = new JSONObject(json);
            JSONObject jsonObjectRoot = mainJson.getJSONObject(Constant.TAG_ROOT);

            ItemPost itemPost;
            String postTitle = "", postType = "", postId = "";

            if (jsonObjectRoot.has("songs_list")) {
                postId = "1";
                postTitle = "Songs";
                postType = "songs";
                itemPost = new ItemPost(postId, postTitle, postType);

                ArrayList<ItemSong> arrayListSongs = new ArrayList<>();
                JSONArray jsonArray_song = jsonObjectRoot.getJSONArray("songs_list");
                for (int i = 0; i < jsonArray_song.length(); i++) {
                    JSONObject objJson = jsonArray_song.getJSONObject(i);

                    String id = objJson.getString(Constant.TAG_SONG_ID);
                    String name = objJson.getString(Constant.TAG_SONG_NAME);
                    String url = objJson.getString(Constant.TAG_MP3_URL);
                    String desc = objJson.getString(Constant.TAG_DESC);
                    String lyrics = objJson.getString(Constant.TAG_SONG_LYRICS);
                    String thumb = objJson.getString(Constant.TAG_THUMB_B).replace(" ", "%20");
                    if(thumb.equals("")) {
                        thumb = "null";
                    }

                    String avg_rate = objJson.getString(Constant.TAG_AVERAGE_RATE);
                    String views = objJson.getString(Constant.TAG_VIEWS);
                    String downloads = objJson.getString(Constant.TAG_DOWNLOADS);
                    Boolean isFav = objJson.getBoolean(Constant.TAG_IS_FAV);

                    String artist = "";
                    if(objJson.has("artist_list")) {
                        JSONArray jAArtist = objJson.getJSONArray("artist_list");
                        if(jAArtist.length() >0) {
                            artist = jAArtist.getJSONObject(0).getString("artist_name");
                        }
                    }

                    ItemSong objItem = new ItemSong(id, artist, url, thumb, name, desc, lyrics, avg_rate, views, downloads, isFav);
                    arrayListSongs.add(objItem);
                }
                itemPost.setArrayListSongs(arrayListSongs);
                arrayListPost.add(itemPost);
            }

            if (jsonObjectRoot.has("artist_list")) {
                postId = "2";
                postTitle = "Artist";
                postType = "artists";
                itemPost = new ItemPost(postId, postTitle, postType);

                ArrayList<ItemArtist> arrayListArtist = new ArrayList<>();
                JSONArray jsonArray_artist = jsonObjectRoot.getJSONArray("artist_list");
                for (int i = 0; i < jsonArray_artist.length(); i++) {
                    JSONObject objJson = jsonArray_artist.getJSONObject(i);

                    String id = objJson.getString(Constant.TAG_ARTIST_ID);
                    String name = objJson.getString(Constant.TAG_ARTIST_NAME);
                    String image = objJson.getString(Constant.TAG_ARTIST_IMAGE);

                    ItemArtist objItem = new ItemArtist(id, name, image, "thumb");
                    arrayListArtist.add(objItem);
                }
                itemPost.setArrayListArtist(arrayListArtist);
                arrayListPost.add(itemPost);
            }

            if (jsonObjectRoot.has("album_list")) {
                ArrayList<ItemAlbums> arrayListAlbums = new ArrayList<>();

                JSONArray jsonArray_albums = jsonObjectRoot.getJSONArray("album_list");

                postId = "3";
                postTitle = "Albums";
                postType = "albums";
                itemPost = new ItemPost(postId, postTitle, postType);

                for (int i = 0; i < jsonArray_albums.length(); i++) {
                    JSONObject objJson = jsonArray_albums.getJSONObject(i);

                    String id = objJson.getString(Constant.TAG_ALBUM_ID);
                    String name = objJson.getString(Constant.TAG_ALBUM_NAME);
                    String image = objJson.getString(Constant.TAG_ALBUM_IMAGE);
                    String total_songs = objJson.getString(Constant.TAG_TOTAL_SONGS);

                    ItemAlbums objItem = new ItemAlbums(id, name, image, total_songs);
                    arrayListAlbums.add(objItem);
                }
                itemPost.setArrayListAlbums(arrayListAlbums);
                arrayListPost.add(itemPost);
            }

            if (jsonObjectRoot.has("category_list")) {
                ArrayList<ItemCat> arrayListCat = new ArrayList<>();

                JSONArray jsonArray_albums = jsonObjectRoot.getJSONArray("category_list");

                postId = "4";
                postTitle = "Categories";
                postType = "categories";
                itemPost = new ItemPost(postId, postTitle, postType);

                for (int i = 0; i < jsonArray_albums.length(); i++) {
                    JSONObject objJson = jsonArray_albums.getJSONObject(i);

                    String id = objJson.getString(Constant.TAG_CID);
                    String name = objJson.getString(Constant.TAG_CAT_NAME);
                    String image = objJson.getString(Constant.TAG_CAT_IMAGE);

                    ItemCat objItem = new ItemCat(id, name, image);
                    arrayListCat.add(objItem);
                }
                itemPost.setArrayListCategories(arrayListCat);
                arrayListPost.add(itemPost);
            }

            if (jsonObjectRoot.has("playlist_list")) {
                ArrayList<ItemServerPlayList> arrayListPlaylist = new ArrayList<>();

                JSONArray jsonArray_albums = jsonObjectRoot.getJSONArray("playlist_list");

                postId = "5";
                postTitle = "Playlist";
                postType = "playlists";
                itemPost = new ItemPost(postId, postTitle, postType);

                for (int i = 0; i < jsonArray_albums.length(); i++) {
                    JSONObject objJson = jsonArray_albums.getJSONObject(i);

                    String id = objJson.getString(Constant.TAG_PID);
                    String name = objJson.getString(Constant.TAG_PLAYLIST_NAME);
                    String image = objJson.getString(Constant.TAG_PLAYLIST_IMAGE);
                    String total_songs = objJson.getString(Constant.TAG_TOTAL_SONGS);

                    ItemServerPlayList objItem = new ItemServerPlayList(id, name, image, total_songs);
                    arrayListPlaylist.add(objItem);
                }
                itemPost.setArrayListPlaylist(arrayListPlaylist);
                arrayListPost.add(itemPost);
            }

            return "1";
        } catch (Exception e) {
            e.printStackTrace();
            return "0";
        }
    }

    @Override
    protected void onPostExecute(String s) {
        searchListener.onEnd(s, arrayListPost);
        super.onPostExecute(s);
    }
}