package com.vpapps.asyncTask;

import android.os.AsyncTask;

import com.vpapps.interfaces.SongListener;
import com.vpapps.item.ItemSong;
import com.vpapps.utils.Constant;
import com.vpapps.utils.JsonUtils;

import org.json.JSONArray;
import org.json.JSONObject;

import java.util.ArrayList;

import okhttp3.RequestBody;

public class LoadSong extends AsyncTask<String, String, String> {

    SongListener songListener;
    RequestBody requestBody;
    ArrayList<ItemSong> arrayList = new ArrayList<>();
    String verifyStatus = "0", message = "";

    public LoadSong(SongListener songListener, RequestBody requestBody) {
        this.songListener = songListener;
        this.requestBody = requestBody;
    }

    @Override
    protected void onPreExecute() {
        songListener.onStart();
        super.onPreExecute();
    }

    @Override
    protected String doInBackground(String... strings) {
        try {
            String json = JsonUtils.okhttpPost(strings[0], requestBody);

            JSONObject mainJson = new JSONObject(json);
            JSONArray jsonArray = mainJson.getJSONArray(Constant.TAG_ROOT);

            if (jsonArray.length() > 0 && jsonArray.getJSONObject(0).has("songs_list")) {
                jsonArray = jsonArray.getJSONObject(0).getJSONArray("songs_list");
            }

            for (int i = 0; i < jsonArray.length(); i++) {
                JSONObject objJson = jsonArray.getJSONObject(i);

                if (!objJson.has(Constant.TAG_SUCCESS)) {
                    String id = objJson.getString(Constant.TAG_SONG_ID);
                    String name = objJson.getString(Constant.TAG_SONG_NAME);
                    String url = objJson.getString(Constant.TAG_MP3_URL);
                    String desc = objJson.getString(Constant.TAG_DESC);
                    String lyrics = objJson.getString(Constant.TAG_SONG_LYRICS);
                    String thumb = objJson.getString(Constant.TAG_THUMB_B).replace(" ", "%20");
                    if(thumb.equals("")) {
                        thumb = "null";
                    }

                    String avg_rate = objJson.getString(Constant.TAG_AVERAGE_RATE);
                    String views = objJson.getString(Constant.TAG_VIEWS);
                    String downloads = objJson.getString(Constant.TAG_DOWNLOADS);
                    Boolean isFav = objJson.getBoolean(Constant.TAG_IS_FAV);

                    String artist = "";
                    if(objJson.has("artist_list")) {
                        JSONArray jAArtist = objJson.getJSONArray("artist_list");
                        if(jAArtist.length() >0) {
                            artist = jAArtist.getJSONObject(0).getString("artist_name");

                            for (int j = 1; j < jAArtist.length(); j++) {
                                artist = artist.concat(", ").concat(jAArtist.getJSONObject(j).getString("artist_name"));
                            }
                        }
                    }

                    ItemSong objItem = new ItemSong(id, artist, url, thumb, name, desc, lyrics, avg_rate, views, downloads, isFav);
                    arrayList.add(objItem);
                } else {
                    verifyStatus = objJson.getString(Constant.TAG_SUCCESS);
                    message = objJson.getString(Constant.TAG_MSG);
                }
            }
            return "1";
        } catch (Exception e) {
            e.printStackTrace();
            return "0";
        }
    }

    @Override
    protected void onPostExecute(String s) {
        songListener.onEnd(s, verifyStatus, message, arrayList);
        super.onPostExecute(s);
    }
}