package com.vpapps.asyncTask;

import android.util.Log;

import com.vpapps.interfaces.SubscriptionPlanListener;
import com.vpapps.item.ItemSubscriptionPlan;
import com.vpapps.utils.BackgroundTask;
import com.vpapps.utils.Constant;
import com.vpapps.utils.JsonUtils;

import org.json.JSONArray;
import org.json.JSONObject;

import java.util.ArrayList;

import okhttp3.RequestBody;

public class LoadSubscriptionPlan {

    RequestBody requestBody;
    ArrayList<ItemSubscriptionPlan> arrayList = new ArrayList<>();
    SubscriptionPlanListener subscriptionPlanListener;
    String verifyStatus = "0", message = "";

    public LoadSubscriptionPlan(SubscriptionPlanListener subscriptionPlanListener, RequestBody requestBody) {
        this.subscriptionPlanListener = subscriptionPlanListener;
        this.requestBody = requestBody;
    }

    public void doWork(String apiUrl) {
        new BackgroundTask() {
            @Override
            public void onPreExecute() {
                subscriptionPlanListener.onStart();
            }

            @Override
            public boolean doInBackground() {
                try {
                    String json = JsonUtils.okhttpPost(apiUrl, requestBody);
                    JSONObject mainJson = new JSONObject(json);

                    verifyStatus = mainJson.getString("success");

                    if (mainJson.get(Constant.TAG_ROOT) instanceof JSONArray) {
                        JSONArray jsonArray = mainJson.getJSONArray(Constant.TAG_ROOT);

                        if (verifyStatus.equals("1")) {
                            for (int i = 0; i < jsonArray.length(); i++) {
                                JSONObject objJson = jsonArray.getJSONObject(i);
                                String id = objJson.getString("plan_id");
                                String planName = objJson.getString("plan_name");
                                String planDuration = objJson.getString("plan_duration");
                                String planPrice = objJson.getString("plan_price");
                                String currencyCode = objJson.getString("currency_code");
                                int deviceLimit = objJson.getInt("plan_device_limit");
                                boolean isAdsOn = objJson.getInt("ads_on_off") == 1;
                                boolean isDownloadOn = objJson.getInt("download_on_off") == 1;

                                String expireOn = "";
                                if (objJson.has("expired_on")) {
                                    expireOn = objJson.getString("expired_on");
                                }

                                ItemSubscriptionPlan itemSubscriptionPlan = new ItemSubscriptionPlan(id, planName, planPrice, planDuration, deviceLimit, isAdsOn, isDownloadOn, currencyCode);
                                itemSubscriptionPlan.setExpireOn(expireOn);
                                arrayList.add(itemSubscriptionPlan);
                            }
                        }
                    } else {
                        JSONObject objJson = mainJson.getJSONObject(Constant.TAG_ROOT);

                        if (verifyStatus.equals("1")) {

                            String id = objJson.getString("plan_id");
                            String planName = objJson.getString("plan_name");
                            String planDuration = objJson.getString("plan_duration");
                            String planPrice = objJson.getString("plan_price");
                            String currencyCode="";
                            if(objJson.has("currency_code")) {
                                currencyCode = objJson.getString("currency_code");
                            }
                            int deviceLimit = objJson.getInt("plan_device_limit");
                            boolean isAdsOn = objJson.getInt("ads_on_off") == 1;
                            boolean isDownloadOn = objJson.getInt("download_on_off") == 1;

                            String expireOn = "";
                            if (objJson.has("expired_on")) {
                                expireOn = objJson.getString("expired_on");
                            }

                            ItemSubscriptionPlan itemSubscriptionPlan = new ItemSubscriptionPlan(id, planName, planPrice, planDuration, deviceLimit, isAdsOn, isDownloadOn, currencyCode);
                            itemSubscriptionPlan.setExpireOn(expireOn);
                            arrayList.add(itemSubscriptionPlan);
                        }
                    }
                    return true;
                } catch (Exception ee) {
                    ee.printStackTrace();
                    return false;
                }
            }

            @Override
            public void onPostExecute(Boolean isExecutionSuccess) {
                subscriptionPlanListener.onEnd(isExecutionSuccess ? "1" : "0", verifyStatus, message, arrayList);
            }
        }.execute();
    }
}