package com.vpapps.asyncTask;

import android.os.AsyncTask;
import android.util.Log;

import com.vpapps.interfaces.SuccessListener;
import com.vpapps.item.ItemSubscriptionPlan;
import com.vpapps.utils.BackgroundTask;
import com.vpapps.utils.Constant;
import com.vpapps.utils.JsonUtils;

import org.json.JSONArray;
import org.json.JSONObject;

import okhttp3.RequestBody;

public class LoadSuccess {

    RequestBody requestBody;
    SuccessListener successListener;
    String success = "0", message = "";

    public LoadSuccess(SuccessListener successListener, RequestBody requestBody) {
        this.successListener = successListener;
        this.requestBody = requestBody;
    }

    public void doWork(String apiUrl) {
        new BackgroundTask() {
            @Override
            public void onPreExecute() {
                successListener.onStart();
            }

            @Override
            public boolean doInBackground() {
                try {
                    String json = JsonUtils.okhttpPost(apiUrl, requestBody);
                    JSONObject mainJson = new JSONObject(json);
                    JSONArray jsonArray = mainJson.getJSONArray(Constant.TAG_ROOT);

                    for (int i = 0; i < jsonArray.length(); i++) {
                        JSONObject c = jsonArray.getJSONObject(i);

                        success = c.getString("success");
                        message = c.getString("msg");
                    }
                    return true;
                } catch (Exception ee) {
                    ee.printStackTrace();
                    return false;
                }
            }

            @Override
            public void onPostExecute(Boolean isExecutionSuccess) {
                successListener.onEnd(isExecutionSuccess ? "1" : "0", success, message);
            }
        }.execute();
    }
}