package com.vpapps.asyncTask;

import android.util.Log;

import com.vpapps.interfaces.TransactionListener;
import com.vpapps.item.ItemTransaction;
import com.vpapps.utils.BackgroundTask;
import com.vpapps.utils.Constant;
import com.vpapps.utils.JsonUtils;

import org.json.JSONArray;
import org.json.JSONObject;

import java.util.ArrayList;

import okhttp3.RequestBody;

public class LoadTransaction {

    RequestBody requestBody;
    ArrayList<ItemTransaction> arrayList = new ArrayList<>();
    TransactionListener transactionListener;
    String apiSuccess = "0", message = "";

    public LoadTransaction(TransactionListener transactionListener, RequestBody requestBody) {
        this.transactionListener = transactionListener;
        this.requestBody = requestBody;
    }

    public void doWork(String apiUrl) {
        new BackgroundTask() {
            @Override
            public void onPreExecute() {
                transactionListener.onStart();
            }

            @Override
            public boolean doInBackground() {
                try {
                    String json = JsonUtils.okhttpPost(apiUrl, requestBody);
                    JSONObject mainJson = new JSONObject(json);

                    apiSuccess = mainJson.getString("success");

                    if (mainJson.get(Constant.TAG_ROOT) instanceof JSONArray) {
                        JSONArray jsonArray = mainJson.getJSONArray(Constant.TAG_ROOT);

                        if (apiSuccess.equals("1")) {
                            for (int i = 0; i < jsonArray.length(); i++) {
                                JSONObject objJson = jsonArray.getJSONObject(i);
                                String planName = objJson.getString("plan_name");
                                String payment_id = objJson.getString("payment_id");
                                String gateway = objJson.getString("gateway");
                                String amount = objJson.getString("payment_amount");
                                String currencyCode = objJson.getString("currency_code");
                                String date = objJson.getString("date");

                                arrayList.add(new ItemTransaction(planName, payment_id, gateway, amount, currencyCode, date));
                            }
                        }
                    }
                    return true;
                } catch (Exception ee) {
                    ee.printStackTrace();
                    return false;
                }
            }

            @Override
            public void onPostExecute(Boolean isExecutionSuccess) {
                transactionListener.onEnd(isExecutionSuccess ? "1" : "0", apiSuccess, message, arrayList);
            }
        }.execute();
    }
}