package com.vpapps.fragment;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Handler;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.appcompat.widget.SearchView;
import androidx.core.view.MenuItemCompat;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentManager;
import androidx.fragment.app.FragmentTransaction;
import androidx.recyclerview.widget.DefaultItemAnimator;
import androidx.recyclerview.widget.GridLayoutManager;
import androidx.recyclerview.widget.RecyclerView;

import com.google.ads.mediation.admob.AdMobAdapter;
import com.google.ads.mediation.facebook.FacebookMediationAdapter;
import com.google.android.gms.ads.AdLoader;
import com.google.android.gms.ads.AdRequest;
import com.google.android.gms.ads.nativead.NativeAd;
import com.vpapps.adapter.AdapterArtist;
import com.vpapps.asyncTask.LoadArtist;
import com.vpapps.interfaces.ArtistListener;
import com.vpapps.interfaces.InterAdListener;
import com.vpapps.item.ItemArtist;
import com.vpapps.onlinemp3.DownloadActivity;
import com.vpapps.onlinemp3.OfflineMusicActivity;
import com.vpapps.onlinemp3.R;
import com.vpapps.onlinemp3.SongByCatActivity;
import com.vpapps.utils.Constant;
import com.vpapps.utils.EndlessRecyclerViewScrollListener;
import com.vpapps.utils.Methods;
import com.vpapps.utils.RecyclerItemClickListener;

import java.util.ArrayList;

import fr.castorflex.android.circularprogressbar.CircularProgressBar;

public class FragmentArtist extends Fragment {

    private Methods methods;
    private RecyclerView rv;
    private AdapterArtist adapterArtist;
    private ArrayList<ItemArtist> arrayList;
    private CircularProgressBar progressBar;
    private FrameLayout frameLayout;
    private GridLayoutManager glm_banner;

    private String errr_msg, homeSecId = "";
    private int page = 1;
    private Boolean isOver = false, isScroll = false, isLoading = false, isFromHome = false;

    private AdLoader adLoader;
    private ArrayList<NativeAd> arrayListNativeAds = new ArrayList<>();

    @Override
    public View onCreateView(@NonNull LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        View rootView = inflater.inflate(R.layout.fragment_artist, container, false);

        methods = new Methods(getActivity(), new InterAdListener() {
            @Override
            public void onClick(int position, String type) {
                if(adapterArtist.getItem(position) != null) {
                    Intent intent = new Intent(getActivity(), SongByCatActivity.class);
                    intent.putExtra("type", getString(R.string.artist));
                    intent.putExtra("id", arrayList.get(position).getId());
                    intent.putExtra("name", arrayList.get(position).getName());
                    startActivity(intent);
                }
            }
        });

        try {
            homeSecId = getArguments().getString("id");
            isFromHome = true;
        } catch (Exception e) {
            homeSecId = "";
            isFromHome = false;
            e.printStackTrace();
        }

        arrayList = new ArrayList<>();

        progressBar = rootView.findViewById(R.id.pb_artist);
        frameLayout = rootView.findViewById(R.id.fl_empty);

        rv = rootView.findViewById(R.id.rv_artist);
        glm_banner = new GridLayoutManager(getActivity(),3);
        glm_banner.setSpanSizeLookup(new GridLayoutManager.SpanSizeLookup() {
            @Override
            public int getSpanSize(int position) {
                return (adapterArtist.getItemViewType(position) == -2 || adapterArtist.isHeader(position)) ? glm_banner.getSpanCount() : 1;
            }
        });

        rv.setLayoutManager(glm_banner);
        rv.setItemAnimator(new DefaultItemAnimator());
        rv.setHasFixedSize(true);

        rv.addOnItemTouchListener(new RecyclerItemClickListener(getActivity(), new RecyclerItemClickListener.OnItemClickListener() {
            @Override
            public void onItemClick(View view, int position) {
                methods.showInterAd(position,"");
            }
        }));

        if(!isFromHome) {
            rv.addOnScrollListener(new EndlessRecyclerViewScrollListener(glm_banner) {
                @Override
                public void onLoadMore(int p, int totalItemsCount) {
                    if (!isOver) {
                        if (!isLoading) {
                            isLoading = true;
                            new Handler().postDelayed(new Runnable() {
                                @Override
                                public void run() {
                                    isScroll = true;
                                    loadArtists();
                                }
                            }, 0);
                        }
                    }
                }
            });
        }

        loadArtists();

        setHasOptionsMenu(true);
        return rootView;
    }

    @Override
    public void onCreateOptionsMenu(@NonNull Menu menu, @NonNull MenuInflater inflater) {
        menu.clear();
        inflater.inflate(R.menu.menu_search, menu);
        MenuItem item = menu.findItem(R.id.menu_search);
        MenuItemCompat.setShowAsAction(item, MenuItemCompat.SHOW_AS_ACTION_COLLAPSE_ACTION_VIEW | MenuItemCompat.SHOW_AS_ACTION_IF_ROOM);
        SearchView searchView = (SearchView) menu.findItem(R.id.menu_search).getActionView();
        searchView.setOnQueryTextListener(queryTextListener);
    }

    SearchView.OnQueryTextListener queryTextListener = new SearchView.OnQueryTextListener() {
        @Override
        public boolean onQueryTextSubmit(String s) {
            Constant.search_item = s.replace(" ", "%20");
            FragmentSearchArtist fsearch = new FragmentSearchArtist();
            FragmentManager fm = getParentFragmentManager();
            FragmentTransaction ft = fm.beginTransaction();
            ft.setTransition(FragmentTransaction.TRANSIT_FRAGMENT_OPEN);
            ft.hide(getParentFragmentManager().getFragments().get(getParentFragmentManager().getBackStackEntryCount()));
            ft.add(R.id.fragment, fsearch, getString(R.string.search_artist));
            ft.addToBackStack(getString(R.string.search_artist));
            ft.commit();
            return true;
        }

        @Override
        public boolean onQueryTextChange(String s) {
            return false;
        }
    };

    private void loadArtists() {
        if (methods.isNetworkAvailable()) {

            String method = "", url = "";
            if(!isFromHome) {
                method = Constant.METHOD_ARTIST;
                url = Constant.METHOD_ARTIST.concat("?page=").concat(String.valueOf(page));
            } else {
                method = Constant.METHOD_HOME_DETAILS;
                url = Constant.METHOD_HOME_DETAILS;
            }

            LoadArtist loadArtist = new LoadArtist(new ArtistListener() {
                @Override
                public void onStart() {
                    if (arrayList.size() == 0) {
                        frameLayout.setVisibility(View.GONE);
                        rv.setVisibility(View.GONE);
                        progressBar.setVisibility(View.VISIBLE);
                    }
                }

                @Override
                public void onEnd(String success, String verifyStatus, String message, ArrayList<ItemArtist> arrayListArtist) {
                    if (getActivity() != null) {
                        if (success.equals("1")) {
                            if (!verifyStatus.equals("-1")) {
                                if (arrayListArtist.size() == 0) {
                                    isOver = true;
                                    errr_msg = getString(R.string.err_no_artist_found);
                                    try {
                                        adapterArtist.hideHeader();
                                    } catch (Exception e) {
                                        e.printStackTrace();
                                    }
                                    setEmpty();
                                } else {
                                    for (int i = 0; i < arrayListArtist.size(); i++) {
                                        arrayList.add(arrayListArtist.get(i));
                                        if (methods.canLoadNativeAds(getActivity())) {
                                            int abc = arrayList.lastIndexOf(null);
                                            if (((arrayList.size() - (abc + 1)) % Constant.nativeAdShow == 0)) {
                                                arrayList.add(null);
                                            }
                                        }
                                    }
                                    page = page + 1;
                                    setAdapter();
                                }
                            } else {
                                methods.getVerifyDialog(getString(R.string.error_unauth_access), message);
                            }
                        } else {
                            isOver = true;
                            try {
                                adapterArtist.hideHeader();
                            } catch (Exception e) {
                                e.printStackTrace();
                            }
                            errr_msg = getString(R.string.err_server);
                            setEmpty();
                        }
                        progressBar.setVisibility(View.GONE);
                        isLoading = false;
                    }
                }
            }, methods.getAPIRequest(method, 0, "", "", "", "", homeSecId, "", "", "","","","","","","","", null));
            loadArtist.execute(url);
        } else {
            errr_msg = getString(R.string.err_internet_not_conn);
            setEmpty();
        }
    }

    private void setAdapter() {
        if (!isScroll) {
            adapterArtist = new AdapterArtist(getActivity(), arrayList);
            rv.setAdapter(adapterArtist);
            setEmpty();
            loadNativeAds();
        } else {
            adapterArtist.notifyDataSetChanged();
        }
    }

    private void loadNativeAds() {
        if (methods.canLoadNativeAds(getActivity()) && !Constant.nativeAdType.equals(Constant.AD_TYPE_WORTISE) && !Constant.nativeAdType.equals(Constant.AD_TYPE_STARTAPP) && arrayList.size() >= 10) {
            AdLoader.Builder builder = new AdLoader.Builder(getActivity(), Constant.nativeAdID);

            Bundle extras = new Bundle();

            AdRequest adRequest;
            if(Constant.interstitialAdType.equals(Constant.AD_TYPE_ADMOB)) {
                adRequest = new AdRequest.Builder()
                        .addNetworkExtrasBundle(AdMobAdapter.class, extras)
                        .build();
            } else {
                adRequest = new AdRequest.Builder()
                        .addNetworkExtrasBundle(AdMobAdapter.class, new Bundle())
                        .addNetworkExtrasBundle(FacebookMediationAdapter.class, extras)
                        .build();
            }

            adLoader = builder.forNativeAd(
                    new NativeAd.OnNativeAdLoadedListener() {
                        @Override
                        public void onNativeAdLoaded(NativeAd nativeAd) {
                            try {
                                if(adLoader.isLoading()) {
                                    arrayListNativeAds.add(nativeAd);
                                } else {
                                    arrayListNativeAds.add(nativeAd);
                                    adapterArtist.addAds(arrayListNativeAds);
                                }
                            } catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                    }).build();
            adLoader.loadAds(adRequest, 5);
        }
    }

    public void setEmpty() {
        if(!arrayList.isEmpty()) {
            rv.setVisibility(View.VISIBLE);
            frameLayout.setVisibility(View.GONE);
        } else {
            rv.setVisibility(View.GONE);
            frameLayout.setVisibility(View.VISIBLE);

            frameLayout.removeAllViews();
            LayoutInflater inflater = (LayoutInflater)   getContext().getSystemService(Context.LAYOUT_INFLATER_SERVICE);

            View myView = null;
            if(errr_msg.equals(getString(R.string.err_no_artist_found))) {
                myView = inflater.inflate(R.layout.layout_err_nodata, null);
            } else if(errr_msg.equals(getString(R.string.err_internet_not_conn))) {
                myView = inflater.inflate(R.layout.layout_err_internet, null);
            } else if(errr_msg.equals(getString(R.string.err_server))){
                myView = inflater.inflate(R.layout.layout_err_server, null);
            }

            TextView textView = myView.findViewById(R.id.tv_empty_msg);
            textView.setText(errr_msg);

            myView.findViewById(R.id.btn_empty_try).setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View v) {
                    loadArtists();
                }
            });

            myView.findViewById(R.id.btn_empty_downloads).setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View v) {
                    Intent intent = new Intent(getActivity(), DownloadActivity.class);
                    startActivity(intent);
                }
            });

            myView.findViewById(R.id.btn_empty_music_lib).setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View v) {
                    Intent intent_music_lib = new Intent(getActivity(), OfflineMusicActivity.class);
                    startActivity(intent_music_lib);
                }
            });

            frameLayout.addView(myView);
        }
    }
}