package com.vpapps.fragment;

import android.content.Intent;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.appcompat.widget.SearchView;
import androidx.core.view.MenuProvider;
import androidx.core.view.ViewCompat;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentManager;
import androidx.fragment.app.FragmentTransaction;
import androidx.lifecycle.Lifecycle;

import com.google.android.material.bottomnavigation.BottomNavigationView;
import com.google.android.material.bottomsheet.BottomSheetDialog;
import com.google.android.material.floatingactionbutton.FloatingActionButton;
import com.vpapps.onlinemp3.MainActivity;
import com.vpapps.onlinemp3.OfflineMusicActivity;
import com.vpapps.onlinemp3.R;
import com.vpapps.onlinemp3.SubscriptionActivity;
import com.vpapps.utils.Constant;
import com.vpapps.utils.Methods;

import java.util.Objects;

public class FragmentDashBoard extends Fragment {

    Methods methods;
    public static BottomNavigationView bottomNavigationView;
    FloatingActionButton fab_library;
    private FragmentManager fm;

    @Override
    public View onCreateView(@NonNull LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {

        View rootView = inflater.inflate(R.layout.fragment_dashboard, container, false);
        setHasOptionsMenu(true);

        bottomNavigationView = rootView.findViewById(R.id.bottomNavigationView);
        ViewCompat.setOnApplyWindowInsetsListener(bottomNavigationView, (v, insets) -> insets);

        fm = getParentFragmentManager();
        methods = new Methods(getActivity());

        fab_library = rootView.findViewById(R.id.fab_home_library);

        FragmentHome f1 = new FragmentHome();
        loadFrag(f1, getString(R.string.home));

        bottomNavigationView.setOnItemSelectedListener(item -> {
            int itemId = item.getItemId();
            if (itemId == R.id.nav_bottom_home) {
                FragmentHome f11 = new FragmentHome();
                loadFrag(f11, getString(R.string.home));
            } else if (itemId == R.id.nav_bottom_profile) {
                FragmentProfile fprofile = new FragmentProfile();
                loadFrag(fprofile, getString(R.string.profile));
            } else if (itemId == R.id.nav_bottom_setting) {
                FragmentSetting fsetting = new FragmentSetting();
                loadFrag(fsetting, getString(R.string.settings));
            } else if (itemId == R.id.nav_bottom_latest) {
                FragmentLatest flatest = new FragmentLatest();
                loadFrag(flatest, getString(R.string.latest));
            }
            return true;
        });

        fab_library.setOnClickListener(view -> {
            openBottomSheetMoreOptions();
        });

        return rootView;
    }

    public void loadFrag(Fragment f1, String name) {
        FragmentTransaction ft = fm.beginTransaction();
        ft.setTransition(FragmentTransaction.TRANSIT_FRAGMENT_OPEN);
        if (name.equals(getString(R.string.search))) {
            ft.hide(fm.getFragments().get(fm.getBackStackEntryCount()));
            ft.add(R.id.fragment_dash, f1, name);
            ft.addToBackStack(name);
        } else {
            ft.replace(R.id.fragment_dash, f1, name);
        }
        ft.commit();

        Objects.requireNonNull((MainActivity) requireActivity()).getSupportActionBar().setTitle(name);
    }

    private void openBottomSheetMoreOptions() {
        View view = getLayoutInflater().inflate(R.layout.layout_bottomsheet_main, null);

        BottomSheetDialog dialog = new BottomSheetDialog(requireContext());
        dialog.setContentView(view);
        dialog.getWindow().findViewById(R.id.design_bottom_sheet).setBackgroundResource(android.R.color.transparent);
        dialog.show();

        TextView tv_artist = dialog.findViewById(R.id.tv_option_artist);
        TextView tv_albums = dialog.findViewById(R.id.tv_option_albums);
        TextView tv_playlist = dialog.findViewById(R.id.tv_option_playlist);
        TextView tv_cat = dialog.findViewById(R.id.tv_option_cat);
        TextView tv_music_lib = dialog.findViewById(R.id.tv_option_music_lib);
        FloatingActionButton fab_close = dialog.findViewById(R.id.fab_options_close);

        tv_artist.setOnClickListener(view1 -> {
            dialog.dismiss();
            FragmentArtist f_art = new FragmentArtist();
            FragmentTransaction ft = getParentFragmentManager().beginTransaction();
            ft.setTransition(FragmentTransaction.TRANSIT_FRAGMENT_OPEN);
            ft.hide(getParentFragmentManager()
                    .getFragments()
                    .get(getParentFragmentManager().getBackStackEntryCount()));
            ft.add(R.id.fragment, f_art, getString(R.string.artist));
            ft.addToBackStack(getString(R.string.artist));
            ft.commit();
            Objects.requireNonNull((MainActivity) requireActivity()).getSupportActionBar().setTitle(getString(R.string.artist));
            Objects.requireNonNull((MainActivity) requireActivity()).getSupportActionBar().setDisplayHomeAsUpEnabled(true);
        });

        tv_albums.setOnClickListener(view1 -> {
            dialog.dismiss();
            FragmentAlbums f_album = new FragmentAlbums();
            FragmentTransaction ft = getParentFragmentManager().beginTransaction();
            ft.setTransition(FragmentTransaction.TRANSIT_FRAGMENT_OPEN);
            ft.hide(getParentFragmentManager()
                    .getFragments()
                    .get(getParentFragmentManager().getBackStackEntryCount()));
            ft.add(R.id.fragment, f_album, getString(R.string.albums));
            ft.addToBackStack(getString(R.string.albums));
            ft.commit();
            Objects.requireNonNull((MainActivity) requireActivity()).getSupportActionBar().setTitle(getString(R.string.albums));
            Objects.requireNonNull((MainActivity) requireActivity()).getSupportActionBar().setDisplayHomeAsUpEnabled(true);
        });

        tv_playlist.setOnClickListener(view1 -> {
            dialog.dismiss();
            FragmentServerPlaylist f_playlist = new FragmentServerPlaylist();
            FragmentTransaction ft = getParentFragmentManager().beginTransaction();
            ft.setTransition(FragmentTransaction.TRANSIT_FRAGMENT_OPEN);
            ft.hide(getParentFragmentManager()
                    .getFragments()
                    .get(getParentFragmentManager().getBackStackEntryCount()));
            ft.add(R.id.fragment, f_playlist, getString(R.string.playlist));
            ft.addToBackStack(getString(R.string.playlist));
            ft.commit();
            Objects.requireNonNull((MainActivity) requireActivity()).getSupportActionBar().setTitle(getString(R.string.playlist));
            Objects.requireNonNull((MainActivity) requireActivity()).getSupportActionBar().setDisplayHomeAsUpEnabled(true);
        });

        tv_cat.setOnClickListener(view1 -> {
            dialog.dismiss();
            FragmentCategories f_cat = new FragmentCategories();
            FragmentTransaction ft = getParentFragmentManager().beginTransaction();
            ft.setTransition(FragmentTransaction.TRANSIT_FRAGMENT_OPEN);
            ft.hide(getParentFragmentManager()
                    .getFragments()
                    .get(getParentFragmentManager().getBackStackEntryCount()));
            ft.add(R.id.fragment, f_cat, getString(R.string.categories));
            ft.addToBackStack(getString(R.string.categories));
            ft.commit();
            Objects.requireNonNull((MainActivity) requireActivity()).getSupportActionBar().setTitle(getString(R.string.categories));
            Objects.requireNonNull((MainActivity) requireActivity()).getSupportActionBar().setDisplayHomeAsUpEnabled(true);
        });

        tv_music_lib.setOnClickListener(view1 -> {
            dialog.dismiss();
            Intent intent = new Intent(requireActivity(), OfflineMusicActivity.class);
            startActivity(intent);
        });

        fab_close.setOnClickListener(view1 -> {
            dialog.dismiss();
        });
    }
}