package com.vpapps.fragment;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;

import com.vpapps.adapter.AdapterHome;
import com.vpapps.asyncTask.LoadHome;
import com.vpapps.interfaces.HomeListener;
import com.vpapps.interfaces.InterAdListener;
import com.vpapps.item.ItemPost;
import com.vpapps.onlinemp3.BaseActivity;
import com.vpapps.onlinemp3.DownloadActivity;
import com.vpapps.onlinemp3.OfflineMusicActivity;
import com.vpapps.onlinemp3.R;
import com.vpapps.onlinemp3.SubscriptionActivity;
import com.vpapps.utils.Constant;
import com.vpapps.utils.DBHelper;
import com.vpapps.utils.Methods;
import com.vpapps.utils.SharedPref;

import java.util.ArrayList;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.appcompat.widget.SearchView;
import androidx.core.view.MenuItemCompat;
import androidx.core.view.MenuProvider;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentManager;
import androidx.fragment.app.FragmentTransaction;
import androidx.lifecycle.Lifecycle;
import androidx.recyclerview.widget.DefaultItemAnimator;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import fr.castorflex.android.circularprogressbar.CircularProgressBar;

public class FragmentHome extends Fragment {

    DBHelper dbHelper;
    Methods methods;
    SharedPref sharedPref;
    CircularProgressBar progressBar;
    FrameLayout frameLayout;
    RecyclerView rv_home;
    AdapterHome adapterHome;
    ArrayList<ItemPost> arrayList;
    private String errr_msg;
    MenuItem menuSubscription;

    @Override
    public View onCreateView(@NonNull LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {

        View rootView = inflater.inflate(R.layout.fragment_home, container, false);

        methods = new Methods(getActivity(), new InterAdListener() {
            @Override
            public void onClick(int position, String type) {

            }
        });
        sharedPref = new SharedPref(requireActivity());
        arrayList = new ArrayList<>();
        dbHelper = new DBHelper(getActivity());

        rv_home = rootView.findViewById(R.id.rv_home);
        LinearLayoutManager llm_artist = new LinearLayoutManager(getActivity());
        rv_home.setLayoutManager(llm_artist);
        rv_home.setItemAnimator(new DefaultItemAnimator());
        rv_home.setHasFixedSize(true);

        progressBar = rootView.findViewById(R.id.pb_home);
        frameLayout = rootView.findViewById(R.id.fl_empty);

        LayoutInflater inflat = (LayoutInflater) getContext().getSystemService(Context.LAYOUT_INFLATER_SERVICE);

        View myView = inflat.inflate(R.layout.layout_err_internet, null);
        frameLayout.addView(myView);
        myView.findViewById(R.id.btn_empty_try).setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                loadHome();
            }
        });
        myView.findViewById(R.id.btn_empty_downloads).setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                Intent intent = new Intent(getActivity(), DownloadActivity.class);
                startActivity(intent);
            }
        });

        myView.findViewById(R.id.btn_empty_music_lib).setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                Intent intent_music_lib = new Intent(getActivity(), OfflineMusicActivity.class);
                startActivity(intent_music_lib);
            }
        });

        loadHome();

        return rootView;
    }

    @Override
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {

        requireActivity().addMenuProvider(new MenuProvider() {
            @Override
            public void onCreateMenu(@NonNull Menu menu, @NonNull MenuInflater menuInflater) {
                menu.clear();
                menuInflater.inflate(R.menu.menu_search, menu);

                MenuItem item = menu.findItem(R.id.menu_search);
                item.setShowAsAction(MenuItem.SHOW_AS_ACTION_COLLAPSE_ACTION_VIEW | MenuItem.SHOW_AS_ACTION_IF_ROOM);
                SearchView searchView = (SearchView) menu.findItem(R.id.menu_search).getActionView();
                searchView.setOnQueryTextListener(queryTextListener);

                menuSubscription = menu.findItem(R.id.menu_subs);
                changeSubscriptionVisibility();
            }

            @Override
            public boolean onMenuItemSelected(@NonNull MenuItem menuItem) {
                if (menuItem.getItemId() == R.id.menu_subs) {
                    Intent intent = new Intent(getActivity(), SubscriptionActivity.class);
                    startActivity(intent);
                    return true;
                }
                return false;
            }
        }, getViewLifecycleOwner(), Lifecycle.State.RESUMED);

        super.onViewCreated(view, savedInstanceState);
    }

    SearchView.OnQueryTextListener queryTextListener = new SearchView.OnQueryTextListener() {
        @Override
        public boolean onQueryTextSubmit(String s) {
            Constant.search_item = s.replace(" ", "%20");
            FragmentSearch fsearch = new FragmentSearch();
            FragmentManager fm = getParentFragmentManager();
            FragmentTransaction ft = fm.beginTransaction();
            ft.setTransition(FragmentTransaction.TRANSIT_FRAGMENT_OPEN);
            ft.hide(fm.findFragmentByTag(getString(R.string.home)));
            ft.add(R.id.fragment, fsearch, getString(R.string.search));
            ft.addToBackStack(getString(R.string.search));
            ft.commit();
            return true;
        }

        @Override
        public boolean onQueryTextChange(String s) {
            return false;
        }
    };

    private void loadHome() {
        if (methods.isNetworkAvailable()) {
            LoadHome loadHome = new LoadHome(new HomeListener() {
                @Override
                public void onStart() {
                    frameLayout.setVisibility(View.GONE);
                    rv_home.setVisibility(View.GONE);
                    progressBar.setVisibility(View.VISIBLE);
                }

                @Override
                public void onEnd(String success, String message, ArrayList<ItemPost> arrayListPost) {
                    if (getActivity() != null) {
                        if (success.equals("1")) {

                            if (Constant.arrayList_play.isEmpty() && !arrayListPost.isEmpty()) {
                                for (int i = 0; i < arrayListPost.size(); i++) {
                                    if(!arrayListPost.get(i).getArrayListSongs().isEmpty()) {
                                        Constant.arrayList_play.addAll(arrayListPost.get(i).getArrayListSongs());
                                        ((BaseActivity) getActivity()).changeText(Constant.arrayList_play.get(0), "home");
                                        break;
                                    }
                                }
                            }

                            arrayList.addAll(arrayListPost);

                            adapterHome = new AdapterHome(getActivity(), arrayListPost);
                            rv_home.setAdapter(adapterHome);
                            loadEmpty();

                            errr_msg = getString(R.string.err_no_artist_found);
                        } else if (success.equals("-2")) {
                            methods.getInvalidUserDialog(message);
                        } else {
                            errr_msg = getString(R.string.err_server);
                        }

                        progressBar.setVisibility(View.GONE);
                    }
                }
            }, methods.getAPIRequest(Constant.METHOD_HOME, 0, "", dbHelper.getRecentNewsIDs("10"), "", "", "", "", "", "", "", "", "", "", "", sharedPref.getUserID(), "", null));
            loadHome.execute(Constant.METHOD_HOME);
        } else {
            errr_msg = getString(R.string.err_internet_not_conn);
            frameLayout.setVisibility(View.VISIBLE);
            progressBar.setVisibility(View.GONE);
        }
    }

    private void loadEmpty() {
        if (!arrayList.isEmpty()) {
            rv_home.setVisibility(View.VISIBLE);
            frameLayout.setVisibility(View.GONE);
        } else {
            rv_home.setVisibility(View.GONE);
            frameLayout.setVisibility(View.VISIBLE);
        }
    }

    public void changeSubscriptionVisibility() {
        if(menuSubscription != null) {
            menuSubscription.setVisible(Constant.isSubscriptionEnabled && (!sharedPref.getIsSubscribed() || sharedPref.getIsAdOn()));
        }
    }
}