package com.vpapps.fragment;

import static android.content.Context.INPUT_METHOD_SERVICE;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.Intent;
import android.os.AsyncTask;
import android.os.Bundle;
import android.os.Handler;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.inputmethod.InputMethodManager;
import android.widget.EditText;
import android.widget.FrameLayout;
import android.widget.TextView;
import android.widget.Toast;

import androidx.annotation.NonNull;
import androidx.fragment.app.Fragment;
import androidx.recyclerview.widget.DefaultItemAnimator;
import androidx.recyclerview.widget.GridLayoutManager;
import androidx.recyclerview.widget.RecyclerView;

import com.google.android.material.bottomsheet.BottomSheetDialog;
import com.google.android.material.button.MaterialButton;
import com.google.android.material.card.MaterialCardView;
import com.vpapps.adapter.AdapterMyPlaylist;
import com.vpapps.interfaces.ClickListenerCallback;
import com.vpapps.interfaces.InterAdListener;
import com.vpapps.item.ItemMyPlayList;
import com.vpapps.onlinemp3.DownloadActivity;
import com.vpapps.onlinemp3.OfflineMusicActivity;
import com.vpapps.onlinemp3.R;
import com.vpapps.onlinemp3.SongByMyPlaylistActivity;
import com.vpapps.utils.DBHelper;
import com.vpapps.utils.Methods;

import java.util.ArrayList;

import fr.castorflex.android.circularprogressbar.CircularProgressBar;

public class FragmentMyPlaylist extends Fragment {

    DBHelper dbHelper;
    Methods methods;
    RecyclerView rv;
    MaterialCardView cv_add;
    AdapterMyPlaylist adapterMyPlaylist;
    ArrayList<ItemMyPlayList> arrayList;
    FrameLayout frameLayout;
    CircularProgressBar progressBar;

    public static FragmentMyPlaylist newInstance(int sectionNumber) {
        FragmentMyPlaylist fragment = new FragmentMyPlaylist();
        return fragment;
    }

    @Override
    public View onCreateView(@NonNull LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {

        View rootView = inflater.inflate(R.layout.fragment_my_playlist, container, false);

        dbHelper = new DBHelper(getActivity());

        methods = new Methods(getActivity(), new InterAdListener() {
            @Override
            public void onClick(int position, String type) {
                Intent intent = new Intent(getActivity(), SongByMyPlaylistActivity.class);
                intent.putExtra("item", adapterMyPlaylist.getItem(position));
                startActivity(intent);
            }
        });

        arrayList = new ArrayList<>();


        cv_add = rootView.findViewById(R.id.cv_my_playlist);
        frameLayout = rootView.findViewById(R.id.fl_empty);
        progressBar = rootView.findViewById(R.id.pb_playlist);
        progressBar.setVisibility(View.VISIBLE);

        rv = rootView.findViewById(R.id.rv_myplaylist);
        GridLayoutManager gridLayoutManager = new GridLayoutManager(getActivity(), 2);
        rv.setLayoutManager(gridLayoutManager);
        rv.setItemAnimator(new DefaultItemAnimator());
        rv.setNestedScrollingEnabled(false);

        cv_add.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                showBottomSheetAddPlaylist();
            }
        });

        loadSongs();

        return rootView;
    }

    @SuppressLint("StaticFieldLeak")
    private void loadSongs() {
        new AsyncTask<String,String,String>() {

            @Override
            protected void onPreExecute() {
                super.onPreExecute();
            }

            @Override
            protected String doInBackground(String... strings) {
                arrayList.addAll(dbHelper.loadPlayList(true));
                return null;
            }

            @Override
            protected void onPostExecute(String s) {
                super.onPostExecute(s);

                adapterMyPlaylist = new AdapterMyPlaylist(getActivity(), arrayList, new ClickListenerCallback() {
                    @Override
                    public void onClick(int position) {
                        methods.showInterAd(position, "");
                    }

                    @Override
                    public void onItemZero() {
                        setEmpty();
                    }
                }, true);
                rv.setAdapter(adapterMyPlaylist);
                setEmpty();
            }
        }.execute();
    }

    private void setEmpty() {
        progressBar.setVisibility(View.GONE);
        if (!arrayList.isEmpty()) {
            frameLayout.setVisibility(View.GONE);
            rv.setVisibility(View.VISIBLE);
        } else {
            frameLayout.setVisibility(View.VISIBLE);
            rv.setVisibility(View.GONE);

            frameLayout.removeAllViews();
            LayoutInflater infltr = (LayoutInflater) getContext().getSystemService(Context.LAYOUT_INFLATER_SERVICE);

            View myView = infltr.inflate(R.layout.layout_err_nodata, null);

            TextView textView = myView.findViewById(R.id.tv_empty_msg);
            textView.setText(getString(R.string.err_no_playlist_found));

            myView.findViewById(R.id.btn_empty_try).setVisibility(View.GONE);

            myView.findViewById(R.id.btn_empty_downloads).setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View v) {
                    Intent intent = new Intent(getActivity(), DownloadActivity.class);
                    startActivity(intent);
                }
            });

            myView.findViewById(R.id.btn_empty_music_lib).setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View v) {
                    Intent intent_music_lib = new Intent(getActivity(), OfflineMusicActivity.class);
                    startActivity(intent_music_lib);
                }
            });

            frameLayout.addView(myView);
        }
    }

    public void showBottomSheetAddPlaylist() {
        final InputMethodManager inputMethodManager = (InputMethodManager) getActivity().getSystemService(INPUT_METHOD_SERVICE);

        View view = getLayoutInflater().inflate(R.layout.layout_bottomsheet_add_playlist, null);

        BottomSheetDialog dialog = new BottomSheetDialog(getActivity(), R.style.BottomSheetDialogStyle);
        dialog.setContentView(view);
        dialog.show();

        MaterialButton button_add = dialog.findViewById(R.id.button_add_playlist);
        MaterialButton button_cancel = dialog.findViewById(R.id.button_add_playlist_cancel);
        EditText et_add = dialog.findViewById(R.id.et_add_playlist);

        button_add.setOnClickListener(v -> {
            if (!et_add.getText().toString().trim().isEmpty()) {
                arrayList.clear();
                arrayList.addAll(dbHelper.addPlayList(et_add.getText().toString(), true));
                Toast.makeText(getActivity(), getString(R.string.playlist_added), Toast.LENGTH_SHORT).show();
                adapterMyPlaylist.notifyDataSetChanged();
                setEmpty();
                dialog.dismiss();
            }
        });

        button_cancel.setOnClickListener(v -> {
            dialog.dismiss();
        });

        new Handler().post(
                new Runnable() {
                    public void run() {
                        inputMethodManager.showSoftInput(et_add, 0);
                        et_add.requestFocus();
                    }
                });
    }

    @Override
    public void onDestroy() {
        dbHelper.close();
        if (adapterMyPlaylist != null) {
            adapterMyPlaylist.closeDatabase();
        }
        super.onDestroy();
    }
}