package com.vpapps.fragment;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Handler;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.view.inputmethod.InputMethodManager;
import android.widget.EditText;
import android.widget.FrameLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;
import android.widget.Toast;

import com.google.android.material.bottomsheet.BottomSheetDialog;
import com.google.android.material.button.MaterialButton;
import com.google.android.material.card.MaterialCardView;
import com.vpapps.adapter.AdapterMyPlaylist;
import com.vpapps.interfaces.ClickListenerCallback;
import com.vpapps.interfaces.InterAdListener;
import com.vpapps.item.ItemMyPlayList;
import com.vpapps.onlinemp3.DownloadActivity;
import com.vpapps.onlinemp3.R;
import com.vpapps.onlinemp3.SongByOFFPlaylistActivity;
import com.vpapps.utils.DBHelper;
import com.vpapps.utils.Methods;

import java.util.ArrayList;

import androidx.annotation.NonNull;
import androidx.appcompat.widget.SearchView;
import androidx.constraintlayout.widget.ConstraintLayout;
import androidx.core.content.ContextCompat;
import androidx.core.view.MenuItemCompat;
import androidx.fragment.app.Fragment;
import androidx.recyclerview.widget.DefaultItemAnimator;
import androidx.recyclerview.widget.GridLayoutManager;
import androidx.recyclerview.widget.RecyclerView;

import static android.content.Context.INPUT_METHOD_SERVICE;

public class FragmentOFPlaylist extends Fragment {

    private DBHelper dbHelper;
    private Methods methods;
    private RecyclerView rv;
    private MaterialCardView cv_add;
    private AdapterMyPlaylist adapterMyPlaylist;
    private ArrayList<ItemMyPlayList> arrayList;
    private FrameLayout frameLayout;
    private Boolean isLoaded = false;
    private SearchView searchView;

    public static FragmentOFPlaylist newInstance(int sectionNumber) {
        return new FragmentOFPlaylist();
    }

    @Override
    public View onCreateView(@NonNull LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {

        View rootView = inflater.inflate(R.layout.fragment_my_playlist, container, false);

        dbHelper = new DBHelper(getActivity());

        methods = new Methods(getActivity(), new InterAdListener() {
            @Override
            public void onClick(int position, String type) {
                Intent intent = new Intent(getActivity(), SongByOFFPlaylistActivity.class);
                intent.putExtra("item", adapterMyPlaylist.getItem(position));
                startActivity(intent);
            }
        });

        arrayList = new ArrayList<>();
        arrayList.addAll(dbHelper.loadPlayList(false));

        cv_add = rootView.findViewById(R.id.cv_my_playlist);
        frameLayout = rootView.findViewById(R.id.fl_empty);

        rv = rootView.findViewById(R.id.rv_myplaylist);
        GridLayoutManager gridLayoutManager = new GridLayoutManager(getActivity(), 2);
        rv.setLayoutManager(gridLayoutManager);
        rv.setItemAnimator(new DefaultItemAnimator());
        rv.setNestedScrollingEnabled(false);

        RelativeLayout.LayoutParams params = (RelativeLayout.LayoutParams) cv_add.getLayoutParams();
        params.setMargins(0, 0, 20, 50);
        cv_add.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                showBottomSheetAddPlaylist();
            }
        });

        adapterMyPlaylist = new AdapterMyPlaylist(getActivity(), arrayList, new ClickListenerCallback() {
            @Override
            public void onClick(int position) {
                methods.showInterAd(position, "");
            }

            @Override
            public void onItemZero() {
                setEmpty();
            }
        }, false);

        rv.setAdapter(adapterMyPlaylist);
        setEmpty();

        setHasOptionsMenu(true);
        return rootView;
    }


    @Override
    public void onCreateOptionsMenu(@NonNull Menu menu, @NonNull MenuInflater inflater) {
        menu.clear();
        inflater.inflate(R.menu.menu_search, menu);

        MenuItem item = menu.findItem(R.id.menu_search);
        MenuItemCompat.setShowAsAction(item, MenuItemCompat.SHOW_AS_ACTION_COLLAPSE_ACTION_VIEW | MenuItemCompat.SHOW_AS_ACTION_IF_ROOM);
        searchView = (SearchView) menu.findItem(R.id.menu_search).getActionView();
        searchView.setOnQueryTextListener(queryTextListener);
        super.onCreateOptionsMenu(menu, inflater);
    }

    SearchView.OnQueryTextListener queryTextListener = new SearchView.OnQueryTextListener() {
        @Override
        public boolean onQueryTextSubmit(String s) {
            return false;
        }

        @Override
        public boolean onQueryTextChange(String s) {
            if (adapterMyPlaylist != null) {
                if (!searchView.isIconified()) {
                    adapterMyPlaylist.getFilter().filter(s);
                    adapterMyPlaylist.notifyDataSetChanged();
                }
            }
            return true;
        }
    };

    private void setEmpty() {
        if (!arrayList.isEmpty()) {
            frameLayout.setVisibility(View.GONE);
            rv.setVisibility(View.VISIBLE);
        } else {
            frameLayout.setVisibility(View.VISIBLE);
            rv.setVisibility(View.GONE);

            frameLayout.removeAllViews();
            LayoutInflater infltr = (LayoutInflater) getContext().getSystemService(Context.LAYOUT_INFLATER_SERVICE);

            View myView = infltr.inflate(R.layout.layout_err_nodata, null);

            TextView textView = myView.findViewById(R.id.tv_empty_msg);
            textView.setText(getString(R.string.err_no_playlist_found));

            myView.findViewById(R.id.btn_empty_try).setVisibility(View.GONE);

            myView.findViewById(R.id.btn_empty_downloads).setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View v) {
                    Intent intent = new Intent(getActivity(), DownloadActivity.class);
                    startActivity(intent);
                }
            });

            myView.findViewById(R.id.btn_empty_music_lib).setVisibility(View.GONE);

            frameLayout.addView(myView);
        }
    }

    public void showBottomSheetAddPlaylist() {
        final InputMethodManager inputMethodManager = (InputMethodManager) getActivity().getSystemService(INPUT_METHOD_SERVICE);

        View view = getLayoutInflater().inflate(R.layout.layout_bottomsheet_add_playlist, null);

        BottomSheetDialog dialog = new BottomSheetDialog(getActivity());
        dialog.setContentView(view);
        dialog.getWindow().findViewById(R.id.design_bottom_sheet).setBackgroundResource(android.R.color.transparent);
        dialog.show();

        ConstraintLayout cl_add_playlist = dialog.findViewById(R.id.cl_add_playlist);
        MaterialButton button_add = dialog.findViewById(R.id.button_add_playlist);
        MaterialButton button_cancel = dialog.findViewById(R.id.button_add_playlist_cancel);
        EditText et_add = dialog.findViewById(R.id.et_add_playlist);

        cl_add_playlist.setBackground(methods.getDrawableWithCornerRadius(ContextCompat.getColor(getActivity(), R.color.bg_bottom_sheet),
                30f, 30f, 0, 0));

        button_add.setOnClickListener(v -> {
            if (!et_add.getText().toString().trim().isEmpty()) {
                arrayList.clear();
                arrayList.addAll(dbHelper.addPlayList(et_add.getText().toString(), false));
                Toast.makeText(getActivity(), getString(R.string.playlist_added), Toast.LENGTH_SHORT).show();
                adapterMyPlaylist.notifyDataSetChanged();
                setEmpty();
                dialog.dismiss();
            }
        });

        button_cancel.setOnClickListener(v -> {
            dialog.dismiss();
        });

        new Handler().post(
                new Runnable() {
                    public void run() {
                        inputMethodManager.showSoftInput(et_add, 0);
                        et_add.requestFocus();
                    }
                });
    }

    @Override
    public void setUserVisibleHint(boolean isVisibleToUser) {
        if (isVisibleToUser && adapterMyPlaylist != null) {
            arrayList.clear();
            arrayList.addAll(dbHelper.loadPlayList(false));
            adapterMyPlaylist.notifyDataSetChanged();
        }
        super.setUserVisibleHint(isVisibleToUser);
    }

    @Override
    public void onResume() {
        if (isLoaded && adapterMyPlaylist != null) {
            arrayList.clear();
            arrayList.addAll(dbHelper.loadPlayList(false));
            adapterMyPlaylist.notifyDataSetChanged();
        } else {
            isLoaded = true;
        }
        super.onResume();
    }

    @Override
    public void onDestroy() {
        dbHelper.close();
        if(adapterMyPlaylist != null) {
            adapterMyPlaylist.closeDatabase();
        }
        super.onDestroy();
    }
}