package com.vpapps.fragment;

import android.app.ProgressDialog;
import android.content.Intent;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import android.widget.Toast;

import androidx.annotation.NonNull;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentTransaction;

import com.google.android.material.bottomsheet.BottomSheetDialog;
import com.google.android.material.button.MaterialButton;
import com.squareup.picasso.Picasso;
import com.vpapps.asyncTask.LoadDeleteAccount;
import com.vpapps.asyncTask.LoadProfile;
import com.vpapps.asyncTask.LoadSubscriptionPlan;
import com.vpapps.interfaces.ProfileListener;
import com.vpapps.interfaces.SubscriptionPlanListener;
import com.vpapps.interfaces.SuccessListener;
import com.vpapps.item.ItemSubscriptionPlan;
import com.vpapps.onlinemp3.LoggedDevicesActivity;
import com.vpapps.onlinemp3.MainActivity;
import com.vpapps.onlinemp3.ProfileEditActivity;
import com.vpapps.onlinemp3.R;
import com.vpapps.onlinemp3.SubscriptionActivity;
import com.vpapps.onlinemp3.SuggestionActivity;
import com.vpapps.onlinemp3.TransactionActivity;
import com.vpapps.utils.Constant;
import com.vpapps.utils.Methods;
import com.vpapps.utils.SharedPref;

import java.util.ArrayList;
import java.util.Objects;

public class FragmentProfile extends Fragment {

    Methods methods;
    SharedPref sharedPref;
    ImageView iv_profile, iv_edit, iv_delete_ac,iv_suggest, iv_fav, iv_logged, iv_subs_plans, iv_transaction;
    TextView tv_name, tv_email, tv_current_subs_plan, tv_current_subs_expires, tv_my_playlist, tv_fav, tv_suggest_song, tv_logout, tv_delete_ac, tv_downloads, tv_recent_songs, tv_subs_plans, tv_logged_devices, tv_transaction;

    @Override
    public View onCreateView(@NonNull LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {

        View rootView = inflater.inflate(R.layout.fragment_profile, container, false);

        sharedPref = new SharedPref(getActivity());
        methods = new Methods(getActivity());

        iv_profile = rootView.findViewById(R.id.iv_profile);
        iv_edit = rootView.findViewById(R.id.iv_prof_edit);
        tv_name = rootView.findViewById(R.id.tv_prof_fname);
        tv_email = rootView.findViewById(R.id.tv_prof_email);
        tv_current_subs_plan = rootView.findViewById(R.id.tv_prof_current_subs_plan);
        tv_current_subs_expires = rootView.findViewById(R.id.tv_prof_expires_on);
        tv_my_playlist = rootView.findViewById(R.id.tv_prof_myplaylist);
        tv_fav = rootView.findViewById(R.id.tv_prof_fav);
        tv_suggest_song = rootView.findViewById(R.id.tv_prof_suggest_song);
        tv_logout = rootView.findViewById(R.id.tv_prof_logout);
        tv_delete_ac = rootView.findViewById(R.id.tv_prof_delete_ac);
        tv_downloads = rootView.findViewById(R.id.tv_prof_downloads);
        tv_subs_plans = rootView.findViewById(R.id.tv_prof_subs_plan);
        iv_subs_plans = rootView.findViewById(R.id.iv_prof_subs_plan);
        tv_transaction = rootView.findViewById(R.id.tv_prof_transaction);
        iv_transaction = rootView.findViewById(R.id.iv_prof_transaction);
        tv_logged_devices = rootView.findViewById(R.id.tv_prof_logged_device);
        iv_logged = rootView.findViewById(R.id.iv_prof_logged_device);
        iv_delete_ac = rootView.findViewById(R.id.iv_prof_delete_ac);
        iv_suggest = rootView.findViewById(R.id.iv_prof_suggest);
        iv_fav = rootView.findViewById(R.id.iv_prof_fav);
        tv_recent_songs = rootView.findViewById(R.id.tv_prof_recent);

        iv_edit.setOnClickListener(view -> {
            if (sharedPref != null && sharedPref.isLogged() && !sharedPref.getUserID().equals("")) {
                Intent intent = new Intent(getActivity(), ProfileEditActivity.class);
                startActivity(intent);
            } else {
                Toast.makeText(getActivity(), getString(R.string.not_log), Toast.LENGTH_SHORT).show();
            }
        });

        tv_my_playlist.setOnClickListener(view -> {
            FragmentMyPlaylist f_my_playlist = new FragmentMyPlaylist();
            FragmentTransaction ft = requireActivity().getSupportFragmentManager().beginTransaction();
            ft.setTransition(FragmentTransaction.TRANSIT_FRAGMENT_OPEN);
            ft.hide(requireActivity().getSupportFragmentManager()
                    .getFragments()
                    .get(requireActivity().getSupportFragmentManager().getBackStackEntryCount()));
            ft.add(R.id.fragment, f_my_playlist, requireActivity().getString(R.string.myplaylist));
            ft.addToBackStack(requireActivity().getString(R.string.myplaylist));
            ft.commit();

            Objects.requireNonNull(((MainActivity) requireActivity()).getSupportActionBar()).setTitle(requireActivity().getString(R.string.myplaylist));
            Objects.requireNonNull(((MainActivity) requireActivity()).getSupportActionBar()).setDisplayHomeAsUpEnabled(true);
        });

        tv_fav.setOnClickListener(view -> {
            FragmentFav f_fav = new FragmentFav();
            FragmentTransaction ft = requireActivity().getSupportFragmentManager().beginTransaction();
            ft.setTransition(FragmentTransaction.TRANSIT_FRAGMENT_OPEN);
            ft.hide(requireActivity().getSupportFragmentManager()
                    .getFragments()
                    .get(requireActivity().getSupportFragmentManager().getBackStackEntryCount()));
            ft.add(R.id.fragment, f_fav, requireActivity().getString(R.string.favourite));
            ft.addToBackStack(requireActivity().getString(R.string.favourite));
            ft.commit();

            Objects.requireNonNull(((MainActivity) requireActivity()).getSupportActionBar()).setTitle(requireActivity().getString(R.string.favourite));
            Objects.requireNonNull(((MainActivity) requireActivity()).getSupportActionBar()).setDisplayHomeAsUpEnabled(true);
        });

        tv_downloads.setOnClickListener(view -> {
            if (methods.checkPerAudio(Constant.REQ_AUDIO_DOWNLOAD_PAGE)) {
                FragmentDownloads f_downloads = new FragmentDownloads();
                FragmentTransaction ft = requireActivity().getSupportFragmentManager().beginTransaction();
                ft.setTransition(FragmentTransaction.TRANSIT_FRAGMENT_OPEN);
                ft.hide(requireActivity().getSupportFragmentManager()
                        .getFragments()
                        .get(requireActivity().getSupportFragmentManager().getBackStackEntryCount()));
                ft.add(R.id.fragment, f_downloads, requireActivity().getString(R.string.downloads));
                ft.addToBackStack(requireActivity().getString(R.string.downloads));
                ft.commit();

                Objects.requireNonNull(((MainActivity) requireActivity()).getSupportActionBar()).setTitle(requireActivity().getString(R.string.downloads));
                Objects.requireNonNull(((MainActivity) requireActivity()).getSupportActionBar()).setDisplayHomeAsUpEnabled(true);
            }
        });

        tv_recent_songs.setOnClickListener(view -> {
            FragmentRecentSongs f_recent = new FragmentRecentSongs();
            FragmentTransaction ft = requireActivity().getSupportFragmentManager().beginTransaction();
            ft.setTransition(FragmentTransaction.TRANSIT_FRAGMENT_OPEN);
            ft.hide(requireActivity().getSupportFragmentManager()
                    .getFragments()
                    .get(requireActivity().getSupportFragmentManager().getBackStackEntryCount()));
            ft.add(R.id.fragment, f_recent, requireActivity().getString(R.string.recently_played));
            ft.addToBackStack(requireActivity().getString(R.string.recently_played));
            ft.commit();

            Objects.requireNonNull(((MainActivity) requireActivity()).getSupportActionBar()).setTitle(requireActivity().getString(R.string.recently_played));
            Objects.requireNonNull(((MainActivity) requireActivity()).getSupportActionBar()).setDisplayHomeAsUpEnabled(true);
        });

        tv_suggest_song.setOnClickListener(view -> {
            Intent intent = new Intent(getActivity(), SuggestionActivity.class);
            startActivity(intent);
        });

        tv_subs_plans.setOnClickListener(view -> {
            Intent intent = new Intent(getActivity(), SubscriptionActivity.class);
            startActivity(intent);
        });

        tv_transaction.setOnClickListener(view -> {
            Intent intent = new Intent(getActivity(), TransactionActivity.class);
            startActivity(intent);
        });

        tv_logout.setOnClickListener(view -> {
            methods.clickLogin();
        });

        tv_delete_ac.setOnClickListener(view -> {
            openBottomSheetDeleteAc();
        });

        tv_logged_devices.setOnClickListener(view -> {
            Intent intent = new Intent(getActivity(), LoggedDevicesActivity.class);
            intent.putExtra("isFromApp", true);
            startActivity(intent);
        });

        initView();

        return rootView;
    }

    private void initView() {
        if (sharedPref.isLogged() && !sharedPref.getUserID().equals("")) {
            tv_logout.setText(getString(R.string.logout));
            iv_edit.setVisibility(View.VISIBLE);
            tv_email.setVisibility(View.VISIBLE);
            tv_current_subs_plan.setVisibility(View.VISIBLE);
            tv_current_subs_expires.setVisibility(View.VISIBLE);
            tv_delete_ac.setVisibility(View.VISIBLE);
            iv_delete_ac.setVisibility(View.VISIBLE);
            tv_suggest_song.setVisibility(View.VISIBLE);
            iv_suggest.setVisibility(View.VISIBLE);
            tv_fav.setVisibility(View.VISIBLE);
            iv_fav.setVisibility(View.VISIBLE);

            if(Constant.isSubscriptionEnabled) {
                tv_subs_plans.setVisibility(View.VISIBLE);
                iv_subs_plans.setVisibility(View.VISIBLE);
                tv_transaction.setVisibility(View.VISIBLE);
                iv_transaction.setVisibility(View.VISIBLE);
                tv_logged_devices.setVisibility(View.VISIBLE);
                iv_logged.setVisibility(View.VISIBLE);
            } else {
                tv_subs_plans.setVisibility(View.GONE);
                iv_subs_plans.setVisibility(View.GONE);
                tv_transaction.setVisibility(View.GONE);
                iv_transaction.setVisibility(View.GONE);
                tv_logged_devices.setVisibility(View.GONE);
                iv_logged.setVisibility(View.GONE);
            }

            tv_name.setText(sharedPref.getUserName());
            tv_email.setText(sharedPref.getUserEmail());

            loadUserProfile();
        } else {
            tv_logout.setText(getString(R.string.login));
            iv_edit.setVisibility(View.GONE);
            tv_email.setVisibility(View.GONE);
            tv_current_subs_plan.setVisibility(View.GONE);
            tv_current_subs_expires.setVisibility(View.GONE);
            tv_delete_ac.setVisibility(View.GONE);
            iv_delete_ac.setVisibility(View.GONE);
            tv_suggest_song.setVisibility(View.GONE);
            iv_suggest.setVisibility(View.GONE);
            tv_fav.setVisibility(View.GONE);
            iv_fav.setVisibility(View.GONE);
            tv_subs_plans.setVisibility(View.GONE);
            iv_subs_plans.setVisibility(View.GONE);
            tv_transaction.setVisibility(View.GONE);
            iv_transaction.setVisibility(View.GONE);
            tv_logged_devices.setVisibility(View.GONE);
            iv_logged.setVisibility(View.GONE);
        }
    }

    private void loadUserProfile() {
        if (methods.isNetworkAvailable()) {
            LoadProfile loadProfile = new LoadProfile(new ProfileListener() {
                @Override
                public void onStart() {
                }

                @Override
                public void onEnd(String success, String registerSuccess, String message, String userId, String userName, String email, String phone, String image) {
                    if (getActivity() != null) {
                        if (success.equals("1")) {
                            if (registerSuccess.equals("1")) {
                                sharedPref.setUserName(userName);
                                sharedPref.setUserEmail(email);
                                sharedPref.setUserMobile(phone);
                                sharedPref.setUserImage(image);
                                setVariables();
                            } else if (registerSuccess.equals("-2")) {
                                methods.getInvalidUserDialog(message);
                            } else {
                                methods.loadLogout(sharedPref);
                            }
                        } else if (success.equals("-2")) {
                            methods.getInvalidUserDialog(message);
                        } else {
                            Toast.makeText(getActivity(), getString(R.string.err_server), Toast.LENGTH_SHORT).show();
                        }
                    }
                }
            }, methods.getAPIRequest(Constant.METHOD_PROFILE, 0, "", "", "", "", "", "", "", "", "", "", "", "", "", sharedPref.getUserID(), "", null));
            loadProfile.execute(Constant.METHOD_PROFILE);
        } else {
            Toast.makeText(getActivity(), getString(R.string.err_internet_not_conn), Toast.LENGTH_SHORT).show();
        }
    }

    public void setVariables() {
        tv_name.setText(sharedPref.getUserName());
        tv_email.setText(sharedPref.getUserEmail());
        if (!sharedPref.getUserImage().equals("")) {
            Picasso.get()
                    .load(sharedPref.getUserImage())
                    .into(iv_profile);
        }

        if(Constant.isSubscriptionEnabled) {
            if (sharedPref.getIsSubscribed()) {
                tv_current_subs_plan.setText(sharedPref.getSubscriptionPlanName().concat(" "));
                tv_current_subs_expires.setText(getString(R.string.expires_on).concat(" ").concat(sharedPref.getSubscriptionPlanExpireOn()));
                tv_current_subs_plan.setVisibility(View.VISIBLE);
                tv_current_subs_expires.setVisibility(View.VISIBLE);
            } else {
                tv_current_subs_plan.setVisibility(View.GONE);
                tv_current_subs_expires.setVisibility(View.GONE);
                loadCheckUserSubscription();
            }
        } else {
            tv_subs_plans.setVisibility(View.GONE);
            iv_subs_plans.setVisibility(View.GONE);
            tv_transaction.setVisibility(View.GONE);
            iv_transaction.setVisibility(View.GONE);
            tv_logged_devices.setVisibility(View.GONE);
            iv_logged.setVisibility(View.GONE);
        }
    }

    private void openBottomSheetDeleteAc() {
        View view = getLayoutInflater().inflate(R.layout.layout_bottom_logout, null);

        BottomSheetDialog dialog = new BottomSheetDialog(requireContext());
        dialog.setContentView(view);
        dialog.getWindow().findViewById(R.id.design_bottom_sheet).setBackgroundResource(android.R.color.transparent);
        dialog.show();

        MaterialButton btn_delete = dialog.findViewById(R.id.btn_bottom_logout);
        MaterialButton btn_cancel = dialog.findViewById(R.id.btn_bottom_cancel);
        TextView tv1 = dialog.findViewById(R.id.tv1);
        TextView tv2 = dialog.findViewById(R.id.tv2);
        tv1.setText(getString(R.string.delete_ac));
        tv2.setText(getString(R.string.sure_delete_ac));
        btn_delete.setText(getString(R.string.delete));

        btn_delete.setOnClickListener(view1 -> {
            dialog.dismiss();
            loadDeleteAccount();
        });

        btn_cancel.setOnClickListener(view1 -> dialog.dismiss());
    }

    private void loadCheckUserSubscription() {
        if (methods.isNetworkAvailable()) {
            LoadSubscriptionPlan loadSubscriptionPlan = new LoadSubscriptionPlan(new SubscriptionPlanListener() {
                @Override
                public void onStart() {

                }

                @Override
                public void onEnd(String success, String verifyStatus, String message, ArrayList<ItemSubscriptionPlan> arrayListSubsPlan) {
                    if (success.equals("1")) {
                        if(verifyStatus.equals("1")) {
                            sharedPref.setSubscriptionDetails(true, arrayListSubsPlan.get(0).getId(), arrayListSubsPlan.get(0).getTitle(), arrayListSubsPlan.get(0).getAmount(), arrayListSubsPlan.get(0).getExpireOn(), arrayListSubsPlan.get(0).getDeviceLimit(), arrayListSubsPlan.get(0).isAdsOn(), arrayListSubsPlan.get(0).isDownloadOn());
                            if(sharedPref.getIsSubscribed()) {
                                tv_current_subs_plan.setText(sharedPref.getSubscriptionPlanName().concat(" "));
                                tv_current_subs_expires.setText(getString(R.string.expires_on).concat(" ").concat(sharedPref.getSubscriptionPlanExpireOn()));
                                tv_current_subs_plan.setVisibility(View.VISIBLE);
                                tv_current_subs_expires.setVisibility(View.VISIBLE);
                            } else {
                                tv_current_subs_plan.setVisibility(View.GONE);
                                tv_current_subs_expires.setVisibility(View.GONE);
                                loadCheckUserSubscription();
                            }
                        }
                    }
                }
            }, methods.getAPIRequest(Constant.METHOD_CHECK_USER_PLAN, 0, "", "", "", "", "", "", "", "", "", "", "", "", "", sharedPref.getUserID(), "", null));
            loadSubscriptionPlan.doWork(Constant.METHOD_CHECK_USER_PLAN);
        }
    }

    private void loadDeleteAccount() {
        if (methods.isNetworkAvailable()) {
            ProgressDialog progressDialog = new ProgressDialog(requireContext());
            progressDialog.setMessage(getResources().getString(R.string.deleting));
            progressDialog.setCancelable(false);
            progressDialog.show();

            LoadDeleteAccount loadDeleteAccount = new LoadDeleteAccount(new SuccessListener() {
                @Override
                public void onStart() {

                }

                @Override
                public void onEnd(String success, String favSuccess, String message) {
                    if (success.equals("1")) {
                        if (favSuccess.equals("1")) {
                            Toast.makeText(requireContext(), getString(R.string.account_del_succ), Toast.LENGTH_SHORT).show();
                            methods.loadLogout(sharedPref);
                        } else {
                            Toast.makeText(requireContext(), message, Toast.LENGTH_SHORT).show();
                        }
                    } else {
                        Toast.makeText(requireContext(), getString(R.string.server_error), Toast.LENGTH_SHORT).show();
                    }
                }
            }, methods.getAPIRequest(Constant.METHOD_DELETE_ACCOUNT, 0, "", "", "", "", "", "", "", "", "", "", "", "", "", sharedPref.getUserID(), "", null));
            loadDeleteAccount.execute(Constant.METHOD_DELETE_ACCOUNT);
        } else {
            Toast.makeText(requireContext(), getString(R.string.err_internet_not_conn), Toast.LENGTH_SHORT).show();
        }
    }

    @Override
    public void onResume() {
        if(sharedPref != null && sharedPref.isLogged() && tv_email != null && tv_email.getVisibility() == View.GONE) {
            initView();
        }
        if (Constant.isUpdate) {
            Constant.isUpdate = false;
            setVariables();
        }
        super.onResume();
    }
}