package com.vpapps.fragment;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;
import android.widget.Toast;

import com.vpapps.adapter.AdapterSearch;
import com.vpapps.asyncTask.LoadSearch;
import com.vpapps.interfaces.InterAdListener;
import com.vpapps.interfaces.SearchListener;
import com.vpapps.item.ItemPost;
import com.vpapps.onlinemp3.DownloadActivity;
import com.vpapps.onlinemp3.MainActivity;
import com.vpapps.onlinemp3.OfflineMusicActivity;
import com.vpapps.onlinemp3.R;
import com.vpapps.utils.Constant;
import com.vpapps.utils.Methods;
import com.vpapps.utils.SharedPref;

import java.util.ArrayList;

import androidx.annotation.NonNull;
import androidx.appcompat.widget.SearchView;
import androidx.core.view.MenuItemCompat;
import androidx.fragment.app.Fragment;
import androidx.recyclerview.widget.DefaultItemAnimator;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import fr.castorflex.android.circularprogressbar.CircularProgressBar;

public class FragmentSearch extends Fragment {

    Methods methods;
    RecyclerView rv_search;
    AdapterSearch adapterSearch;
    ArrayList<ItemPost> arrayList_posts;
    private RelativeLayout rl_search;
    private CircularProgressBar progressBar;
    private FrameLayout frameLayout;

    private String errr_msg;
    private SearchView searchView;

    @Override
    public View onCreateView(@NonNull LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {

        View rootView = inflater.inflate(R.layout.activity_search, container, false);

        methods = new Methods(getActivity(), new InterAdListener() {
            @Override
            public void onClick(int position, String type) {
//                Intent intent = new Intent(getActivity(), SongByCatActivity.class);
//
//                if (type.equals(getString(R.string.artist))) {
//                    intent.putExtra("type", getString(R.string.artist));
//                    intent.putExtra("id", arrayList_artist.get(position).getId());
//                    intent.putExtra("name", arrayList_artist.get(position).getName());
//                } else if (type.equals(getString(R.string.albums))) {
//                    intent.putExtra("type", getString(R.string.albums));
//                    intent.putExtra("id", arrayList_album.get(position).getId());
//                    intent.putExtra("name", arrayList_album.get(position).getName());
//                }
//                startActivity(intent);
            }
        });
        ((MainActivity) getActivity()).getSupportActionBar().setTitle(getString(R.string.search));

        arrayList_posts = new ArrayList<>();

        frameLayout = rootView.findViewById(R.id.fl_empty);
        progressBar = rootView.findViewById(R.id.pb_search);

        rv_search = rootView.findViewById(R.id.rv_search);
        LinearLayoutManager llm_artist = new LinearLayoutManager(getActivity());
        rv_search.setLayoutManager(llm_artist);
        rv_search.setItemAnimator(new DefaultItemAnimator());
        rv_search.setHasFixedSize(true);

        rl_search = rootView.findViewById(R.id.rl_search);

        loadSongs();

        setHasOptionsMenu(true);
        return rootView;
    }

    @Override
    public void onCreateOptionsMenu(Menu menu, MenuInflater inflater) {
        menu.clear();
        inflater.inflate(R.menu.menu_search, menu);

        MenuItem item = menu.findItem(R.id.menu_search);
        MenuItemCompat.setShowAsAction(item, MenuItemCompat.SHOW_AS_ACTION_COLLAPSE_ACTION_VIEW | MenuItemCompat.SHOW_AS_ACTION_IF_ROOM);
        searchView = (SearchView) menu.findItem(R.id.menu_search).getActionView();
        searchView.setOnQueryTextListener(queryTextListener);
    }

    SearchView.OnQueryTextListener queryTextListener = new SearchView.OnQueryTextListener() {
        @Override
        public boolean onQueryTextSubmit(String s) {
            if (methods.isNetworkAvailable()) {
                Constant.search_item = s.replace(" ", "%20");
                arrayList_posts.clear();

                loadSongs();
            } else {
                Toast.makeText(getActivity(), getResources().getString(R.string.err_internet_not_conn), Toast.LENGTH_SHORT).show();
            }
            return true;
        }

        @Override
        public boolean onQueryTextChange(String s) {
            return false;
        }
    };

    private void loadSongs() {
        if (methods.isNetworkAvailable()) {
            LoadSearch loadSong = new LoadSearch(new SearchListener() {
                @Override
                public void onStart() {
                    arrayList_posts.clear();
                    frameLayout.setVisibility(View.GONE);
                    rl_search.setVisibility(View.GONE);
                    progressBar.setVisibility(View.VISIBLE);
                }

                @Override
                public void onEnd(String success, ArrayList<ItemPost> arrayListPosts) {
                    if (getActivity() != null) {

                        if (success.equals("1")) {
                            errr_msg = getString(R.string.err_no_data_found);
                            arrayList_posts.addAll(arrayListPosts);

                            setAdapter();
                        }
                    } else {
                        errr_msg = getString(R.string.err_server);
                        setEmpty();
                    }
                    progressBar.setVisibility(View.GONE);
                }
            }, methods.getAPIRequest(Constant.METHOD_SEARCH, 1, "", "", Constant.search_item, "", "", "", "", "", "", "", "", "", "", new SharedPref(getActivity()).getUserID(), "", null));
            loadSong.execute(Constant.METHOD_SEARCH);
        } else {
            errr_msg = getString(R.string.err_internet_not_conn);
            setEmpty();
        }
    }

    private void setAdapter() {
        adapterSearch = new AdapterSearch(getActivity(), arrayList_posts);
        rv_search.setAdapter(adapterSearch);

        setEmpty();
    }

    public void setEmpty() {
        if (!arrayList_posts.isEmpty()) {
            rl_search.setVisibility(View.VISIBLE);
        } else {
            frameLayout.setVisibility(View.VISIBLE);
            frameLayout.removeAllViews();
            LayoutInflater inflater = (LayoutInflater) getActivity().getSystemService(Context.LAYOUT_INFLATER_SERVICE);

            View myView = null;
            if (errr_msg.equals(getString(R.string.err_no_data_found))) {
                myView = inflater.inflate(R.layout.layout_err_nodata, null);
            } else if (errr_msg.equals(getString(R.string.err_internet_not_conn))) {
                myView = inflater.inflate(R.layout.layout_err_internet, null);
            } else if (errr_msg.equals(getString(R.string.err_server))) {
                myView = inflater.inflate(R.layout.layout_err_server, null);
            }

            TextView textView = myView.findViewById(R.id.tv_empty_msg);
            textView.setText(errr_msg);

            myView.findViewById(R.id.btn_empty_try).setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View v) {
                    loadSongs();
                }
            });

            myView.findViewById(R.id.btn_empty_downloads).setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View v) {
                    Intent intent = new Intent(getActivity(), DownloadActivity.class);
                    startActivity(intent);
                }
            });

            myView.findViewById(R.id.btn_empty_music_lib).setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View v) {
                    Intent intent_music_lib = new Intent(getActivity(), OfflineMusicActivity.class);
                    startActivity(intent_music_lib);
                }
            });

            frameLayout.addView(myView);
        }
    }
}