package com.vpapps.fragment;

import android.annotation.SuppressLint;
import android.content.Intent;
import android.content.res.ColorStateList;
import android.net.Uri;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.CompoundButton;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RadioGroup;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.appcompat.app.AppCompatDelegate;
import androidx.appcompat.widget.SwitchCompat;
import androidx.constraintlayout.widget.ConstraintLayout;
import androidx.core.content.ContextCompat;
import androidx.core.graphics.drawable.DrawableCompat;
import androidx.fragment.app.Fragment;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;

import com.google.android.material.bottomsheet.BottomSheetDialog;
import com.google.android.material.button.MaterialButton;
import com.google.android.material.radiobutton.MaterialRadioButton;
import com.onesignal.OneSignal;
import com.vpapps.adapter.AdapterPages;
import com.vpapps.onlinemp3.AboutActivity;
import com.vpapps.onlinemp3.R;
import com.vpapps.utils.Constant;
import com.vpapps.utils.Methods;
import com.vpapps.utils.SharedPref;

public class FragmentSetting extends Fragment {

    SharedPref sharedPref;
    Methods methods;
    RecyclerView rv_pages;
    AdapterPages adapterPages;
    ConstraintLayout ll_theme;
    LinearLayout ll_noti_permission;
    SwitchCompat switch_noti;
    Boolean isNoti = true;
    ImageView iv_theme;
    TextView tv_about, tv_moreapp, tv_rateapp, tv_shareapp, tv_theme, tv_noti_permission;
    String them_mode = "";

    @Override
    public View onCreateView(@NonNull LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {

        View rootView = inflater.inflate(R.layout.fragment_setting, container, false);

        sharedPref = new SharedPref(getActivity());
        methods = new Methods(getActivity());

        isNoti = sharedPref.getIsNotification();
        them_mode = methods.getDarkMode();

        ll_theme = rootView.findViewById(R.id.ll_theme);
        ll_noti_permission = rootView.findViewById(R.id.ll_noti_per);
        rv_pages = rootView.findViewById(R.id.rv_pages);
        switch_noti = rootView.findViewById(R.id.switch_noti);
        iv_theme = rootView.findViewById(R.id.iv_theme);
        tv_theme = rootView.findViewById(R.id.tv_theme);
        tv_rateapp = rootView.findViewById(R.id.tv_rateapp);
        tv_shareapp = rootView.findViewById(R.id.tv_shareapp);
        tv_moreapp = rootView.findViewById(R.id.tv_moreapp);
        tv_about = rootView.findViewById(R.id.tv_about);
        tv_noti_permission = rootView.findViewById(R.id.tv_noti_permission);

        tv_noti_permission.setVisibility(methods.getPerNotificationStatus() ? View.GONE : View.VISIBLE);

        switch_noti.setChecked(isNoti);

        if (methods.isDarkMode()) {
            iv_theme.setImageResource(R.mipmap.mode_dark);
        } else {
            iv_theme.setImageResource(R.mipmap.mode_icon);
        }

        String mode = methods.getDarkMode();
        switch (mode) {
            case Constant.DARK_MODE_SYSTEM -> tv_theme.setText(getString(R.string.system_default));
            case Constant.DARK_MODE_OFF -> tv_theme.setText(getString(R.string.light));
            case Constant.DARK_MODE_ON -> tv_theme.setText(getString(R.string.dark));
        }

        ll_theme.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                openThemeDialog();
            }
        });

        ll_noti_permission.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                if(!methods.getPerNotificationStatus()) {
                    methods.checkPerNotification();
                }
            }
        });

        switch_noti.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener() {
            @Override
            public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
                if(isChecked) {
                    OneSignal.getUser().getPushSubscription().optIn();
                } else{
                    OneSignal.getUser().getPushSubscription().optOut();
                }
                sharedPref.setIsNotification(isChecked);
            }
        });

        tv_about.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                Intent intent = new Intent(getActivity(), AboutActivity.class);
                startActivity(intent);
            }
        });

        tv_rateapp.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                final String appName = requireActivity().getPackageName();//your application package name i.e play store application url
                try {
                    startActivity(new Intent(Intent.ACTION_VIEW,
                            Uri.parse("market://details?id="
                                    + appName)));
                } catch (android.content.ActivityNotFoundException anfe) {
                    startActivity(new Intent(
                            Intent.ACTION_VIEW,
                            Uri.parse("http://play.google.com/store/apps/details?id="
                                    + appName)));
                }
            }
        });

        tv_shareapp.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                Intent ishare = new Intent(Intent.ACTION_SEND);
                ishare.setType("text/plain");
                ishare.putExtra(Intent.EXTRA_TEXT, getResources().getString(R.string.app_name) + " - http://play.google.com/store/apps/details?id=" + requireActivity().getPackageName());
                startActivity(ishare);
            }
        });

        tv_moreapp.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                startActivity(new Intent(Intent.ACTION_VIEW, Uri.parse(getString(R.string.play_more_apps))));
            }
        });

        changeThemeColor();

        if(!Constant.arrayListPages.isEmpty()) {
            rv_pages.setLayoutManager(new LinearLayoutManager(getActivity()));
            adapterPages = new AdapterPages(getActivity(), Constant.arrayListPages);
            rv_pages.setAdapter(adapterPages);
        }

        return rootView;
    }

    private void openThemeDialog() {
        View view = getLayoutInflater().inflate(R.layout.layout_bottom_theme, null);

        BottomSheetDialog dialog_theme = new BottomSheetDialog(requireActivity(), R.style.BottomSheetDialogStyle);
        dialog_theme.setContentView(view);
        dialog_theme.show();

        RadioGroup radioGroup = dialog_theme.findViewById(R.id.rg_theme);
        MaterialButton btn_cancel = dialog_theme.findViewById(R.id.btn_theme_cancel);
        MaterialButton btn_save = dialog_theme.findViewById(R.id.btn_theme_save);

        switch (sharedPref.getDarkMode()) {
            case Constant.DARK_MODE_SYSTEM -> radioGroup.check(radioGroup.getChildAt(0).getId());
            case Constant.DARK_MODE_OFF -> radioGroup.check(radioGroup.getChildAt(1).getId());
            case Constant.DARK_MODE_ON -> radioGroup.check(radioGroup.getChildAt(2).getId());
        }

        radioGroup.setOnCheckedChangeListener(new RadioGroup.OnCheckedChangeListener() {
            @SuppressLint("ResourceType")
            @Override
            public void onCheckedChanged(RadioGroup group, int checkedId) {
                MaterialRadioButton rb = group.findViewById(checkedId);
                if (null != rb && checkedId > -1) {
                    if (checkedId == R.id.rb_system_them) {
                        them_mode = Constant.DARK_MODE_SYSTEM;
                    } else if (checkedId == R.id.rb_light_them) {
                        them_mode = Constant.DARK_MODE_OFF;
                    } else if (checkedId == R.id.rb_dark_them) {
                        them_mode = Constant.DARK_MODE_ON;
                    }
                }
            }
        });

        btn_cancel.setOnClickListener(v -> dialog_theme.dismiss());

        btn_save.setOnClickListener(v -> {
            sharedPref.setDarkMode(them_mode);
            switch (them_mode) {
                case Constant.DARK_MODE_SYSTEM ->
                        tv_theme.setText(getResources().getString(R.string.system_default));
                case Constant.DARK_MODE_OFF ->
                        tv_theme.setText(getResources().getString(R.string.light));
                case Constant.DARK_MODE_ON ->
                        tv_theme.setText(getResources().getString(R.string.dark));
                default -> {
                }
            }
            dialog_theme.dismiss();

            String mode = sharedPref.getDarkMode();
            switch (mode) {
                case Constant.DARK_MODE_SYSTEM ->
                        AppCompatDelegate.setDefaultNightMode(AppCompatDelegate.MODE_NIGHT_FOLLOW_SYSTEM);
                case Constant.DARK_MODE_OFF ->
                        AppCompatDelegate.setDefaultNightMode(AppCompatDelegate.MODE_NIGHT_NO);
                case Constant.DARK_MODE_ON ->
                        AppCompatDelegate.setDefaultNightMode(AppCompatDelegate.MODE_NIGHT_YES);
            }
        });
    }

    private void changeThemeColor() {

        int[][] states = new int[][]{
                new int[]{-android.R.attr.state_checked},
                new int[]{android.R.attr.state_checked},
        };

        int[] thumbColors = new int[]{
                ContextCompat.getColor(requireActivity(), R.color.switch_thumb_disable),
                ContextCompat.getColor(requireActivity(), R.color.primary),
        };

        int[] trackColors = new int[]{
                ContextCompat.getColor(requireActivity(), R.color.black40_dark),
                ContextCompat.getColor(requireActivity(), R.color.black40_dark),
        };
        DrawableCompat.setTintList(DrawableCompat.wrap(switch_noti.getThumbDrawable()), new ColorStateList(states, thumbColors));
        DrawableCompat.setTintList(DrawableCompat.wrap(switch_noti.getTrackDrawable()), new ColorStateList(states, trackColors));
    }

    @Override
    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        super.onRequestPermissionsResult(requestCode, permissions, grantResults);
        if(permissions.length > 0 && permissions[0].equalsIgnoreCase("android.permission.post_notifications")) {
            if(grantResults.length >0 && grantResults[0] != -1) {
                tv_noti_permission.setVisibility(View.GONE);
            }
        }
    }
}