package com.vpapps.onlinemp3;

import static android.provider.Settings.ACTION_REQUEST_SCHEDULE_EXACT_ALARM;

import android.annotation.SuppressLint;
import android.app.AlarmManager;
import android.app.AlertDialog;
import android.app.PendingIntent;
import android.app.ProgressDialog;
import android.app.TimePickerDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.graphics.Color;
import android.graphics.PorterDuff;
import android.graphics.drawable.ColorDrawable;
import android.media.AudioManager;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.CountDownTimer;
import android.os.Handler;
import android.provider.Settings;
import android.view.LayoutInflater;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.view.animation.Animation;
import android.view.animation.LinearInterpolator;
import android.webkit.WebView;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.ProgressBar;
import android.widget.RatingBar;
import android.widget.RelativeLayout;
import android.widget.SeekBar;
import android.widget.TextView;
import android.widget.Toast;

import androidx.annotation.NonNull;
import androidx.appcompat.app.AppCompatActivity;
import androidx.appcompat.widget.AppCompatRatingBar;
import androidx.appcompat.widget.Toolbar;
import androidx.cardview.widget.CardView;
import androidx.constraintlayout.widget.ConstraintLayout;
import androidx.core.content.ContextCompat;
import androidx.core.graphics.Insets;
import androidx.core.view.ViewCompat;
import androidx.core.view.WindowInsetsCompat;
import androidx.viewpager.widget.PagerAdapter;
import androidx.viewpager.widget.ViewPager;

import com.google.android.material.bottomsheet.BottomSheetDialog;
import com.google.android.material.button.MaterialButton;
import com.h6ah4i.android.widget.verticalseekbar.VerticalSeekBar;
import com.makeramen.roundedimageview.RoundedImageView;
import com.sothree.slidinguppanel.SlidingUpPanelLayout;
import com.squareup.picasso.Callback;
import com.squareup.picasso.Picasso;
import com.vpapps.asyncTask.GetRating;
import com.vpapps.asyncTask.LoadFav;
import com.vpapps.asyncTask.LoadRating;
import com.vpapps.asyncTask.LoadSong;
import com.vpapps.eventbus.EventLogout;
import com.vpapps.interfaces.RatingListener;
import com.vpapps.interfaces.RewardAdListener;
import com.vpapps.interfaces.SongListener;
import com.vpapps.interfaces.SuccessListener;
import com.vpapps.item.ItemMyPlayList;
import com.vpapps.item.ItemSong;
import com.vpapps.eventbus.MessageEvent;
import com.vpapps.utils.Constant;
import com.vpapps.utils.DBHelper;
import com.vpapps.utils.GlobalBus;
import com.vpapps.utils.Methods;
import com.vpapps.utils.PausableRotateAnimation;
import com.vpapps.utils.RelativePopupWindow;
import com.vpapps.utils.SharedPref;
import com.vpapps.utils.SleepTimerReceiver;

import org.greenrobot.eventbus.Subscribe;
import org.greenrobot.eventbus.ThreadMode;

import java.util.ArrayList;
import java.util.Random;
import java.util.concurrent.TimeUnit;

public class BaseActivity extends AppCompatActivity implements View.OnClickListener {

    Methods methods;
    DBHelper dbHelper;
    SharedPref sharedPref;
    public ViewPager viewpager;
    ImagePagerAdapter adapter;
    SlidingUpPanelLayout mLayout;
    AudioManager am;
    Toolbar toolbar;
    Boolean isExpand = false, isRotateAnim = false;
    BottomSheetDialog dialog_desc, dialog_rate;
    RelativeLayout rl_min_header;
    LinearLayout ll_max_header;
    RelativeLayout rl_music_loading;
    Handler seekHandler = new Handler();
    PausableRotateAnimation rotateAnimation;

    AppCompatRatingBar ratingBar;
    SeekBar seekBar_music, seekbar_min;
    View view_playlist, view_download, view_rate;
    TextView tv_min_title, tv_min_artist, tv_max_title, tv_max_artist, tv_music_title, tv_music_artist, tv_song_count,
            tv_current_time, tv_total_time, tv_sleepTime;
    RoundedImageView iv_max_song, iv_min_song, imageView_pager;
    CardView cv_music_sleepTime;
    ImageView iv_music_bg, iv_min_play, iv_min_next, iv_max_equalizer, iv_max_fav, iv_max_option, iv_music_shuffle,
            iv_music_repeat, iv_music_previous, iv_music_next, iv_music_play, iv_music_add2playlist, iv_music_share,
            iv_music_download, iv_music_rate, iv_music_volume;

    LinearLayout ll_adView;
    CountDownTimer countDownTimer;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_base);
        ViewCompat.setOnApplyWindowInsetsListener(findViewById(R.id.drawer_layout), (v, insets) -> {
            Insets systemBars = insets.getInsets(WindowInsetsCompat.Type.systemBars());
            v.setPadding(systemBars.left, 0, systemBars.right, 0);
            return insets;
        });


        Constant.context = this;

        methods = new Methods(this);
        sharedPref = new SharedPref(this);
        dbHelper = new DBHelper(this);
        am = (AudioManager) getSystemService(Context.AUDIO_SERVICE);

        ll_adView = findViewById(R.id.ll_adView);

        mLayout = findViewById(R.id.sliding_layout);
        toolbar = findViewById(R.id.toolbar_offline_music);
        setSupportActionBar(toolbar);

        methods.forceRTLIfSupported(getWindow());
        methods.setStatusColorTransparent(getWindow());

        adapter = new ImagePagerAdapter();

        viewpager = findViewById(R.id.viewPager_song);
        viewpager.setOffscreenPageLimit(5);
        rl_min_header = findViewById(R.id.rl_min_header);
        ll_max_header = findViewById(R.id.ll_max_header);
        rl_music_loading = findViewById(R.id.rl_music_loading);
        ratingBar = findViewById(R.id.rb_music);
        seekBar_music = findViewById(R.id.seekbar_music);
        seekbar_min = findViewById(R.id.seekbar_min);
        seekbar_min.setPadding(0, 0, 0, 0);

        RelativeLayout rl = findViewById(R.id.rl);
        rl.setOnClickListener(v -> {

        });

        iv_music_bg = findViewById(R.id.iv_music_bg);
        iv_music_play = findViewById(R.id.iv_music_play);
        iv_music_next = findViewById(R.id.iv_music_next);
        iv_music_previous = findViewById(R.id.iv_music_previous);
        iv_music_shuffle = findViewById(R.id.iv_music_shuffle);
        iv_music_repeat = findViewById(R.id.iv_music_repeat);
        iv_music_add2playlist = findViewById(R.id.iv_music_add2playlist);
        iv_music_share = findViewById(R.id.iv_music_share);
        iv_music_download = findViewById(R.id.iv_music_download);
        iv_music_rate = findViewById(R.id.iv_music_rate);
        iv_music_volume = findViewById(R.id.iv_music_volume);

        view_rate = findViewById(R.id.view_music_rate);
        view_download = findViewById(R.id.view_music_download);
        view_playlist = findViewById(R.id.view_music_playlist);

        iv_min_song = findViewById(R.id.iv_min_song);
        iv_max_song = findViewById(R.id.iv_max_song);
        iv_min_play = findViewById(R.id.iv_min_play);
        iv_min_next = findViewById(R.id.iv_min_next);
        iv_max_fav = findViewById(R.id.iv_max_fav);
        iv_max_equalizer = findViewById(R.id.iv_max_equalizer);
        iv_max_option = findViewById(R.id.iv_max_option);

        tv_current_time = findViewById(R.id.tv_music_time);
        tv_total_time = findViewById(R.id.tv_music_total_time);
        tv_song_count = findViewById(R.id.tv_music_song_count);
        tv_music_title = findViewById(R.id.tv_music_title);
        tv_music_artist = findViewById(R.id.tv_music_artist);
        cv_music_sleepTime = findViewById(R.id.cv_music_sleepTime);
        tv_sleepTime = findViewById(R.id.tv_music_sleepTime);
        tv_min_title = findViewById(R.id.tv_min_title);
        tv_min_artist = findViewById(R.id.tv_min_artist);
        tv_max_title = findViewById(R.id.tv_max_title);
        tv_max_artist = findViewById(R.id.tv_max_artist);

        iv_max_fav.setOnClickListener(this);
        iv_max_equalizer.setOnClickListener(this);
        iv_max_option.setOnClickListener(this);

        iv_min_play.setOnClickListener(this);
        iv_min_next.setOnClickListener(this);

        iv_music_play.setOnClickListener(this);
        iv_music_next.setOnClickListener(this);
        iv_music_previous.setOnClickListener(this);
        iv_music_shuffle.setOnClickListener(this);
        iv_music_repeat.setOnClickListener(this);
        iv_music_add2playlist.setOnClickListener(this);
        iv_music_share.setOnClickListener(this);
        iv_music_download.setOnClickListener(this);
        iv_music_rate.setOnClickListener(this);
        iv_music_volume.setOnClickListener(this);
        cv_music_sleepTime.setOnClickListener(this);

        if (methods.isDarkMode()) {
            iv_music_next.setColorFilter(Color.WHITE);
            iv_music_previous.setColorFilter(Color.WHITE);
            iv_music_add2playlist.setColorFilter(Color.WHITE);
            iv_music_share.setColorFilter(Color.WHITE);
            iv_music_download.setColorFilter(Color.WHITE);
            iv_music_rate.setColorFilter(Color.WHITE);
            iv_music_volume.setColorFilter(Color.WHITE);

            iv_min_next.setColorFilter(Color.WHITE);
            iv_min_play.setColorFilter(Color.WHITE);
        }

        if (!Constant.isRepeat) {
            if (methods.isDarkMode()) {
                iv_music_repeat.setImageDrawable(ContextCompat.getDrawable(BaseActivity.this, R.drawable.ic_repeat));
            } else {
                iv_music_repeat.setImageDrawable(ContextCompat.getDrawable(BaseActivity.this, R.mipmap.ic_repeat));
            }
        } else {
            iv_music_repeat.setImageDrawable(ContextCompat.getDrawable(BaseActivity.this, R.mipmap.ic_repeat_hover));
        }

        if (!Constant.isSuffle) {
            iv_music_shuffle.setColorFilter(ContextCompat.getColor(BaseActivity.this, R.color.grey_dark));
        } else {
            iv_music_shuffle.setColorFilter(ContextCompat.getColor(BaseActivity.this, R.color.primary));
        }

        ImageView iv_white_blur = findViewById(R.id.iv_music_white_blur);
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(ViewGroup.LayoutParams.MATCH_PARENT, (50 * methods.getScreenHeight() / 100));
        params.addRule(RelativeLayout.ALIGN_PARENT_BOTTOM);
        iv_white_blur.setLayoutParams(params);

        mLayout.addPanelSlideListener(new SlidingUpPanelLayout.PanelSlideListener() {
            @Override
            public void onPanelSlide(View panel, float slideOffset) {
                if (slideOffset == 0.0f) {
                    isExpand = false;

                    rl_min_header.setVisibility(View.VISIBLE);
                    ll_max_header.setVisibility(View.INVISIBLE);
                } else if (slideOffset > 0.0f && slideOffset < 1.0f) {
                    rl_min_header.setVisibility(View.VISIBLE);
                    ll_max_header.setVisibility(View.VISIBLE);

                    if (isExpand) {
                        rl_min_header.setAlpha(1.0f - slideOffset);
                        ll_max_header.setAlpha(0.0f + slideOffset);
                    } else {
                        rl_min_header.setAlpha(1.0f - slideOffset);
                        ll_max_header.setAlpha(slideOffset);
                    }
                } else {
                    isExpand = true;

                    rl_min_header.setVisibility(View.INVISIBLE);
                    ll_max_header.setVisibility(View.VISIBLE);
                }
            }

            @Override
            public void onPanelStateChanged(View panel, SlidingUpPanelLayout.PanelState previousState, SlidingUpPanelLayout.PanelState newState) {
                if (newState == SlidingUpPanelLayout.PanelState.EXPANDED) {
                    try {
                        if (viewpager.getAdapter() == null || Constant.isNewAdded || !Constant.addedFrom.equals(adapter.getIsLoadedFrom())) {
                            viewpager.setAdapter(adapter);
                        }
                        viewpager.setCurrentItem(Constant.playPos);
                    } catch (Exception e) {
                        adapter.notifyDataSetChanged();
                        viewpager.setCurrentItem(Constant.playPos);
                    }
                }
            }
        });

        seekBar_music.setOnSeekBarChangeListener(new SeekBar.OnSeekBarChangeListener() {

            @Override
            public void onProgressChanged(SeekBar seekBar, int progress, boolean fromUser) {
            }

            @Override
            public void onStartTrackingTouch(SeekBar seekBar) {
            }

            @Override
            public void onStopTrackingTouch(SeekBar seekBar) {
                int progress = seekBar.getProgress();
                try {
                    Intent intent = new Intent(BaseActivity.this, PlayerService.class);
                    intent.setAction(PlayerService.ACTION_SEEKTO);
                    intent.putExtra("seekto", methods.getSeekFromPercentage(progress, PlayerService.getInstance().getDuration()));
                    startService(intent);
                } catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });

        newRotateAnim();
        viewpager.addOnPageChangeListener(new ViewPager.OnPageChangeListener() {
            @Override
            public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
//                Constant.isScrolled = true;
            }

            @Override
            public void onPageSelected(int position) {
                changeTextPager(Constant.arrayList_play.get(position));

                View view = viewpager.findViewWithTag("myview" + position);
                if (view != null) {
                    ImageView iv = view.findViewById(R.id.iv_vp_play);
                    if (Constant.playPos == position) {
                        iv.setVisibility(View.GONE);
                    } else {
                        iv.setVisibility(View.VISIBLE);
                    }
                }
            }

            @Override
            public void onPageScrollStateChanged(int state) {

            }
        });

        tv_current_time.setText("00:00");
        tv_total_time.setText("00:00");


        if (Constant.pushID.equals("0")) {
            if (Constant.arrayList_play.isEmpty()) {
                Constant.arrayList_play.addAll(dbHelper.loadDataRecent(true, Constant.recentLimit));
                if (!Constant.arrayList_play.isEmpty()) {
                    GlobalBus.getBus().postSticky(Constant.arrayList_play.get(Constant.playPos));
                }
            }
        } else if (Constant.pushType.equals("song")) {
            new LoadSong(new SongListener() {
                @Override
                public void onStart() {
                    Constant.pushID = "0";
                }

                @Override
                public void onEnd(String success, String verifyStatus, String message, ArrayList<ItemSong> arrayList) {
                    if (success.equals("1") && !verifyStatus.equals("-1") && !arrayList.isEmpty()) {
                        Constant.isOnline = true;
                        Constant.arrayList_play.clear();
                        Constant.arrayList_play.addAll(arrayList);
                        Constant.playPos = 0;
                        try {
                            GlobalBus.getBus().postSticky(new ItemMyPlayList("", "", null));
                        } catch (Exception e) {
                            e.printStackTrace();
                        }

                        Intent intent = new Intent(BaseActivity.this, PlayerService.class);
                        intent.setAction(PlayerService.ACTION_PLAY);
                        startService(intent);
                    } else if (verifyStatus.equals("-1")) {
                        methods.getVerifyDialog(getString(R.string.error_unauth_access), message);
                    }
                }
            }, methods.getAPIRequest(Constant.METHOD_SONG_DETAIL, 0, "", Constant.pushID, "", "", "", "", "", "", "", "", "", "", "", new SharedPref(BaseActivity.this).getUserID(), "", null)).execute(Constant.METHOD_SONG_DETAIL);
        }

        sharedPref.setCheckSleepTime();
        if (sharedPref.getIsSleepTimeOn()) {
            updateTimer(sharedPref.getSleepTime());
        }
    }

    @Override
    public boolean onOptionsItemSelected(MenuItem menuItem) {
        if (menuItem.getItemId() == android.R.id.home) {
            onBackPressed();
        } else {
            return super.onOptionsItemSelected(menuItem);
        }
        return true;
    }

    @Override
    public void onClick(View view) {
        int id = view.getId();
        if (id == R.id.iv_min_play) {
            playPause();
        } else if (id == R.id.iv_music_play) {
            playPause();
        } else if (id == R.id.iv_min_next) {
            next();
        } else if (id == R.id.iv_music_next) {
            next();
            //            case R.id.iv_min_previous:
//                previous();
//                break;
        } else if (id == R.id.iv_music_previous) {
            previous();
        } else if (id == R.id.iv_music_shuffle) {
            setShuffle();
        } else if (id == R.id.iv_music_repeat) {
            setRepeat();
        } else if (id == R.id.iv_max_option) {
            openOptionPopUp();
        } else if (id == R.id.iv_max_fav) {
            if (sharedPref.isLogged()) {
                if (!Constant.arrayList_play.isEmpty()) {
                    if (Constant.isOnline) {
                        methods.animateHeartButton(view);
                        view.setSelected(!view.isSelected());
                        fav();
                    }
                } else {
                    Toast.makeText(BaseActivity.this, getResources().getString(R.string.err_no_songs_selected), Toast.LENGTH_SHORT).show();
                }
            } else {
                methods.clickLogin();
            }
        } else if (id == R.id.iv_max_equalizer) {
            Intent intent = new Intent(BaseActivity.this, EquilizerActivity.class);
            startActivity(intent);
        } else if (id == R.id.iv_music_share) {
            shareSong();
        } else if (id == R.id.iv_music_add2playlist) {
            if (!Constant.arrayList_play.isEmpty()) {
                methods.showBottomSheetAddToPlaylist(Constant.arrayList_play.get(viewpager.getCurrentItem()), Constant.isOnline);
            } else {
                Toast.makeText(BaseActivity.this, getResources().getString(R.string.err_no_songs_selected), Toast.LENGTH_SHORT).show();
            }
        } else if (id == R.id.iv_music_download) {
            if (methods.checkPerAudio(Constant.REQ_AUDIO_DOWNLOAD)) {
                if (!Constant.arrayList_play.isEmpty()) {
                    methods.showRewardAds(new RewardAdListener() {
                        @Override
                        public void onClick() {
                            methods.download(Constant.arrayList_play.get(viewpager.getCurrentItem()));
                        }
                    });
                } else {
                    Toast.makeText(BaseActivity.this, getString(R.string.err_no_songs_selected), Toast.LENGTH_SHORT).show();
                }
            }
        } else if (id == R.id.iv_music_rate) {
            if (!Constant.arrayList_play.isEmpty()) {
                openRateDialog();
            }
        } else if (id == R.id.iv_music_volume) {
            changeVolume();
        } else if (id == R.id.cv_music_sleepTime) {
            if (!sharedPref.getIsSleepTimeOn()) {
                sleepTimePermission();
            } else {
                openCancelTimerDialog();
            }
        }
    }

    public void showBottomSheetDialog(boolean isLyrics) {
        View view = getLayoutInflater().inflate(R.layout.layout_desc, null);

        dialog_desc = new BottomSheetDialog(this, R.style.BottomSheetDialogStyle);
        dialog_desc.setContentView(view);
        dialog_desc.show();

        WebView webview_song_desc = dialog_desc.findViewById(R.id.webView_bottom);
        TextView tv_desc = dialog_desc.findViewById(R.id.tv_desc_title);

        tv_desc.setText(isLyrics ? getString(R.string.lyrics) : getString(R.string.description));

        webview_song_desc.getSettings().setJavaScriptEnabled(true);
        String mimeType = "text/html;charset=UTF-8";
        String encoding = "utf-8";


        String text = "", content = "";
        if (isLyrics) {
            content = Constant.arrayList_play.get(Constant.playPos).getLyrics();
        } else {
            content = Constant.arrayList_play.get(Constant.playPos).getDescription();
        }
        if (Constant.arrayList_play.size() > Constant.playPos) {
            if (methods.isDarkMode()) {
                text = "<html><head>"
                        + "<style> body{color:#fff !important;text-align:left}"
                        + "</style></head>"
                        + "<body>"
                        + content
                        + "</body></html>";
            } else {
                text = "<html><head>"
                        + "<style> body{color:#000 !important;text-align:left}"
                        + "</style></head>"
                        + "<body>"
                        + content
                        + "</body></html>";
            }
        }
        webview_song_desc.setBackgroundColor(Color.TRANSPARENT);
        webview_song_desc.loadDataWithBaseURL("blarg://ignored", text, mimeType, encoding, "");
    }

    private final Runnable run = new Runnable() {
        @Override
        public void run() {
            seekUpdation();
        }
    };

    public void seekUpdation() {
        try {
            seekbar_min.setProgress(methods.getProgressPercentage(PlayerService.exoPlayer.getCurrentPosition(), PlayerService.getInstance().getDuration()));
            seekBar_music.setProgress(methods.getProgressPercentage(PlayerService.exoPlayer.getCurrentPosition(), PlayerService.getInstance().getDuration()));
            tv_current_time.setText(methods.milliSecondsToTimer(PlayerService.exoPlayer.getCurrentPosition(), PlayerService.getInstance().getDuration()));
            tv_total_time.setText(methods.milliSecondsToTimer(PlayerService.exoPlayer.getDuration(), PlayerService.getInstance().getDuration()));
            seekBar_music.setSecondaryProgress(PlayerService.exoPlayer.getBufferedPercentage());
            if (PlayerService.exoPlayer.getPlayWhenReady() && Constant.isAppOpen) {
                seekHandler.removeCallbacks(run);
                seekHandler.postDelayed(run, 1000);
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void playPause() {
        if (!Constant.arrayList_play.isEmpty()) {
            Intent intent = new Intent(BaseActivity.this, PlayerService.class);
            if (Constant.isPlayed) {
                intent.setAction(PlayerService.ACTION_TOGGLE);
                startService(intent);
            } else {
                if (!Constant.isOnline || methods.isNetworkAvailable()) {
                    intent.setAction(PlayerService.ACTION_PLAY);
                    startService(intent);
                } else {
                    Toast.makeText(BaseActivity.this, getResources().getString(R.string.err_internet_not_conn), Toast.LENGTH_SHORT).show();
                }
            }
        } else {
            Toast.makeText(BaseActivity.this, getResources().getString(R.string.err_no_songs_selected), Toast.LENGTH_SHORT).show();
        }
    }

    public void next() {
        if (!Constant.arrayList_play.isEmpty()) {
            if (!Constant.isOnline || methods.isNetworkAvailable()) {
                isRotateAnim = false;
                Intent intent = new Intent(BaseActivity.this, PlayerService.class);
                intent.setAction(PlayerService.ACTION_NEXT);
                startService(intent);
            } else {
                Toast.makeText(BaseActivity.this, getResources().getString(R.string.err_internet_not_conn), Toast.LENGTH_SHORT).show();
            }
        } else {
            Toast.makeText(BaseActivity.this, getResources().getString(R.string.err_no_songs_selected), Toast.LENGTH_SHORT).show();
        }
    }

    public void previous() {
        if (!Constant.arrayList_play.isEmpty()) {
            if (!Constant.isOnline || methods.isNetworkAvailable()) {
                isRotateAnim = false;
                Intent intent = new Intent(BaseActivity.this, PlayerService.class);
                intent.setAction(PlayerService.ACTION_PREVIOUS);
                startService(intent);
            } else {
                Toast.makeText(BaseActivity.this, getResources().getString(R.string.err_internet_not_conn), Toast.LENGTH_SHORT).show();
            }
        } else {
            Toast.makeText(BaseActivity.this, getResources().getString(R.string.err_no_songs_selected), Toast.LENGTH_SHORT).show();
        }
    }

    public void setRepeat() {
        if (Constant.isRepeat) {
            Constant.isRepeat = false;
            if (methods.isDarkMode()) {
                iv_music_repeat.setImageDrawable(getResources().getDrawable(R.drawable.ic_repeat));
            } else {
                iv_music_repeat.setImageDrawable(getResources().getDrawable(R.mipmap.ic_repeat));
            }
        } else {
            Constant.isRepeat = true;
            iv_music_repeat.setImageDrawable(getResources().getDrawable(R.mipmap.ic_repeat_hover));
        }
    }

    public void setShuffle() {
        if (Constant.isSuffle) {
            Constant.isSuffle = false;
            iv_music_shuffle.setColorFilter(ContextCompat.getColor(BaseActivity.this, R.color.grey_dark));
        } else {
            Constant.isSuffle = true;
            iv_music_shuffle.setColorFilter(ContextCompat.getColor(BaseActivity.this, R.color.primary));
        }
    }

    private void shareSong() {
        if (!Constant.arrayList_play.isEmpty()) {

            if (Constant.isOnline || Constant.isDownloaded) {
                Intent sharingIntent = new Intent(android.content.Intent.ACTION_SEND);
                sharingIntent.setType("text/plain");
                sharingIntent.putExtra(android.content.Intent.EXTRA_SUBJECT, getResources().getString(R.string.share_song));
                sharingIntent.putExtra(android.content.Intent.EXTRA_TEXT, getResources().getString(R.string.listening) + " - " + Constant.arrayList_play.get(viewpager.getCurrentItem()).getTitle() + "\n\nvia " + getResources().getString(R.string.app_name) + " - http://play.google.com/store/apps/details?id=" + getPackageName());
                startActivity(Intent.createChooser(sharingIntent, getResources().getString(R.string.share_song)));
            } else {
                if (methods.checkPerAudio(Constant.REQ_AUDIO_SHARE)) {
                    Intent share = new Intent(Intent.ACTION_SEND);
                    share.setType("audio/mp3");
                    share.putExtra(Intent.EXTRA_STREAM, Uri.parse(Constant.arrayList_play.get(viewpager.getCurrentItem()).getUrl()));
                    share.putExtra(android.content.Intent.EXTRA_TEXT, getResources().getString(R.string.listening) + " - " + Constant.arrayList_play.get(viewpager.getCurrentItem()).getTitle() + "\n\nvia " + getResources().getString(R.string.app_name) + " - http://play.google.com/store/apps/details?id=" + getPackageName());
                    startActivity(Intent.createChooser(share, getResources().getString(R.string.share_song)));
                }
            }
        } else {
            Toast.makeText(BaseActivity.this, getResources().getString(R.string.err_no_songs_selected), Toast.LENGTH_SHORT).show();
        }
    }

    private void loadFav(String qid, final int posi) {
        if (methods.isNetworkAvailable()) {
            LoadFav loadFav = new LoadFav(new SuccessListener() {
                @Override
                public void onStart() {

                }

                @Override
                public void onEnd(String success, String favSuccess, String message) {
                    if (success.equals("1")) {
                        if (favSuccess.equals("1")) {
                            Constant.arrayList_play.get(posi).setIsFavourite(true);
                        } else if (favSuccess.equals("-2")) {
                            methods.getInvalidUserDialog(message);
                        } else {
                            Constant.arrayList_play.get(posi).setIsFavourite(false);
                        }
                        if (Constant.addedFrom.equals("fav")) {
                            Constant.addedFrom = "";
                        }
                        changeFav(Constant.arrayList_play.get(posi).getIsFavourite());
                        Toast.makeText(BaseActivity.this, message, Toast.LENGTH_SHORT).show();
                    }
                }
            }, methods.getAPIRequest(Constant.METHOD_SONG_FAVOURITE, 0, "", qid, "", "", "", "", "", "", "", "", "", "", "", sharedPref.getUserID(), "", null));
            loadFav.execute(Constant.METHOD_SONG_FAVOURITE);
        } else {
            Toast.makeText(this, getString(R.string.err_internet_not_conn), Toast.LENGTH_SHORT).show();
        }
    }

    public void fav() {
        loadFav(Constant.arrayList_play.get(Constant.playPos).getId(), Constant.playPos);
    }

    public void changeFav(Boolean isFav) {
        if (isFav) {
            iv_max_fav.setImageDrawable(getResources().getDrawable(R.mipmap.ic_fav_hover));
        } else {
            iv_max_fav.setImageDrawable(getResources().getDrawable(R.mipmap.ic_fav));
        }
    }

    private void openRateDialog() {
        View view = getLayoutInflater().inflate(R.layout.layout_bottomsheet_rate, null);

        dialog_rate = new BottomSheetDialog(BaseActivity.this);
        dialog_rate.setContentView(view);
        dialog_rate.getWindow().findViewById(R.id.design_bottom_sheet).setBackgroundResource(android.R.color.transparent);
        dialog_rate.show();

        ConstraintLayout cl_add_playlist = dialog_rate.findViewById(R.id.cl_add_playlist);
        final RatingBar ratingBar = dialog_rate.findViewById(R.id.rb_add);
        MaterialButton button_add = dialog_rate.findViewById(R.id.button_submit_rating);
        MaterialButton button_cancel = dialog_rate.findViewById(R.id.button_later_rating);
        final TextView textView = dialog_rate.findViewById(R.id.tv_rate);

        cl_add_playlist.setBackground(methods.getDrawableWithCornerRadius(ContextCompat.getColor(BaseActivity.this, R.color.bg_bottom_sheet),
                30f, 30f, 0, 0));

        ratingBar.setStepSize(Float.parseFloat("1"));

        if (Constant.arrayList_play.get(viewpager.getCurrentItem()).getUserRating().equals("") || Constant.arrayList_play.get(viewpager.getCurrentItem()).getUserRating().equals("0")) {
            new GetRating(new RatingListener() {
                @Override
                public void onStart() {

                }

                @Override
                public void onEnd(String success, String isRateSuccess, String message, int rating) {
                    if (rating > 0) {
                        ratingBar.setRating(rating);
                        textView.setText(getString(R.string.thanks_for_rating));
                    } else {
                        ratingBar.setRating(1);
                    }
                    Constant.arrayList_play.get(viewpager.getCurrentItem()).setUserRating(String.valueOf(rating));

                }
            }, methods.getAPIRequest(Constant.METHOD_SONG_DETAIL, 0, "", Constant.arrayList_play.get(viewpager.getCurrentItem()).getId(), "", "", "", "", "", "", "", "", "", "", "", sharedPref.getUserID(), "", null)).execute(Constant.METHOD_SONG_DETAIL);
        } else {
            if (Integer.parseInt(Constant.arrayList_play.get(viewpager.getCurrentItem()).getUserRating()) != 0 && !Constant.arrayList_play.get(viewpager.getCurrentItem()).getUserRating().equals("")) {
                textView.setText(getString(R.string.thanks_for_rating));
                ratingBar.setRating(Integer.parseInt(Constant.arrayList_play.get(viewpager.getCurrentItem()).getUserRating()));
            } else {
                ratingBar.setRating(1);
            }
        }

        button_add.setOnClickListener(v -> {
            if (sharedPref.isLogged()) {
                if (ratingBar.getRating() != 0) {
                    if (methods.isNetworkAvailable()) {
                        loadRatingApi(String.valueOf((int) ratingBar.getRating()));
                    } else {
                        Toast.makeText(BaseActivity.this, getString(R.string.err_internet_not_conn), Toast.LENGTH_SHORT).show();
                    }
                } else {
                    Toast.makeText(BaseActivity.this, getString(R.string.select_rating), Toast.LENGTH_SHORT).show();
                }
            } else {
                methods.clickLogin();
            }
        });

        button_cancel.setOnClickListener(v -> {
            dialog_rate.dismiss();
        });
    }

    private void loadRatingApi(final String rate) {
        String deviceId = Settings.Secure.getString(getContentResolver(), Settings.Secure.ANDROID_ID);

        final ProgressDialog progressDialog;
        progressDialog = new ProgressDialog(BaseActivity.this);
        progressDialog.setMessage(getResources().getString(R.string.loading));

        LoadRating loadRating = new LoadRating(new RatingListener() {
            @Override
            public void onStart() {
                progressDialog.show();
            }

            @Override
            public void onEnd(String success, String isRateSuccess, String message, int rating) {
                if (progressDialog.isShowing()) {
                    progressDialog.dismiss();
                }
                if (success.equals("1")) {
                    if (isRateSuccess.equals("1")) {
                        Constant.arrayList_play.get(viewpager.getCurrentItem()).setAverageRating(String.valueOf(rating));
                        Constant.arrayList_play.get(viewpager.getCurrentItem()).setUserRating(String.valueOf(rate));
                        ratingBar.setRating(rating);
                    }
                    Toast.makeText(BaseActivity.this, message, Toast.LENGTH_SHORT).show();
                } else {
                    Toast.makeText(BaseActivity.this, getResources().getString(R.string.server_error), Toast.LENGTH_SHORT).show();
                }
                dialog_rate.dismiss();
            }
        }, methods.getAPIRequest(Constant.METHOD_SONG_RATE, 0, "", Constant.arrayList_play.get(viewpager.getCurrentItem()).getId(), "", "", "", "", "", "", rate, "", "", "", "", sharedPref.getUserID(), "", null));
        loadRating.execute(Constant.METHOD_SONG_RATE);
    }

    private void changeVolume() {

        final RelativePopupWindow popupWindow = new RelativePopupWindow(this);

        // inflate your layout or dynamically add view
        LayoutInflater inflater = (LayoutInflater) getSystemService(Context.LAYOUT_INFLATER_SERVICE);

        View view = inflater.inflate(R.layout.layout_dailog_volume, null);
        ImageView imageView1 = view.findViewById(R.id.iv1);
        ImageView imageView2 = view.findViewById(R.id.iv2);
        imageView1.setColorFilter(ContextCompat.getColor(BaseActivity.this, R.color.black));
        imageView2.setColorFilter(ContextCompat.getColor(BaseActivity.this, R.color.black));

        VerticalSeekBar seekBar = view.findViewById(R.id.seekbar_volume);
        seekBar.getThumb().setColorFilter(ContextCompat.getColor(BaseActivity.this, R.color.colorAccent), PorterDuff.Mode.SRC_IN);
        seekBar.getProgressDrawable().setColorFilter(ContextCompat.getColor(BaseActivity.this, R.color.colorPrimary), PorterDuff.Mode.SRC_IN);

        final AudioManager am = (AudioManager) getSystemService(Context.AUDIO_SERVICE);
        seekBar.setMax(am.getStreamMaxVolume(AudioManager.STREAM_MUSIC));
        int volume_level = am.getStreamVolume(AudioManager.STREAM_MUSIC);
        seekBar.setProgress(volume_level);
        seekBar.setOnSeekBarChangeListener(new SeekBar.OnSeekBarChangeListener() {
            @Override
            public void onProgressChanged(SeekBar seekBar, int i, boolean b) {
                am.setStreamVolume(AudioManager.STREAM_MUSIC, i, 0);
            }

            @Override
            public void onStartTrackingTouch(SeekBar seekBar) {

            }

            @Override
            public void onStopTrackingTouch(SeekBar seekBar) {

            }
        });

        popupWindow.setFocusable(true);
        popupWindow.setWidth(WindowManager.LayoutParams.WRAP_CONTENT);
        popupWindow.setHeight(WindowManager.LayoutParams.WRAP_CONTENT);
        popupWindow.setBackgroundDrawable(new ColorDrawable(android.graphics.Color.TRANSPARENT));
        popupWindow.setContentView(view);
        popupWindow.showOnAnchor(iv_music_volume, RelativePopupWindow.VerticalPosition.ABOVE, RelativePopupWindow.HorizontalPosition.CENTER);
    }

    public void newRotateAnim() {
        if (rotateAnimation != null) {
            rotateAnimation.cancel();
        }
        rotateAnimation = new PausableRotateAnimation(0, 360, Animation.RELATIVE_TO_SELF, 0.5f, Animation.RELATIVE_TO_SELF, 0.5f);
        rotateAnimation.setDuration(Constant.rotateSpeed);
        rotateAnimation.setRepeatCount(Animation.INFINITE);
        rotateAnimation.setInterpolator(new LinearInterpolator());
    }

    public void changeImageAnimation(Boolean isPlay) {
        try {
            if (!isPlay) {
                rotateAnimation.pause();
            } else {
                if (!isRotateAnim) {
                    isRotateAnim = true;
                    if (imageView_pager != null) {
                        imageView_pager.setAnimation(null);
                    }
                    View view_pager = viewpager.findViewWithTag("myview" + Constant.playPos);
                    newRotateAnim();
                    imageView_pager = view_pager.findViewById(R.id.image);
                    imageView_pager.startAnimation(rotateAnimation);
                } else {
                    rotateAnimation.resume();
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void changeTextPager(ItemSong itemSong) {
        ratingBar.setRating(Integer.parseInt(itemSong.getAverageRating()));

        tv_music_artist.setText(itemSong.getArtist());
        tv_music_title.setText(itemSong.getTitle());
        tv_song_count.setText((viewpager.getCurrentItem() + 1) + "/" + Constant.arrayList_play.size());
    }

    public void changeText(final ItemSong itemSong, final String page) {

        tv_min_title.setText(itemSong.getTitle());
        tv_min_artist.setText(itemSong.getArtist());

        tv_max_title.setText(itemSong.getTitle());
        tv_max_artist.setText(itemSong.getArtist());

        ratingBar.setRating(Integer.parseInt(itemSong.getAverageRating()));
        tv_music_title.setText(itemSong.getTitle());
        tv_music_artist.setText(itemSong.getArtist());

        tv_song_count.setText(Constant.playPos + 1 + "/" + Constant.arrayList_play.size());

        changeFav(itemSong.getIsFavourite());

        if (Constant.isOnline) {

            Picasso.get()
                    .load(itemSong.getImageBig())
                    .resize(300, 300)
                    .placeholder(R.drawable.placeholder_song)
                    .into(iv_min_song);

            Picasso.get()
                    .load(itemSong.getImageBig())
                    .resize(300, 300)
                    .placeholder(R.drawable.placeholder_song)
                    .into(iv_max_song);

            if (ratingBar.getVisibility() == View.GONE) {
                ratingBar.setVisibility(View.VISIBLE);
                iv_max_fav.setVisibility(View.VISIBLE);

                iv_music_rate.setVisibility(View.VISIBLE);
                view_rate.setVisibility(View.VISIBLE);
                iv_music_add2playlist.setVisibility(View.VISIBLE);
            }

            if (Constant.isSongDownload) {
                iv_music_download.setVisibility(View.VISIBLE);
                view_download.setVisibility(View.VISIBLE);
            } else {
                iv_music_download.setVisibility(View.GONE);
                view_download.setVisibility(View.GONE);
            }
        } else {
            if (Constant.isDownloaded) {
                iv_music_add2playlist.setVisibility(View.GONE);
            } else {
                iv_music_add2playlist.setVisibility(View.VISIBLE);
            }
            Picasso.get()
                    .load(Uri.parse(itemSong.getImageBig()))
                    .resize(300, 300)
                    .placeholder(R.drawable.placeholder_song)
                    .into(iv_min_song);

            Picasso.get()
                    .load(Uri.parse(itemSong.getImageBig()))
                    .resize(300, 300)
                    .placeholder(R.drawable.placeholder_song)
                    .into(iv_max_song);

            if (ratingBar.getVisibility() == View.VISIBLE) {
                ratingBar.setVisibility(View.GONE);
                iv_max_fav.setVisibility(View.GONE);

                iv_music_rate.setVisibility(View.GONE);
                view_rate.setVisibility(View.GONE);

                iv_music_download.setVisibility(View.GONE);
                view_download.setVisibility(View.GONE);
            }
        }

        if (viewpager.getAdapter() == null || Constant.isNewAdded || !Constant.addedFrom.equals(adapter.getIsLoadedFrom())) {
            viewpager.setAdapter(adapter);
            Constant.isNewAdded = false;
        }
        try {
            viewpager.setCurrentItem(Constant.playPos);
        } catch (Exception e) {
            adapter.notifyDataSetChanged();
            viewpager.setCurrentItem(Constant.playPos);
        }
    }

    public void changePlayPauseIcon(Boolean isPlay) {
        if (!isPlay) {
            iv_music_play.setImageDrawable(getResources().getDrawable(R.drawable.play));
            iv_min_play.setImageDrawable(getResources().getDrawable(R.mipmap.ic_play_grey));
        } else {
            iv_music_play.setImageDrawable(getResources().getDrawable(R.drawable.pause));
            iv_min_play.setImageDrawable(getResources().getDrawable(R.mipmap.ic_pause_grey));
        }
        seekUpdation();
    }

    public void isBuffering(Boolean isBuffer) {
        if (isBuffer) {
            rl_music_loading.setVisibility(View.VISIBLE);
            iv_music_play.setVisibility(View.INVISIBLE);
        } else {
            rl_music_loading.setVisibility(View.INVISIBLE);
            iv_music_play.setVisibility(View.VISIBLE);
            changePlayPauseIcon(!isBuffer);
//            seekUpdation();
        }
        iv_music_next.setEnabled(!isBuffer);
        iv_music_previous.setEnabled(!isBuffer);
        iv_min_next.setEnabled(!isBuffer);
//        iv_min_previous.setEnabled(!isBuffer);
        iv_music_download.setEnabled(!isBuffer);
        iv_min_play.setEnabled(!isBuffer);
        seekBar_music.setEnabled(!isBuffer);
    }

    private class ImagePagerAdapter extends PagerAdapter {

        private final LayoutInflater inflater;
        private String loadedPage = "";

        private ImagePagerAdapter() {
            inflater = getLayoutInflater();
        }

        @Override
        public int getCount() {
            return Constant.arrayList_play.size();
        }

        @Override
        public boolean isViewFromObject(@NonNull View view, @NonNull Object object) {
            return view.equals(object);
        }

        String getIsLoadedFrom() {
            return loadedPage;
        }

        @NonNull
        @Override
        public Object instantiateItem(@NonNull ViewGroup container, int position) {

            View imageLayout = inflater.inflate(R.layout.layout_viewpager, container, false);
            assert imageLayout != null;
            RoundedImageView imageView = imageLayout.findViewById(R.id.image);
            final ImageView imageView_play = imageLayout.findViewById(R.id.iv_vp_play);
            final ProgressBar spinner = imageLayout.findViewById(R.id.loading);

            loadedPage = Constant.addedFrom;

            if (Constant.playPos == position) {
                imageView_play.setVisibility(View.GONE);
            }

            if (Constant.isOnline) {
                Picasso.get()
                        .load(Constant.arrayList_play.get(position).getImageBig())
                        .resize(300, 300)
                        .placeholder(R.drawable.cd)
                        .into(imageView, new Callback() {
                            @Override
                            public void onSuccess() {
                                spinner.setVisibility(View.GONE);
                            }

                            @Override
                            public void onError(Exception e) {
                                spinner.setVisibility(View.GONE);
                            }
                        });
            } else {
                Picasso.get()
                        .load(Uri.parse(Constant.arrayList_play.get(position).getImageBig()))
                        .resize(300, 300)
                        .placeholder(R.drawable.placeholder_song)
                        .into(imageView);
                spinner.setVisibility(View.GONE);
            }

            imageView_play.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View v) {
                    Constant.playPos = viewpager.getCurrentItem();
                    isRotateAnim = false;
                    if (!Constant.isOnline || methods.isNetworkAvailable()) {
                        Intent intent = new Intent(BaseActivity.this, PlayerService.class);
                        intent.setAction(PlayerService.ACTION_PLAY);
                        startService(intent);
                        imageView_play.setVisibility(View.GONE);
                    } else {
                        Toast.makeText(BaseActivity.this, getResources().getString(R.string.err_internet_not_conn), Toast.LENGTH_SHORT).show();
                    }
                }
            });

            if (position == 0) {
                isRotateAnim = false;
                imageView_pager = imageView;
            }

            imageLayout.setTag("myview" + position);
            container.addView(imageLayout, 0);
            return imageLayout;

        }

        @Override
        public void destroyItem(@NonNull ViewGroup container, int position, @NonNull Object object) {
            container.removeView((View) object);
        }
    }

    private void openOptionPopUp() {
        View view = getLayoutInflater().inflate(R.layout.layout_bottomsheet_optons, null);

        BottomSheetDialog dialog = new BottomSheetDialog(BaseActivity.this);
        dialog.setContentView(view);
        dialog.getWindow().findViewById(R.id.design_bottom_sheet).setBackgroundResource(android.R.color.transparent);
        dialog.show();

        TextView tv_lyrics = dialog.findViewById(R.id.tv_option_lyrics);
        TextView tv_desc = dialog.findViewById(R.id.tv_option_desc);
        TextView tv_report = dialog.findViewById(R.id.tv_option_report);

        if (!Constant.isOnline) {
            tv_report.setVisibility(View.GONE);
            dialog.findViewById(R.id.iv_option_report).setVisibility(View.GONE);
        }

        tv_lyrics.setOnClickListener(view1 -> {
            if (!Constant.arrayList_play.isEmpty()) {
                dialog.dismiss();
                showBottomSheetDialog(true);
            }
        });

        tv_desc.setOnClickListener(view1 -> {
            if (!Constant.arrayList_play.isEmpty()) {
                dialog.dismiss();
                showBottomSheetDialog(false);
            }
        });

        tv_report.setOnClickListener(view1 -> {
            dialog.dismiss();
            Intent intent = new Intent(BaseActivity.this, ReportActivity.class);
            startActivity(intent);
        });
    }

    private void sleepTimePermission() {
        AlarmManager alarmManager = (AlarmManager) getSystemService(ALARM_SERVICE);
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.S) {
            if(alarmManager.canScheduleExactAlarms()) {
                sleepTime(alarmManager);
            } else {
                Intent intent = new Intent(ACTION_REQUEST_SCHEDULE_EXACT_ALARM);
                startActivity(intent);
            }
        } else {
            sleepTime(alarmManager);
        }
    }

    private void sleepTime(AlarmManager alarmManager) {
        TimePickerDialog timePickerDialog = new TimePickerDialog(
                BaseActivity.this,
                (timePicker, hourOfDay, minute) -> {
                    long totalTimeInMillis = ((hourOfDay * 60L + minute) * 60 * 1000) + System.currentTimeMillis();

                    if(totalTimeInMillis > System.currentTimeMillis()) {
                        Random random = new Random();
                        int id = random.nextInt(100);

                        sharedPref.setSleepTime(true, totalTimeInMillis, id);

                        Intent intent = new Intent(BaseActivity.this, SleepTimerReceiver.class);
                        PendingIntent pendingIntent = PendingIntent.getBroadcast(BaseActivity.this, id, intent, PendingIntent.FLAG_IMMUTABLE);
                        alarmManager.setExact(AlarmManager.RTC_WAKEUP, totalTimeInMillis, pendingIntent);

                        updateTimer(totalTimeInMillis);
                    } else {
                        Toast.makeText(BaseActivity.this, getString(R.string.min_sleeptime), Toast.LENGTH_SHORT).show();
                    }
                },
                0, // Initial hour
                0,
                true);
        timePickerDialog.setTitle("Set Sleep Time");

        timePickerDialog.show();
    }

    private void updateTimer(final long time) {
        tv_sleepTime.setVisibility(View.VISIBLE);
        countDownTimer = new CountDownTimer(time - System.currentTimeMillis(), 1000) {

            @Override
            public void onTick(long timeLeft) {
                @SuppressLint("DefaultLocale") String hms = String.format("%02d:%02d:%02d", TimeUnit.MILLISECONDS.toHours(timeLeft),
                        TimeUnit.MILLISECONDS.toMinutes(timeLeft) % TimeUnit.HOURS.toMinutes(1),
                        TimeUnit.MILLISECONDS.toSeconds(timeLeft) % TimeUnit.MINUTES.toSeconds(1));
                tv_sleepTime.setText(hms);
                cv_music_sleepTime.setCardBackgroundColor(ContextCompat.getColor(BaseActivity.this, R.color.red));
            }

            @Override
            public void onFinish() {
                cv_music_sleepTime.setCardBackgroundColor(ContextCompat.getColor(BaseActivity.this, R.color.primary));
                tv_sleepTime.setVisibility(View.GONE);
            }
        }.start();
    }

    private void openCancelTimerDialog() {
        View view = getLayoutInflater().inflate(R.layout.layout_bottom_logout, null);

        BottomSheetDialog dialog = new BottomSheetDialog(BaseActivity.this);
        dialog.setContentView(view);
        dialog.getWindow().findViewById(R.id.design_bottom_sheet).setBackgroundResource(android.R.color.transparent);
        dialog.show();

        MaterialButton btn_stop = dialog.findViewById(R.id.btn_bottom_logout);
        MaterialButton btn_cancel = dialog.findViewById(R.id.btn_bottom_cancel);
        TextView tv1 = dialog.findViewById(R.id.tv1);
        TextView tv2 = dialog.findViewById(R.id.tv2);

        btn_stop.setText(getString(R.string.stop));
        tv1.setText(getString(R.string.cancel_timer));
        tv2.setText(getString(R.string.sure_cancel_timer));

        btn_stop.setOnClickListener(view1 -> {
            dialog.dismiss();

            Intent intent = new Intent(BaseActivity.this, SleepTimerReceiver.class);
            PendingIntent pendingIntent = PendingIntent.getBroadcast(BaseActivity.this, sharedPref.getSleepID(), intent, PendingIntent.FLAG_IMMUTABLE);
            AlarmManager alarmManager = (AlarmManager) getSystemService(Context.ALARM_SERVICE);
            pendingIntent.cancel();
            alarmManager.cancel(pendingIntent);
            sharedPref.setSleepTime(false, 0, 0);

            countDownTimer.cancel();
            tv_sleepTime.setVisibility(View.GONE);
            cv_music_sleepTime.setCardBackgroundColor(ContextCompat.getColor(BaseActivity.this, R.color.primary));
        });

        btn_cancel.setOnClickListener(view1 -> dialog.dismiss());
    }

    @Subscribe(sticky = true, threadMode = ThreadMode.MAIN)
    public void onSongChange(ItemSong itemSong) {
        changeText(itemSong, "home");
        Constant.context = BaseActivity.this;
        changeImageAnimation(PlayerService.getInstance().getIsPlayling());
//        GlobalBus.getBus().removeStickyEvent(itemSong);
    }

    @Subscribe(sticky = true, threadMode = ThreadMode.MAIN)
    public void onLogout(EventLogout eventLogout) {
        if(!sharedPref.getUserSession().equals("") || sharedPref.isLogged()) {
            methods.openBottomSheetForcedLogout(sharedPref);
        }
        GlobalBus.getBus().removeStickyEvent(eventLogout);
    }

    @Subscribe(sticky = true, threadMode = ThreadMode.MAIN)
    public void onBufferChange(MessageEvent messageEvent) {
        if (messageEvent.message.equals("buffer")) {
            isBuffering(messageEvent.flag);
        } else {
            changePlayPauseIcon(messageEvent.flag);
        }
    }

    @Subscribe(sticky = true, threadMode = ThreadMode.MAIN)
    public void onViewPagerChanged(ItemMyPlayList itemMyPlayList) {
        adapter.notifyDataSetChanged();
        tv_song_count.setText(Constant.playPos + 1 + "/" + Constant.arrayList_play.size());
        GlobalBus.getBus().removeStickyEvent(itemMyPlayList);
    }

    @Override
    public void onStart() {
        super.onStart();
        GlobalBus.getBus().register(this);
    }

    @Override
    public void onStop() {
        GlobalBus.getBus().unregister(this);
        super.onStop();
    }

    @Override
    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        boolean canUseExternalStorage = false;

        if (requestCode == Constant.REQ_AUDIO_DOWNLOAD) {
            if (grantResults.length > 0 && grantResults[0] == PackageManager.PERMISSION_GRANTED) {
                canUseExternalStorage = true;

                if (!Constant.arrayList_play.isEmpty()) {
                    methods.showRewardAds(new RewardAdListener() {
                        @Override
                        public void onClick() {
                            methods.download(Constant.arrayList_play.get(viewpager.getCurrentItem()));
                        }
                    });
                } else {
                    Toast.makeText(BaseActivity.this, getString(R.string.err_no_songs_selected), Toast.LENGTH_SHORT).show();
                }
            }

            if (!canUseExternalStorage) {
                Toast.makeText(BaseActivity.this, getResources().getString(R.string.err_cannot_use_features), Toast.LENGTH_SHORT).show();
            }
        } else if (requestCode == Constant.REQ_AUDIO_SHARE) {
            if (grantResults.length > 0 && grantResults[0] == PackageManager.PERMISSION_GRANTED) {
                canUseExternalStorage = true;

                Intent share = new Intent(Intent.ACTION_SEND);
                share.setType("audio/mp3");
                share.putExtra(Intent.EXTRA_STREAM, Uri.parse(Constant.arrayList_play.get(viewpager.getCurrentItem()).getUrl()));
                share.putExtra(android.content.Intent.EXTRA_TEXT, getResources().getString(R.string.listening) + " - " + Constant.arrayList_play.get(viewpager.getCurrentItem()).getTitle() + "\n\nvia " + getResources().getString(R.string.app_name) + " - http://play.google.com/store/apps/details?id=" + getPackageName());
                startActivity(Intent.createChooser(share, getResources().getString(R.string.share_song)));
            }

            if (!canUseExternalStorage) {
                Toast.makeText(BaseActivity.this, getResources().getString(R.string.err_cannot_use_features), Toast.LENGTH_SHORT).show();
            }
        }
        super.onRequestPermissionsResult(requestCode, permissions, grantResults);
    }

    @Override
    protected void onPause() {
        seekHandler.removeCallbacks(run);
        super.onPause();
    }

    @Override
    protected void onDestroy() {
        try {
            dbHelper.close();
        } catch (Exception e) {
            e.printStackTrace();
        }
        super.onDestroy();
    }
}