package com.vpapps.onlinemp3;

import android.graphics.Color;
import android.os.Bundle;
import android.view.MenuItem;

import com.bullhead.equalizer.EqualizerFragment;

import androidx.appcompat.app.AppCompatActivity;

public class EquilizerActivity extends AppCompatActivity {

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_equilizer);

        loadEqualizerSettings();

        int sessionId = PlayerService.getInstance().getAudioSessionID();
        EqualizerFragment equalizerFragment = EqualizerFragment.newBuilder()
                .setAccentColor(Color.parseColor("#4caf50"))
                .setAudioSessionId(sessionId)
                .build();
        getSupportFragmentManager().beginTransaction()
                .replace(R.id.eqFrame, equalizerFragment)
                .commit();


    }

    @Override
    public boolean onOptionsItemSelected(MenuItem menuItem) {
        switch (menuItem.getItemId()) {
            case android.R.id.home:
                onBackPressed();
                break;

            default:
                return super.onOptionsItemSelected(menuItem);
        }
        return true;
    }

    private void saveEqualizerSettings(){
//        if (Settings.equalizerModel != null){
//            EqualizerSettings settings = new EqualizerSettings();
//            settings.bassStrength = Settings.equalizerModel.getBassStrength();
//            settings.presetPos = Settings.equalizerModel.getPresetPos();
//            settings.reverbPreset = Settings.equalizerModel.getReverbPreset();
//            settings.seekbarpos = Settings.equalizerModel.getSeekbarpos();
//
//            SharedPreferences preferences = PreferenceManager.getDefaultSharedPreferences(this);
//
//            Gson gson = new Gson();
//            preferences.edit()
//                    .putString("equalizer", gson.toJson(settings))
//                    .apply();
//        }
    }

    private void loadEqualizerSettings(){
//        SharedPreferences preferences = PreferenceManager.getDefaultSharedPreferences(this);
//
//        Gson gson = new Gson();
//        EqualizerSettings settings = gson.fromJson(preferences.getString("equalizer", "{}"), EqualizerSettings.class);
//        EqualizerModel model = new EqualizerModel();
//        model.setBassStrength(settings.bassStrength);
//        model.setPresetPos(settings.presetPos);
//        model.setReverbPreset(settings.reverbPreset);
//        model.setSeekbarpos(settings.seekbarpos);
//
//        Settings.isEqualizerEnabled = true;
//        Settings.isEqualizerReloaded = true;
//        Settings.bassStrength = settings.bassStrength;
//        Settings.presetPos = settings.presetPos;
//        Settings.reverbPreset = settings.reverbPreset;
//        Settings.seekbarpos = settings.seekbarpos;
//        Settings.equalizerModel = model;
    }

    @Override
    protected void onStop() {

        saveEqualizerSettings();

        super.onStop();
    }
}