package com.vpapps.onlinemp3;

import android.app.ProgressDialog;
import android.content.Intent;
import android.os.Build;
import android.os.Bundle;
import android.view.MenuItem;
import android.view.View;
import android.widget.TextView;
import android.widget.Toast;

import androidx.appcompat.app.AppCompatActivity;
import androidx.appcompat.widget.Toolbar;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;

import com.google.android.material.bottomsheet.BottomSheetDialog;
import com.google.android.material.button.MaterialButton;
import com.vpapps.adapter.AdapterLoggedDevice;
import com.vpapps.asyncTask.LoadLoggedDevice;
import com.vpapps.asyncTask.LoadLogout;
import com.vpapps.interfaces.ClickListenerCallback;
import com.vpapps.interfaces.LoggedDeviceListener;
import com.vpapps.item.ItemLoggedDevice;
import com.vpapps.utils.Constant;
import com.vpapps.utils.Methods;
import com.vpapps.utils.SharedPref;

import java.util.ArrayList;

import fr.castorflex.android.circularprogressbar.CircularProgressBar;

public class LoggedDevicesActivity extends AppCompatActivity {

    Toolbar toolbar;
    Methods methods;
    SharedPref sharedPref;
    RecyclerView rv_devices;
    AdapterLoggedDevice adapterLoggedDevice;
    ArrayList<ItemLoggedDevice> arrayList = new ArrayList<>();
    MaterialButton btn_logout_this_device;
    TextView tv_this_device;
    CircularProgressBar progressBar;
    boolean isFromApp = false;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_logged_devices);

        isFromApp = getIntent().getBooleanExtra("isFromApp", false);

        sharedPref = new SharedPref(LoggedDevicesActivity.this);
        methods = new Methods(this);
        methods.forceRTLIfSupported(getWindow());
        methods.setStatusColorDark(getWindow());

        toolbar = this.findViewById(R.id.toolbar_logged_device);
        toolbar.setTitle(getString(R.string.logged_devices));
        this.setSupportActionBar(toolbar);
        getSupportActionBar().setDisplayHomeAsUpEnabled(true);

        rv_devices = findViewById(R.id.rv_logged_devices);
        btn_logout_this_device = findViewById(R.id.btn_this_device_logout);
        tv_this_device = findViewById(R.id.tv_device_name_this);
        progressBar = findViewById(R.id.pb_devices);

        rv_devices.setLayoutManager(new LinearLayoutManager(LoggedDevicesActivity.this));

        methods.showBannerAd(findViewById(R.id.ll_adView));

        tv_this_device.setText(Build.BRAND + " " + Build.MODEL);

        btn_logout_this_device.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                methods.loadLogout(sharedPref);
            }
        });

        loadLoggedDevices();
    }

    @Override
    public boolean onOptionsItemSelected(MenuItem menuItem) {
        if (menuItem.getItemId() == android.R.id.home) {
            onBackPressed();
        } else {
            return super.onOptionsItemSelected(menuItem);
        }
        return true;
    }

    public void loadLoggedDevices() {
        if (methods.isNetworkAvailable()) {
            LoadLoggedDevice loadLoggedDevice = new LoadLoggedDevice(new LoggedDeviceListener() {
                @Override
                public void onStart() {
                    progressBar.setVisibility(View.VISIBLE);
                }

                @Override
                public void onEnd(String success, String verifyStatus, String message, ArrayList<ItemLoggedDevice> arrayListLoggedDevice) {
                    progressBar.setVisibility(View.GONE);
                    if (success.equals("1")) {

                        arrayList.addAll(arrayListLoggedDevice);
                        setAdapter();
                    }
                }
            }, methods.getAPIRequest(Constant.METHOD_USER_ACTIVE_DEVICE_LIST, 0, "", "", "", "", "", "", "", "", "", "", "", "", "", new SharedPref(LoggedDevicesActivity.this).getUserID(), "", null));
            loadLoggedDevice.doWork(Constant.METHOD_USER_ACTIVE_DEVICE_LIST, sharedPref.getUserSession());
        } else {
            Toast.makeText(LoggedDevicesActivity.this, getString(R.string.err_internet_not_conn), Toast.LENGTH_SHORT).show();
        }
    }

    private void setAdapter() {
        adapterLoggedDevice = new AdapterLoggedDevice(LoggedDevicesActivity.this, arrayList, new ClickListenerCallback() {
            @Override
            public void onClick(int position) {
                loadLogout(arrayList.get(position).getSessionID(), arrayList.get(position).getUserID(), position);
            }

            @Override
            public void onItemZero() {

            }
        });
        rv_devices.setAdapter(adapterLoggedDevice);
        setEmpty();
    }

    public void setEmpty() {
        if (!arrayList.isEmpty()) {
            findViewById(R.id.tv2).setVisibility(View.VISIBLE);
            rv_devices.setVisibility(View.VISIBLE);
//            frameLayout.setVisibility(View.GONE);
        } else {
            findViewById(R.id.tv2).setVisibility(View.GONE);
            rv_devices.setVisibility(View.GONE);
//            frameLayout.setVisibility(View.VISIBLE);
//
//            frameLayout.removeAllViews();
//            LayoutInflater inflater = (LayoutInflater) getSystemService(Context.LAYOUT_INFLATER_SERVICE);
//
//            View myView = null;
//            if (errr_msg.equals(getString(R.string.err_no_songs_found))) {
//                myView = inflater.inflate(R.layout.layout_err_nodata, null);
//            } else if (errr_msg.equals(getString(R.string.err_internet_not_conn))) {
//                myView = inflater.inflate(R.layout.layout_err_internet, null);
//            } else if (errr_msg.equals(getString(R.string.err_server))) {
//                myView = inflater.inflate(R.layout.layout_err_server, null);
//            }
//
//            TextView textView = myView.findViewById(R.id.tv_empty_msg);
//            textView.setText(errr_msg);
//
//            myView.findViewById(R.id.btn_empty_try).setOnClickListener(new View.OnClickListener() {
//                @Override
//                public void onClick(View v) {
//                    loadSongs();
//                }
//            });
//
//            myView.findViewById(R.id.btn_empty_downloads).setOnClickListener(new View.OnClickListener() {
//                @Override
//                public void onClick(View v) {
//                    Intent intent = new Intent(SongByCatActivity.this, DownloadActivity.class);
//                    startActivity(intent);
//                }
//            });
//
//            myView.findViewById(R.id.btn_empty_music_lib).setOnClickListener(new View.OnClickListener() {
//                @Override
//                public void onClick(View v) {
//                    Intent intent_music_lib = new Intent(SongByCatActivity.this, OfflineMusicActivity.class);
//                    startActivity(intent_music_lib);
//                }
//            });
//            frameLayout.addView(myView);
        }
    }

    private void loadLogout(String sessionID, String userID, int pos) {
        if (methods.isNetworkAvailable()) {
            ProgressDialog progressDialog = new ProgressDialog(LoggedDevicesActivity.this);
            progressDialog.setMessage(getResources().getString(R.string.logging_out));
            progressDialog.setCancelable(false);
            progressDialog.show();

            LoadLogout loadLogout = new LoadLogout(new LoggedDeviceListener() {
                @Override
                public void onStart() {

                }

                @Override
                public void onEnd(String success, String isDeviceLimitReached, String message, ArrayList<ItemLoggedDevice> arrayListLoggedDevice) {
                    if (success.equals("1")) {
                        sharedPref.setIsDeviceLimitReached(!isDeviceLimitReached.equals("false"));
                        arrayList.remove(pos);
                        adapterLoggedDevice.notifyItemRemoved(pos);

                        if(isDeviceLimitReached.equals("false")) {
                            onBackPressed();
                        }
                    } else {
                        Toast.makeText(LoggedDevicesActivity.this, getString(R.string.server_error), Toast.LENGTH_SHORT).show();
                    }
                    progressDialog.dismiss();
                }
            }, methods.getAPIRequest(Constant.METHOD_LOGOUT, 0, "", "", "", "", "", "", "", "", "", "", "", sessionID, "", userID, "", null));
            loadLogout.doWork(Constant.METHOD_LOGOUT);
        } else {
            Toast.makeText(LoggedDevicesActivity.this, getString(R.string.err_internet_not_conn), Toast.LENGTH_SHORT).show();
        }
    }

    private void openBottomSheetLogout() {
        View view = getLayoutInflater().inflate(R.layout.layout_bottom_logged_devices, null);

        BottomSheetDialog dialog = new BottomSheetDialog(LoggedDevicesActivity.this);
        dialog.setContentView(view);
        dialog.getWindow().findViewById(R.id.design_bottom_sheet).setBackgroundResource(android.R.color.transparent);
        dialog.show();

        MaterialButton btn_logout_other = dialog.findViewById(R.id.btn_bottom_logout_other);
        MaterialButton btn_logout = dialog.findViewById(R.id.btn_bottom_logout);

        btn_logout_other.setOnClickListener(view1 -> {
            dialog.dismiss();
        });

        btn_logout.setOnClickListener(view1 -> {
            dialog.dismiss();
            methods.loadLogout(sharedPref);
        });
    }

    @Override
    public void onBackPressed() {
        if (!sharedPref.isDeviceLimitReached()) {
            if(isFromApp) {
                super.onBackPressed();
            } else {
                Intent intent = new Intent(LoggedDevicesActivity.this, MainActivity.class);
                startActivity(intent);
                finish();
            }
        } else {
            openBottomSheetLogout();
        }
    }
}