package com.vpapps.onlinemp3;

import android.app.Application;
import android.content.Intent;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Bundle;
import android.view.MenuItem;
import android.view.View;
import android.widget.FrameLayout;
import android.widget.TextView;
import android.widget.Toast;

import androidx.annotation.NonNull;
import androidx.core.content.ContextCompat;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentManager;
import androidx.fragment.app.FragmentTransaction;

import com.google.android.material.bottomsheet.BottomSheetDialog;
import com.google.android.material.button.MaterialButton;
import com.sothree.slidinguppanel.SlidingUpPanelLayout;
import com.vpapps.adService.RewardAdAdmob;
import com.vpapps.adService.RewardAdApplovin;
import com.vpapps.adService.RewardAdStartApp;
import com.vpapps.adService.RewardAdUnity;
import com.vpapps.adService.RewardAdWortise;
import com.vpapps.asyncTask.LoadAbout;
import com.vpapps.asyncTask.LoadSubscriptionPlan;
import com.vpapps.fragment.FragmentDashBoard;
import com.vpapps.fragment.FragmentDownloads;
import com.vpapps.fragment.FragmentHome;
import com.vpapps.interfaces.AboutListener;
import com.vpapps.adService.AdManagerInterAdmob;
import com.vpapps.adService.AdManagerInterApplovin;
import com.vpapps.adService.AdManagerInterStartApp;
import com.vpapps.adService.AdManagerInterUnity;
import com.vpapps.adService.AdManagerInterWortise;
import com.vpapps.interfaces.SubscriptionPlanListener;
import com.vpapps.item.ItemSubscriptionPlan;
import com.vpapps.utils.Constant;
import com.vpapps.utils.GDPRChecker;
import com.vpapps.utils.Methods;

import java.util.ArrayList;
import java.util.EventListener;
import java.util.Objects;

public class MainActivity extends BaseActivity implements EventListener {

    Methods methods;
    FragmentManager fm;
    GDPRChecker gdprChecker;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);

        FrameLayout contentFrameLayout = findViewById(R.id.content_frame);
        getLayoutInflater().inflate(R.layout.content_main, contentFrameLayout);

//        try {
//            PackageInfo info = getPackageManager().getPackageInfo(
//                    getPackageName(),
//                    PackageManager.GET_SIGNATURES);
//            for (Signature signature : info.signatures) {
//                MessageDigest md = MessageDigest.getInstance("SHA");
//                md.update(signature.toByteArray());
//                Log.d("KeyHash:", Base64.encodeToString(md.digest(), Base64.DEFAULT));
//            }
//        } catch (PackageManager.NameNotFoundException e) {
//
//        } catch (NoSuchAlgorithmException e) {
//
//        }

        Constant.isAppOpen = true;
        methods = new Methods(this);
        methods.forceRTLIfSupported(getWindow());

        fm = getSupportFragmentManager();

        gdprChecker = new GDPRChecker(MainActivity.this);
        gdprChecker.check();

        if (methods.isNetworkAvailable()) {
            loadAboutData();
        } else {
            dbHelper.getAbout();
        }

        FragmentDashBoard f1 = new FragmentDashBoard();
        loadFrag(f1, getString(R.string.dashboard), fm);

        if (!methods.getPerNotificationStatus()) {
            methods.permissionDialog();
        }

        loadCheckUserSubscription();
    }

    @Override
    public boolean onOptionsItemSelected(MenuItem item) {
        if (item.getItemId() == android.R.id.home) {
            onBackPressed();
            return true;
        }
        return super.onOptionsItemSelected(item);
    }

    public void loadFrag(Fragment f1, String name, FragmentManager fm) {
        for (int i = 0; i < fm.getBackStackEntryCount(); ++i) {
            fm.popBackStackImmediate();
        }

        FragmentTransaction ft = fm.beginTransaction();
        ft.setTransition(FragmentTransaction.TRANSIT_FRAGMENT_OPEN);
        if (!name.equals(getString(R.string.dashboard))) {
            ft.hide(fm.getFragments().get(fm.getBackStackEntryCount()));
            ft.add(R.id.fragment, f1, name);
            ft.addToBackStack(name);
        } else {
            ft.replace(R.id.fragment, f1, name);
        }
//        changeToolbarColor(!name.equals(getString(R.string.dashboard)));
        ft.commit();

        getSupportActionBar().setTitle(name);

        if (mLayout.getPanelState() == SlidingUpPanelLayout.PanelState.EXPANDED) {
            mLayout.setPanelState(SlidingUpPanelLayout.PanelState.COLLAPSED);
        }
    }

    private void exitDialog() {
        View view = getLayoutInflater().inflate(R.layout.layout_bottom_logout, null);

        BottomSheetDialog dialog = new BottomSheetDialog(MainActivity.this, R.style.BottomSheetDialogStyle);
        dialog.setContentView(view);
        dialog.show();

        MaterialButton btn_stop = dialog.findViewById(R.id.btn_bottom_logout);
        MaterialButton btn_cancel = dialog.findViewById(R.id.btn_bottom_cancel);
        TextView tv1 = dialog.findViewById(R.id.tv1);
        TextView tv2 = dialog.findViewById(R.id.tv2);

        btn_stop.setText(getString(R.string.exit));
        tv1.setText(getString(R.string.exit));
        tv2.setText(getString(R.string.sure_exit));

        btn_stop.setOnClickListener(view1 -> {
            dialog.dismiss();
            finish();
        });

        btn_cancel.setOnClickListener(view1 -> dialog.dismiss());
    }

    public void loadAboutData() {
        LoadAbout loadAbout = new LoadAbout(MainActivity.this, new AboutListener() {
            @Override
            public void onStart() {
            }

            @Override
            public void onEnd(String success, String verifyStatus, String message) {
                if (!isFinishing()) {
                    if (!verifyStatus.equals("-1") && !verifyStatus.equals("-2")) {
                        sharedPref.setSocialDetails();
                        String version = "";
                        try {
                            PackageInfo pInfo = getPackageManager().getPackageInfo(getPackageName(), 0);
                            version = String.valueOf(pInfo.versionCode);
                        } catch (PackageManager.NameNotFoundException e) {
                            e.printStackTrace();
                        }
                        if (Constant.showUpdateDialog && !Constant.appVersion.equals(version)) {
                            methods.showUpdateAlert(Constant.appUpdateMsg, false);
                        } else {
                            dbHelper.addtoAbout();
                        }

                        methods.initializeAds();

                        Application application = getApplication();
                        ((MyApplication) application).loadAd(MainActivity.this);

                        if (Constant.isInterAd && (!sharedPref.getIsSubscribed() || sharedPref.getIsAdOn())) {
                            switch (Constant.interstitialAdType) {
                                case Constant.AD_TYPE_ADMOB, Constant.AD_TYPE_FACEBOOK -> {
                                    AdManagerInterAdmob adManagerInterAdmob = new AdManagerInterAdmob(getApplicationContext());
                                    adManagerInterAdmob.createAd();
                                }
                                case Constant.AD_TYPE_STARTAPP -> {
                                    AdManagerInterStartApp adManagerInterStartApp = new AdManagerInterStartApp(getApplicationContext());
                                    adManagerInterStartApp.createAd();
                                }
                                case Constant.AD_TYPE_APPLOVIN -> {
                                    AdManagerInterApplovin adManagerInterApplovin = new AdManagerInterApplovin(MainActivity.this);
                                    adManagerInterApplovin.createAd();
                                }
                                case Constant.AD_TYPE_WORTISE -> {
                                    AdManagerInterWortise adManagerInterWortise = new AdManagerInterWortise(MainActivity.this);
                                    adManagerInterWortise.createAd();
                                }
                                case Constant.AD_TYPE_UNITY -> {
                                    AdManagerInterUnity adManagerInterUnity = new AdManagerInterUnity();
                                    adManagerInterUnity.createAd();
                                }
                            }
                        }

                        if (Constant.isRewardAd && (!sharedPref.getIsSubscribed() || sharedPref.getIsAdOn())) {
                            switch (Constant.rewardAdType) {
                                case Constant.AD_TYPE_ADMOB, Constant.AD_TYPE_FACEBOOK -> {
                                    RewardAdAdmob rewardAdAdmob = new RewardAdAdmob(getApplicationContext());
                                    rewardAdAdmob.createAd();
                                }
                                case Constant.AD_TYPE_STARTAPP -> {
                                    RewardAdStartApp rewardAdStartApp = new RewardAdStartApp(getApplicationContext());
                                    rewardAdStartApp.createAd();
                                }
                                case Constant.AD_TYPE_APPLOVIN -> {
                                    RewardAdApplovin rewardAdApplovin = new RewardAdApplovin(MainActivity.this);
                                    rewardAdApplovin.createAd();
                                }
                                case Constant.AD_TYPE_WORTISE -> {
                                    RewardAdWortise rewardAdWortise = new RewardAdWortise(getApplicationContext());
                                    rewardAdWortise.createAd();
                                }
                                case Constant.AD_TYPE_UNITY -> {
                                    RewardAdUnity rewardAdUnity = new RewardAdUnity();
                                    rewardAdUnity.createAd();
                                }
                            }
                        }
                    } else if (verifyStatus.equals("-2")) {
                        methods.getInvalidUserDialog(message);
                    } else {
                        methods.getVerifyDialog(getString(R.string.error_unauth_access), message);
                    }
                }

                try {
                    FragmentHome fragment = (FragmentHome) getSupportFragmentManager().findFragmentById(R.id.fragment_dash);
                    assert fragment != null;
                    fragment.changeSubscriptionVisibility();
                } catch (Exception ignored) {

                }
            }
        });
        loadAbout.doWork();
    }

    private void loadCheckUserSubscription() {
        if (methods.isNetworkAvailable()) {
            LoadSubscriptionPlan loadSubscriptionPlan = new LoadSubscriptionPlan(new SubscriptionPlanListener() {
                @Override
                public void onStart() {

                }

                @Override
                public void onEnd(String success, String verifyStatus, String message, ArrayList<ItemSubscriptionPlan> arrayListSubsPlan) {
                    if (success.equals("1")) {
                        if(verifyStatus.equals("1")) {
                            sharedPref.setSubscriptionDetails(true, arrayListSubsPlan.get(0).getId(), arrayListSubsPlan.get(0).getTitle(), arrayListSubsPlan.get(0).getAmount(), arrayListSubsPlan.get(0).getExpireOn(), arrayListSubsPlan.get(0).getDeviceLimit(), arrayListSubsPlan.get(0).isAdsOn(), arrayListSubsPlan.get(0).isDownloadOn());
                        }
                    }
                }
            }, methods.getAPIRequest(Constant.METHOD_CHECK_USER_PLAN, 0, "", "", "", "", "", "", "", "", "", "", "", "", "", sharedPref.getUserID(), "", null));
            loadSubscriptionPlan.doWork(Constant.METHOD_CHECK_USER_PLAN);
        }
    }

    @Override
    protected void onDestroy() {
        Constant.isAppOpen = false;
        if (PlayerService.exoPlayer != null && !PlayerService.exoPlayer.getPlayWhenReady()) {
            Intent intent = new Intent(getApplicationContext(), PlayerService.class);
            intent.setAction(PlayerService.ACTION_STOP);
            stopService(intent);
        }
        super.onDestroy();
    }

    @Override
    public void onBackPressed() {
        if (dialog_desc != null && dialog_desc.isShowing()) {
            dialog_desc.dismiss();
        } else if (mLayout.getPanelState().equals(SlidingUpPanelLayout.PanelState.EXPANDED)) {
            mLayout.setPanelState(SlidingUpPanelLayout.PanelState.COLLAPSED);
        } else if (fm.getBackStackEntryCount() != 0) {
            String title = fm.getFragments().get(fm.getBackStackEntryCount()).getTag();
            if (title != null && (title.equals(getString(R.string.dashboard)) || title.equals(getString(R.string.home)) || title.equals(getString(R.string.categories)) || title.equals(getString(R.string.latest)) || title.equals(getString(R.string.recently_played)))) {

                if (title.equals(getString(R.string.home))) {
                    toolbar.setBackgroundColor(ContextCompat.getColor(MainActivity.this, R.color.bg));
                    methods.setStatusColor(getWindow());
                }
            }
            Objects.requireNonNull(getSupportActionBar()).setDisplayHomeAsUpEnabled(false);
            getSupportActionBar().setTitle(title);
            super.onBackPressed();
        } else {
            exitDialog();
        }
    }

    @Override
    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        boolean canUseExternalStorage = false;

        if (requestCode == Constant.REQ_AUDIO_DOWNLOAD_PAGE) {
            if (grantResults.length > 0
                    && grantResults[0] == PackageManager.PERMISSION_GRANTED) {
                canUseExternalStorage = true;

                FragmentDownloads f_downloads = new FragmentDownloads();
                FragmentTransaction ft = getSupportFragmentManager().beginTransaction();
                ft.setTransition(FragmentTransaction.TRANSIT_FRAGMENT_OPEN);
                ft.hide(getSupportFragmentManager()
                        .getFragments()
                        .get(getSupportFragmentManager().getBackStackEntryCount()));
                ft.add(R.id.fragment, f_downloads, getString(R.string.downloads));
                ft.addToBackStack(getString(R.string.downloads));
                ft.commit();

                Objects.requireNonNull(getSupportActionBar()).setTitle(getString(R.string.downloads));
                getSupportActionBar().setDisplayHomeAsUpEnabled(true);
            }

            if (!canUseExternalStorage) {
                Toast.makeText(MainActivity.this, getResources().getString(R.string.err_cannot_use_features), Toast.LENGTH_SHORT).show();
            }
        }
        super.onRequestPermissionsResult(requestCode, permissions, grantResults);
    }

    @Override
    protected void onResume() {
        try {
            FragmentHome fragment = (FragmentHome) getSupportFragmentManager().findFragmentById(R.id.fragment_dash);
            assert fragment != null;
            fragment.changeSubscriptionVisibility();
        } catch (Exception ignored) {
        }
        super.onResume();
    }
}