package com.vpapps.onlinemp3;

import android.content.Intent;
import android.os.Bundle;
import android.view.View;
import android.widget.ImageView;
import android.widget.TextView;
import android.widget.Toast;

import androidx.appcompat.app.AppCompatActivity;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;

import com.cinetpay.androidsdk.CinetPayActivity;
import com.google.android.material.button.MaterialButton;
import com.vpapps.adapter.AdapterPaymentMethods;
import com.vpapps.asyncTask.LoadPaymentDetails;
import com.vpapps.interfaces.PaymentMethodListener;
import com.vpapps.item.ItemPage;
import com.vpapps.item.ItemPaymentMethod;
import com.vpapps.item.ItemSubscriptionPlan;
import com.vpapps.onlinemp3.payment.CinetpayActivity;
import com.vpapps.onlinemp3.payment.FlutterwaveActivity;
import com.vpapps.onlinemp3.payment.InstamojoActivity;
import com.vpapps.onlinemp3.payment.PayUMoneyActivity;
import com.vpapps.onlinemp3.payment.PaypalActivity;
import com.vpapps.onlinemp3.payment.PaystackActivity;
import com.vpapps.onlinemp3.payment.RazorPayActivity;
import com.vpapps.onlinemp3.payment.StripeActivity;
import com.vpapps.utils.Constant;
import com.vpapps.utils.Methods;
import com.vpapps.utils.SharedPref;

import java.util.ArrayList;
import java.util.Date;

import fr.castorflex.android.circularprogressbar.CircularProgressBar;

public class PaymentMethodActivity extends AppCompatActivity {

    Methods methods;
    SharedPref sharedPref;
    RecyclerView rv_payment;
    AdapterPaymentMethods adapterPaymentMethods;
    ArrayList<ItemPaymentMethod> arrayList = new ArrayList<>();
    MaterialButton btn_payment;
    ImageView iv_close;
    TextView tv_subs_title, tv_subs_amount, tv_subs_duration;
    CircularProgressBar progressBar;
    ItemSubscriptionPlan itemSubscriptionPlan;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_payment_gateway);

        itemSubscriptionPlan = (ItemSubscriptionPlan) getIntent().getSerializableExtra("item");

        methods = new Methods(this);
        methods.forceRTLIfSupported(getWindow());
        sharedPref = new SharedPref(this);

        rv_payment = findViewById(R.id.rv_payment);
        btn_payment = findViewById(R.id.btn_payment);
        progressBar = findViewById(R.id.pb_payment);
        tv_subs_title = findViewById(R.id.tv_subs_plan_title);
        tv_subs_amount = findViewById(R.id.tv_subs_plan_amount);
        tv_subs_duration = findViewById(R.id.tv_subs_plan_duration);
        iv_close = findViewById(R.id.iv_payment_close);

        LinearLayoutManager linearLayoutManager = new LinearLayoutManager(PaymentMethodActivity.this);
        rv_payment.setLayoutManager(linearLayoutManager);

        tv_subs_title.setText(itemSubscriptionPlan.getTitle());
        tv_subs_amount.setText(itemSubscriptionPlan.getAmount().concat(" ").concat(itemSubscriptionPlan.getCurrencyCode()));
        tv_subs_duration.setText(itemSubscriptionPlan.getDuration());

        iv_close.setOnClickListener(view -> onBackPressed());

        btn_payment.setOnClickListener(view -> {
            if(adapterPaymentMethods.getSelectedPos() != -1) {
                Intent intent;
                switch (arrayList.get(adapterPaymentMethods.getSelectedPos()).getName()) {
                    case "Paypal" -> {
                        intent = new Intent(PaymentMethodActivity.this, PaypalActivity.class);
                        intent.putExtra("isSandbox",  arrayList.get(adapterPaymentMethods.getSelectedPos()).isPaypalSandbox());
                    }
                    case "Stripe" -> {
                        intent = new Intent(PaymentMethodActivity.this, StripeActivity.class);
                        intent.putExtra("stripePublisherKey",  arrayList.get(adapterPaymentMethods.getSelectedPos()).getStripePublisherKey());
                    }
                    case "Razorpay" -> {
                        intent = new Intent(PaymentMethodActivity.this, RazorPayActivity.class);
                        intent.putExtra("razorPayKey",  arrayList.get(adapterPaymentMethods.getSelectedPos()).getRazorpayKey());
                    }
                    case "Instamojo" -> {
                        intent = new Intent(PaymentMethodActivity.this, InstamojoActivity.class);
                        intent.putExtra("isSandbox",  arrayList.get(adapterPaymentMethods.getSelectedPos()).isInstamojoSandBox());
                    }
                    case "Paystack" -> {
                        intent = new Intent(PaymentMethodActivity.this, PaystackActivity.class);
                        intent.putExtra("payStackPublicKey",  arrayList.get(adapterPaymentMethods.getSelectedPos()).getPaystackPublicKey());
                    }
                    case "PayUMoney" -> {
                        intent = new Intent(PaymentMethodActivity.this, PayUMoneyActivity.class);
                        intent.putExtra("payUMoneyMerchantId",  arrayList.get(adapterPaymentMethods.getSelectedPos()).getPayUMoneyMerchantId());
                        intent.putExtra("payUMoneyMerchantKey",  arrayList.get(adapterPaymentMethods.getSelectedPos()).getPayUMoneyMerchantKey());
                        intent.putExtra("isSandbox",  arrayList.get(adapterPaymentMethods.getSelectedPos()).isPayUMoneySandbox());
                    }
                    case "Flutterwave" -> {
                        intent = new Intent(PaymentMethodActivity.this, FlutterwaveActivity.class);
                        intent.putExtra("flutterwavePublicKey",  arrayList.get(adapterPaymentMethods.getSelectedPos()).getFlutterWavePublicKey());
                        intent.putExtra("flutterwaveEncryptKey",  arrayList.get(adapterPaymentMethods.getSelectedPos()).getFlutterWaveEncryptionKey());
                    }
                    case "CinetPay" -> {
                        String transaction_id = String.valueOf(new Date().getTime());

                        intent = new Intent(PaymentMethodActivity.this, CinetpayActivity.class);
                        intent.putExtra(CinetPayActivity.KEY_API_KEY, arrayList.get(adapterPaymentMethods.getSelectedPos()).getCinetPayApiKey());
                        intent.putExtra(CinetPayActivity.KEY_SITE_ID, arrayList.get(adapterPaymentMethods.getSelectedPos()).getCinetPaySiteId());
                        intent.putExtra(CinetPayActivity.KEY_TRANSACTION_ID, transaction_id);
                        intent.putExtra(CinetPayActivity.KEY_AMOUNT, itemSubscriptionPlan.getAmount());
                        intent.putExtra(CinetPayActivity.KEY_CURRENCY, itemSubscriptionPlan.getCurrencyCode());
                        intent.putExtra(CinetPayActivity.KEY_DESCRIPTION, itemSubscriptionPlan.getTitle());
                        intent.putExtra(CinetPayActivity.KEY_CHANNELS, "MOBILE_MONEY");
                    }
                    case "Bank Transfer" -> {
                        intent = new Intent(PaymentMethodActivity.this, WebViewActivity.class);
                        intent.putExtra("item", new ItemPage("0", arrayList.get(adapterPaymentMethods.getSelectedPos()).getName(), arrayList.get(adapterPaymentMethods.getSelectedPos()).getBankTransferInfo()));
                    }
                    default -> {
                        intent = new Intent(PaymentMethodActivity.this, RazorPayActivity.class);
                    }
                }
                intent.putExtra("planGateway", arrayList.get(adapterPaymentMethods.getSelectedPos()).getName());
                intent.putExtra("itemSubs", itemSubscriptionPlan);
                startActivity(intent);
            } else {
                Toast.makeText(this, getString(R.string.err_select_payment_method), Toast.LENGTH_SHORT).show();
            }
        });

        loadPaymentMethods();
    }

    private void loadPaymentMethods() {
        if (methods.isNetworkAvailable()) {
            LoadPaymentDetails loadRegister = new LoadPaymentDetails(new PaymentMethodListener() {
                @Override
                public void onStart() {
                    progressBar.setVisibility(View.VISIBLE);
                }

                @Override
                public void onEnd(String success, String verifyStatus, String message, ArrayList<ItemPaymentMethod> arrayListPaymentMethods) {
                    progressBar.setVisibility(View.GONE);
                    if (success.equals("1")) {
                        arrayList.addAll(arrayListPaymentMethods);

                        adapterPaymentMethods = new AdapterPaymentMethods(PaymentMethodActivity.this, arrayList);
                        rv_payment.setAdapter(adapterPaymentMethods);
                    } else {
                        Toast.makeText(PaymentMethodActivity.this, getString(R.string.err_server), Toast.LENGTH_SHORT).show();
                    }
                }
            }, methods.getAPIRequest(Constant.METHOD_PAYMENT_METHOD, 0, "", "", "", "", "", "", "", "", "", "", "", "", "","","", null));
            loadRegister.doWork(Constant.METHOD_PAYMENT_METHOD);
        } else {
            Toast.makeText(this, getString(R.string.err_internet_not_conn), Toast.LENGTH_SHORT).show();
        }
    }
}