package com.vpapps.onlinemp3;

import android.app.IntentService;
import android.app.Notification;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.ServiceInfo;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.media.AudioManager;
import android.net.Uri;
import android.os.AsyncTask;
import android.os.Build;
import android.os.PowerManager;
import android.provider.MediaStore;
import android.support.v4.media.MediaDescriptionCompat;
import android.support.v4.media.session.MediaSessionCompat;
import android.support.v4.media.session.PlaybackStateCompat;
import android.telephony.TelephonyManager;
import android.widget.Toast;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.app.NotificationCompat;

import com.google.android.exoplayer2.C;
import com.google.android.exoplayer2.ExoPlayer;
import com.google.android.exoplayer2.MediaItem;
import com.google.android.exoplayer2.PlaybackException;
import com.google.android.exoplayer2.Player;
import com.google.android.exoplayer2.audio.AudioAttributes;
import com.google.android.exoplayer2.ext.mediasession.MediaSessionConnector;
import com.google.android.exoplayer2.ext.mediasession.TimelineQueueNavigator;
import com.google.android.exoplayer2.source.MediaSource;
import com.google.android.exoplayer2.source.ProgressiveMediaSource;
import com.google.android.exoplayer2.ui.PlayerNotificationManager;
import com.google.android.exoplayer2.upstream.DataSource;
import com.google.android.exoplayer2.upstream.DefaultBandwidthMeter;
import com.google.android.exoplayer2.upstream.DefaultDataSourceFactory;
import com.google.android.exoplayer2.util.Util;
import com.vpapps.eventbus.MessageEvent;
import com.vpapps.item.ItemAlbums;
import com.vpapps.item.ItemSong;
import com.vpapps.utils.Constant;
import com.vpapps.utils.DBHelper;
import com.vpapps.utils.EncryptedFileDataSourceFactory;
import com.vpapps.utils.GlobalBus;
import com.vpapps.utils.JsonUtils;
import com.vpapps.utils.MediaButtonIntentReceiver;
import com.vpapps.utils.Methods;
import com.vpapps.utils.SharedPref;

import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;

import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import javax.net.ssl.HttpsURLConnection;

public class PlayerService extends IntentService implements Player.Listener {

    public static final String ACTION_TOGGLE = "action.ACTION_TOGGLE";
    public static final String ACTION_PLAY = "action.ACTION_PLAY";
    public static final String ACTION_NEXT = "action.ACTION_NEXT";
    public static final String ACTION_PREVIOUS = "action.ACTION_PREVIOUS";
    public static final String ACTION_STOP = "action.ACTION_STOP";
    public static final String ACTION_SEEKTO = "action.ACTION_SEEKTO";

    public static ExoPlayer exoPlayer = null;
    MediaSessionCompat mMediaSession;

    DefaultBandwidthMeter bandwidthMeter;
    public static DataSource.Factory dataSourceFactory;

    static PlayerService playerService;
    Methods methods;
    DBHelper dbHelper;
    Boolean isNewSong = false;
    Bitmap bitmap;
    ComponentName componentName;
    AudioManager mAudioManager;
    PowerManager.WakeLock mWakeLock;

    Cipher mCipher = null;
    SecretKeySpec secretKeySpec;
    byte[] secretKey = BuildConfig.ENC_KEY.getBytes();
    byte[] initialIv = BuildConfig.IV.getBytes();

    PlayerNotificationManager notificationManager;
    MediaSessionConnector mediaSessionConnector;
    NotificationReceiver notificationReceiver;
    PlayerNotificationManager.BitmapCallback callbackBitmap;

    public PlayerService() {
        super(null);
    }

    static public PlayerService getInstance() {
        if (playerService == null) {
            playerService = new PlayerService();
        }
        return playerService;
    }

    public static Boolean getIsPlayling() {
        return exoPlayer != null && exoPlayer.getPlayWhenReady();
    }

    public long getDuration() {
        if (exoPlayer == null) {
            return 0;
        } else {
            return exoPlayer.getDuration();
        }
    }

    public int getAudioSessionID() {
        if (exoPlayer == null) {
            return 0;
        } else {
            return exoPlayer.getAudioSessionId();
        }
    }

    @Override
    protected void onHandleIntent(@Nullable Intent intent) {
    }

    @Override
    public void onCreate() {

        methods = new Methods(getApplicationContext());
        dbHelper = new DBHelper(getApplicationContext());

        mAudioManager = (AudioManager) getSystemService(Context.AUDIO_SERVICE);
        mAudioManager.requestAudioFocus(onAudioFocusChangeListener, AudioManager.STREAM_MUSIC, AudioManager.AUDIOFOCUS_GAIN);

        componentName = new ComponentName(getPackageName(), MediaButtonIntentReceiver.class.getName());
        mAudioManager.registerMediaButtonEventReceiver(componentName);

        try {
            registerReceiver(onCallIncome, new IntentFilter("android.intent.action.PHONE_STATE"));
            registerReceiver(onHeadPhoneDetect, new IntentFilter(AudioManager.ACTION_AUDIO_BECOMING_NOISY));
        } catch (Exception e) {
            e.printStackTrace();
        }

        bandwidthMeter = new DefaultBandwidthMeter.Builder(getApplicationContext()).build();

        exoPlayer = new ExoPlayer.Builder(getApplicationContext()).build();
        exoPlayer.addListener(this);

        PowerManager powerManager = (PowerManager) getSystemService(Context.POWER_SERVICE);
        mWakeLock = powerManager.newWakeLock(PowerManager.PARTIAL_WAKE_LOCK, getClass().getName());
        mWakeLock.setReferenceCounted(false);

        AudioAttributes audioAttributes = new AudioAttributes.Builder().setUsage(C.USAGE_MEDIA).setContentType(C.AUDIO_CONTENT_TYPE_MUSIC).build();
        exoPlayer.setAudioAttributes(audioAttributes, true);
        mMediaSession = new MediaSessionCompat(this, getResources().getString(R.string.app_name));
        mMediaSession.setActive(true);
        mediaSessionConnector = new MediaSessionConnector(mMediaSession);

        long enabledActions = PlaybackStateCompat.ACTION_PLAY | PlaybackStateCompat.ACTION_PAUSE | PlaybackStateCompat.ACTION_SKIP_TO_NEXT | PlaybackStateCompat.ACTION_SKIP_TO_PREVIOUS | PlaybackStateCompat.ACTION_STOP | PlaybackStateCompat.ACTION_SEEK_TO;

        mediaSessionConnector.setEnabledPlaybackActions(enabledActions);


        mediaSessionConnector.setPlayer(exoPlayer);

        TimelineQueueNavigator queueNavigator = new TimelineQueueNavigator(mMediaSession) {
            @NonNull
            @Override
            public MediaDescriptionCompat getMediaDescription(Player player, int windowIndex) {
                return new MediaDescriptionCompat.Builder().setTitle(Constant.arrayList_play.get(windowIndex).getTitle()).setDescription("MediaDescription description for " + windowIndex).setSubtitle(Constant.arrayList_play.get(windowIndex).getArtist()).build();
            }

            @Override
            public void onSkipToNext(@NonNull Player player) {
                nextNoti();
                super.onSkipToNext(player);
            }

            @Override
            public void onSkipToPrevious(@NonNull Player player) {
                try {
                    long playbackPosition = player.getCurrentPosition();
                    if (playbackPosition <= 3000) {
                        if (player.getCurrentPeriodIndex() != 0) {
                            previousNoti();
                        }
                    }
                } catch (Exception e) {
                    e.printStackTrace();
                }
                super.onSkipToPrevious(player);
            }
        };
        mediaSessionConnector.setQueueNavigator(queueNavigator);

        List<MediaSessionCompat.QueueItem> queue = new ArrayList<>();
        for (int i = 0; i < Constant.arrayList_play.size(); i++) {
            queue.add(new MediaSessionCompat.QueueItem(queueNavigator.getMediaDescription(exoPlayer, i), i));
        }
        mMediaSession.setQueue(queue);

        notificationReceiver = new NotificationReceiver();
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.TIRAMISU) {
            registerReceiver(notificationReceiver, addIntentFilter(), RECEIVER_EXPORTED);
        } else {
            registerReceiver(notificationReceiver, addIntentFilter());
        }

        super.onCreate();
    }

    @Override
    public int onStartCommand(@Nullable Intent intent, int flags, int startId) {
        try {
            String action = intent.getAction();
            switch (action) {

                case ACTION_PLAY:
                    startNewSong();
                    break;
                case ACTION_TOGGLE:
                    togglePlay();
                    break;
                case ACTION_SEEKTO:
                    seekTo(intent.getExtras().getLong("seekto"));
                    break;
                case ACTION_STOP:
                    stop(intent);
                    break;
                case ACTION_PREVIOUS:
                    if (!Constant.isOnline || methods.isNetworkAvailable()) {
                        previous();
                        exoPlayer.seekToDefaultPosition(Constant.playPos);
                    } else {
                        Toast.makeText(getApplicationContext(), getResources().getString(R.string.err_internet_not_conn), Toast.LENGTH_SHORT).show();
                    }
                    break;
                case ACTION_NEXT:
                    if (!Constant.isOnline || methods.isNetworkAvailable()) {
                        next();
                        exoPlayer.seekToDefaultPosition(Constant.playPos);
                    } else {
                        Toast.makeText(getApplicationContext(), getResources().getString(R.string.err_internet_not_conn), Toast.LENGTH_SHORT).show();
                    }
                    break;
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        return START_STICKY;
    }

    private void createNoti() {
        String channelId = getResources().getString(R.string.app_name);
        int notificationId = 111111;
        notificationManager = new PlayerNotificationManager.Builder(this, notificationId, channelId).setNotificationListener(notificationListener).setMediaDescriptionAdapter(descriptionAdapter).setChannelImportance(NotificationManager.IMPORTANCE_HIGH).setSmallIconResourceId(R.mipmap.app_icon).setChannelDescriptionResourceId(R.string.app_name).setNextActionIconResourceId(R.mipmap.ic_noti_next).setPreviousActionIconResourceId(R.mipmap.ic_noti_previous).setPlayActionIconResourceId(R.mipmap.ic_noti_play).setPauseActionIconResourceId(R.mipmap.ic_noti_pause).setChannelNameResourceId(R.string.app_name).build();

        notificationManager.setPlayer(exoPlayer);
        notificationManager.setPriority(NotificationCompat.PRIORITY_MAX);

        notificationManager.setUsePlayPauseActions(true);
        notificationManager.setUseFastForwardAction(false);
        notificationManager.setUseRewindAction(false);
        notificationManager.setUseNextAction(true);
        notificationManager.setUsePreviousAction(true);
        notificationManager.setUseStopAction(true);
        notificationManager.setUseNextActionInCompactView(true);
        notificationManager.setUsePreviousActionInCompactView(true);
        notificationManager.setMediaSessionToken(mMediaSession.getSessionToken());

        updateNotiImage();
    }

    PlayerNotificationManager.NotificationListener notificationListener = new PlayerNotificationManager.NotificationListener() {
        @Override
        public void onNotificationCancelled(int notificationId, boolean dismissedByUser) {
        }

        @Override
        public void onNotificationPosted(int notificationId, Notification notification, boolean ongoing) {
            if (ongoing) {
                if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.Q) {
                    startForeground(notificationId, notification, ServiceInfo.FOREGROUND_SERVICE_TYPE_MEDIA_PLAYBACK);
                } else {
                    startForeground(notificationId, notification);
                }
            }
        }
    };

    PlayerNotificationManager.MediaDescriptionAdapter descriptionAdapter = new PlayerNotificationManager.MediaDescriptionAdapter() {
        @Override
        public CharSequence getCurrentContentTitle(Player player) {
            return Constant.arrayList_play.get(Constant.playPos).getTitle();
        }

        @Nullable
        @Override
        public PendingIntent createCurrentContentIntent(Player player) {
            Intent notificationIntent = new Intent(PlayerService.this, SplashActivity.class);
            notificationIntent.setAction(Intent.ACTION_MAIN);
            notificationIntent.addCategory(Intent.CATEGORY_LAUNCHER);
            notificationIntent.putExtra("isnoti", true);

            return PendingIntent.getActivity(PlayerService.this, 0, notificationIntent, PendingIntent.FLAG_IMMUTABLE);
        }

        @Nullable
        @Override
        public CharSequence getCurrentContentText(Player player) {
            return Constant.arrayList_play.get(Constant.playPos).getArtist();
        }

        @Nullable
        @Override
        public Bitmap getCurrentLargeIcon(Player player, PlayerNotificationManager.BitmapCallback callback) {
            callbackBitmap = callback;
            return bitmap;
        }
    };

    @Override
    public void onPlaybackStateChanged(int playbackState) {
        Player.Listener.super.onPlaybackStateChanged(playbackState);
        if (playbackState == Player.STATE_READY) {
            exoPlayer.play();
            if (isNewSong) {
                isNewSong = false;
                Constant.isPlayed = true;
                setBuffer(false);
                GlobalBus.getBus().postSticky(Constant.arrayList_play.get(Constant.playPos));
                if (notificationManager == null) {
                    createNoti();
                } else {
                    updateNotiImage();
                }
            }
        }
    }

    @Override
    public void onPositionDiscontinuity(Player.PositionInfo oldPosition, Player.PositionInfo newPosition, int reason) {
        Player.Listener.super.onPositionDiscontinuity(oldPosition, newPosition, reason);
        if (reason == Player.DISCONTINUITY_REASON_AUTO_TRANSITION) {
            onCompletion();
        }
    }

    private void onCompletion() {
        if (Constant.isRepeat) {
            exoPlayer.seekToDefaultPosition(Constant.playPos);
        } else {
            changeImageAnimation(false);
            if (Constant.isSuffle) {
                Random rand = new Random();
                Constant.playPos = rand.nextInt((Constant.arrayList_play.size() - 1) + 1);
                exoPlayer.seekToDefaultPosition(Constant.playPos);
            } else {
                if (Constant.playPos < (Constant.arrayList_play.size() - 1)) {
                    Constant.playPos = Constant.playPos + 1;
                } else {
                    Constant.playPos = 0;
                }
            }
        }

        Constant.isPlayed = true;
        setBuffer(false);
        ((BaseActivity) Constant.context).isRotateAnim = false;
        changeImageAnimation(true);
        GlobalBus.getBus().postSticky(Constant.arrayList_play.get(Constant.playPos));
        if (notificationManager == null) {
            createNoti();
        } else {
            updateNotiImage();
        }
    }

    @Override
    public void onIsPlayingChanged(boolean isPlaying) {
        Player.Listener.super.onIsPlayingChanged(isPlaying);
        changePlayPause(isPlaying);
        if (isPlaying) {
            if (!mWakeLock.isHeld()) {
                mWakeLock.acquire(60000);
            }
        } else {
            if (mWakeLock.isHeld()) {
                mWakeLock.release();
            }
        }
    }

    @Override
    public void onPlayerError(PlaybackException error) {
        Player.Listener.super.onPlayerError(error);
        exoPlayer.setPlayWhenReady(false);
        setBuffer(false);
        changePlayPause(false);
    }

    private void startNewSong() {

        isNewSong = true;
        setBuffer(true);

//        String url;
        try {
//            url = Constant.arrayList_play.get(Constant.playPos).getUrl();

//            ProgressiveMediaSource sampleSource;
            if (Constant.isOnline || !Constant.isDownloaded) {
                dataSourceFactory = new DefaultDataSourceFactory(getApplicationContext(), Util.getUserAgent(getApplicationContext(), "onlinemp3"), bandwidthMeter);
            } else {
                if (mCipher == null) {
                    String AES_ALGORITHM = "AES";
                    String AES_TRANSFORMATION = "AES/CTR/NoPadding";

                    secretKeySpec = new SecretKeySpec(secretKey, AES_ALGORITHM);
                    try {
                        mCipher = Cipher.getInstance(AES_TRANSFORMATION);
                        mCipher.init(Cipher.DECRYPT_MODE, secretKeySpec, new IvParameterSpec(initialIv));
                    } catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                dataSourceFactory = new EncryptedFileDataSourceFactory(mCipher, secretKeySpec, new IvParameterSpec(initialIv), bandwidthMeter);
            }

//            sampleSource = new ProgressiveMediaSource.Factory(dataSourceFactory)
//                    .createMediaSource(new MediaItem.Builder().setUri(Uri.parse(url)).build());

            if (Constant.isNewAdded || exoPlayer.getMediaItemCount() == 0 || Constant.playPos >= exoPlayer.getMediaItemCount()) {
                loadMultipleMedia();
            }
            exoPlayer.seekToDefaultPosition(Constant.playPos);
            exoPlayer.prepare();
            exoPlayer.setPlayWhenReady(true);

            if (!Constant.isDownloaded) {
                dbHelper.addToRecent(Constant.arrayList_play.get(Constant.playPos), Constant.isOnline);
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void loadMultipleMedia() {
//        List<MediaItem> mediaItemsToLoad = new ArrayList<>();
        List<MediaSource> mediaItemsSource = new ArrayList<>();
        for (ItemSong playerItem : Constant.arrayList_play) {
            Uri uri = Uri.parse(playerItem.getUrl());
//            MediaMetadata mediaMetadata = new MediaMetadata.Builder().setTitle(playerItem.getTitle()).build();
//            MediaItem mediaItem = new MediaItem.Builder().setUri(uri).setMediaMetadata(mediaMetadata).build();
//            mediaItemsToLoad.add(mediaItem);


            MediaSource sampleSource = new ProgressiveMediaSource.Factory(dataSourceFactory).createMediaSource(new MediaItem.Builder().setUri(uri).build());
            mediaItemsSource.add(sampleSource);
        }
//        exoPlayer.setMediaItems(mediaItemsToLoad);
        exoPlayer.setMediaSources(mediaItemsSource);
    }

    public void addMediaSource(Uri uri) {
        if (dataSourceFactory != null && exoPlayer != null) {
            exoPlayer.addMediaSource(new ProgressiveMediaSource.Factory(dataSourceFactory).createMediaSource(new MediaItem.Builder().setUri(uri).build()));
        }
    }

    private void togglePlay() {
        if (exoPlayer.getPlayWhenReady()) {
            exoPlayer.setPlayWhenReady(false);
        } else {
            exoPlayer.setPlayWhenReady(true);
        }
        changePlayPause(exoPlayer.getPlayWhenReady());
    }

    private void previous() {
        isNewSong = true;
        setBuffer(true);
        if (Constant.isSuffle) {
            Random rand = new Random();
            Constant.playPos = rand.nextInt((Constant.arrayList_play.size() - 1) + 1);
        } else {
            if (Constant.playPos > 0) {
                Constant.playPos = Constant.playPos - 1;
            } else {
                Constant.playPos = Constant.arrayList_play.size() - 1;
            }
        }
        if (exoPlayer.getMediaItemCount() != 0) {
            exoPlayer.setPlayWhenReady(true);
        } else {
            startNewSong();
        }
    }

    private void next() {
        isNewSong = true;
        setBuffer(true);
        if (Constant.isSuffle) {
            Random rand = new Random();
            Constant.playPos = rand.nextInt((Constant.arrayList_play.size() - 1) + 1);
        } else {
            if (Constant.playPos < (Constant.arrayList_play.size() - 1)) {
                Constant.playPos = Constant.playPos + 1;
            } else {
                Constant.playPos = 0;
            }
        }
        if (exoPlayer.getMediaItemCount() != 0) {
            exoPlayer.setPlayWhenReady(true);
        } else {
            startNewSong();
        }
    }

    private void previousNoti() {
        isNewSong = true;
        setBuffer(true);

        if (Constant.playPos > 0) {
            Constant.playPos = Constant.playPos - 1;
        } else {
            Constant.playPos = Constant.arrayList_play.size() - 1;
        }

        ////                exoPlayer.setPlayWhenReady(true);
////                exoPlayer.seekToDefaultPosition(Constant.playPos);

//        if (Constant.arrayList_play.get(Constant.playPos).isSongFree() || Constant.arrayList_play.get(Constant.playPos).isSongPurchased()) {
////                exoPlayer.setPlayWhenReady(true);
////                exoPlayer.seekToDefaultPosition(Constant.playPos);
//        } else {
//            exoPlayer.setPlayWhenReady(false);
//            setBuffer(false);
//            changePlayPause(false);
//
//            updateNotiImage();
//
//            Constant.isPlayed = false;
//            GlobalBus.getBus().postSticky(Constant.arrayList_play.get(Constant.playPos));
//        }
    }

    private void nextNoti() {
        isNewSong = true;
        setBuffer(true);

        if (Constant.playPos < (Constant.arrayList_play.size() - 1)) {
            Constant.playPos = Constant.playPos + 1;
        } else {
            Constant.playPos = 0;
        }

//        if (Constant.arrayList_play.get(Constant.playPos).isSongFree() || Constant.arrayList_play.get(Constant.playPos).isSongPurchased()) {
////                exoPlayer.setPlayWhenReady(true);
////                exoPlayer.seekToDefaultPosition(Constant.playPos);
//        } else {
//            exoPlayer.setPlayWhenReady(false);
//            setBuffer(false);
//            changePlayPause(false);
//
//            updateNotiImage();
//
//            Constant.isPlayed = false;
//            GlobalBus.getBus().postSticky(Constant.arrayList_play.get(Constant.playPos));
//        }
    }

    private void seekTo(long seek) {
        exoPlayer.seekTo((int) seek);
    }

    private void changePlayPause(Boolean flag) {
        try {
            changeEquilizer();
            changeImageAnimation(flag);
            GlobalBus.getBus().postSticky(new MessageEvent(flag, "playicon"));
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void updateNotiImage() {
        new AsyncTask<String, String, String>() {

            @Override
            protected void onPostExecute(String s) {
                super.onPostExecute(s);
            }

            @Override
            protected String doInBackground(String... strings) {
                try {
                    if (Constant.isOnline) {
                        JsonUtils.okhttpPost(Constant.METHOD_SONG_VIEW, methods.getAPIRequest(Constant.METHOD_SONG_VIEW, 0, "", Constant.arrayList_play.get(Constant.playPos).getId(), "", "", "", "", "", "", "", "", "", "", "", new SharedPref(getApplicationContext()).getUserID(), "", null));
                    }
                    getBitmapFromURL(Constant.arrayList_play.get(Constant.playPos).getImageBig());
                } catch (Exception e) {
                    e.printStackTrace();
                }
                return null;
            }
        }.execute();
    }

    private void setBuffer(Boolean isBuffer) {
        if (!isBuffer) {
            changeEquilizer();
        }
        GlobalBus.getBus().postSticky(new MessageEvent(isBuffer, "buffer"));
    }

    private void changeEquilizer() {
        GlobalBus.getBus().postSticky(new ItemAlbums("", "", "", ""));
    }

    private void changeImageAnimation(boolean flag) {
        try {
            ((BaseActivity) Constant.context).changeImageAnimation(flag);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void getBitmapFromURL(String src) {
        try {
            if (Constant.isOnline) {
                URL url = new URL(src);
                InputStream input;
                if (src.contains("https://")) {
                    HttpsURLConnection connection = (HttpsURLConnection) url.openConnection();
                    connection.setDoInput(true);
                    connection.connect();
                    input = connection.getInputStream();
                } else {
                    HttpURLConnection connection = (HttpURLConnection) url.openConnection();
                    connection.setDoInput(true);
                    connection.connect();
                    input = connection.getInputStream();
                }
                bitmap = BitmapFactory.decodeStream(input);

            } else {
                try {
                    bitmap = MediaStore.Images.Media.getBitmap(this.getContentResolver(), Uri.parse(src));
                } catch (Exception e) {
                    bitmap = BitmapFactory.decodeResource(getResources(), R.drawable.placeholder_song);
                }
            }
            if (callbackBitmap != null) {
                callbackBitmap.onBitmap(bitmap);
            }
        } catch (IOException e) {
            // Log exception
            e.printStackTrace();
        }
    }

    BroadcastReceiver onCallIncome = new BroadcastReceiver() {
        @Override
        public void onReceive(Context context, Intent intent) {

            String a = intent.getStringExtra(TelephonyManager.EXTRA_STATE);

            try {
                if (exoPlayer.getPlayWhenReady()) {
                    if (a.equals(TelephonyManager.EXTRA_STATE_OFFHOOK) || a.equals(TelephonyManager.EXTRA_STATE_RINGING)) {
                        exoPlayer.setPlayWhenReady(false);
                    }
                }
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
    };

    BroadcastReceiver onHeadPhoneDetect = new BroadcastReceiver() {
        @Override
        public void onReceive(Context context, Intent intent) {
            try {
                if (exoPlayer.getPlayWhenReady()) {
                    togglePlay();
                }
            } catch (Exception e) {
                e.printStackTrace();

            }
        }
    };

    AudioManager.OnAudioFocusChangeListener onAudioFocusChangeListener = new AudioManager.OnAudioFocusChangeListener() {
        @Override
        public void onAudioFocusChange(int focusChange) {
            switch (focusChange) {
                case AudioManager.AUDIOFOCUS_GAIN:
                case AudioManager.AUDIOFOCUS_LOSS_TRANSIENT_CAN_DUCK:
//                    resumePlayer(); // Resume your media player here
                    break;
                case AudioManager.AUDIOFOCUS_LOSS:
                case AudioManager.AUDIOFOCUS_LOSS_TRANSIENT:
                    try {
                        if (exoPlayer.getPlayWhenReady()) {
                            togglePlay();
                        }
                    } catch (Exception e) {
                        e.printStackTrace();
                    }
                    break;
            }
        }
    };

    private class NotificationReceiver extends BroadcastReceiver {

        @Override
        public void onReceive(Context context, Intent intent) {
            switch (intent.getAction()) {
//                case PlayerNotificationManager.ACTION_PLAY:
//                    break;
//                case PlayerNotificationManager.ACTION_PAUSE:
//                    break;
                case PlayerNotificationManager.ACTION_PREVIOUS:
//                    previous();
                    previousNoti();
                    break;
                case PlayerNotificationManager.ACTION_NEXT:
//                    next();
                    nextNoti();
                    break;
                case PlayerNotificationManager.ACTION_STOP:
                    stop(intent);
                    break;
            }
        }
    }

    private IntentFilter addIntentFilter() {
        IntentFilter intentFilter = new IntentFilter();
//        intentFilter.addAction(PlayerNotificationManager.ACTION_PLAY);
//        intentFilter.addAction(PlayerNotificationManager.ACTION_PAUSE);
        intentFilter.addAction(PlayerNotificationManager.ACTION_PREVIOUS);
        intentFilter.addAction(PlayerNotificationManager.ACTION_NEXT);
        intentFilter.addAction(PlayerNotificationManager.ACTION_NEXT);
        intentFilter.addAction(PlayerNotificationManager.ACTION_STOP);
        return intentFilter;
    }

    private void stop(Intent intent) {
        try {
            Constant.isPlayed = false;

            exoPlayer.setPlayWhenReady(false);
            changePlayPause(false);
            exoPlayer.stop();
            exoPlayer.release();
            exoPlayer = null;
            try {
                mAudioManager.abandonAudioFocus(onAudioFocusChangeListener);
                mAudioManager.unregisterMediaButtonEventReceiver(componentName);
                unregisterReceiver(onCallIncome);
                unregisterReceiver(onHeadPhoneDetect);
            } catch (Exception e) {
                e.printStackTrace();
            }
            stopService(intent);
            stopForeground(true);
            stopSelf();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void onDestroy() {
        try {
            try {
                Constant.isPlayed = false;

                try {
                    mAudioManager.abandonAudioFocus(onAudioFocusChangeListener);
                    mAudioManager.unregisterMediaButtonEventReceiver(componentName);
                    unregisterReceiver(onCallIncome);
                    unregisterReceiver(onHeadPhoneDetect);
                } catch (Exception e) {
                    e.printStackTrace();
                }
                stopForeground(true);
                stopSelf();
            } catch (Exception e) {
                e.printStackTrace();
            }

            unregisterReceiver(notificationReceiver);
            if (mWakeLock.isHeld()) {
                mWakeLock.release();
            }
            dbHelper.close();
        } catch (Exception e) {
            e.printStackTrace();
        }
        super.onDestroy();
    }

    @Override
    public void onTaskRemoved(Intent rootIntent) {
        super.onTaskRemoved(rootIntent);
        try {
            if (!exoPlayer.getPlayWhenReady()) stopForeground(true);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
}