package com.vpapps.onlinemp3;

import android.app.Activity;
import android.app.ProgressDialog;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.view.MenuItem;
import android.view.View;
import android.widget.EditText;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.Toast;

import androidx.appcompat.app.AppCompatActivity;
import androidx.appcompat.widget.AppCompatButton;
import androidx.appcompat.widget.Toolbar;

import com.squareup.picasso.Picasso;
import com.vpapps.asyncTask.LoadProfileEdit;
import com.vpapps.interfaces.ProfileListener;
import com.vpapps.utils.Constant;
import com.vpapps.utils.Methods;
import com.vpapps.utils.SharedPref;

import java.io.File;

public class ProfileEditActivity extends AppCompatActivity {

    Toolbar toolbar;
    Methods methods;
    SharedPref sharedPref;
    private EditText editText_name, editText_email, editText_phone, editText_pass, editText_cpass;
    ImageView iv_profile;
    ProgressDialog progressDialog;
    LinearLayout ll_pass, ll_cpass;
    String imagePath = "";
    int PICK_IMAGE_REQUEST = 1;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_profile_edit);

        sharedPref = new SharedPref(this);
        methods = new Methods(this);
        methods.forceRTLIfSupported(getWindow());
        methods.setStatusColorDark(getWindow());

        progressDialog = new ProgressDialog(this);
        progressDialog.setMessage(getResources().getString(R.string.loading));
        progressDialog.setCancelable(false);

        toolbar = findViewById(R.id.toolbar_proedit);
        setSupportActionBar(toolbar);
        getSupportActionBar().setDisplayHomeAsUpEnabled(true);

        AppCompatButton button_update = findViewById(R.id.button_prof_update);
        ll_pass = findViewById(R.id.ll_prof_edit_pass);
        ll_cpass = findViewById(R.id.ll_prof_edit_cpass);
        iv_profile = findViewById(R.id.iv_profile);
        editText_name = findViewById(R.id.editText_profedit_name);
        editText_email = findViewById(R.id.editText_profedit_email);
        editText_phone = findViewById(R.id.editText_profedit_phone);
        editText_pass = findViewById(R.id.editText_profedit_password);
        editText_cpass = findViewById(R.id.editText_profedit_cpassword);

        if (sharedPref.getLoginType().equals(Constant.LOGIN_TYPE_NORMAL)) {
            ll_pass.setVisibility(View.VISIBLE);
            ll_cpass.setVisibility(View.VISIBLE);
            editText_email.setEnabled(true);
        } else {
            ll_pass.setVisibility(View.GONE);
            ll_cpass.setVisibility(View.GONE);
            editText_email.setEnabled(false);
        }

        LinearLayout ll_adView = findViewById(R.id.ll_adView);
        methods.showBannerAd(ll_adView);

        setProfileVar();

        button_update.setOnClickListener(view -> {
            if (validate()) {
                loadUpdateProfile();
            }
        });

        iv_profile.setOnClickListener(v -> {
            if (methods.checkPerImages()) {
                pickImage();
            }
        });
    }

    @Override
    public boolean onOptionsItemSelected(MenuItem item) {
        if (item.getItemId() == android.R.id.home) {
            onBackPressed();
        }
        return super.onOptionsItemSelected(item);
    }

    private Boolean validate() {
        editText_name.setError(null);
        editText_email.setError(null);
        editText_cpass.setError(null);
        if (editText_name.getText().toString().trim().isEmpty()) {
            editText_name.setError(getString(R.string.cannot_empty));
            editText_name.requestFocus();
            return false;
        } else if (editText_email.getText().toString().trim().isEmpty()) {
            editText_email.setError(getString(R.string.email_empty));
            editText_email.requestFocus();
            return false;
        } else if (editText_pass.getText().toString().endsWith(" ")) {
            editText_pass.setError(getString(R.string.pass_end_space));
            editText_pass.requestFocus();
            return false;
        } else if (!editText_pass.getText().toString().trim().equals(editText_cpass.getText().toString().trim())) {
            editText_cpass.setError(getString(R.string.pass_nomatch));
            editText_cpass.requestFocus();
            return false;
        } else {
            return true;
        }
    }

    private void updateArray(String image) {
        sharedPref.setUserName(editText_name.getText().toString());
        sharedPref.setUserEmail(editText_email.getText().toString());
        sharedPref.setUserMobile(editText_phone.getText().toString());
        sharedPref.setUserImage(image);

        if (!editText_pass.getText().toString().equals("")) {
            sharedPref.setRemember(false);
        }
    }

    private void loadUpdateProfile() {
        if (methods.isNetworkAvailable()) {
            File file = null;
            if (imagePath != null && !imagePath.equals("")) {
                file = new File(imagePath);
            }
            LoadProfileEdit loadProfileEdit = new LoadProfileEdit(new ProfileListener() {
                @Override
                public void onStart() {
                    progressDialog.show();
                }

                @Override
                public void onEnd(String success, String registerSuccess, String message, String userId, String userName, String email, String phone, String image) {
                    progressDialog.dismiss();
                    if (success.equals("1")) {
                        switch (registerSuccess) {
                            case "1":
                                updateArray(image);
                                imagePath = "";
                                Constant.isUpdate = true;
                                finish();
                                Toast.makeText(ProfileEditActivity.this, message, Toast.LENGTH_SHORT).show();
                                break;
                            case "-1":
                                methods.getVerifyDialog(getString(R.string.error_unauth_access), message);
                                break;
                            default:
                                if (message.contains("Email address already used")) {
                                    editText_email.setError(message);
                                    editText_email.requestFocus();
                                } else {
                                    Toast.makeText(ProfileEditActivity.this, message, Toast.LENGTH_SHORT).show();
                                }
                                break;
                        }
                    } else {
                        Toast.makeText(ProfileEditActivity.this, getString(R.string.err_server), Toast.LENGTH_SHORT).show();
                    }
                }
            }, methods.getAPIRequest(Constant.METHOD_PROFILE_EDIT, 0, "", "", "", "", "", "", "", "", "", editText_email.getText().toString(), editText_pass.getText().toString(), editText_name.getText().toString(), editText_phone.getText().toString(), sharedPref.getUserID(), "", file));
            loadProfileEdit.execute(Constant.METHOD_PROFILE_EDIT);
        } else {
            Toast.makeText(ProfileEditActivity.this, getString(R.string.err_internet_not_conn), Toast.LENGTH_SHORT).show();
        }
    }

    public void setProfileVar() {
        editText_name.setText(sharedPref.getUserName());
        editText_phone.setText(sharedPref.getUserMobile());
        editText_email.setText(sharedPref.getUserEmail());

        if (!sharedPref.getUserImage().equals("")) {
            Picasso.get()
                    .load(sharedPref.getUserImage())
                    .into(iv_profile);
        }
    }

    private void pickImage() {
        Intent intent = new Intent();
        intent.setType("image/*");
        intent.setAction(Intent.ACTION_GET_CONTENT);
        startActivityForResult(Intent.createChooser(intent, getResources().getString(R.string.select_image)), PICK_IMAGE_REQUEST);
    }

    @Override
    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);

        if (requestCode == PICK_IMAGE_REQUEST && resultCode == Activity.RESULT_OK && data != null && data.getData() != null) {

            Uri uri = data.getData();
            imagePath = methods.getPathImage(uri);
            iv_profile.setImageURI(uri);
        }
    }
}