package com.vpapps.onlinemp3;

import android.content.Context;
import android.content.Intent;
import android.graphics.Typeface;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.widget.CheckBox;
import android.widget.FrameLayout;
import android.widget.TextView;
import android.widget.Toast;

import com.vpapps.adapter.AdapterSelectableSongList;
import com.vpapps.interfaces.ClickListenerCallback;
import com.vpapps.item.ItemSong;
import com.vpapps.utils.Constant;
import com.vpapps.utils.DBHelper;
import com.vpapps.utils.Methods;

import java.util.ArrayList;

import androidx.appcompat.app.AppCompatActivity;
import androidx.appcompat.widget.Toolbar;
import androidx.recyclerview.widget.DefaultItemAnimator;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;

public class SelectSongActivity extends AppCompatActivity {

    Toolbar toolbar;
    Methods methods;
    DBHelper dbHelper;
    RecyclerView rv;
    ArrayList<ItemSong> arrayList;
    FrameLayout frameLayout;
    AdapterSelectableSongList adapter;
    CheckBox checkBox_menu;
    TextView tv_select_add;
    String pid = "", type = "", play_id = "";

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_select_song);

        pid = getIntent().getStringExtra("pid");
        type = getIntent().getStringExtra("type");
        if (type.equals(getString(R.string.playlist))) {
            play_id = getIntent().getStringExtra("play_id");
        }

        dbHelper = new DBHelper(this);
        methods = new Methods(this);
        methods = new Methods(this);
        methods.forceRTLIfSupported(getWindow());
        methods.setStatusColor(getWindow());

        toolbar = this.findViewById(R.id.toolbar_select);
        toolbar.setTitle("0 " + getString(R.string.selected));
        this.setSupportActionBar(toolbar);
        getSupportActionBar().setDisplayHomeAsUpEnabled(true);

        tv_select_add = findViewById(R.id.tv_select_add);
        tv_select_add.setTypeface(tv_select_add.getTypeface(), Typeface.BOLD);
        frameLayout = findViewById(R.id.fl_empty);

        arrayList = new ArrayList<>();
        if (type.equals(getString(R.string.recent))) {
            arrayList.addAll(dbHelper.loadDataRecent(false, Constant.recentLimit));
        } else if (type.equals(getString(R.string.playlist))) {
            arrayList.addAll(dbHelper.loadDataPlaylist(play_id, false));
        } else if (type.equals(getString(R.string.edit))) {
            arrayList.addAll((ArrayList<ItemSong>) getIntent().getSerializableExtra("array"));
            tv_select_add.setText(getString(R.string.remove));
        } else {
            arrayList.addAll(Constant.arrayListOfflineSongs);
        }

        rv = findViewById(R.id.rv_select);
        LinearLayoutManager llm = new LinearLayoutManager(this);
        rv.setLayoutManager(llm);
        rv.setItemAnimator(new DefaultItemAnimator());
        rv.setHasFixedSize(true);
        rv.setNestedScrollingEnabled(false);

        adapter = new AdapterSelectableSongList(SelectSongActivity.this, arrayList, new ClickListenerCallback() {
            @Override
            public void onClick(int position) {
                getSupportActionBar().setTitle(adapter.getSelectedCounts() + " " + getString(R.string.selected));
            }

            @Override
            public void onItemZero() {

            }
        });

        tv_select_add.setOnClickListener(v -> {
            ArrayList<ItemSong> checkedArray = adapter.getSelectedIDs();
            if (!checkedArray.isEmpty()) {
                for (int i = 0; i < checkedArray.size(); i++) {
                    if (!type.equals(getString(R.string.edit))) {
                        dbHelper.addToPlayList(checkedArray.get(i), pid, false);
                    } else {
                        dbHelper.removeFromPlayList(checkedArray.get(i).getId(), false);
                    }
                }
//                    Toast.makeText(SelectSongActivity.this, getString(R.string.add_to_playlist), Toast.LENGTH_SHORT).show();
                finish();
            } else {
                Toast.makeText(SelectSongActivity.this, getString(R.string.select_song), Toast.LENGTH_SHORT).show();
            }
        });

        rv.setAdapter(adapter);
        setEmpty();
    }

    @Override
    public boolean onCreateOptionsMenu(Menu menu) {
        getMenuInflater().inflate(R.menu.menu_checkbox, menu);
        checkBox_menu = (CheckBox) menu.findItem(R.id.menu_cb).getActionView();
        checkBox_menu.setOnCheckedChangeListener((buttonView, isChecked) -> {
            adapter.toggleSelectAll(isChecked);
            getSupportActionBar().setTitle(adapter.getSelectedCounts() + " " + getString(R.string.selected));
        });
        return super.onCreateOptionsMenu(menu);
    }

    @Override
    public boolean onOptionsItemSelected(MenuItem item) {
        if (item.getItemId() == android.R.id.home) {
            onBackPressed();
        }
        return super.onOptionsItemSelected(item);
    }

    private void setEmpty() {
        if (!arrayList.isEmpty()) {
            frameLayout.setVisibility(View.GONE);
            rv.setVisibility(View.VISIBLE);
        } else {
            frameLayout.setVisibility(View.VISIBLE);
            rv.setVisibility(View.GONE);

            frameLayout.removeAllViews();
            LayoutInflater infltr = (LayoutInflater) getSystemService(Context.LAYOUT_INFLATER_SERVICE);

            View myView = infltr.inflate(R.layout.layout_err_nodata, null);

            TextView textView = myView.findViewById(R.id.tv_empty_msg);
            textView.setText(getString(R.string.err_no_songs_found));

            myView.findViewById(R.id.btn_empty_try).setVisibility(View.GONE);

            myView.findViewById(R.id.btn_empty_downloads).setOnClickListener(v -> {
                Intent intent = new Intent(SelectSongActivity.this, DownloadActivity.class);
                startActivity(intent);
            });

            myView.findViewById(R.id.btn_empty_music_lib).setOnClickListener(v -> {
                Intent intent_music_lib = new Intent(SelectSongActivity.this, OfflineMusicActivity.class);
                startActivity(intent_music_lib);
            });

            frameLayout.addView(myView);
        }
    }

    @Override
    protected void onDestroy() {
        try {
            dbHelper.close();
        } catch (Exception e) {
            e.printStackTrace();
        }
        super.onDestroy();
    }
}