package com.vpapps.onlinemp3;

import android.annotation.SuppressLint;
import android.app.Application;
import android.content.Intent;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Bundle;
import android.os.Handler;
import android.util.Log;
import android.view.View;
import android.widget.TextView;
import android.widget.Toast;

import androidx.appcompat.app.AppCompatActivity;

import com.google.android.material.bottomsheet.BottomSheetDialog;
import com.google.android.material.button.MaterialButton;
import com.google.firebase.auth.FirebaseAuth;
import com.google.firebase.auth.FirebaseUser;
import com.vpapps.asyncTask.LoadAbout;
import com.vpapps.asyncTask.LoadSuccess;
import com.vpapps.interfaces.AboutListener;
import com.vpapps.interfaces.SuccessListener;
import com.vpapps.item.ItemServerPlayList;
import com.vpapps.utils.Constant;
import com.vpapps.utils.DBHelper;
import com.vpapps.utils.Methods;
import com.vpapps.utils.SharedPref;

@SuppressLint("CustomSplashScreen")
public class SplashActivity extends AppCompatActivity {

    SharedPref sharedPref;
    Methods methods;
    DBHelper dbHelper;
    Application application;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);

        setContentView(R.layout.activity_splash);

        hideStatusBar();
        methods = new Methods(this);
        sharedPref = new SharedPref(this);
        dbHelper = new DBHelper(this);

        if (sharedPref.getIsFirst()) {
            loadAboutData();
        } else {
            dbHelper.getAbout();
            application = getApplication();
            ((MyApplication) application).loadAd(SplashActivity.this);

            try {
                Constant.isFromPush = getIntent().getExtras().getBoolean("ispushnoti", false);
            } catch (Exception e) {
                Constant.isFromPush = false;
            }
            try {
                Constant.isFromNoti = getIntent().getExtras().getBoolean("isnoti", false);
            } catch (Exception e) {
                Constant.isFromNoti = false;
            }

            if (!sharedPref.getIsAutoLogin()) {
                new Handler().postDelayed(new Runnable() {
                    @Override
                    public void run() {
                        openMainActivity();
                    }
                },Constant.splashLoadingTime);
            } else {
                if (sharedPref.getLoginType().equals(Constant.LOGIN_TYPE_GOOGLE)) {
                    FirebaseUser currentUser = FirebaseAuth.getInstance().getCurrentUser();
                    if (currentUser == null) {
                        sharedPref.setLoginDetails("0", "", "", "", "", "", "", false, "", Constant.LOGIN_TYPE_NORMAL, false);
                        sharedPref.setIsAutoLogin(false);

                        new Handler().postDelayed(new Runnable() {
                            @Override
                            public void run() {
                                openMainActivity();
                            }
                        }, Constant.splashLoadingTime);

                    } else {
                        if (!sharedPref.getIsSubscribed()) {
                            new Handler().postDelayed(new Runnable() {
                                @Override
                                public void run() {
                                    openMainActivity();
                                }
                            }, Constant.splashLoadingTime);
                        } else {
                            loadCheckUserDeviceLimit();
                        }
                    }
                 } else {
                    if (!sharedPref.getIsSubscribed()) {
                        new Handler().postDelayed(new Runnable() {
                            @Override
                            public void run() {
                                openMainActivity();
                            }
                        }, Constant.splashLoadingTime);
                    } else {
                        loadCheckUserDeviceLimit();
                    }
                }
            }
        }
    }

    public void loadAboutData() {
        if (methods.isNetworkAvailable()) {
            LoadAbout loadAbout = new LoadAbout(SplashActivity.this, new AboutListener() {
                @Override
                public void onStart() {

                }

                @Override
                public void onEnd(String success, String verifyStatus, String message) {
                    if (success.equals("1")) {
                        if (!verifyStatus.equals("-1") && !verifyStatus.equals("-2")) {
                            sharedPref.setSocialDetails();
                            String version = "";
                            try {
                                PackageInfo pInfo = getPackageManager().getPackageInfo(getPackageName(), 0);
                                version = String.valueOf(pInfo.versionCode);
                            } catch (PackageManager.NameNotFoundException e) {
                                e.printStackTrace();
                            }
                            if (Constant.showUpdateDialog && !Constant.appVersion.equals(version)) {
                                methods.showUpdateAlert(Constant.appUpdateMsg, true);
                            } else {
                                application = getApplication();
                                ((MyApplication) application).loadAd(SplashActivity.this);

                                dbHelper.addtoAbout();
                                openLoginActivity();
                            }
                        } else if (verifyStatus.equals("-2")) {
                            methods.getInvalidUserDialog(message);
                        } else {
                            errorDialog(getString(R.string.error_unauth_access), message, true);
                        }
                    } else {
                        errorDialog(getString(R.string.server_error), getString(R.string.err_server), true);
                    }
                }
            });
            loadAbout.doWork();
        } else {
            errorDialog(getString(R.string.err_internet_not_conn), getString(R.string.error_connect_net_tryagain), true);
        }
    }

    public void loadCheckUserDeviceLimit() {
        if (methods.isNetworkAvailable()) {
            LoadSuccess loadSuccess = new LoadSuccess(new SuccessListener() {
                @Override
                public void onStart() {
                }

                @Override
                public void onEnd(String success, String isUserDeviceLimitReached, String message) {
                    if (success.equals("1")) {
                        if (isUserDeviceLimitReached.equals("0")) {
                            sharedPref.setIsDeviceLimitReached(false);
                            openMainActivity();
                        } else {
                            sharedPref.setIsDeviceLimitReached(true);
                            Intent intent = new Intent(SplashActivity.this, LoggedDevicesActivity.class);
                            intent.setFlags(Intent.FLAG_ACTIVITY_CLEAR_TOP);
                            intent.putExtra("isFromApp", false);
                            startActivity(intent);
                            finish();
                        }
                    } else {
                        errorDialog(getString(R.string.server_error), getString(R.string.server_error), false);
                    }
                }
            }, methods.getAPIRequest(Constant.METHOD_CHECK_USER_DEVICE_LIMIT_REACHED, 0, "", "", "", "", "", "", "", sharedPref.getSubscriptionPlanID(), "", "", "", "", "", sharedPref.getUserID(), "", null));
            loadSuccess.doWork(Constant.METHOD_CHECK_USER_DEVICE_LIMIT_REACHED);
        } else {
            Toast.makeText(this, getString(R.string.err_internet_not_conn), Toast.LENGTH_SHORT).show();
        }
    }

    private void errorDialog(String title, String message, boolean isAbout) {
        View view = getLayoutInflater().inflate(R.layout.layout_bottom_logout, null);

        BottomSheetDialog dialog = new BottomSheetDialog(SplashActivity.this);
        dialog.setContentView(view);
        dialog.setCancelable(false);
        dialog.getWindow().findViewById(R.id.design_bottom_sheet).setBackgroundResource(android.R.color.transparent);
        dialog.show();

        MaterialButton btn_stop = dialog.findViewById(R.id.btn_bottom_logout);
        MaterialButton btn_cancel = dialog.findViewById(R.id.btn_bottom_cancel);
        TextView tv1 = dialog.findViewById(R.id.tv1);
        TextView tv2 = dialog.findViewById(R.id.tv2);


        btn_cancel.setText(getString(R.string.exit));
        tv1.setText(title);
        tv2.setText(message);

        if (title.equals(getString(R.string.err_internet_not_conn)) || title.equals(getString(R.string.server_error))) {
            btn_stop.setText(getString(R.string.try_again));
            btn_stop.setOnClickListener(view1 -> {
                dialog.dismiss();
                if (isAbout) {
                    loadAboutData();
                } else {
                    loadCheckUserDeviceLimit();
                }
            });
        }

        btn_cancel.setOnClickListener(view1 -> {
            finish();
        });
    }

    private void openLoginActivity() {
        Intent intent;
        if (sharedPref.getIsFirst()) {
            sharedPref.setIsFirst(false);
            intent = new Intent(SplashActivity.this, LoginActivity.class);
            intent.setFlags(Intent.FLAG_ACTIVITY_CLEAR_TOP);
            intent.putExtra("from", "");
        } else {
            intent = new Intent(SplashActivity.this, MainActivity.class);
        }
        startActivity(intent);
        finish();
    }

    private void openMainActivity() {
        Intent intent = null;
        if (Constant.isFromPush && !Constant.pushID.equals("0")) {
            switch (Constant.pushType) {
                case "category" -> {
                    intent = new Intent(SplashActivity.this, SongByCatActivity.class);
                    intent.putExtra("isPush", true);
                    intent.putExtra("type", getString(R.string.categories));
                    intent.putExtra("id", Constant.pushID);
                    intent.putExtra("name", Constant.pushName);
                }
                case "album" -> {
                    intent = new Intent(SplashActivity.this, SongByCatActivity.class);
                    intent.putExtra("isPush", true);
                    intent.putExtra("type", getString(R.string.albums));
                    intent.putExtra("id", Constant.pushID);
                    intent.putExtra("name", Constant.pushName);
                }
                case "artist" -> {
                    intent = new Intent(SplashActivity.this, SongByCatActivity.class);
                    intent.putExtra("isPush", true);
                    intent.putExtra("type", getString(R.string.artist));
                    intent.putExtra("id", Constant.pushID);
                    intent.putExtra("name", Constant.pushName);
                }
                case "playlist" -> {
                    intent = new Intent(SplashActivity.this, SongByServerPlaylistActivity.class);
                    intent.putExtra("item", new ItemServerPlayList(Constant.pushID, Constant.pushName, "null", "0"));
                    intent.putExtra("isPush", true);
                }
                default -> intent = new Intent(SplashActivity.this, MainActivity.class);
            }
            intent.setFlags(Intent.FLAG_ACTIVITY_CLEAR_TOP);
            startActivity(intent);
            finish();
        } else {
            if (!((MyApplication) application).appOpenAdManager.isAdAvailable() || (Constant.isAppOpenAdShown && !((MyApplication) application).appOpenAdManager.isShowingAd)) {
                intent = new Intent(SplashActivity.this, MainActivity.class);
                intent.setFlags(Intent.FLAG_ACTIVITY_CLEAR_TOP);
                startActivity(intent);
                finish();
            } else if(((MyApplication) application).appOpenAdManager.isAdAvailable() && !((MyApplication) application).appOpenAdManager.isShowingAd) {
                ((MyApplication) application).appOpenAdManager.showAdIfAvailable(SplashActivity.this);
            }
        }
    }

    void hideStatusBar() {
        View decorView = getWindow().getDecorView();
        int uiOptions = View.SYSTEM_UI_FLAG_FULLSCREEN;
        decorView.setSystemUiVisibility(uiOptions);
    }

    @Override
    protected void onDestroy() {
        try {
            dbHelper.close();
        } catch (Exception e) {
            e.printStackTrace();
        }
        super.onDestroy();
    }
}