package com.vpapps.onlinemp3;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.TextView;
import android.widget.Toast;

import androidx.appcompat.app.AppCompatActivity;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;

import com.google.android.material.button.MaterialButton;
import com.vpapps.adapter.AdapterSubscriptionPlans;
import com.vpapps.asyncTask.LoadSubscriptionPlan;
import com.vpapps.interfaces.ClickListenerCallback;
import com.vpapps.interfaces.SubscriptionPlanListener;
import com.vpapps.item.ItemSubscriptionPlan;
import com.vpapps.utils.Constant;
import com.vpapps.utils.FirstItemMarginDecorator;
import com.vpapps.utils.Methods;
import com.vpapps.utils.SharedPref;

import java.util.ArrayList;

import fr.castorflex.android.circularprogressbar.CircularProgressBar;

public class SubscriptionActivity extends AppCompatActivity {

    Methods methods;
    SharedPref sharedPref;
    RecyclerView rv_plan;
    AdapterSubscriptionPlans adapterSubscriptionPlans;
    ArrayList<ItemSubscriptionPlan> arrayList = new ArrayList<>();
    MaterialButton btn_submit;
    ImageView iv_close;
    TextView tv_subs_1, tv_subs_2, tv_subs_3;
    CircularProgressBar pb_subs_plan;
    FrameLayout frameLayout;
    String errr_msg;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_subscription);

        methods = new Methods(this);
        sharedPref = new SharedPref(this);

        methods.setStatusColorTransparent(getWindow());
        getWindow().getDecorView().setSystemUiVisibility(View.SYSTEM_UI_FLAG_LAYOUT_FULLSCREEN | View.SYSTEM_UI_FLAG_LAYOUT_STABLE);

        rv_plan = findViewById(R.id.rv_subs_plan);
        btn_submit = findViewById(R.id.btn_subs_plan);
        frameLayout = findViewById(R.id.fl_empty);
        pb_subs_plan = findViewById(R.id.pb_subs_plan);
        iv_close = findViewById(R.id.iv_subs_close);
        tv_subs_1 = findViewById(R.id.tv_subs_1);
        tv_subs_2 = findViewById(R.id.tv_subs_2);
        tv_subs_3 = findViewById(R.id.tv_subs_3);

        LinearLayoutManager linearLayoutManager = new LinearLayoutManager(SubscriptionActivity.this, LinearLayoutManager.HORIZONTAL, false);

        rv_plan.setLayoutManager(linearLayoutManager);
        rv_plan.addItemDecoration(new FirstItemMarginDecorator(SubscriptionActivity.this, methods.convertDpToPixel(20)));

        btn_submit.setOnClickListener(view -> {
            if(sharedPref.isLogged()) {
                if (adapterSubscriptionPlans.getSelectedPos() != -1) {
                    if (sharedPref.getSubscriptionPlanID().equals(arrayList.get(adapterSubscriptionPlans.getSelectedPos()).getId())) {
                        Toast.makeText(this, getString(R.string.err_plan_already_active), Toast.LENGTH_SHORT).show();
                    } else if (Double.parseDouble(sharedPref.getSubscriptionPlanAmount()) > Double.parseDouble(arrayList.get(adapterSubscriptionPlans.getSelectedPos()).getAmount())) {
                        Toast.makeText(this, getString(R.string.err_select_higher_plan), Toast.LENGTH_SHORT).show();
                    } else {
                        if(Double.parseDouble(arrayList.get(adapterSubscriptionPlans.getSelectedPos()).getAmount())>0) {
                            Intent intent = new Intent(SubscriptionActivity.this, PaymentMethodActivity.class);
                            intent.putExtra("item", arrayList.get(adapterSubscriptionPlans.getSelectedPos()));
                            startActivity(intent);
                        } else {
                            methods.loadAddTransaction(arrayList.get(adapterSubscriptionPlans.getSelectedPos()), "Free Plan", sharedPref.getUserID().concat(String.valueOf(System.currentTimeMillis())));
                        }
                    }
                } else {
                    Toast.makeText(this, getString(R.string.err_select_subs_plan), Toast.LENGTH_SHORT).show();
                }
            } else {
                methods.clickLogin();
            }
        });

        iv_close.setOnClickListener(view -> onBackPressed());

        if(Constant.arrayListSubscription.isEmpty()) {
            loadSubscriptionMethods();
        } else {
            arrayList.addAll(Constant.arrayListSubscription);
            setAdapter();
        }
    }

    private void loadSubscriptionMethods() {
        if (methods.isNetworkAvailable()) {
            LoadSubscriptionPlan loadSubscriptionPlan = new LoadSubscriptionPlan(new SubscriptionPlanListener() {
                @Override
                public void onStart() {
                    pb_subs_plan.setVisibility(View.VISIBLE);
                    frameLayout.setVisibility(View.GONE);
                }

                @Override
                public void onEnd(String success, String verifyStatus, String message, ArrayList<ItemSubscriptionPlan> arrayListSubsPlan) {
                    if (success.equals("1")) {
                        errr_msg = getString(R.string.err_no_data_found);
                        Constant.arrayListSubscription.clear();
                        Constant.arrayListSubscription.addAll(arrayListSubsPlan);
                        arrayList.addAll(arrayListSubsPlan);
                        setAdapter();
                    } else {
                        errr_msg = getString(R.string.err_server);
                        setEmpty();
                    }
                }
            }, methods.getAPIRequest(Constant.METHOD_SUBSCRIPTION_PLAN, 0, "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", null));
            loadSubscriptionPlan.doWork(Constant.METHOD_SUBSCRIPTION_PLAN);
        } else {
            errr_msg = getString(R.string.err_internet_not_conn);
            setEmpty();
        }
    }

    private void setAdapter() {
        adapterSubscriptionPlans = new AdapterSubscriptionPlans(SubscriptionActivity.this, arrayList, new ClickListenerCallback() {
            @Override
            public void onClick(int position) {
                tv_subs_1.setText(getString(R.string.listen_on).concat(String.valueOf(arrayList.get(position).getDeviceLimit())).concat(" ").concat(getString(R.string.devices)));
                tv_subs_2.setText(arrayList.get(position).isAdsOn() ? getString(R.string.ads) : getString(R.string.no_ads));
                tv_subs_3.setText(arrayList.get(position).isDownloadOn() ? getString(R.string.download_songs) : getString(R.string.no_download_songs));
                findViewById(R.id.cl1).setVisibility(View.VISIBLE);
            }

            @Override
            public void onItemZero() {

            }
        });
        rv_plan.setAdapter(adapterSubscriptionPlans);

        rv_plan.setAdapter(adapterSubscriptionPlans);

        if(sharedPref.getIsSubscribed()) {
            for (int i = 0; i < arrayList.size(); i++) {
                if(arrayList.get(i).getId().equals(sharedPref.getSubscriptionPlanID())) {
                    adapterSubscriptionPlans.setSelectedPos(i);
                    break;
                }
            }
        } else {
            if(!arrayList.isEmpty()){
                adapterSubscriptionPlans.setSelectedPos(0);
            }
        }

        setEmpty();
    }

    @SuppressLint("InflateParams")
    private void setEmpty() {
        pb_subs_plan.setVisibility(View.GONE);
        if (!arrayList.isEmpty()) {
            rv_plan.setVisibility(View.VISIBLE);
            frameLayout.setVisibility(View.GONE);
        } else {
            rv_plan.setVisibility(View.GONE);
            frameLayout.setVisibility(View.VISIBLE);

            frameLayout.removeAllViews();
            LayoutInflater inflater = (LayoutInflater) getSystemService(Context.LAYOUT_INFLATER_SERVICE);

            View myView = null;
            if (errr_msg.equals(getString(R.string.err_no_data_found))) {
                myView = inflater.inflate(R.layout.layout_err_nodata, null);
            } else if (errr_msg.equals(getString(R.string.err_internet_not_conn))) {
                myView = inflater.inflate(R.layout.layout_err_internet, null);
            } else if (errr_msg.equals(getString(R.string.err_server))) {
                myView = inflater.inflate(R.layout.layout_err_server, null);
            }

            assert myView != null;
            TextView textView = myView.findViewById(R.id.tv_empty_msg);
            textView.setText(errr_msg);

            myView.findViewById(R.id.btn_empty_try).setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View v) {
                    loadSubscriptionMethods();
                }
            });
            frameLayout.addView(myView);

            myView.findViewById(R.id.btn_empty_downloads).setVisibility(View.GONE);
            myView.findViewById(R.id.btn_empty_music_lib).setVisibility(View.GONE);
        }
    }
}