package com.vpapps.onlinemp3;

import android.content.Context;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.MenuItem;
import android.view.View;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import android.widget.TextView;

import androidx.appcompat.app.AppCompatActivity;
import androidx.appcompat.widget.Toolbar;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;

import com.vpapps.adapter.AdapterTransaction;
import com.vpapps.asyncTask.LoadTransaction;
import com.vpapps.interfaces.TransactionListener;
import com.vpapps.item.ItemTransaction;
import com.vpapps.utils.Constant;
import com.vpapps.utils.Methods;
import com.vpapps.utils.SharedPref;

import java.util.ArrayList;

import fr.castorflex.android.circularprogressbar.CircularProgressBar;

public class TransactionActivity extends AppCompatActivity {

    Toolbar toolbar;
    Methods methods;
    RecyclerView rv_transaction;
    AdapterTransaction adapterTransaction;
    ArrayList<ItemTransaction> arrayList = new ArrayList<>();
    CircularProgressBar progressBar;
    FrameLayout frameLayout;
    String errr_msg;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_transaction);

        methods = new Methods(this);
        methods.forceRTLIfSupported(getWindow());
        methods.setStatusColorDark(getWindow());

        toolbar = this.findViewById(R.id.toolbar_transaction);
        this.setSupportActionBar(toolbar);
        getSupportActionBar().setDisplayHomeAsUpEnabled(true);

        progressBar = findViewById(R.id.pb_transaction);
        frameLayout = findViewById(R.id.fl_empty);
        rv_transaction = findViewById(R.id.rv_transaction);
        rv_transaction.setLayoutManager(new LinearLayoutManager(this));


        if (methods.isNetworkAvailable()) {
            loadTransaction();
        } else {
            errr_msg = getString(R.string.err_internet_not_conn);
            setEmpty();
        }

        LinearLayout ll_adView = findViewById(R.id.ll_adView);
        methods.showBannerAd(ll_adView);
    }

    @Override
    public boolean onOptionsItemSelected(MenuItem menuItem) {
        if (menuItem.getItemId() == android.R.id.home) {
            onBackPressed();
        } else {
            return super.onOptionsItemSelected(menuItem);
        }
        return true;
    }

    public void loadTransaction() {
        LoadTransaction loadTransaction = new LoadTransaction(new TransactionListener() {
            @Override
            public void onStart() {
                progressBar.setVisibility(View.VISIBLE);
                frameLayout.setVisibility(View.GONE);
                rv_transaction.setVisibility(View.GONE);
            }

            @Override
            public void onEnd(String success, String apiSuccess, String message, ArrayList<ItemTransaction> arrayListTransaction) {
                if (success.equals("1")) {
                    if (!apiSuccess.equals("-1") && !apiSuccess.equals("-2")) {

                        arrayList.addAll(arrayListTransaction);
                        errr_msg = getString(R.string.err_no_data_found);
                        setAdapter();

                    } else if (apiSuccess.equals("-2")) {
                        methods.getInvalidUserDialog(message);
                    } else {
                        methods.getVerifyDialog(getString(R.string.error_unauth_access), message);
                    }
                } else {
                    errr_msg = getString(R.string.err_server);
                    setEmpty();
                }
            }
        }, methods.getAPIRequest(Constant.METHOD_TRANSACTION, 0, "", "", "", "", "", "", "", "", "", "", "", "", "", new SharedPref(TransactionActivity.this).getUserID(), "", null));
        loadTransaction.doWork(Constant.METHOD_TRANSACTION);
    }

    private void setAdapter() {
        adapterTransaction = new AdapterTransaction(TransactionActivity.this, arrayList);
        rv_transaction.setAdapter(adapterTransaction);
        setEmpty();
    }

    public void setEmpty() {
        progressBar.setVisibility(View.GONE);
        if (!arrayList.isEmpty()) {
            rv_transaction.setVisibility(View.VISIBLE);
            frameLayout.setVisibility(View.GONE);
        } else {
            rv_transaction.setVisibility(View.GONE);
            frameLayout.setVisibility(View.VISIBLE);

            frameLayout.removeAllViews();
            LayoutInflater inflater = (LayoutInflater) getSystemService(Context.LAYOUT_INFLATER_SERVICE);

            View myView = null;
            if (errr_msg.equals(getString(R.string.err_no_data_found))) {
                myView = inflater.inflate(R.layout.layout_err_nodata, null);
            } else if (errr_msg.equals(getString(R.string.err_internet_not_conn))) {
                myView = inflater.inflate(R.layout.layout_err_internet, null);
            } else if (errr_msg.equals(getString(R.string.err_server))) {
                myView = inflater.inflate(R.layout.layout_err_server, null);
            }

            assert myView != null;
            TextView textView = myView.findViewById(R.id.tv_empty_msg);
            textView.setText(errr_msg);

            myView.findViewById(R.id.btn_empty_try).setOnClickListener(v -> loadTransaction());

            myView.findViewById(R.id.btn_empty_music_lib).setVisibility(View.GONE);
            myView.findViewById(R.id.btn_empty_downloads).setVisibility(View.GONE);

            frameLayout.addView(myView);
        }
    }
}