package com.vpapps.onlinemp3.payment;

import android.content.Context;
import android.util.Log;
import android.webkit.JavascriptInterface;
import android.widget.Toast;

import com.vpapps.item.ItemSubscriptionPlan;
import com.vpapps.onlinemp3.R;
import com.vpapps.utils.Methods;

import org.json.JSONException;
import org.json.JSONObject;

public class CinetPayWebAppInterface extends com.cinetpay.androidsdk.CinetPayWebAppInterface {
    String planId;
    String gatewayName;
    Context context;
    Methods methods;
    ItemSubscriptionPlan itemSubscriptionPlan;

    public CinetPayWebAppInterface(Context c, ItemSubscriptionPlan itemSubscriptionPlan, String apikey, String site_id, String transaction_id, int amount, String currency, String description, String gatewayName, String planId) {
        super(c, apikey, site_id, transaction_id, amount, currency, description);
        this.planId = planId;
        this.gatewayName = gatewayName;
        this.itemSubscriptionPlan = itemSubscriptionPlan;
        this.context = c;
        methods = new Methods(context);
    }

    @Override
    @JavascriptInterface
    public void onResponse(String response) {
        Log.d("MyCinetPayWebApp", response);
        try {
            JSONObject jsonObject = new JSONObject(response);
            if (jsonObject.has("status")) {
                String statusSuccess = jsonObject.getString("status");
                String transId = jsonObject.getString("operator_id");
                if (statusSuccess.equals("ACCEPTED")) {
                    methods.loadAddTransaction(itemSubscriptionPlan, gatewayName, transId);
                } else {
                    Toast.makeText(context, context.getString(R.string.err_payment_failed), Toast.LENGTH_SHORT).show();
                }
            }
        } catch (JSONException e) {
            e.printStackTrace();
        }
    }

    @Override
    @JavascriptInterface
    public void onError(String response) {
        Log.d("onerror", response);
    }
}
