package com.vpapps.onlinemp3.payment;

import android.content.Intent;
import android.os.Bundle;

import androidx.annotation.Nullable;

import com.cinetpay.androidsdk.CinetPayActivity;
import com.vpapps.item.ItemSubscriptionPlan;
import com.vpapps.onlinemp3.R;
import com.vpapps.utils.Methods;
import com.vpapps.utils.SharedPref;


public class CinetpayActivity extends CinetPayActivity {

    Methods methods;
    SharedPref sharedPref;
    ItemSubscriptionPlan itemSubscriptionPlan;

    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);

        methods = new Methods(CinetpayActivity.this);
        sharedPref = new SharedPref(CinetpayActivity.this);

        Intent intent = getIntent();
        itemSubscriptionPlan = (ItemSubscriptionPlan) intent.getSerializableExtra("itemSubs");

        String api_key = intent.getStringExtra(KEY_API_KEY);
        String site_id = intent.getStringExtra(KEY_SITE_ID);
        String transaction_id = intent.getStringExtra(KEY_TRANSACTION_ID);
        int amount = (int)Double.parseDouble(intent.getStringExtra(KEY_AMOUNT));
        String currency = intent.getStringExtra(KEY_CURRENCY);
        String description = intent.getStringExtra(KEY_DESCRIPTION);
        String channels = intent.getStringExtra(KEY_CHANNELS);
        String customer_name = intent.getStringExtra(KEY_CUSTOMER_NAME);
        String customer_surname = intent.getStringExtra(KEY_CUSTOMER_SURNAME);
        String customer_email = intent.getStringExtra(KEY_CUSTOMER_EMAIL);
        String customer_gateway_name = intent.getStringExtra("planGateway");
        String customer_plan_id = itemSubscriptionPlan.getId();

        mWebView.addJavascriptInterface(
                        new CinetPayWebAppInterface(this, itemSubscriptionPlan, api_key, site_id, transaction_id, amount, currency, description, customer_gateway_name, customer_plan_id)
                                .setChannels(channels)
                                .setCustomerName(customer_name)
                                .setCustomerSurname(customer_surname)
                                .setCustomerEmail(customer_email), "Android");
    }
}
