package com.vpapps.onlinemp3.payment;

import android.app.ProgressDialog;
import android.content.Intent;
import android.os.Bundle;
import android.view.MenuItem;
import android.widget.Button;
import android.widget.TextView;
import android.widget.Toast;

import androidx.annotation.Nullable;
import androidx.appcompat.app.AppCompatActivity;

import com.flutterwave.raveandroid.RavePayActivity;
import com.flutterwave.raveandroid.RaveUiManager;
import com.flutterwave.raveandroid.rave_java_commons.RaveConstants;
import com.google.android.material.appbar.MaterialToolbar;
import com.vpapps.item.ItemSubscriptionPlan;
import com.vpapps.onlinemp3.R;
import com.vpapps.utils.Methods;
import com.vpapps.utils.SharedPref;

import org.json.JSONException;
import org.json.JSONObject;

import java.util.Locale;
import java.util.Random;


public class FlutterwaveActivity extends AppCompatActivity {

    Methods methods;
    SharedPref sharedPref;
    ItemSubscriptionPlan itemSubscriptionPlan;
    String paymentGateway, flutterwavePublicKey, flutterwaveEncryptKey;
    TextView tv_plan_name, tv_desc, tv_payment_method;
    Button btnPay;
    ProgressDialog pDialog;

    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_payment);

        methods = new Methods(FlutterwaveActivity.this);
        sharedPref = new SharedPref(FlutterwaveActivity.this);

        pDialog = new ProgressDialog(this);

        Intent intent = getIntent();
        itemSubscriptionPlan = (ItemSubscriptionPlan) intent.getSerializableExtra("itemSubs");
        paymentGateway = intent.getStringExtra("planGateway");
        flutterwavePublicKey = intent.getStringExtra("flutterwavePublicKey");
        flutterwaveEncryptKey = intent.getStringExtra("flutterwaveEncryptKey");

        methods.forceRTLIfSupported(getWindow());
        methods.setStatusColorDark(getWindow());

        MaterialToolbar toolbar = findViewById(R.id.toolbar_payment);
        toolbar.setTitle(getString(R.string.payment));
        this.setSupportActionBar(toolbar);
        getSupportActionBar().setDisplayHomeAsUpEnabled(true);

        btnPay = findViewById(R.id.btn_pay);
        tv_plan_name = findViewById(R.id.tv_plan_name);
        tv_desc = findViewById(R.id.tv_desc);
        tv_payment_method = findViewById(R.id.tv_payment_method);

        btnPay.setText(getString(R.string.pay).concat(" ").concat(itemSubscriptionPlan.getAmount()).concat(" ").concat(itemSubscriptionPlan.getCurrencyCode()));
        tv_plan_name.setText(itemSubscriptionPlan.getTitle());
        tv_payment_method.setText("* ".concat(paymentGateway));

        tv_desc.setText(getString(R.string.bullet)
                .concat(getString(R.string.listen_on))
                .concat(String.valueOf(itemSubscriptionPlan.getDeviceLimit()))
                .concat(" ")
                .concat(getString(R.string.devices))
                .concat("\n")
                .concat(getString(R.string.bullet))
                .concat((itemSubscriptionPlan.isAdsOn() ? getString(R.string.ads) : getString(R.string.no_ads))
                        .concat("\n")
                        .concat(getString(R.string.bullet))
                        .concat(itemSubscriptionPlan.isDownloadOn() ? getString(R.string.download_songs) : getString(R.string.no_download_songs))));

        btnPay.setOnClickListener(view -> startPayment());
    }

    @Override
    public boolean onOptionsItemSelected(MenuItem menuItem) {
        if (menuItem.getItemId() == android.R.id.home) {
            onBackPressed();
        } else {
            return super.onOptionsItemSelected(menuItem);
        }
        return true;
    }

    public void startPayment() {
        RaveUiManager raveUiManager = new RaveUiManager(FlutterwaveActivity.this);
        raveUiManager.setAmount(Double.parseDouble(itemSubscriptionPlan.getAmount()))
                .setCurrency(itemSubscriptionPlan.getCurrencyCode()) //NGN
                .setEmail(new SharedPref(FlutterwaveActivity.this).getUserEmail())
                .setfName(new SharedPref(FlutterwaveActivity.this).getUserName())
                .setPublicKey(flutterwavePublicKey)
                .setEncryptionKey(flutterwaveEncryptKey)
                .setTxRef(getTransactionId())
                .acceptAccountPayments(true)
                .shouldDisplayFee(true)
                .acceptCardPayments(true)
                .acceptMpesaPayments(true)
                .acceptAchPayments(true)
                .acceptGHMobileMoneyPayments(true)
                .acceptUgMobileMoneyPayments(true)
                .acceptZmMobileMoneyPayments(true)
                .acceptRwfMobileMoneyPayments(true)
                .acceptSaBankPayments(true)
                .acceptUkPayments(true)
                .acceptBankTransferPayments(true)
                .acceptUssdPayments(true)
                .acceptBarterPayments(true)
                .acceptFrancMobileMoneyPayments(true, "NG")
                .allowSaveCardFeature(true)
                .onStagingEnv(false)
                .isPreAuth(true)
                .showStagingLabel(false);
        raveUiManager.initialize();
    }

    public String getTransactionId() {
        Random rnd = new Random();
        int number = rnd.nextInt(999999);
        String orderId = String.format(Locale.getDefault(), "%06d", number);
        return "fW" + new SharedPref(FlutterwaveActivity.this).getUserID() + orderId;
    }

    private void showError(String error) {
        Toast.makeText(this, error, Toast.LENGTH_SHORT).show();
    }

    @Override
    protected void onActivityResult(int requestCode, int resultCode, @Nullable Intent data) {
        if (requestCode == RaveConstants.RAVE_REQUEST_CODE && data != null) {
            String message = data.getStringExtra("response");
            if (resultCode == RavePayActivity.RESULT_SUCCESS) {
                try {
                    assert message != null;
                    JSONObject jsonObject = new JSONObject(message);
                    JSONObject jsonData = jsonObject.getJSONObject("data");
                    String status = jsonData.getString("status");
                    if (status.equals("successful")) {
                        String paymentID = jsonData.getString("flwRef");
                        methods.loadAddTransaction(itemSubscriptionPlan, paymentGateway, paymentID);
                    } else {
                        showError( "Failed " + jsonData.getString("vbvrespmessage"));
                    }
                } catch (JSONException e) {
                    e.printStackTrace();
                }

            } else if (resultCode == RavePayActivity.RESULT_ERROR) {
                showError(getString(R.string.err_payment_failed));
            } else if (resultCode == RavePayActivity.RESULT_CANCELLED) {
                showError(getString(R.string.err_payment_cancel));
            }
        } else {
            super.onActivityResult(requestCode, resultCode, data);
        }
    }
}
