package com.vpapps.onlinemp3.payment;

import android.app.ProgressDialog;
import android.content.Intent;
import android.os.Bundle;
import android.util.Log;
import android.view.MenuItem;
import android.widget.Button;
import android.widget.TextView;
import android.widget.Toast;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.appcompat.app.AppCompatActivity;

import com.google.android.material.appbar.MaterialToolbar;
import com.instamojo.android.Instamojo;
import com.vpapps.asyncTask.LoadGenerateKeys;
import com.vpapps.interfaces.GenerateKeysListener;
import com.vpapps.item.ItemSubscriptionPlan;
import com.vpapps.onlinemp3.R;
import com.vpapps.utils.Constant;
import com.vpapps.utils.Methods;
import com.vpapps.utils.SharedPref;

import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;


public class InstamojoActivity extends AppCompatActivity implements Instamojo.InstamojoPaymentCallback {

    Methods methods;
    SharedPref sharedPref;
    ItemSubscriptionPlan itemSubscriptionPlan;
    String paymentGateway;
    TextView tv_plan_name, tv_desc, tv_payment_method;
    Button btnPay;
    String orderId = "";
    ProgressDialog pDialog;
    boolean isSandbox;

    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_payment);

        isSandbox = getIntent().getBooleanExtra("isSandbox", false);

        if(!isSandbox) {
            Instamojo.getInstance().initialize(this, Instamojo.Environment.PRODUCTION);
        } else {
            Instamojo.getInstance().initialize(this, Instamojo.Environment.TEST);
        }

        Intent intent = getIntent();
        itemSubscriptionPlan = (ItemSubscriptionPlan) intent.getSerializableExtra("itemSubs");
        paymentGateway = intent.getStringExtra("planGateway");

        methods = new Methods(InstamojoActivity.this);
        sharedPref = new SharedPref(InstamojoActivity.this);

        methods.forceRTLIfSupported(getWindow());
        methods.setStatusColorDark(getWindow());

        MaterialToolbar toolbar = findViewById(R.id.toolbar_payment);
        toolbar.setTitle(getString(R.string.payment));
        this.setSupportActionBar(toolbar);
        getSupportActionBar().setDisplayHomeAsUpEnabled(true);

        pDialog = new ProgressDialog(this);

        btnPay = findViewById(R.id.btn_pay);
        tv_plan_name = findViewById(R.id.tv_plan_name);
        tv_desc = findViewById(R.id.tv_desc);
        tv_payment_method = findViewById(R.id.tv_payment_method);

        btnPay.setText(getString(R.string.pay).concat(" ").concat(itemSubscriptionPlan.getAmount()).concat(" ").concat(itemSubscriptionPlan.getCurrencyCode()));
        tv_plan_name.setText(itemSubscriptionPlan.getTitle());
        tv_payment_method.setText("* ".concat(paymentGateway));
        tv_desc.setText(getString(R.string.bullet)
                .concat(getString(R.string.listen_on))
                .concat(String.valueOf(itemSubscriptionPlan.getDeviceLimit()))
                .concat(" ")
                .concat(getString(R.string.devices))
                .concat("\n")
                .concat(getString(R.string.bullet))
                .concat((itemSubscriptionPlan.isAdsOn() ? getString(R.string.ads) : getString(R.string.no_ads))
                        .concat("\n")
                        .concat(getString(R.string.bullet))
                        .concat(itemSubscriptionPlan.isDownloadOn() ? getString(R.string.download_songs) : getString(R.string.no_download_songs))));

        itemSubscriptionPlan.setAmount(String.valueOf((int) Double.parseDouble(itemSubscriptionPlan.getAmount()) * 100));

        btnPay.setOnClickListener(view -> {
            if (sharedPref.getUserMobile().isEmpty()) {
                showError(getString(R.string.err_phone_update));
            } else {
                if (orderId != null && orderId.isEmpty()) {
                    getOrderId();
                } else {
                    startPayment();
                }
            }
        });
    }

    @Override
    public boolean onOptionsItemSelected(MenuItem menuItem) {
        if (menuItem.getItemId() == android.R.id.home) {
            onBackPressed();
        } else {
            return super.onOptionsItemSelected(menuItem);
        }
        return true;
    }

    private void getOrderId() {
        if (methods.isNetworkAvailable()) {
            LoadGenerateKeys loadGenerateKeys = new LoadGenerateKeys(new GenerateKeysListener() {
                @Override
                public void onStart() {
                    pDialog.setMessage(getResources().getString(R.string.loading));
                    pDialog.setCancelable(false);
                    pDialog.show();
                }

                @Override
                public void onEnd(String success, String apiSuccess, String message, String razorPayOrderID, String stripePaymentID, String stripeToken, String stripeEphemeralKey, String stripeCustomer, String braintreeToken, String payumoneyHash, String instamojoOrderID) {
                    pDialog.dismiss();
                    if (success.equals("1")) {
                        if (apiSuccess.equals("1")) {
                            orderId = instamojoOrderID;
                            if (orderId != null && !orderId.isEmpty()) {
                                startPayment();
                            }
                        } else {
                            Toast.makeText(InstamojoActivity.this, message, Toast.LENGTH_SHORT).show();
                        }
                    } else {
                        Toast.makeText(InstamojoActivity.this, getString(R.string.err_server), Toast.LENGTH_SHORT).show();
                    }
                }
            }, methods.getAPIRequest(Constant.METHOD_INSTAMOJO_ORDER_ID, 0, "", "", "", "", "", "", "", itemSubscriptionPlan.getId(), "", "", "", "", "", sharedPref.getUserID(), "", null));
            loadGenerateKeys.doWork(Constant.METHOD_INSTAMOJO_ORDER_ID, paymentGateway);
        } else {
            Toast.makeText(this, getString(R.string.err_internet_not_conn), Toast.LENGTH_SHORT).show();
        }
    }

    public void startPayment() {
        Instamojo.getInstance().initiatePayment(InstamojoActivity.this, orderId, InstamojoActivity.this);
    }

    private void showError(String error) {
        Toast.makeText(InstamojoActivity.this, error, Toast.LENGTH_SHORT).show();
    }

    @Override
    public void onInstamojoPaymentComplete(String orderID, String transactionID, String paymentID, String paymentStatus) {
        try {
            methods.loadAddTransaction(itemSubscriptionPlan, paymentGateway, paymentID);
        } catch (Exception e) {

        }
    }

    @Override
    public void onPaymentCancelled() {
        try {
            showError(getString(R.string.err_payment_cancel));
        } catch (Exception e) {

        }
    }

    @Override
    public void onInitiatePaymentFailure(String errorMessage) {
        try {
            showError(getString(R.string.payment_failed).concat(" ") + errorMessage);
        } catch (Exception e) {

        }
    }
}
